/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.bill.applypay;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.pub.ContractUtil;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.daily.web.AbstractExpenseBaseBillPlugin;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ApplyPayBillEdit
extends AbstractExpenseBaseBillPlugin
implements ItemClickListener,
HyperLinkClickListener {
    private String contract = "pmbs_contractpayitem";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"flexpublicreimbillno", "recsrcbillno"});
        EntryGrid contractGrid = (EntryGrid)this.getControl("accountentry");
        if (!ObjectUtils.isEmpty((Object)contractGrid)) {
            contractGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void click(EventObject evt) {
        String key;
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "flexpublicreimbillno": {
                String publicreimbillno = (String)this.getModel().getValue("publicreimbillno");
                QFilter[] filters = new QFilter[]{new QFilter("billno", "=", (Object)publicreimbillno)};
                DynamicObject publicreimBill = QueryServiceHelper.queryOne((String)"er_publicreimbursebill", (String)"id", (QFilter[])filters);
                BillShowParameter billShowParameter = new BillShowParameter();
                billShowParameter.setFormId("er_publicreimbursebill");
                billShowParameter.setPkId((Object)publicreimBill.getLong("id"));
                billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)billShowParameter);
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        if ("recsrcbillno".equals(hyperLinkClickEvent.getFieldName())) {
            long recsrcbillid = (Long)this.getModel().getValue("recsrcbillid", rowIndex);
            String recsrcbilltype = (String)this.getModel().getValue("recsrcbilltype", rowIndex);
            ShowPageUtils.openLinkedForm((Object)recsrcbillid, (String)recsrcbilltype, (IFormView)this.getView());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        List<Integer> deleteIndex = Lists.newArrayList();
        String detailtype = (String)model.getValue("detailtype");
        Set<Object> entrybillno = new HashSet();
        DynamicObjectCollection dynamicObjectCollection = model.getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
        if (StringUtils.equalsIgnoreCase((String)detailtype, (String)"biztype_contract")) {
            entrybillno = dynamicObjectCollection.stream().map(v -> (String)v.get("entrycontractno")).collect(Collectors.toSet());
            String wbsrcbilltype = (String)((DynamicObject)dynamicObjectCollection.get(0)).get("wbsrcbilltype");
            String relationcontract = "0";
            if (model.getValue("company") != null) {
                relationcontract = SystemParamterUtil.getRelationContract((Long)((Long)((DynamicObject)this.getModel().getValue("company")).getPkValue()));
            }
            if ("1".equals(relationcontract)) {
                deleteIndex = ContractUtil.loadErContract((IDataModel)model, entrybillno);
            } else {
                String selectPropties = "contract.billno,contract.billname,currency,exchangerate,contract.totaloftaxamount,reimbursedamt,reimbursableamt,contract.signdate";
                DynamicObject[] contractDynamicObjts = BusinessDataServiceHelper.load((String)this.contract, (String)selectPropties, (QFilter[])new QFilter[]{new QFilter("contract.billno", "in", entrybillno)});
                HashSet<String> entrycontractFordel = new HashSet<String>();
                for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                    if (entrycontractFordel.contains(((DynamicObject)dynamicObjectCollection.get(i)).get("entrycontractno"))) {
                        deleteIndex.add(i);
                        continue;
                    }
                    for (int j = 0; j < contractDynamicObjts.length; ++j) {
                        if (!((DynamicObject)dynamicObjectCollection.get(i)).get("entrycontractno").equals(contractDynamicObjts[j].get("contract.billno"))) continue;
                        entrycontractFordel.add((String)((DynamicObject)dynamicObjectCollection.get(i)).get("entrycontractno"));
                        model.setValue("entrycontractname", contractDynamicObjts[j].get("contract.billname"), i);
                        model.setValue("totalamount", contractDynamicObjts[j].get("contract.totaloftaxamount"), i);
                        model.setValue("expusedamount", contractDynamicObjts[j].get("reimbursedamt"), i);
                        model.setValue("expreimbursableamount", contractDynamicObjts[j].get("reimbursableamt"), i);
                        model.setValue("entrycurrency", contractDynamicObjts[j].get("currency"), i);
                        model.setValue("signingdate", contractDynamicObjts[j].get("contract.signdate"), i);
                    }
                }
            }
            model.deleteEntryRows("expenseentryentity", deleteIndex.stream().mapToInt(Integer::intValue).toArray());
        } else if (StringUtils.equalsIgnoreCase((String)detailtype, (String)"biztype_project")) {
            entrybillno = dynamicObjectCollection.stream().map(v -> (String)v.get("entryprojectno")).collect(Collectors.toSet());
            DynamicObject[] projectDynamicObjts = BusinessDataServiceHelper.load((String)"er_applyprojectbill", (String)"billno,projectnamedesc,acapproveamount, balanceamount, usedamount,currency,bizdate ", (QFilter[])new QFilter[]{new QFilter("billno", "in", entrybillno)});
            HashSet<String> entryprojectnoFordel = new HashSet<String>();
            for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                if (entryprojectnoFordel.contains(((DynamicObject)dynamicObjectCollection.get(i)).get("entryprojectno"))) {
                    deleteIndex.add(i);
                    continue;
                }
                for (int j = 0; j < projectDynamicObjts.length; ++j) {
                    if (!((DynamicObject)dynamicObjectCollection.get(i)).get("entryprojectno").equals(projectDynamicObjts[j].get("billno"))) continue;
                    entryprojectnoFordel.add((String)((DynamicObject)dynamicObjectCollection.get(i)).get("entryprojectno"));
                    model.setValue("entryprojectname", projectDynamicObjts[j].get("projectnamedesc"), i);
                    model.setValue("totalamount", projectDynamicObjts[j].get("acapproveamount"), i);
                    model.setValue("expusedamount", projectDynamicObjts[j].get("usedamount"), i);
                    model.setValue("expreimbursableamount", projectDynamicObjts[j].get("balanceamount"), i);
                    model.setValue("entrycurrency", projectDynamicObjts[j].get("currency"), i);
                    model.setValue("signingdate", projectDynamicObjts[j].get("bizdate"), i);
                }
            }
            model.deleteEntryRows("expenseentryentity", deleteIndex.stream().mapToInt(Integer::intValue).toArray());
        } else if (StringUtils.equalsIgnoreCase((String)detailtype, (String)"biztype_contractestimate")) {
            entrybillno = dynamicObjectCollection.stream().map(v -> (String)v.get("entrycontractno")).collect(Collectors.toSet());
            String relationcontract = "0";
            if (model.getValue("company") != null) {
                relationcontract = SystemParamterUtil.getRelationContract((Long)((Long)((DynamicObject)this.getModel().getValue("company")).getPkValue()));
            }
            if ("1".equals(relationcontract)) {
                deleteIndex = ContractUtil.loadErContract((IDataModel)model, entrybillno);
                model.deleteEntryRows("expenseentryentity", deleteIndex.stream().mapToInt(Integer::intValue).toArray());
            }
        }
        boolean isPushBill = this.getModel().getDataEntity().getDataEntityState().isPushChanged();
        if (isPushBill) {
            DynamicObjectCollection accountentry = model.getDataEntity(true).getDynamicObjectCollection("accountentry");
            BigDecimal receiveamount = BigDecimal.ZERO;
            for (int i = 0; i < accountentry.size(); ++i) {
                receiveamount = receiveamount.add((BigDecimal)((DynamicObject)accountentry.get(i)).get("receiveamount"));
            }
            boolean ischanged = model.getDataChanged();
            model.setValue("loanamount", (Object)receiveamount);
            model.setValue("approveamount", (Object)receiveamount);
            model.setDataChanged(ischanged);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propNewValue = valueSet[0].getNewValue();
        IDataModel model = this.getView().getModel();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (propName) {
            case "orireceiveamount": {
                model.setValue("accapproveamount", (Object)((BigDecimal)propNewValue), rowIndex);
                DynamicObjectCollection accountentry = model.getDataEntity(true).getDynamicObjectCollection("accountentry");
                BigDecimal receiveamountTotal = AmountChangeUtil.sumAmountBy((Collection)accountentry, (String)"receiveamount");
                model.setValue("loanamount", (Object)receiveamountTotal);
                break;
            }
            case "accapproveamount": {
                BigDecimal expenseAmount = (BigDecimal)model.getValue("orireceiveamount", rowIndex);
                if (expenseAmount.compareTo((BigDecimal)propNewValue) < 0) {
                    model.setValue("accapproveamount", (Object)expenseAmount, rowIndex);
                    return;
                }
                AmountUtils.refreshCurrAmount((IDataModel)model, (BigDecimal)((BigDecimal)propNewValue), (String)"accapprovecurramount", (String)"accexchangerate", (String)"accquotetype", (int)rowIndex);
                DynamicObjectCollection accountentrys = model.getDataEntity(true).getDynamicObjectCollection("accountentry");
                BigDecimal accapprovecurramountTotal = AmountChangeUtil.sumAmountBy((Collection)accountentrys, (String)"accapprovecurramount");
                model.setValue("approveamount", (Object)accapprovecurramountTotal);
                BigDecimal oriaccpayedamount = (BigDecimal)model.getValue("oriaccpayedamount", rowIndex);
                model.setValue("oriaccnotpayamount", (Object)((BigDecimal)propNewValue).subtract(oriaccpayedamount), rowIndex);
                BigDecimal accpayedamount = (BigDecimal)model.getValue("accpayedamount", rowIndex);
                model.setValue("accnotpayamount", (Object)((BigDecimal)model.getValue("accapprovecurramount", rowIndex)).subtract(accpayedamount), rowIndex);
                BigDecimal accnotpayamount = AmountChangeUtil.sumAmountBy((Collection)accountentrys, (String)"accnotpayamount");
                model.setValue("notpayamount", (Object)accnotpayamount);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if (e.getEntryProp().getName().equals("accountentry")) {
            DynamicObjectCollection accountEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("accountentry");
            BigDecimal receiveamountTotal = AmountChangeUtil.sumAmountBy((Collection)this.getModel().getDataEntity(true).getDynamicObjectCollection("accountentry"), (String)"receiveamount");
            this.getModel().setValue("loanamount", (Object)receiveamountTotal);
            BigDecimal accapprovecurramountTotal = AmountChangeUtil.sumAmountBy((Collection)accountEntry, (String)"accapprovecurramount");
            this.getModel().setValue("approveamount", (Object)accapprovecurramountTotal);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String opKey;
        switch (opKey = e.getOperateKey()) {
            case "confirmstopreim": {
                OperationResult opResult = e.getOperationResult();
                if (!opResult.isSuccess()) break;
                this.getView().close();
            }
        }
    }
}

