/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.bill.contract;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.container.AdvContainer;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.fi.er.business.pub.ContractUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErCostCenterUtil;
import kd.fi.er.common.field.writeoffmoney.ContractProjectWriteOffFields;
import kd.fi.er.common.field.writeoffmoney.WriteOffFields;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ContractBillEdit
extends AbstractBillPlugIn
implements ClickListener,
ICloseCallBack,
HyperLinkClickListener {
    public void registerListener(EventObject e) {
        EntryGrid expentryGrid;
        super.registerListener(e);
        this.addClickListeners(new String[]{"contractsconn", "wbsrcbillno"});
        EntryGrid entryGrid = (EntryGrid)this.getControl("projectentryentity");
        if (!ObjectUtils.isEmpty((Object)entryGrid)) {
            entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
        if (!ObjectUtils.isEmpty((Object)(expentryGrid = (EntryGrid)this.getControl("expenseentryentity")))) {
            expentryGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
        ContractUtil.setContractPartF7Filter((IDataModel)this.getModel(), (IFormView)this.getView());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ContractUtil.setCurrency((IDataModel)this.getModel());
        ContractUtil.setDefaultParty((IFormView)this.getView());
        this.setWriteOffType();
    }

    private void setWriteOffType() {
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        String writeType = (String)ErCommonUtils.getEMParameter((long)ErCommonUtils.getPk((Object)company), (String)"er010");
        this.getModel().setValue("writeofftype", (Object)writeType);
    }

    private String getWriteOffType() {
        return (String)this.getModel().getValue("writeofftype");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        ContractUtil.refreshHeadContacts((IFormView)this.getView(), (EventObject)e);
        String opType = "";
        IFormView parentview = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentview != null && parentview.getPageCache() != null) {
            opType = parentview.getPageCache().get("changeoOpType");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)opType)) {
            opType = "bar_changea";
        }
        IDataModel model = this.getModel();
        boolean dataChanged = model.getDataChanged();
        Boolean isPush = model.getDataEntity().getDataEntityState().isPushChanged();
        String detailType = (String)model.getValue("detailtype");
        if (isPush.booleanValue() && detailType.equalsIgnoreCase("biztype_changebill")) {
            switch (opType) {
                case "bar_changea": {
                    model.setValue("changetype", (Object)"A");
                    ContractUtil.clearExpAmount((IDataModel)model, (IFormView)view);
                    break;
                }
                case "bar_changeb": {
                    model.setValue("changetype", (Object)"B");
                    break;
                }
                case "bar_changec": {
                    model.setValue("changetype", (Object)"C");
                    ContractUtil.clearExpAmount((IDataModel)model, (IFormView)view);
                    break;
                }
                case "bar_changed": 
                case "bar_changed_frame": {
                    model.setValue("changetype", (Object)"D");
                    break;
                }
            }
        }
        if (isPush.booleanValue() && this.getModel().getEntryRowCount("projectentryentity") > 0) {
            DynamicObjectCollection partycoll;
            Set collect;
            DynamicObject unit = (DynamicObject)this.getModel().getValue("projectwunit", 0);
            String projectwtype = (String)this.getModel().getValue("projectwtype", 0);
            if (unit != null && (collect = (partycoll = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("contractpartyentry")).stream().filter(v -> v.getDynamicObject("contractparty") != null).collect(Collectors.toSet())).size() == 0) {
                for (int i = 0; i < partycoll.size(); ++i) {
                    DynamicObject partyObj = (DynamicObject)partycoll.get(i);
                    if (!"1".equals(partyObj.getString("signcontract"))) continue;
                    this.getModel().setValue("contractparty", (Object)unit, i);
                    this.getModel().setValue("partytype", (Object)projectwtype, i);
                    this.getModel().setValue("partb", (Object)unit);
                    this.getModel().setValue("partbtype", (Object)projectwtype);
                    break;
                }
            }
        }
        if (!dataChanged) {
            model.setDataChanged(dataChanged);
        }
        AdvContainer projectContainer = (AdvContainer)this.getControl("advconapproject");
        int entryRowCount = this.getModel().getEntryRowCount("projectentryentity");
        if (entryRowCount < 1) {
            projectContainer.setCollapse(true);
        } else {
            projectContainer.setCollapse(false);
        }
        int itemRowCount = this.getModel().getEntryRowCount("termentry");
        AdvContainer advconap32 = (AdvContainer)view.getControl("advconap32");
        if (itemRowCount > 0) {
            advconap32.setCollapse(false);
        } else {
            advconap32.setCollapse(true);
        }
        if (isPush.booleanValue() && !detailType.equals("biztype_stopbill")) {
            ContractUtil.refreshWriteOffAmount((IDataModel)this.getModel(), (WriteOffFields)ContractProjectWriteOffFields.getInstance());
        }
        ContractUtil.controlEndDate((IDataModel)model, (Object)model.getValue("startdate"), (DateEdit)((DateEdit)this.getControl("enddate")));
        ContractUtil.setFrameworkcontractChange((IDataModel)model, (IFormView)this.getView(), (Boolean)((Boolean)this.getModel().getValue("frameworkcontract")));
        ContractUtil.controlEndDate((IDataModel)model, (Object)model.getValue("signdate"), (DateEdit)((DateEdit)this.getControl("changedate")));
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        switch (key = ((TextEdit)e.getSource()).getKey()) {
            case "contractsconn": {
                this.getView().invokeOperation("selectcontracts");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        int rowIndex = valueSet[0].getRowIndex();
        Object oldValue = valueSet[0].getOldValue();
        Object newValue = valueSet[0].getNewValue();
        boolean isCountByExpense = true;
        IDataModel model = this.getModel();
        BigDecimal paypercent = BigDecimal.ZERO;
        BigDecimal expenseamount = BigDecimal.ZERO;
        switch (propName) {
            case "frameworkcontract": {
                ContractUtil.setFrameworkcontractChange((IDataModel)model, (IFormView)this.getView(), (Boolean)((Boolean)newValue));
                break;
            }
            case "currexpenseamount": {
                model.setValue("expnotpayamount", newValue, rowIndex);
                this.sumBillAmount(model);
                ContractUtil.refreshWriteOffAmount((IDataModel)this.getModel(), (WriteOffFields)ContractProjectWriteOffFields.getInstance());
                break;
            }
            case "orinotpayamount": {
                BigDecimal amount = (BigDecimal)newValue;
                BigDecimal changerate = (BigDecimal)model.getValue("changerate");
                DynamicObject currency = (DynamicObject)model.getValue("currency");
                int amtprecision = currency.getInt("amtprecision");
                String expquotetype = (String)model.getValue("quotetype");
                BigDecimal currNotPayAmount = AmountUtils.getCurrencyAmount((BigDecimal)amount, (BigDecimal)changerate, (int)amtprecision, (String)expquotetype);
                model.setValue("notpayamount", (Object)currNotPayAmount);
                BigDecimal orinonpayAmount = (BigDecimal)model.getValue("orinonpayamount");
                model.setValue("oriavailableamount", (Object)amount.subtract(orinonpayAmount));
                break;
            }
            case "expnotpayamount": {
                this.getModel().setValue("notpayamount", (Object)AmountUtils.getEntryAmount((IDataModel)this.getModel(), (String)"expenseentryentity", (String)"expnotpayamount"));
                break;
            }
            case "oriapplyamount": {
                break;
            }
            case "billtaxamount": {
                ContractUtil.refreshOriginalAmount((IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "contractparty": {
                ContractUtil.setTel((IDataModel)this.getModel(), (int)rowIndex);
                ContractUtil.deleteProjectEntry((Object)valueSet[0].getOldValue(), (IDataModel)this.getModel());
                this.getView().updateView("partb");
                break;
            }
            case "contractsconn": {
                if (!StringUtils.isEmpty((String)((String)newValue))) break;
                this.getModel().deleteEntryData("contractrelation");
                break;
            }
            case "partytype": {
                ContractUtil.clearTel((IDataModel)this.getModel(), (int)rowIndex);
                ContractUtil.deleteProjectEntry((Object)valueSet[0].getOldValue(), (IDataModel)this.getModel());
                break;
            }
            case "changetype": {
                if (model.getValue("detailtype").equals("biztype_applybill")) {
                    return;
                }
                int expcount = model.getEntryRowCount("expenseentryentity");
                if (newValue.equals("C") || newValue.equals("C")) break;
                for (int i = expcount - 1; i >= 0; --i) {
                    if (!model.getValue("itemfrom", i).equals("0")) continue;
                    model.deleteEntryRow("expenseentryentity", i);
                }
                break;
            }
            case "expenseamount": {
                ContractUtil.refreshWriteOffAmount((IDataModel)this.getModel(), (WriteOffFields)ContractProjectWriteOffFields.getInstance());
                model.setValue("oriexpnotpayamount", newValue, rowIndex);
                break;
            }
            case "oriprojectwriteoffamount": {
                ContractUtil.refreshWriteOffCurrAmount((IDataModel)this.getModel(), (int)rowIndex, (IFormView)this.getView());
                break;
            }
            case "iscurrency": {
                this.getModel().setValue("contractcurrency", this.getModel().getValue("currency"));
                break;
            }
            case "startdate": {
                ContractUtil.controlEndDate((IDataModel)this.getModel(), (Object)newValue, (DateEdit)((DateEdit)this.getControl("enddate")));
                break;
            }
            case "changedate": {
                Date signdate = this.getModel().getDataEntity().getDate("signdate");
                Date changedate = (Date)newValue;
                if (!changedate.before(signdate)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d8\u66f4\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u7b7e\u8ba2\u65e5\u671f\u3002", (String)"ContractUtil_38", (String)"fi-er-business", (Object[])new Object[0]));
                break;
            }
            case "entrycostcompany": {
                int entryRowCount = this.getModel().getEntryRowCount("expenseentryentity");
                if (entryRowCount <= 0 || ContractUtil.checkExpenseItem((IDataModel)this.getModel(), (IFormView)this.getView(), (int)rowIndex)) break;
                this.getModel().setValue("expenseitem", null, rowIndex);
                break;
            }
            case "projectwriteoffamount": {
                String writeType = this.getWriteOffType();
                if (!writeType.equals("2")) break;
                ContractUtil.changeOriWriteOffAmount((BigDecimal)((BigDecimal)newValue), (int)rowIndex, (IDataModel)model);
                break;
            }
            case "orientryamount": {
                ContractUtil.refreshOriginalAmount((IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "expebalanceamount": {
                model.setValue("balanceamount", (Object)AmountUtils.getEntryAmount((IDataModel)this.getModel(), (String)"expenseentryentity", (String)"expebalanceamount"));
                break;
            }
            case "contractamount": {
                ContractUtil.refreshWriteOffAmount((IDataModel)this.getModel(), (WriteOffFields)ContractProjectWriteOffFields.getInstance());
                ContractUtil.refreshOriginalAmount((IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "signdate": {
                if (newValue == null) break;
                model.setValue("bizdate", newValue);
                break;
            }
            case "paybyrata": {
                model.setValue("prorataamount", (Object)BigDecimal.ZERO);
                model.setValue("proratataxamount", (Object)BigDecimal.ZERO);
                DynamicObjectCollection entryEntitys = model.getEntryEntity("expenseentryentity");
                if (entryEntitys.size() == 0) {
                    return;
                }
                for (int i = 0; i < entryEntitys.size(); ++i) {
                    model.setValue("paypercent", (Object)BigDecimal.ZERO, i);
                }
                break;
            }
            case "paypercent": {
                int entryPrecision = ((DynamicObject)model.getValue("contractcurrency")).getInt("amtprecision");
                paypercent = (BigDecimal)newValue;
                BigDecimal prorataamount = (BigDecimal)model.getValue("prorataamount");
                expenseamount = prorataamount.multiply(paypercent).divide(BigDecimal.valueOf(100L), entryPrecision, RoundingMode.HALF_EVEN);
                model.setValue("expenseamount", (Object)expenseamount, rowIndex);
                break;
            }
            case "prorataamount": {
                DynamicObjectCollection entryEntity = model.getEntryEntity("expenseentryentity");
                if (entryEntity.size() == 0) {
                    return;
                }
                int precision = ((DynamicObject)model.getValue("contractcurrency")).getInt("amtprecision");
                for (int i = 0; i < entryEntity.size(); ++i) {
                    paypercent = (BigDecimal)((DynamicObject)entryEntity.get(i)).get("paypercent");
                    expenseamount = ((BigDecimal)model.getValue("prorataamount")).multiply(paypercent).divide(BigDecimal.valueOf(100L), precision, RoundingMode.HALF_EVEN);
                    model.setValue("expenseamount", (Object)expenseamount, i);
                }
                break;
            }
            case "notpayamount": {
                BigDecimal notpayamount = (BigDecimal)newValue;
                BigDecimal nonpayAmount = (BigDecimal)model.getValue("nonpayamount");
                model.setValue("availableamount", (Object)notpayamount.subtract(nonpayAmount));
                break;
            }
            case "std_entrycostcenter": {
                if (newValue == null || newValue == "") break;
                ErCostCenterUtil.costEntryCenterChangeContractForPC((IFormView)this.getView(), (Object)newValue, (int)rowIndex);
                break;
            }
        }
    }

    private void sumBillAmount(IDataModel dataModel) {
        BigDecimal expenseamount = AmountUtils.getEntryAmount((IDataModel)dataModel, (String)"expenseentryentity", (String)"expenseamount");
        dataModel.setValue("oribalanceamount", (Object)expenseamount);
        dataModel.setValue("oricanloanamount", (Object)expenseamount);
        dataModel.setValue("orinotpayamount", (Object)expenseamount);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String key = ((FormOperate)e.getSource()).getOperateKey();
        ArrayList<String> status = new ArrayList<String>();
        status.add((String)this.getModel().getValue("billstatus"));
        if (ContractUtil.isFrozen(status) && ContractUtil.isFrozenOp((String)key)) {
            e.setCancel(true);
            String opName = ((FormOperate)e.getSource()).getOperateName().toString();
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u5904\u4e8e\u51bb\u7ed3\u72b6\u6001\uff0c\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"ContractBillEdit_3", (String)"fi-er-formplugin", (Object[])new Object[0]), opName));
        }
        switch (key) {
            case "draw_project": {
                DynamicObjectCollection partycoll = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("contractpartyentry");
                Set collect = partycoll.stream().filter(v -> v.getDynamicObject("contractparty") != null).collect(Collectors.toSet());
                if (collect.size() != 0 || !ContractUtil.isFilterBySup((IDataModel)this.getModel())) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7b7e\u7ea6\u65b9\u540d\u79f0\u3002", (String)"ContractBillEdit_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
            case "frozen": {
                ContractUtil.froze((Long)((Long)this.getModel().getDataEntity().getPkValue()), (IFormView)this.getView());
                break;
            }
            case "unfrozen": {
                ContractUtil.unFroze((Long)((Long)this.getModel().getDataEntity().getPkValue()), (IFormView)this.getView());
                break;
            }
            case "save": 
            case "submit": {
                ContractUtil.contractPaybyrataCheckAmount((BeforeDoOperationEventArgs)e, (IDataModel)this.getModel(), (IFormView)this.getView());
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        IDataModel model = this.getModel();
        switch (key) {
            case "selectcontracts": {
                ContractUtil.setHeadConnContracts((IDataModel)this.getModel());
                break;
            }
            case "unfrozen": {
                OperationResult opResult = e.getOperationResult();
                if (opResult.isSuccess()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u89e3\u51bb\u6210\u529f\u3002", (String)"ContractBillList_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
                }
            }
            case "newentrypartya": {
                int entryRowCount = model.getEntryRowCount("contractpartyentry");
                model.setValue("signcontract", (Object)"0", entryRowCount - 1);
                model.setValue("partytype", (Object)"bos_org", entryRowCount - 1);
                break;
            }
            case "newentrypartyb": {
                int entryRowCounts = model.getEntryRowCount("contractpartyentry");
                model.setValue("signcontract", (Object)"1", entryRowCounts - 1);
                model.setValue("partytype", (Object)"bd_supplier", entryRowCounts - 1);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        switch (entryName) {
            case "contractpartyentry": {
                RowDataEntity[] rowDataEntities = e.getRowDataEntities();
                break;
            }
            case "projectentryentity": {
                ContractUtil.refreshWriteOffAmount((IDataModel)this.getModel(), (WriteOffFields)ContractProjectWriteOffFields.getInstance());
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        int[] rowIndexs = e.getRowIndexs();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (entryName) {
            case "expenseentryentity": {
                if (((Boolean)this.getModel().getValue("frameworkcontract")).booleanValue()) {
                    return;
                }
                if (!model.getValue("detailtype").equals("biztype_changebill") || !model.getValue("itemfrom", rowIndexs[0]).equals("1")) break;
                view.showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u751f\u6210\u7684\u5206\u5f55\u884c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ContractBillEdit_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            case "contractpartyentry": {
                if (!model.getValue("detailtype").equals("biztype_changebill") || !model.getValue("partentryfrom", rowIndexs[0]).equals("botp")) break;
                view.showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u751f\u6210\u7684\u5206\u5f55\u884c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ContractBillEdit_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        IDataModel dataModel = this.getModel();
        switch (entryName) {
            case "expenseentryentity": {
                this.sumBillAmount(dataModel);
                ContractUtil.refreshHeadAmountByExpense((IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "projectentryentity": {
                ContractUtil.refreshWriteOffAmount((IDataModel)this.getModel(), (WriteOffFields)ContractProjectWriteOffFields.getInstance());
                break;
            }
            case "contractpartyentry": {
                ContractUtil.deleteProjectEntry(null, (IDataModel)this.getModel());
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        int rowIndex = evt.getRowIndex();
        switch (fieldName) {
            case "projectbillno": {
                ContractUtil.handleProjectHyperLink((IDataModel)this.getModel(), (IFormView)this.getView(), (int)rowIndex);
                break;
            }
            case "wbsrcbillno": {
                ContractUtil.handlePurContractHyperLink((IDataModel)this.getModel(), (IFormView)this.getView(), (int)rowIndex);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setWriteOffType();
    }
}

