/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.bill.contract;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.isc.IscHelper;
import kd.fi.er.business.pub.ContractUtil;
import kd.fi.er.business.pub.PublicUpBillUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.utils.ErStdConfig;
import org.apache.commons.lang.StringUtils;

public class ContractBillList
extends AbstractListPlugin {
    private static final String BAR_CHANGEA = "bar_changea";
    private static final String BAR_CHANGEB = "bar_changeb";
    private static final String BAR_CHANGEC = "bar_changec";
    private static final String BAR_CHANGED = "bar_changed";
    private static final String BAR_CHANGED_FRAME = "bar_changed_frame";
    private static final String EXPENSEENTRYENTITY_SOURCEBILLNO = "expenseentryentity.wbsrcbillno";
    private static final String EXPENSEENTRYENTITY_WBSRCBILLTYPE = "expenseentryentity.wbsrcbilltype";
    private static final Log logger = LogFactory.getLog(ContractBillList.class);
    private static String[] opkey = new String[]{"submit", "docontractsign", "updateconsign", "frozen", "unfrozen", "closebill", "pushtocontractstop"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{BAR_CHANGEA, BAR_CHANGEB, BAR_CHANGEC, BAR_CHANGED, BAR_CHANGED_FRAME, "barstopbill"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "bar_changea": {
                this.checkChangePush(evt, BAR_CHANGEA, ResManager.loadKDString((String)"\u53d8\u66f4\u91d1\u989d", (String)"ContractBillList_90", (String)"fi-er-formplugin", (Object[])new Object[0]));
                break;
            }
            case "bar_changeb": {
                this.checkChangePush(evt, BAR_CHANGEB, ResManager.loadKDString((String)"\u53d8\u66f4\u7a0e\u7387", (String)"ContractBillList_91", (String)"fi-er-formplugin", (Object[])new Object[0]));
                break;
            }
            case "bar_changec": {
                this.checkChangePush(evt, BAR_CHANGEC, ResManager.loadKDString((String)"\u6b64\u53d8\u66f4\u64cd\u4f5c", (String)"ContractBillList_92", (String)"fi-er-formplugin", (Object[])new Object[0]));
                break;
            }
            case "bar_changed": {
                this.checkChangePush(evt, BAR_CHANGED, ResManager.loadKDString((String)"\u53d8\u66f4\u5176\u4ed6", (String)"ContractBillList_93", (String)"fi-er-formplugin", (Object[])new Object[0]));
                break;
            }
            case "bar_changed_frame": {
                this.checkChangePush(evt, BAR_CHANGED_FRAME, ResManager.loadKDString((String)"\u53d8\u66f4\u6846\u67b6\u5408\u540c", (String)"ContractBillList_94", (String)"fi-er-formplugin", (Object[])new Object[0]));
                break;
            }
            case "barstopbill": {
                Set ids = this.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
                if (ids.size() == 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ContractBillList_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
        }
    }

    private void checkChangePush(BeforeItemClickEvent evt, String changeoOpType, String itemTitle) {
        DynamicObjectCollection prepayBills;
        long count;
        QFilter qFilter;
        Set ids = this.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        if (ids.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ContractBillList_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        IListView listView = (IListView)this.getView();
        String entityName = listView.getListModel().getEntityId();
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        for (ListSelectedRow selectedRow : selectedRows) {
            Object primaryKeyValues = selectedRow.getPrimaryKeyValue();
            qFilter = new QFilter("id", "=", primaryKeyValues);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)entityName, (String)"frameworkcontract,billno,paybyrata,stdbilltype,detailtype,sbilltype", (QFilter[])new QFilter[]{qFilter});
            if ("1".equals(dynamicObject.get("sbilltype"))) {
                this.getView().showTipNotification(String.format(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s\u4e3a\u96c6\u6210\u5355\u636e\uff0c\u65e0\u6cd5\u8fdb\u884c\u6b64\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ContractBillList_28", (String)"fi-er-formplugin", (Object[])new Object[0]), dynamicObject.getString("billno")), new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (BAR_CHANGED_FRAME.equals(changeoOpType)) continue;
            if (dynamicObject.getBoolean("frameworkcontract")) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6846\u67b6\u5408\u540c\u4e0d\u652f\u6301%1$s\u3002", (String)"ContractBillList_95", (String)"fi-er-formplugin", (Object[])new Object[0]), itemTitle));
                evt.setCancel(true);
                return;
            }
            if (!"biztype_applybill".equals(dynamicObject.getString("detailtype")) || !dynamicObject.getBoolean("paybyrata") || !BAR_CHANGEA.equals(changeoOpType) && !BAR_CHANGEC.equals(changeoOpType)) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6309\u6bd4\u4f8b\u652f\u4ed8\u5408\u540c\u6682\u65f6\u4e0d\u652f\u6301%1$s\u3002", (String)"ContractBillList_97", (String)"fi-er-formplugin", (Object[])new Object[0]), itemTitle));
            evt.setCancel(true);
            return;
        }
        String OnWayCondition = "A,B,C,D";
        String selectedProperties = String.join((CharSequence)",", "id", "billstatus", "stdbilltype", "changetype");
        if (BAR_CHANGEB.equals(changeoOpType)) {
            String changetypes = "A,C";
            qFilter = new QFilter("expenseentryentity.wbsrcbillid", "in", ids);
            qFilter.and("billstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"A", "B", "C", "D", "E", "J", "I"}));
            QFilter[] filters = new QFilter[]{qFilter};
            DynamicObject[] loads = BusinessDataServiceHelper.load((String)"er_contractbill", (String)selectedProperties, (QFilter[])filters);
            boolean boochangetype = Arrays.stream(loads).anyMatch(v -> changetypes.contains(v.getString("changetype")));
            if (boochangetype) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5df2\u505a\u8fc7\u91d1\u989d\u53d8\u66f4\u7684\u5355\u636e\u4e0d\u53ef\u53d8\u66f4\u7a0e\u7387\u3002", (String)"ContractBillList_98", (String)"fi-er-formplugin", (Object[])new Object[0]), new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
        if ((count = (prepayBills = QueryServiceHelper.query((String)"er_contractbill", (String)selectedProperties, (QFilter[])new QFilter[]{new QFilter("srcsourceid", "in", ids)})).stream().filter(prepayBillOnWay -> OnWayCondition.contains(prepayBillOnWay.getString("billstatus"))).count()) > 0L) {
            this.getView().showTipNotification(String.format(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u4e0b\u6e38\u5355\u636e\uff0c\u8bf7\u5148\u5b8c\u6210\u6d41\u7a0b\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u201c%1$s\u201d\u3002", (String)"ContractBillList_9", (String)"fi-er-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u53d8\u66f4", (String)"ContractBillList_96", (String)"fi-er-formplugin", (Object[])new Object[0])), new Object[0]));
            evt.setCancel(true);
            return;
        }
        List onwayids = ContractUtil.checkHasOnWayBills((ListSelectedRowCollection)selectedRows, (String)OnWayCondition);
        if (onwayids.size() > 0) {
            this.getView().showTipNotification(String.format(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u4e0b\u6e38\u5355\u636e\uff0c\u8bf7\u5148\u5b8c\u6210\u6d41\u7a0b\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u201c%1$s\u201d\u3002", (String)"ContractBillList_9", (String)"fi-er-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u53d8\u66f4", (String)"ContractBillList_96", (String)"fi-er-formplugin", (Object[])new Object[0])), new Object[0]));
            evt.setCancel(true);
            return;
        }
        this.getView().getPageCache().put("changeoOpType", changeoOpType);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        OperationResult result = e.getOperationResult();
        IDataModel dataModel = this.getModel();
        ListView listView = (ListView)this.getView();
        ListSelectedRowCollection selectedRowCollection = listView.getSelectedRows();
        List pks = selectedRowCollection.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        switch (key) {
            case "audit": {
                break;
            }
            case "unfrozen": {
                if (!result.isSuccess()) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u89e3\u51bb\u6210\u529f\u3002", (String)"ContractBillList_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
                break;
            }
            case "frozen": {
                if (!result.isSuccess()) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u51bb\u7ed3\u6210\u529f\u3002", (String)"ContractBillList_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection selectedBills;
        Set collect;
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        List lists = args.getListSelectedData().stream().map(v -> (Long)v.getPrimaryKeyValue()).collect(Collectors.toList());
        String opName = ((FormOperate)args.getSource()).getOperateName().toString();
        String OnWayStatus = "A,B,C,D";
        if (ContractUtil.isFrozen(args.getListSelectedData().stream().map(ListSelectedRow::getBillStatus).collect(Collectors.toList())) && ContractUtil.isFrozenOp((String)operateKey)) {
            args.setCancel(true);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u5904\u4e8e\u51bb\u7ed3\u72b6\u6001\uff0c\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"ContractBillList_4", (String)"fi-er-formplugin", (Object[])new Object[0]), opName));
            return;
        }
        if (Arrays.stream(opkey).anyMatch(v -> operateKey.equals(v)) && (collect = (selectedBills = QueryServiceHelper.query((String)"er_contractbill", (String)"id,billno,detailtype,billstatus,sbilltype", (QFilter[])new QFilter[]{new QFilter("id", "in", lists)})).stream().filter(o -> o.get("sbilltype").equals("1")).map(o -> o.getString("billno")).collect(Collectors.toSet())).size() > 0) {
            this.getView().showTipNotification(String.format(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s\u4e3a\u96c6\u6210\u5355\u636e\uff0c\u65e0\u6cd5\u8fdb\u884c\u6b64\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ContractBillList_28", (String)"fi-er-formplugin", (Object[])new Object[0]), collect.toString()), new Object[0]));
            args.setCancel(true);
            return;
        }
        ListSelectedRowCollection rows = args.getListSelectedData();
        switch (operateKey) {
            case "changedprojectower": {
                QFilter qFilter = new QFilter("id", "in", lists);
                String OnWayCondition = "H,I,J";
                DynamicObjectCollection selectedBills2 = QueryServiceHelper.query((String)"er_contractbill", (String)"id,detailtype,billstatus", (QFilter[])new QFilter[]{qFilter});
                Set billstatusSet = selectedBills2.stream().filter(v -> OnWayCondition.contains(v.getString("billstatus"))).collect(Collectors.toSet());
                if (billstatusSet.size() > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u7684\u5355\u636e\u72b6\u6001\u4e0d\u652f\u6301\u53d8\u66f4\u5e72\u7cfb\u4eba\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5355\u636e\u3002", (String)"ContractBillList_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Set detailtypeSet = selectedBills2.stream().filter(v -> "biztype_stopbill".equals(v.get("detailtype")) || "biztype_changebill".equals(v.get("detailtype"))).collect(Collectors.toSet());
                if (detailtypeSet.size() <= 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5408\u540c\u53d8\u66f4\u5355/\u5408\u540c\u7ec8\u6b62\u5355\u4e0d\u652f\u6301\u53d8\u66f4\u5e72\u7cfb\u4eba\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5355\u636e\u3002", (String)"ContractBillList_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            case "frozen": {
                for (ListSelectedRow row : rows) {
                    if (ContractUtil.froze((Long)((Long)row.getPrimaryKeyValue()), (IFormView)this.getView())) continue;
                    args.setCancel(true);
                }
                break;
            }
            case "unfrozen": {
                for (ListSelectedRow row : rows) {
                    if (ContractUtil.unFroze((Long)((Long)row.getPrimaryKeyValue()), (IFormView)this.getView())) continue;
                    args.setCancel(true);
                }
                break;
            }
            case "publicreimburse": {
                if (!ContractUtil.checkRelationContract((IFormView)this.getView(), (ListSelectedRowCollection)rows, (String)ResManager.loadKDString((String)"\u5bf9\u516c\u62a5\u9500\u5355", (String)"ApplyPayMobEdit_1", (String)"fi-er-formplugin", (Object[])new Object[0]))) {
                    args.setCancel(true);
                    return;
                }
                if (!this.checkDownRepayBill()) {
                    args.setCancel(true);
                    break;
                }
                OnWayStatus = OnWayStatus + ",F";
                List listpub = ContractUtil.checkDownBills((ListSelectedRowCollection)rows, (String)operateKey);
                if (listpub.size() > 0) {
                    this.getView().showTipNotification(String.format(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u4e0b\u6e38\u5355\u636e\uff0c\u8bf7\u5148\u5b8c\u6210\u6d41\u7a0b\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u201c%1$s\u201d\u3002", (String)"ContractBillList_9", (String)"fi-er-formplugin", (Object[])new Object[0]), opName), new Object[0]));
                    args.setCancel(true);
                }
                if (ContractUtil.checkMultiPublicReim((ListSelectedRowCollection)rows, (IFormView)this.getView())) break;
                args.setCancel(true);
                break;
            }
            case "pushtoprepay": {
                if (!ContractUtil.checkRelationContract((IFormView)this.getView(), (ListSelectedRowCollection)rows, (String)ResManager.loadKDString((String)"\u9884\u4ed8\u5355", (String)"ErHomeAddNewDialogPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]))) {
                    args.setCancel(true);
                    break;
                }
                if (!this.checkDownRepayBill()) {
                    args.setCancel(true);
                    break;
                }
                OnWayStatus = OnWayStatus + ",F";
                List listpre = ContractUtil.checkDownBills((ListSelectedRowCollection)rows, (String)operateKey);
                if (listpre.size() > 0) {
                    this.getView().showTipNotification(String.format(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u4e0b\u6e38\u5355\u636e\uff0c\u8bf7\u5148\u5b8c\u6210\u6d41\u7a0b\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u201c%1$s\u201d\u3002", (String)"ContractBillList_9", (String)"fi-er-formplugin", (Object[])new Object[0]), opName), new Object[0]));
                    args.setCancel(true);
                }
                if (ContractUtil.checkMultiPublicReim((ListSelectedRowCollection)rows, (IFormView)this.getView())) break;
                args.setCancel(true);
                break;
            }
            case "pushtocontractstop": {
                List list = ContractUtil.checkDownBills((ListSelectedRowCollection)rows, (String)operateKey);
                if (list.size() > 0) {
                    this.getView().showTipNotification(String.format(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u4e0b\u6e38\u5355\u636e\uff0c\u8bf7\u5148\u5b8c\u6210\u6d41\u7a0b\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u201c%1$s\u201d\u3002", (String)"ContractBillList_9", (String)"fi-er-formplugin", (Object[])new Object[0]), opName), new Object[0]));
                    args.setCancel(true);
                }
                String OnWayCondition = "A,B,C,D";
                String selectedProperties = String.join((CharSequence)",", "id", "billstatus");
                DynamicObjectCollection prepayBills = QueryServiceHelper.query((String)"er_contractbill", (String)selectedProperties, (QFilter[])new QFilter[]{new QFilter("srcsourceid", "in", lists)});
                long count = prepayBills.stream().filter(prepayBillOnWay -> OnWayCondition.contains(prepayBillOnWay.getString("billstatus"))).count();
                if (count <= 0L) break;
                this.getView().showTipNotification(String.format(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u4e0b\u6e38\u5355\u636e\uff0c\u8bf7\u5148\u5b8c\u6210\u6d41\u7a0b\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u201c%1$s\u201d\u3002", (String)"ContractBillList_9", (String)"fi-er-formplugin", (Object[])new Object[0]), opName), new Object[0]));
                args.setCancel(true);
                return;
            }
            case "pushcontractchange": {
                List onwaylist = ContractUtil.checkDownBills((ListSelectedRowCollection)rows, (String)operateKey);
                if (onwaylist.size() <= 0) break;
                this.getView().showTipNotification(String.format(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u4e0b\u6e38\u5355\u636e\uff0c\u8bf7\u5148\u5b8c\u6210\u6d41\u7a0b\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u201c%1$s\u201d\u3002", (String)"ContractBillList_9", (String)"fi-er-formplugin", (Object[])new Object[0]), opName), new Object[0]));
                args.setCancel(true);
                break;
            }
            case "pushcostestimatebill": {
                boolean b = this.checkCostestimatebill(args, this.getView(), rows);
                if (!b) {
                    return;
                }
                List listContract = ContractUtil.checkDownBills((ListSelectedRowCollection)rows, (String)operateKey);
                if (listContract.size() <= 0) break;
                this.getView().showTipNotification(String.format(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u4e0b\u6e38\u5355\u636e\uff0c\u8bf7\u5148\u5b8c\u6210\u6d41\u7a0b\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u201c%1$s\u201d\u3002", (String)"ContractBillList_9", (String)"fi-er-formplugin", (Object[])new Object[0]), opName), new Object[0]));
                args.setCancel(true);
                break;
            }
            case "docontractsign": {
                this.docontractsign(args, this.getView(), rows, operateKey);
                break;
            }
            case "updateconsign": {
                this.docontractsign(args, this.getView(), rows, operateKey);
                break;
            }
            case "pushwithholding": {
                if (ContractUtil.checkMultiPublicReim((ListSelectedRowCollection)rows, (IFormView)this.getView())) break;
                args.setCancel(true);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "importdts": {
                try {
                    IscHelper.checkExistBefore((IFormView)this.getView(), (boolean)true);
                    break;
                }
                catch (Exception e) {
                    logger.error("ContractBillList>>>>>itemClick>:\u5931\u8d25\uff0c\u539f\u56e0\u5982\u4e0b\uff1a", (Throwable)e);
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        try {
            IscHelper.importConfirmCallBack((MessageBoxClosedEvent)evt, (IFormView)this.getView());
        }
        catch (IOException e) {
            logger.error("ErAbstractReportList>>>confirmCallBack:\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u5982\u4e0b\uff1a", (Throwable)e);
        }
    }

    private boolean checkCostestimatebill(BeforeDoOperationEventArgs args, IFormView view, ListSelectedRowCollection selectedRows) {
        if (selectedRows.size() <= 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ContractBillList_10", (String)"fi-er-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        Object[] primaryKeyValue = selectedRows.getPrimaryKeyValues();
        QFilter filter = new QFilter("id", "in", (Object)primaryKeyValue);
        String selectFields = "company,id,frameworkcontract,enddate,billno";
        DynamicObjectCollection contractDy = QueryServiceHelper.query((String)"er_contractbill", (String)selectFields, (QFilter[])new QFilter[]{filter});
        long frameworkcontract = contractDy.stream().filter(it -> !it.getBoolean("frameworkcontract")).count();
        if (frameworkcontract > 0L) {
            args.setCancel(true);
            view.showTipNotification(ResManager.loadKDString((String)"\u4ec5\u6846\u67b6\u5408\u540c\u53ef\u4e0b\u63a8\u8d39\u7528\u6682\u4f30\u5355\u3002", (String)"ContractBillList_15", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return false;
        }
        Boolean contractdeadlinecontrol = ErStdConfig.getContractDeadlineControl();
        logger.info(">>>>>>>>>>>>>>>>>contractdeadlinecontrol:" + contractdeadlinecontrol);
        if (!contractdeadlinecontrol.booleanValue()) {
            Date now = TripCommonUtil.strToDate((String)TripCommonUtil.DateToStr((Date)new Date()), (String)"yyyy-MM-dd");
            StringBuilder errorbillno = new StringBuilder();
            contractDy.stream().forEach(row -> {
                Date enddate;
                Date date = enddate = row.get("enddate") != null ? TripCommonUtil.strToDate((String)TripCommonUtil.DateToStr((Date)((Date)row.get("enddate"))), (String)"yyyy-MM-dd") : null;
                if (enddate != null && now.after(enddate)) {
                    errorbillno.append(" ").append(row.get("billno"));
                }
            });
            logger.info(">>>>>>>>>>>>>>>>>contractdeadlinecontrol>>>>errorbillno:" + errorbillno);
            if (errorbillno.length() > 0) {
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u5df2\u8d85\u8fc7\u5408\u540c\u622a\u6b62\u65e5\u671f\uff0c\u65e0\u6cd5\u4e0b\u63a8\u3002", (String)"ContractBillList_24", (String)"fi-er-formplugin", (Object[])new Object[0]), errorbillno));
                args.setCancel(true);
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void docontractsign(BeforeDoOperationEventArgs args, IFormView view, ListSelectedRowCollection selectedRows, String operateKey) {
        String formname;
        Object[] primaryKeyValue;
        block7: {
            Set collect = selectedRows.stream().map(b -> (Long)b.getPrimaryKeyValue()).collect(Collectors.toSet());
            if (collect.size() > 1 || collect.size() <= 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ContractBillList_10", (String)"fi-er-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            primaryKeyValue = selectedRows.getPrimaryKeyValues();
            QFilter filter = new QFilter("id", "=", primaryKeyValue[0]);
            QFilter filters = new QFilter("expenseentryentity.wbsrcbillid", "=", primaryKeyValue[0]);
            String selectFields = "id,billno,billstatus,detailtype,changetype";
            Optional.ofNullable(filters).ifPresent(arg_0 -> ((QFilter)filter).or(arg_0));
            DynamicObjectCollection contractDy = QueryServiceHelper.query((String)"er_contractbill", (String)selectFields, (QFilter[])new QFilter[]{filter});
            formname = ResManager.loadKDString((String)"\u786e\u8ba4\u7b7e\u7ea6\u4fe1\u606f", (String)"ContractBillList_12", (String)"fi-er-formplugin", (Object[])new Object[0]);
            List applybillDy = contractDy.stream().filter(v -> "biztype_applybill".equals(v.getString("detailtype"))).collect(Collectors.toList());
            if (applybillDy.size() == 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e3a\u201c\u5408\u540c\u53f0\u8d26\u201d\uff0c\u624d\u80fd\u6267\u884c\u6b64\u64cd\u4f5c\u3002", (String)"ContractBillList_31", (String)"fi-er-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String OnWayCondition = "A,B,C,D";
            List changebillDy = contractDy.stream().filter(v -> "biztype_changebill".equals(v.getString("detailtype")) && OnWayCondition.contains(v.getString("billstatus"))).collect(Collectors.toList());
            if (changebillDy.size() > 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u4e0b\u6e38\u53d8\u66f4\u5355\u636e\uff0c\u8bf7\u5148\u5b8c\u6210\u6d41\u7a0b\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ContractBillList_30", (String)"fi-er-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if ("updateconsign".equals(operateKey) && applybillDy.size() > 0) {
                if ("F".equals(((DynamicObject)applybillDy.get(0)).get("billstatus")) && "biztype_applybill".equals(((DynamicObject)applybillDy.get(0)).getString("detailtype"))) {
                    formname = ResManager.loadKDString((String)"\u66f4\u65b0\u7b7e\u7ea6\u4fe1\u606f", (String)"ContractBillList_13", (String)"fi-er-formplugin", (Object[])new Object[0]);
                    break block7;
                } else {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e3a\u201c\u5408\u540c\u53f0\u8d26\u201d\uff0c\u5408\u540c\u72b6\u6001\u4e3a\u201c\u6267\u884c\u4e2d\u201d\u65f6\u624d\u80fd\u6267\u884c\u6b64\u64cd\u4f5c\u3002", (String)"ContractBillList_14", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            if (!(!"docontractsign".equals(operateKey) || applybillDy.size() <= 0 || "E".equals(((DynamicObject)applybillDy.get(0)).get("billstatus")) && "biztype_applybill".equals(((DynamicObject)applybillDy.get(0)).getString("detailtype")))) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e3a\u201c\u5408\u540c\u53f0\u8d26\u201d\uff0c\u5408\u540c\u72b6\u6001\u4e3a\u201c\u5ba1\u6838\u901a\u8fc7\u201d\u65f6\u624d\u80fd\u6267\u884c\u6b64\u64cd\u4f5c\u3002", (String)"ContractBillList_11", (String)"fi-er-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        FormShowParameter showParameter = new FormShowParameter();
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        customParam.put("contractId", primaryKeyValue[0]);
        showParameter.setFormId("er_contractsign");
        showParameter.setCustomParams(customParam);
        showParameter.setCaption(formname);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "er_contractsign"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map returnData;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (StringUtils.equalsIgnoreCase((String)"er_contractsign", (String)actionId) && (returnData = (Map)evt.getReturnData()) != null && returnData.containsKey("ok") && returnData.containsKey("attachmentData")) {
            ContractUtil.synAttachment((IFormView)this.getView(), (Map)returnData);
        }
    }

    private boolean checkDownRepayBill() {
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        for (ListSelectedRow row : selectedRows) {
            if (!PublicUpBillUtil.hasDownOnwayRepayBills((String)"er_contractbill", (ListSelectedRow)row)) continue;
            String billNo = row.getBillNo();
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5df2\u5b58\u5728\u5728\u9014\u4e0b\u6e38\u8fd8\u6b3e\u5355\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u5173\u8054\u9884\u4ed8/\u501f\u6b3e/\u62a5\u9500\u3002", (String)"ProjectPushValidatePlugin_2", (String)"fi-er-formplugin", (Object[])new Object[]{billNo}));
            return false;
        }
        return true;
    }
}

