/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.bill.contract;

import java.util.EventObject;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.pub.ContractUtil;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.daily.mobile.util.MobileEntryUtil;

public class ContractItemEntryAddMobPlugin
extends AbstractMobBillPlugIn
implements ClickListener,
RowClickEventListener {
    private static Log logger = LogFactory.getLog(ContractItemEntryAddMobPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_save", "addcontractitem"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel dataModel = this.getModel();
        IFormView formView = this.getView();
        IDataModel parentModel = formView.getParentView().getModel();
        Object billStatus = parentModel.getValue("billstatus");
        dataModel.setValue("billstatus", billStatus);
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        int index = (Integer)formShowParameter.getCustomParam("index");
        if (index != -1) {
            DynamicObjectCollection expenseColl = parentModel.getEntryEntity("termentry");
            dataModel.beginInit();
            int newRowIndex = MobileEntryUtil.addEntryToModel(dataModel, "termentry", (DynamicObject)expenseColl.get(index), true);
            dataModel.endInit();
            formView.updateView("termentry", newRowIndex);
        } else {
            int size = dataModel.getEntryRowCount("termentry");
            if (size < 1) {
                dataModel.batchCreateNewEntryRow("termentry", 1);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView formView = this.getView();
        IDataModel parentModel = formView.getParentView().getModel();
        CoreBaseBillServiceHelper.setFromStatus((AbstractFormPlugin)this);
        ShowPageUtils.setMobilePageFormStatus((IFormView)formView);
        ContractUtil.setSecondFiledLockAndVisible((String)((String)parentModel.getValue("detailtype")), (String)((String)parentModel.getValue("changetype")), (IDataModel)this.getModel(), (IFormView)formView, (String)"termentry");
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        IDataModel dataModel = this.getModel();
        IFormView formView = this.getView();
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btn_save": {
                ContractUtil.saveContractPartOrItemByHand((IDataModel)dataModel, (IFormView)formView, (String)"termentry");
            }
        }
    }
}

