/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.bill.contract;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.IMobileListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.mvc.list.MobileListView;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.pub.ContractUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.ErBillStatusEnum;
import kd.fi.er.formplugin.mobile.BaseBillListRefreshAuditor;
import org.apache.commons.lang3.StringUtils;

public class ContractMobileBillListPlugin
extends BaseBillListRefreshAuditor
implements ClickListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_frozen", "btn_unfrozen", "btn_changprojectower"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
    }

    public void afterBindData(EventObject e) {
        Long companyId = RequestContext.get().getOrgId();
        String stakeHoldersChange = (String)ErCommonUtils.getEMParameter((long)companyId, (String)"stakeholderschange");
        if (StringUtils.isEmpty((CharSequence)stakeHoldersChange)) {
            return;
        }
        switch (stakeHoldersChange) {
            case "0": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"btn_changprojectower"});
                break;
            }
            case "1": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"btn_changprojectower"});
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter billShowParameter = e.getParameter();
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        Long billId = (Long)billShowParameter.getPkId();
        String formId = billShowParameter.getFormId();
        customParam.put("FormId", formId);
        customParam.put("Status", billShowParameter.getBillStatusValue());
        customParam.put("PageId", billShowParameter.getPageId());
        customParam.put("billId", billId);
        billShowParameter.setPkId(null);
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setCustomParams(customParam);
        formShowParameter.setFormId("er_dlbill_tabap");
        formShowParameter.setCaption(FormMetadataCache.getFormConfig((String)formId).getCaption().getLocaleValue());
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        if (e.getParameter().getBillStatus() != BillOperationStatus.ADDNEW) {
            String billStatus = ((IListView)this.getView()).getCurrentSelectedRowInfo().getBillStatus();
            if (ErBillStatusEnum.C.toString().equals(billStatus) || ErBillStatusEnum.E.toString().equals(billStatus) || ErBillStatusEnum.F.toString().equals(billStatus) || ErBillStatusEnum.G.toString().equals(billStatus) || ErBillStatusEnum.H.toString().equals(billStatus) || ErBillStatusEnum.I.toString().equals(billStatus) || "J".equals(billStatus)) {
                e.getParameter().setBillStatus(BillOperationStatus.AUDIT);
            }
        }
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((FormOperate)args.getSource()).getOperateKey()) {
            case "frozen": {
                ListSelectedRowCollection listSelectedRows = args.getListSelectedData();
                if (listSelectedRows == null || listSelectedRows.size() <= 0 || ContractUtil.froze((Long)((Long)listSelectedRows.get(0).getPrimaryKeyValue()), (IFormView)this.getView())) break;
                args.setCancel(true);
                break;
            }
            case "unfrozen": {
                ListSelectedRowCollection listSelectedRows = args.getListSelectedData();
                if (listSelectedRows == null || listSelectedRows.size() <= 0 || ContractUtil.unFroze((Long)((Long)listSelectedRows.get(0).getPrimaryKeyValue()), (IFormView)this.getView())) break;
                args.setCancel(true);
                break;
            }
            case "changedprojectower": {
                ListSelectedRowCollection listSelectedRows = args.getListSelectedData();
                MobileListView view = (MobileListView)this.getView();
                boolean res = ContractUtil.checkChangeProjectOwer((ListSelectedRowCollection)listSelectedRows, (IMobileListView)view);
                if (res) {
                    args.setCancel(Boolean.TRUE.booleanValue());
                    return;
                }
                ListFilterParameter lfp = new ListFilterParameter();
                lfp.setFilter(new QFilter("enable", "=", (Object)Boolean.TRUE));
                ContractUtil.createShowMobileF7ListForm((String)"bos_user", (boolean)true, (IMobileListView)view, (IFormPlugin)this, (ListFilterParameter)lfp);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (StringUtils.equalsIgnoreCase((CharSequence)actionId, (CharSequence)"projectower")) {
            List selectUsers = (List)evt.getReturnData();
            HashSet ids = new HashSet();
            if (selectUsers != null && selectUsers.size() != 0) {
                selectUsers.stream().forEach(v -> ids.add((Long)v.getPrimaryKeyValue()));
                MobileListView view = (MobileListView)this.getView();
                ContractUtil.setUsersToSelectedBillProjectOwer(ids, (IMobileListView)view, (String)"er_contractbill");
            }
        }
    }
}

