/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.bill.contract;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.pub.ContractUtil;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErCostCenterUtil;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.budget.BudgetCommonUtil;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostCenterF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.util.MobileEntryUtil;

public class ContractPlanEntryAddMobPlugin
extends AbstractMobBillPlugIn
implements ClickListener,
RowClickEventListener {
    private static Log logger = LogFactory.getLog(ContractPlanEntryAddMobPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_save", "addcontractplan"});
        BasedataEdit entryCostCenterF7 = (BasedataEdit)this.getControl("entrycostcenter");
        BeforeCostCenterF7SelectListener beforeCostCenterF7SelectListener = new BeforeCostCenterF7SelectListener(this.getView());
        if (entryCostCenterF7 != null) {
            entryCostCenterF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCenterF7SelectListener);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel dataModel = this.getModel();
        IFormView formView = this.getView();
        IDataModel parentModel = formView.getParentView().getModel();
        Object billStatus = parentModel.getValue("billstatus");
        dataModel.setValue("billstatus", billStatus);
        dataModel.setValue("iscurrency", parentModel.getValue("iscurrency"));
        dataModel.setValue("currency", parentModel.getValue("currency"));
        dataModel.setValue("contractcurrency", parentModel.getValue("contractcurrency"));
        dataModel.setValue("changerate", parentModel.getValue("changerate"));
        dataModel.setValue("prorataamount", parentModel.getValue("prorataamount"));
        dataModel.setValue("paybyrata", parentModel.getValue("paybyrata"));
        dataModel.setValue("quotetype", parentModel.getValue("quotetype"));
        DynamicObject costCompany = (DynamicObject)parentModel.getValue("costcompany");
        dataModel.setValue("costcompany", (Object)costCompany);
        dataModel.setValue("org", parentModel.getValue("org"));
        dataModel.setValue("company", parentModel.getValue("company"));
        dataModel.setValue("applier", parentModel.getValue("applier"));
        dataModel.setValue("bizdate", parentModel.getValue("bizdate"));
        String costCompanyshowType = CommonServiceHelper.getBillCostOrgShowType((IFormView)this.getView().getParentView());
        dataModel.setValue("expensesassumeshowtypes", (Object)costCompanyshowType);
        if (Objects.nonNull(dataModel.getProperty("costorgusemode"))) {
            dataModel.setValue("costorgusemode", parentModel.getValue("costorgusemode"));
        }
        dataModel.setValue("projecttype", parentModel.getValue("projecttype"));
        dataModel.setValue("detailtype", parentModel.getValue("detailtype"));
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        int index = (Integer)formShowParameter.getCustomParam("index");
        if (index != -1) {
            DynamicObjectCollection expenseColl = parentModel.getEntryEntity("expenseentryentity");
            dataModel.beginInit();
            int newRowIndex = MobileEntryUtil.addEntryToModel(dataModel, "expenseentryentity", (DynamicObject)expenseColl.get(index), true);
            dataModel.endInit();
            formView.updateView("expenseentryentity", newRowIndex);
        } else {
            int entryRowCount = dataModel.getEntryRowCount("expenseentryentity");
            if (entryRowCount > 0) {
                DynamicObject costDept = (DynamicObject)parentModel.getValue("costdept");
                DynamicObject costCenter = (DynamicObject)parentModel.getValue("std_costcenter");
                for (int i = 0; i < entryRowCount; ++i) {
                    dataModel.setValue("entrycostdept", costDept == null ? null : costDept.getPkValue(), i);
                    dataModel.setValue("entrycostcompany", costCompany == null ? null : costCompany.getPkValue(), i);
                    dataModel.setValue("entrycostcenter", costCenter == null ? null : costCenter.getPkValue(), i);
                }
                ContractUtil.refreshEntryValue((IDataModel)dataModel, (Object)parentModel.getValue("contractcurrency"), (String)"entrycurrency");
                ContractUtil.refreshEntryValue((IDataModel)dataModel, (Object)parentModel.getValue("changerate"), (String)"exchangerate");
                ContractUtil.refreshEntryValue((IDataModel)dataModel, (Object)parentModel.getValue("quotetype"), (String)"expquotetype");
            }
        }
        Long company = (Long)((DynamicObject)dataModel.getValue("company")).getPkValue();
        if (company == null || company.compareTo(0L) == 0) {
            company = RequestContext.get().getOrgId();
        }
        String budgeMsgValue = (String)ErCommonUtils.getEMParameter((long)company, (String)"budgeMsgControl");
        ContractUtil.setBudgetShow((IDataModel)dataModel, (IFormView)formView, (boolean)BudgetCommonUtil.isShowBudget(formView.getEntityId(), company), (String)budgeMsgValue, (int)-1);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView formView = this.getView();
        IDataModel parentModel = formView.getParentView().getModel();
        CoreBaseBillServiceHelper.setFromStatus((AbstractFormPlugin)this);
        ShowPageUtils.setMobilePageFormStatus((IFormView)formView);
        ContractUtil.setSecondFiledLockAndVisible((String)((String)parentModel.getValue("detailtype")), (String)((String)parentModel.getValue("changetype")), (IDataModel)this.getModel(), (IFormView)formView, (String)"expenseentryentity");
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        IDataModel dataModel = this.getModel();
        IFormView formView = this.getView();
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btn_save": {
                ContractUtil.saveContractPartOrItemByHand((IDataModel)dataModel, (IFormView)formView, (String)"expenseentryentity");
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rowDataEntities;
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        if ("expenseentryentity".equals(entryName) && (rowDataEntities = e.getRowDataEntities()).length > 0) {
            RowDataEntity rowDataEntity = e.getRowDataEntities()[0];
            int rowIndex = rowDataEntity.getRowIndex();
            IFormView pView = this.getView().getParentView();
            IDataModel pModel = pView.getModel();
            DynamicObject costDept = (DynamicObject)pModel.getValue("costdept");
            DynamicObject costCompany = (DynamicObject)pModel.getValue("costcompany");
            model.setValue("entrycostdept", costDept == null ? null : costDept.getPkValue(), rowIndex);
            model.setValue("entrycostcompany", costCompany == null ? null : costCompany.getPkValue(), rowIndex);
            ErCostCenterUtil.initEntryCostCenter((IDataModel)model, (String)"expenseentryentity", (int)rowIndex, (int)-1);
            Long company = (Long)((DynamicObject)model.getValue("company")).getPkValue();
            if (company == null || company.compareTo(0L) == 0) {
                company = RequestContext.get().getOrgId();
            }
            String budgeMsgValue = (String)ErCommonUtils.getEMParameter((long)company, (String)"budgeMsgControl");
            ContractUtil.setBudgetVisible((IFormView)this.getView(), (String)"expenseentryentity", (String)budgeMsgValue, (boolean)BudgetCommonUtil.isShowBudget(this.getView().getEntityId(), company), (int)rowIndex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        Object newValue = changeSet[0].getNewValue();
        IDataModel dataModel = this.getModel();
        BigDecimal paypercent = BigDecimal.ZERO;
        BigDecimal expenseamount = BigDecimal.ZERO;
        switch (propName) {
            case "currexpenseamount": {
                dataModel.setValue("expnotpayamount", newValue, rowIndex);
                dataModel.setValue("expeapproveamount", dataModel.getValue("expenseamount", rowIndex), rowIndex);
                dataModel.setValue("expeapprovecurramount", newValue, rowIndex);
                break;
            }
            case "expeapprovecurramount": {
                Object approveAmount = dataModel.getValue("expeapproveamount", rowIndex);
                dataModel.setValue("orgiexpebalanceamount", approveAmount, rowIndex);
                dataModel.setValue("expebalanceamount", newValue, rowIndex);
                dataModel.setValue("canloanamount", approveAmount, rowIndex);
                dataModel.setValue("canloancurramount", newValue, rowIndex);
                break;
            }
            case "paybyrata": {
                dataModel.setValue("prorataamount", (Object)BigDecimal.ZERO);
                DynamicObjectCollection entryEntitys = dataModel.getEntryEntity("expenseentryentity");
                if (entryEntitys.size() == 0) {
                    return;
                }
                for (int i = 0; i < entryEntitys.size(); ++i) {
                    dataModel.setValue("paypercent", (Object)BigDecimal.ZERO, i);
                }
                break;
            }
            case "paypercent": {
                int entryPrecision = ((DynamicObject)dataModel.getValue("contractcurrency")).getInt("amtprecision");
                paypercent = (BigDecimal)newValue;
                BigDecimal prorataamount = (BigDecimal)dataModel.getValue("prorataamount");
                expenseamount = prorataamount.multiply(paypercent).divide(BigDecimal.valueOf(100L), entryPrecision, RoundingMode.HALF_EVEN);
                dataModel.setValue("expenseamount", (Object)expenseamount, rowIndex);
                break;
            }
            case "prorataamount": {
                DynamicObjectCollection entryEntity = dataModel.getEntryEntity("expenseentryentity");
                if (entryEntity.size() == 0) {
                    return;
                }
                int precision = ((DynamicObject)dataModel.getValue("contractcurrency")).getInt("amtprecision");
                for (int i = 0; i < entryEntity.size(); ++i) {
                    paypercent = (BigDecimal)((DynamicObject)entryEntity.get(i)).get("paypercent");
                    expenseamount = ((BigDecimal)dataModel.getValue("prorataamount")).multiply(paypercent).divide(BigDecimal.valueOf(100L), precision, RoundingMode.HALF_EVEN);
                    dataModel.setValue("expenseamount", (Object)expenseamount, i);
                }
                break;
            }
            case "entrycostcompany": {
                int entryRowCount = dataModel.getEntryRowCount("expenseentryentity");
                if (entryRowCount <= 0 || ContractUtil.checkExpenseItem((IDataModel)dataModel, (IFormView)this.getView(), (int)rowIndex)) break;
                dataModel.setValue("expenseitem", null, rowIndex);
                break;
            }
            case "expenseamount": {
                dataModel.setValue("oriexpnotpayamount", newValue, rowIndex);
            }
        }
    }
}

