/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.bill.project;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.fi.er.business.pub.ContractUtil;
import kd.fi.er.business.pub.PublicUpBillUtil;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.model.EntityInfo;

public class ProjectPushValidatePlugin
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"bar_pushloan", "bar_pushprepay", "bar_pushpubreimburse"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String key = ((FormOperate)e.getSource()).getOperateKey();
        boolean isCancel = false;
        if (key.equals("pushloan") || key.equals("pushtoprepay")) {
            boolean bl = isCancel = !this.checkDownContractBill();
            if (!isCancel) {
                boolean bl2 = isCancel = !this.checkDownRepayBill();
            }
        }
        if (key.equals("pushpublicreimbursebill")) {
            boolean bl = isCancel = !this.checkPublicReimDownBill();
            if (!isCancel) {
                isCancel = !this.checkDownRepayBill();
            }
        }
        e.setCancel(isCancel);
    }

    private boolean checkDownContractBill() {
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        if (!"2".equals(ErStdConfig.getApplyprojectbillRelated())) {
            for (ListSelectedRow row : selectedRows) {
                if (!this.hasDownContract(row)) continue;
                String billNo = row.getBillNo();
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5df2\u5b58\u5728\u5728\u9014\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u518d\u63a8\u9884\u4ed8\u5355/\u501f\u6b3e\u5355\u3002", (String)"ProjectPushValidatePlugin_0", (String)"fi-er-formplugin", (Object[])new Object[]{billNo}));
                return false;
            }
        }
        return true;
    }

    private boolean hasDownContract(ListSelectedRow row) {
        EntityInfo prepayInfo;
        Long[] billIds = new Long[]{(Long)row.getPrimaryKeyValue()};
        List ids = PublicUpBillUtil.getProjectHasOnWayBills((Long[])billIds, (EntityInfo)(prepayInfo = new EntityInfo.Builder().entityName("er_contractbill").entryName("projectentryentity").sourceName("sourcebillid").build()));
        return ids != null && ids.size() > 0;
    }

    private boolean checkPublicReimDownBill() {
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        for (ListSelectedRow row : selectedRows) {
            if (!this.publicreimHasDownBill(row)) continue;
            String billNo = row.getBillNo();
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5df2\u5b58\u5728\u5728\u9014\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u518d\u63a8\u5bf9\u516c\u62a5\u9500\u5355\u3002", (String)"ProjectPushValidatePlugin_1", (String)"fi-er-formplugin", (Object[])new Object[]{billNo}));
            return false;
        }
        return true;
    }

    private boolean publicreimHasDownBill(ListSelectedRow row) {
        Long[] billIds = new Long[]{(Long)row.getPrimaryKeyValue()};
        String applyprojectbillRelated = ErStdConfig.getApplyprojectbillRelated();
        if (!"2".equals(applyprojectbillRelated)) {
            String onWayCondition = "B,C";
            EntityInfo prepayInfo = new EntityInfo.Builder().entityName("er_contractbill").entryName("projectentryentity").sourceName("sourcebillid").build();
            List ids = ContractUtil.getProjectHasOnWayBills((Long[])billIds, (EntityInfo)prepayInfo, (String)onWayCondition);
            if (ids != null && ids.size() > 0) {
                return true;
            }
            onWayCondition = "B,C,E,F";
            prepayInfo = new EntityInfo.Builder().entityName("er_dailyloanbill").entryName("expenseentryentity").sourceName("sourcebillid").build();
            ids = ContractUtil.getProjectHasOnWayBills((Long[])billIds, (EntityInfo)prepayInfo, (String)onWayCondition);
            if (ids != null && ids.size() > 0) {
                return true;
            }
            prepayInfo = new EntityInfo.Builder().entityName("er_prepaybill").entryName("expenseentryentity").sourceName("wbsrcbillid").build();
            ids = ContractUtil.getProjectHasOnWayBills((Long[])billIds, (EntityInfo)prepayInfo, (String)onWayCondition);
            if (ids != null && ids.size() > 0) {
                return true;
            }
        }
        return false;
    }

    private boolean checkDownRepayBill() {
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        for (ListSelectedRow row : selectedRows) {
            if (!PublicUpBillUtil.hasDownOnwayRepayBills((String)"er_applyprojectbill", (ListSelectedRow)row)) continue;
            String billNo = row.getBillNo();
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5df2\u5b58\u5728\u5728\u9014\u4e0b\u6e38\u8fd8\u6b3e\u5355\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u5173\u8054\u9884\u4ed8/\u501f\u6b3e/\u62a5\u9500\u3002", (String)"ProjectPushValidatePlugin_2", (String)"fi-er-formplugin", (Object[])new Object[]{billNo}));
            return false;
        }
        return true;
    }
}

