/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.botp.wb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.PreparePropertysEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;

public class ApplyPayWriteBackPlugin
extends AbstractWriteBackPlugIn {
    private static final Log logger = LogFactory.getLog(ApplyPayWriteBackPlugin.class);
    private static final String BILL_NO = "billno";

    public void preparePropertys(PreparePropertysEventArgs e) {
        super.preparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("head_paydate");
        fieldKeys.add(BILL_NO);
    }

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        super.afterSaveSourceBill(e);
        String srcBillType = e.getSrcSubMainType().getName();
        if (srcBillType.equals("er_publicreimbursebill")) {
            DynamicObject[] srcBills;
            for (DynamicObject bill : srcBills = e.getSrcDataEntities()) {
                DataEntityPropertyCollection properties = bill.getDataEntityType().getProperties();
                if (!properties.containsKey((Object)"head_paydate") && properties.containsKey((Object)BILL_NO)) {
                    QFilter qf = new QFilter(BILL_NO, "=", (Object)bill.getString(BILL_NO));
                    bill = BusinessDataServiceHelper.loadSingle((String)"er_publicreimbursebill", (String)"id,billno,head_paydate", (QFilter[])new QFilter[]{qf});
                }
                if (!properties.containsKey((Object)BILL_NO)) continue;
                Date payDate = (Date)this.getLastDate(bill);
                bill.set("head_paydate", (Object)payDate);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
            }
        }
    }

    private Object getLastDate(DynamicObject bill) {
        Optional<Object> max = Optional.empty();
        ArrayList payEntreis = new ArrayList();
        QFilter qf = new QFilter("accountentry.recsrcbillno", "=", (Object)bill.getString(BILL_NO));
        DynamicObject[] payBills = BusinessDataServiceHelper.load((String)"er_applypaybill", (String)"id,caspayentry.targetpaydate,caspayentry.targetbillno", (QFilter[])new QFilter[]{qf});
        if (null != payBills && payBills.length > 0) {
            Arrays.asList(payBills).forEach(item -> {
                DynamicObjectCollection caspayentry = item.getDynamicObjectCollection("caspayentry");
                if (CollectionUtils.isNotEmpty((Collection)caspayentry)) {
                    payEntreis.addAll(caspayentry);
                }
            });
        }
        logger.error("\u4ed8\u6b3e\u5206\u5f55\u6570\u91cf" + payEntreis.size());
        if (CollectionUtils.isNotEmpty(payEntreis)) {
            max = payEntreis.stream().max(new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    long result = this.getDate(o1, "targetpaydate") - this.getDate(o2, "targetpaydate");
                    if (result > 0L) {
                        return 1;
                    }
                    if (result == 0L) {
                        return 0;
                    }
                    return -1;
                }

                long getDate(DynamicObject o, String propertyName) {
                    return o.getDate(propertyName) == null ? 0L : o.getDate(propertyName).getTime();
                }
            });
        }
        if (max.isPresent()) {
            return ((DynamicObject)max.get()).getDate("targetpaydate");
        }
        return null;
    }
}

