/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.report;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.er.business.isc.IscHelper;
import kd.fi.er.business.utils.BotpDrawServiceUtil;
import kd.fi.er.common.ShowPageUtils;
import org.apache.commons.lang3.StringUtils;

public class ErAbstractReportList
extends AbstractListPlugin {
    protected static final String BILLNO = "billno";
    protected static final String FORMID = "formid";
    protected static final String ERTRACK_UP = "ErTrackup";
    protected static final String ERTRACK_UP_TYPE = "lookup";
    protected static final String ERTRACK_DOWN = "Ertrackdown";
    protected static final String ERTRACK_DOWN_TYPE = "lookdown";
    private static final Log logger = LogFactory.getLog(ErAbstractReportList.class);

    public void setFilter(SetFilterEvent e) {
        List<String> excludeStatus = this.getExcludeBillstatus();
        e.getQFilters().add(new QFilter("billstatus", "not in", excludeStatus));
    }

    protected List<String> getExcludeBillstatus() {
        return Arrays.asList("A", "D", "H");
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbar", "toolbarap", "tblclose"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String operationKey = evt.getOperationKey();
        IFormView view = this.getView();
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"close")) {
            IFormView parentView = view.getParentView();
            if (parentView != null && StringUtils.equalsIgnoreCase((CharSequence)parentView.getEntityId(), (CharSequence)"er_report_mgl")) {
                parentView.close();
                view.sendFormAction(view.getParentView());
            }
        } else if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"importdts")) {
            try {
                IscHelper.checkExistBefore((IFormView)view, (boolean)true);
            }
            catch (Exception e) {
                logger.error("ErAbstractReportList>>>beforeItemClick:\u5931\u8d25\uff0c\u539f\u56e0\u5982\u4e0b\uff1a", (Throwable)e);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        try {
            IscHelper.importConfirmCallBack((MessageBoxClosedEvent)evt, (IFormView)this.getView());
        }
        catch (IOException e) {
            logger.error("ErAbstractReportList>>>confirmCallBack:\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u5982\u4e0b\uff1a", (Throwable)e);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        ListView view = (ListView)this.getView();
        ListSelectedRowCollection selectedRows = view.getSelectedRows();
        if (StringUtils.equalsIgnoreCase((CharSequence)ERTRACK_UP, (CharSequence)operateKey) || StringUtils.equalsIgnoreCase((CharSequence)ERTRACK_DOWN, (CharSequence)operateKey)) {
            Set selectRowsPkSet = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
            if (selectRowsPkSet.size() > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u6570\u636e\u8fdb\u884c\u4e0a\u67e5/\u4e0b\u67e5\u3002", (String)"ErLoanBillDsList_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            ListSelectedRow selectedRow = selectedRows.get(0);
            Object selectedBillid = selectedRow.getPrimaryKeyValue();
            String fiels = String.join((CharSequence)",", FORMID, BILLNO);
            DynamicObject ds = QueryServiceHelper.queryOne((String)view.getBillFormId(), (String)fiels, (QFilter[])new QFilter[]{new QFilter("id", "=", selectedBillid)});
            if (ds != null) {
                String entityID = this.handleFormId(ds);
                String type = null;
                ArrayList linkNodes = null;
                if (StringUtils.equalsIgnoreCase((CharSequence)ERTRACK_UP, (CharSequence)operateKey)) {
                    linkNodes = new ArrayList(BFTrackerServiceHelper.loadBillLinkUpNodes((String)entityID, (Long[])new Long[]{(Long)selectedBillid}, (boolean)false).values());
                    type = ERTRACK_UP_TYPE;
                } else if (StringUtils.equalsIgnoreCase((CharSequence)ERTRACK_DOWN, (CharSequence)operateKey)) {
                    linkNodes = new ArrayList(BFTrackerServiceHelper.loadBillLinkDownNodes((String)entityID, (Long[])new Long[]{(Long)selectedBillid}, (boolean)false).values());
                    type = ERTRACK_DOWN_TYPE;
                }
                if (this.showNotFoundData(linkNodes, (IFormView)view)) {
                    return;
                }
                String jsonNodes = SerializationUtils.serializeToBase64(linkNodes);
                BotpDrawServiceUtil.showRelateBills((String)entityID, (String)selectedRow.getBillNo(), (String)jsonNodes, (String)type, (IFormView)view);
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u4e0d\u5b58\u5728\u3002", (String)"ErLoanBillDsList_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        }
    }

    protected boolean showNotFoundData(List list, IFormView view) {
        if (list == null || list.size() == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5173\u8054\u7684\u6570\u636e\u3002", (String)"ErLoanBillDsList_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        ListView view = (ListView)this.getView();
        long pk = (Long)view.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        DynamicObject ds = BusinessDataServiceHelper.loadSingleFromCache((String)view.getBillFormId(), (String)FORMID, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pk)});
        if (ds == null) {
            return;
        }
        String entityId = this.handleFormId(ds);
        if (BILLNO.equals(fieldName)) {
            args.setCancel(true);
            ShowPageUtils.openLinkedForm((Object)pk, (String)entityId, (IFormView)view, (ShowType)ShowType.MainNewTabPage, (boolean)true);
        }
    }

    protected String handleFormId(DynamicObject ds) {
        return ds.getString(FORMID);
    }
}

