/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.report.mb;

import com.google.common.collect.Lists;
import java.util.EventObject;
import java.util.LinkedList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;

public class DeptAnalysisFormPlugin
extends AbstractMobFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("org");
        if (orgEdit != null) {
            orgEdit.addBeforeF7SelectListener(p0 -> {
                LinkedList<Long> mangedOrgs = this.getMangedOrgs();
                p0.getFormShowParameter().setCustomParam("range", mangedOrgs);
                if (p0.getFormShowParameter() instanceof ListShowParameter) {
                    ListShowParameter p = (ListShowParameter)p0.getFormShowParameter();
                    p.getListFilterParameter().getQFilters().add(new QFilter("id", "in", mangedOrgs));
                }
            });
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initOrg();
    }

    private void initOrg() {
        LinkedList<Long> lstUsrMngedDpts;
        Object value = this.getModel().getValue("org");
        if (value instanceof DynamicObjectCollection && ((DynamicObjectCollection)value).isEmpty() && !(lstUsrMngedDpts = this.getMangedOrgs()).isEmpty()) {
            Long deptId = lstUsrMngedDpts.get(0);
            this.getModel().setValue("org", (Object)new Object[]{deptId});
            Long companyId = CoreBaseBillServiceHelper.initCompanyByDept((Long)deptId);
            Long costCompanyId = CoreBaseBillServiceHelper.getAccountOrgId((Long)deptId);
            Long currencyId = BaseCurrencyServiceHelper.getBaseCurrencyId((Object)companyId, (Object)costCompanyId);
            if (currencyId != null && currencyId != 0L) {
                this.getModel().setValue("currency", (Object)currencyId);
            }
        }
    }

    private LinkedList<Long> getMangedOrgs() {
        LinkedList lstUsrMngedDpts = Lists.newLinkedList();
        long curUserId = RequestContext.get().getCurrUserId();
        ORM orgORM = ORM.create();
        QFilter f1 = new QFilter("id", "=", (Object)curUserId);
        QFilter f2 = new QFilter("entryentity.isincharge", "=", (Object)"1");
        try (DataSet ds = orgORM.queryDataSet(UserServiceHelper.class.getName(), "bos_user", "entryentity.dpt.id,entryentity.ispartjob", new QFilter[]{f1, f2});){
            for (Row row : ds) {
                Long org = row.getLong("entryentity.dpt.id");
                if (org == null) continue;
                if (!row.getBoolean("entryentity.ispartjob").booleanValue()) {
                    lstUsrMngedDpts.addFirst(org);
                    continue;
                }
                lstUsrMngedDpts.add(org);
            }
        }
        if (lstUsrMngedDpts.isEmpty()) {
            lstUsrMngedDpts.add(-996L);
        }
        return lstUsrMngedDpts;
    }
}

