/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.report.mb.board.dept.loan;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.er.business.reportmb.core.FieldDO;
import kd.fi.er.formplugin.report.mb.util.ReportDataProcessCenter;
import org.apache.commons.lang3.StringUtils;

public class DeptLoanShowDetailGroupPlugin
extends AbstractMobFormPlugin
implements TabSelectListener,
RowClickEventListener {
    private static final Log log = LogFactory.getLog(DeptLoanShowDetailGroupPlugin.class);
    private static int preSize = 10;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl("tabap");
        if (tab != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
        this.addItemClickListeners(new String[]{"mtoolbarap"});
        this.addClickListeners(new String[]{"expandall", "returnmainpage", "alertrepaybtn"});
        this.addRowClickListeners("entryentity", "entryentity1", "entryentity2");
    }

    private void addRowClickListeners(String ... entries) {
        for (String entryName : entries) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(entryName);
            if (entryGrid == null) continue;
            entryGrid.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button item = (Button)evt.getSource();
        if ("expandall".equals(item.getKey())) {
            this.expandAll();
        } else if ("returnmainpage".equals(item.getKey())) {
            this.releasePage();
        } else if ("alertrepaybtn".equals(item.getKey())) {
            this.confirm();
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        if (!this.isShowAll()) {
            this.expandAll();
        }
    }

    private void expandAll() {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId("er_m_loangrouplist");
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setCustomParam("pageId", (Object)this.getView().getPageId());
        showParameter.setCustomParam("showall", (Object)true);
        Tab tab = (Tab)this.getControl("tabap");
        showParameter.setCustomParam("activeTab", (Object)tab.getCurrentTab());
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void confirm() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5411\u501f\u6b3e\u4eba\u53d1\u8d77\u6d88\u606f\u63d0\u9192\uff1f", (String)"DeptLoanShowDetailGroupPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("send", (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("send".equals(messageBoxClosedEvent.getCallBackId())) {
            Tab tab = (Tab)this.getControl("tabap");
            String currentTab = tab.getCurrentTab();
            this.sendMessage(currentTab);
        }
    }

    private void sendMessage(String currentTab) {
        List list;
        String dataKey = null;
        if ("deaddaytab".equals(currentTab)) {
            dataKey = "dead";
        } else if ("comingdaytab".equals(currentTab)) {
            dataKey = "coming";
        }
        String data = this.getData(this.getDataView());
        Map groupMap = null;
        groupMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
        if (groupMap != null && !groupMap.isEmpty() && (list = (List)groupMap.get(dataKey)) != null && !list.isEmpty()) {
            Map<Long, List<Map>> groupByApplier = list.stream().collect(Collectors.groupingBy(v -> Long.valueOf(v.get(FieldDO.applierField.getAlias()) == null ? "0" : v.get(FieldDO.applierField.getAlias()).toString())));
            for (Map.Entry<Long, List<Map>> group : groupByApplier.entrySet()) {
                Long applierId = group.getKey();
                List<Map> value = group.getValue();
                BigDecimal totalBalanceAmt = value.stream().map(v -> new BigDecimal(v.get(FieldDO.balanceAmtField.getAlias()).toString())).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                this.sendTips(dataKey, applierId, value.size(), totalBalanceAmt);
            }
        }
    }

    private void sendTips(String dataKey, Long applierId, int size, BigDecimal totalBalanceAmt) {
        MessageInfo createMessageInfo = DeptLoanShowDetailGroupPlugin.createMessageInfo(dataKey, size, totalBalanceAmt.toPlainString(), applierId);
        long msgId = MessageCenterServiceHelper.sendMessage((MessageInfo)createMessageInfo);
        if (msgId == 0L) {
            throw new KDBizException("send message error");
        }
    }

    public static MessageInfo createMessageInfo(String expireSlot, int count, String totalAmountText, Long userId) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setTag(ResManager.loadKDString((String)"\u8d39\u7528\u5206\u6790", (String)"DeptLoanShowDetailGroupPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
        messageInfo.setTitle(ResManager.loadKDString((String)"\u6309\u65f6\u8fd8\u6b3e\u6216\u6838\u9500\u63d0\u9192", (String)"DeptLoanShowDetailGroupPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
        String content = "";
        if ("dead".equals(expireSlot)) {
            content = ResManager.loadKDString((String)"%1$s\u7b14\u603b\u989d\u4e3a%2$s\u7684\u501f\u6b3e\u5df2\u5230\u671f\uff0c\u8bf7\u5c3d\u5feb\u8fd8\u6b3e\u6216\u6838\u9500\u3002", (String)"DeptLoanShowDetailGroupPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]);
        } else if ("comingdaytab".equals(expireSlot)) {
            content = ResManager.loadKDString((String)"%1$s\u7b14\u603b\u989d\u4e3a%2$s\u7684\u501f\u6b3e\u5373\u5c06\u5230\u671f\uff0c\u8bf7\u5c3d\u5feb\u8fd8\u6b3e\u6216\u6838\u9500\u3002", (String)"DeptLoanShowDetailGroupPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]);
        }
        messageInfo.setContent(String.format(content, count, totalAmountText));
        messageInfo.setUserIds(new ArrayList<Long>(Collections.singletonList(userId)));
        messageInfo.setType("message");
        messageInfo.setMobContentUrl("");
        messageInfo.setNotifyType("");
        return messageInfo;
    }

    private IFormView getDataView() {
        IFormView pview = null;
        boolean isShowAll = this.isShowAll();
        if (isShowAll) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object pageId = formShowParameter.getCustomParam("pageId");
            pview = this.getView().getView(pageId.toString()).getParentView();
        } else {
            pview = this.getView().getParentView();
        }
        return pview;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        boolean isShowAll = this.isShowAll();
        if (isShowAll) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"expandall"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"mtoolbarap"});
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        IFormView dataView = this.getDataView();
        this.settingCurrency(dataView);
        this.paintList(dataView);
        String activeTab = (String)formShowParameter.getCustomParam("activeTab");
        if (activeTab == null) {
            activeTab = "deaddaytab";
        }
        if (StringUtils.isNotBlank((CharSequence)activeTab)) {
            Tab tab = (Tab)this.getControl("tabap");
            tab.activeTab(activeTab);
        }
    }

    private boolean isShowAll() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return Boolean.TRUE.equals(formShowParameter.getCustomParam("showall"));
    }

    private void settingCurrency(IFormView pview) {
        if (pview != null) {
            this.getModel().setValue("currency", pview.getModel().getValue("currency"));
        }
    }

    private void paintList(IFormView mainPageView) {
        Map groupMap = null;
        if (mainPageView != null) {
            String data = this.getData(mainPageView);
            if (data == null) {
                this.getView().showErrorNotification("no data");
                return;
            }
            groupMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
        }
        this.getModel().beginInit();
        this.initEntryEntity(EntryField.entryentity, groupMap);
        this.initEntryEntity(EntryField.entryentity1, groupMap);
        this.initEntryEntity(EntryField.entryentity2, groupMap);
        this.getModel().endInit();
        this.getView().updateView("tabap");
    }

    private void initEntryEntity(EntryField entryField, Map<String, List<Map<String, Object>>> groupMap) {
        List<Map<String, Object>> list;
        if (groupMap != null && !groupMap.isEmpty() && (list = groupMap.get(entryField.type)) != null && !list.isEmpty()) {
            list.sort((o1, o2) -> {
                String date1 = (String)o1.get(FieldDO.repayDateField.getAlias());
                String date2 = (String)o2.get(FieldDO.repayDateField.getAlias());
                if (date1 == null) {
                    if (date2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (date2 == null) {
                    return 1;
                }
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    long diff = sdf.parse(date1).getTime() - sdf.parse(date2).getTime();
                    if (diff > 0L) {
                        return 1;
                    }
                    if (diff == 0L) {
                        return 0;
                    }
                    return -1;
                }
                catch (ParseException e) {
                    throw new KDBizException((Throwable)e, new ErrorCode("parseException", e.getMessage()), new Object[0]);
                }
            });
            if (!this.isShowAll()) {
                list = list.subList(0, list.size() > preSize ? preSize : list.size());
            }
            int[] batchCreateNewEntryRow = this.getModel().batchCreateNewEntryRow(entryField.name(), list.size());
            int i = 0;
            for (Map<String, Object> map : list) {
                this.getModel().setValue(entryField.billno, map.get(FieldDO.billnoField.getAlias()), batchCreateNewEntryRow[i]);
                this.getModel().setValue(entryField.duedate, map.get(FieldDO.repayDateField.getAlias()), batchCreateNewEntryRow[i]);
                this.getModel().setValue(entryField.currexpenseamount, map.get(FieldDO.entry_balanceAmtField.getAlias()), batchCreateNewEntryRow[i]);
                this.getModel().setValue(entryField.applier, map.get(FieldDO.applierField.getAlias()), batchCreateNewEntryRow[i]);
                this.getModel().setValue(entryField.avatar, map.get("avatar"), batchCreateNewEntryRow[i]);
                ++i;
            }
        }
    }

    private String getData(IFormView mainPageView) {
        return ReportDataProcessCenter.getData("loan.loanmap", mainPageView);
    }

    public void tabSelected(TabSelectEvent event) {
        if ("notdaytab".equals(event.getTabKey())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"alertrepaybtn"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"alertrepaybtn"});
        }
    }

    private void releasePage() {
        this.getView().close();
    }

    private static enum EntryField {
        entryentity("dead", "billno", "duedate", "currexpenseamount", "applier", "avatar"),
        entryentity1("coming", "billno1", "duedate1", "currexpenseamount1", "applier1", "avatar1"),
        entryentity2("notday", "billno2", "duedate2", "currexpenseamount2", "applier2", "avatar2");

        String billno;
        String duedate;
        String currexpenseamount;
        String applier;
        String avatar;
        String type;

        private EntryField(String type, String billno, String duedate, String currexpenseamount, String applier, String avatar) {
            this.type = type;
            this.billno = billno;
            this.duedate = duedate;
            this.currexpenseamount = currexpenseamount;
            this.applier = applier;
            this.avatar = avatar;
        }
    }
}

