/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.report.mb.board.dept.reim;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.reportmb.context.AbstractReportContext;
import kd.fi.er.business.reportmb.context.DeptReimAnalysisContext;
import kd.fi.er.business.reportmb.core.FieldDO;
import kd.fi.er.business.reportmb.core.TableDO;
import kd.fi.er.business.reportmb.datahandler.analysis.dept.Group2ListByMonthHandler;
import kd.fi.er.business.reportmb.datahandler.analysis.dept.Group2ListHandler;
import kd.fi.er.business.reportmb.datahandler.analysis.dept.SumAmountByMonthDataHandler;
import kd.fi.er.business.reportmb.datahandler.analysis.dept.SumAmountByStatusAndMonthDataHandler;
import kd.fi.er.business.reportmb.query.CommonQueryExecuteProxy;
import kd.fi.er.business.reportmb.query.IRptQueryExecute;
import kd.fi.er.business.reportmb.query.MultiThreadQueryExecute;
import kd.fi.er.business.utils.AmountFormatsUtil;
import kd.fi.er.formplugin.report.mb.meta.DeptReimAnalysisTableMeta;
import kd.fi.er.formplugin.report.mb.util.MBReportUtil;
import kd.fi.er.formplugin.report.mb.util.ReportDataProcessCenter;
import org.apache.commons.lang3.StringUtils;

public class DeptReimAnalysisIndexPlugin
extends AbstractMobFormPlugin {
    private static String filterPageFormID = "er_m_deptfilter";
    private static String showDetailFormID = "er_m_showdetail";
    private static String FILTERPAGE = "filterpage";
    private static String FILTERPAGEICON = "filterpageicon";
    private static String LABELFLEX = "labelflex";
    private static final String JOINSTR = ",";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{FILTERPAGE, LABELFLEX, FILTERPAGEICON});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        String key = null;
        if (source instanceof Button) {
            key = ((Button)source).getKey();
        } else if (source instanceof Container) {
            key = ((Container)source).getKey();
        }
        if (FILTERPAGE.equals(key) || FILTERPAGEICON.equals(key)) {
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.setFormId(filterPageFormID);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.getOpenStyle().setTargetKey("filterpageflex");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, filterPageFormID));
            this.getView().showForm((FormShowParameter)showParameter);
        } else if (LABELFLEX.equals(key)) {
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.setFormId(showDetailFormID);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (filterPageFormID.equals(closedCallBackEvent.getActionId())) {
            this.refreshPage();
            this.getView().updateView("bizdate");
            this.getView().updateView("org");
            this.getView().updateView("currency");
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshPage();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("bizdate".equals(name) && e.getChangeSet()[0].getNewValue() != null || "org".equals(name) || "currency".equals(name)) {
            this.refreshPage();
        }
    }

    private void refreshPage() {
        DeptReimAnalysisContext context = new DeptReimAnalysisContext();
        context.setView(this.getView());
        context.setTables(this.loadTable());
        Integer value = (Integer)this.getModel().getValue("monthrange");
        context.setMonthrange(value);
        MultiThreadQueryExecute queryExecute = new MultiThreadQueryExecute((AbstractReportContext)context);
        CommonQueryExecuteProxy proxy = new CommonQueryExecuteProxy((IRptQueryExecute)queryExecute);
        Map data = proxy.doExecute();
        if (!data.values().stream().anyMatch(list -> !list.isEmpty())) {
            this.getModel().setValue("datatag", (Object)0);
            return;
        }
        this.getModel().setValue("datatag", (Object)1);
        Group2ListHandler group2ListHandler = new Group2ListHandler(data);
        SumAmountByStatusAndMonthDataHandler sumAmountByStatusAndMonthDataHandler = new SumAmountByStatusAndMonthDataHandler(data);
        Group2ListByMonthHandler group2ListByMonthHandler = new Group2ListByMonthHandler(data);
        ReportDataProcessCenter.doHandleProcess(this.getView(), (AbstractReportContext)context, "reim.list", group2ListHandler);
        ReportDataProcessCenter.doHandleProcess(this.getView(), (AbstractReportContext)context, "reim.statusgroup", sumAmountByStatusAndMonthDataHandler);
        ReportDataProcessCenter.doHandleProcess(this.getView(), (AbstractReportContext)context, "reim.groupByMonthDetailRows", group2ListByMonthHandler);
        SumAmountByMonthDataHandler dataHandler = new SumAmountByMonthDataHandler(data);
        JSONObject jsonObject = (JSONObject)dataHandler.doHandler((AbstractReportContext)context);
        this.paintChart(jsonObject);
        this.paintLabelFlex(jsonObject);
        this.paintList();
    }

    private void paintLabelFlex(JSONObject jsonObject) {
        this.setLabelText(jsonObject, "appliercount");
        this.setLabelText(jsonObject, "billcount");
        String sign = this.getModel().getDataEntity().getDynamicObject("currency").getString("sign");
        this.setLabelText(jsonObject, "totalamt", sign);
        this.setLabelText(jsonObject, "adv", sign);
    }

    private void setLabelText(JSONObject jsonObject, String labelName, String sign) {
        Label label = (Label)this.getControl(labelName);
        if (label != null) {
            if (sign != null) {
                BigDecimal bigDecimal = jsonObject.getBigDecimal(labelName).setScale(2, RoundingMode.HALF_UP);
                label.setText(AmountFormatsUtil.getLabelAmountAfterFormat((String)sign, (BigDecimal)bigDecimal, (int)2));
            } else {
                label.setText(jsonObject.getString(labelName));
            }
        }
    }

    private void setLabelText(JSONObject jsonObject, String labelName) {
        this.setLabelText(jsonObject, labelName, null);
    }

    private void paintList() {
        Container contrainer = (Container)this.getControl("listfp");
        String formid = "er_m_grouplist";
        contrainer.deleteControls(new String[]{formid});
        FlexPanelAp flex = new FlexPanelAp();
        flex.setGrow(0);
        flex.setShrink(0);
        flex.setRadius("8px");
        flex.setKey(formid);
        ArrayList items = Lists.newArrayListWithExpectedSize((int)1);
        items.add(flex.createControl());
        contrainer.addControls((List)items);
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(formid);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(formid);
        showParameter.setSendToClient(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void paintChart(JSONObject jsonObject) {
        Number[] yValue = (BigDecimal[])jsonObject.getJSONArray("yAxis").toArray((Object[])new BigDecimal[0]);
        Tuple<BigDecimal, String> autoUnit = MBReportUtil.getUnit((BigDecimal[])yValue);
        String unit = (String)autoUnit.item2;
        for (int i = 0; i < yValue.length; ++i) {
            yValue[i] = MBReportUtil.formatValue(yValue[i], autoUnit);
        }
        Chart chart = (Chart)this.getControl("trendchart");
        chart.setShowLegend(false);
        chart.setShowTooltip(true);
        String sign = this.getModel().getDataEntity().getDynamicObject("currency").getString("sign");
        chart.addTooltip("formatter", (Object)String.format("{a} <br/>{b},%1s{c}%2s", sign, unit));
        Axis xAxis = chart.createXAxis("", AxisType.category);
        xAxis.setCategorys((String[])jsonObject.getJSONArray("xAxis").toArray((Object[])new String[0]));
        Axis yAxis = chart.createYAxis("", AxisType.value);
        yAxis.setMin((Number)0);
        yAxis.setPropValue("show", (Object)true);
        yAxis.setPosition(Position.right);
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        map.put("formatter", String.format("{value} %1s", unit));
        yAxis.setPropValue("axisLabel", (Object)map);
        BarSeries barSeries = chart.createBarSeries("");
        barSeries.setData(yValue);
        barSeries.getLabel().setFormatter(String.format("{@value} %1s", unit));
        barSeries.setPropValue("showBackground", (Object)false);
        barSeries.setBarWidth("40%");
        LineSeries lineSeries = chart.createLineSeries("");
        lineSeries.setData(yValue);
        HashMap noshow = Maps.newHashMapWithExpectedSize((int)1);
        noshow.put("show", false);
        lineSeries.setPropValue("tooltip", (Object)noshow);
        chart.refresh();
    }

    private List<TableDO> loadTable() {
        ArrayList tables = Lists.newArrayListWithCapacity((int)4);
        QFilter tripexpenseFilter = this.getFilter("tripexpenseitemval", "tripentry.entryentity.expenseitem");
        QFilter projectFilter = this.getFilter("projectval", "expenseentryentity.std_project");
        QFilter traProjectFilter = this.getFilter("projectval", "tripentry.std_project");
        QFilter nonFilter = new QFilter("1", "!=", (Object)1);
        QFilter orgFilter = null;
        QFilter statusFilter = null;
        QFilter currencyFilter = new QFilter("currency", "=", ((DynamicObject)this.getModel().getValue("currency")).getPkValue());
        QFilter timeFilter = this.getTimeFilter((Date)this.getModel().getValue("bizdate"));
        Map<DeptReimAnalysisTableMeta.BILLTYPE, String[]> meta = this.getMeta();
        for (Map.Entry<DeptReimAnalysisTableMeta.BILLTYPE, String[]> entry : meta.entrySet()) {
            DeptReimAnalysisTableMeta.BILLTYPE billtype = entry.getKey();
            String[] entityIds = entry.getValue();
            statusFilter = this.getBillStatusFilter(billtype);
            for (String entityId : entityIds) {
                QFilter expenseitemFilter;
                if (!StringUtils.isNotBlank((CharSequence)entityId)) continue;
                TableDO tableDO = DeptReimAnalysisTableMeta.createTableDO(billtype, entityId);
                tables.add(tableDO);
                List qFilters = tableDO.getQFilters();
                if (DeptReimAnalysisTableMeta.BILLTYPE.DAILYREIM == billtype || DeptReimAnalysisTableMeta.BILLTYPE.PUBREIM == billtype) {
                    if (tripexpenseFilter != null) {
                        qFilters.add(nonFilter);
                        continue;
                    }
                    orgFilter = this.getFilter("org", FieldDO.orgField.getFilterKey());
                    if (orgFilter == null) {
                        orgFilter = nonFilter;
                    }
                    expenseitemFilter = this.getFilter("expenseitemval", "expenseentryentity.expenseitem");
                    this.addQFilter(qFilters, projectFilter, expenseitemFilter, orgFilter, currencyFilter, timeFilter, statusFilter);
                }
                if (DeptReimAnalysisTableMeta.BILLTYPE.TRIPREIM != billtype) continue;
                orgFilter = this.getFilter("org", FieldDO.trip_orgField.getFilterKey());
                if (orgFilter == null) {
                    orgFilter = nonFilter;
                }
                expenseitemFilter = this.getFilter("expenseitemval", FieldDO.trip_expenseitemField.getFilterKey());
                QFilter cardKindFilter = new QFilter("billkind", "!=", (Object)"1");
                this.addQFilter(qFilters, traProjectFilter, tripexpenseFilter, cardKindFilter, orgFilter, currencyFilter, timeFilter, statusFilter, expenseitemFilter);
                TableDO gridTableDO = DeptReimAnalysisTableMeta.createTableDO(DeptReimAnalysisTableMeta.BILLTYPE.TRIPREIM_GRID, entityId);
                tables.add(gridTableDO);
                QFilter gridKindFilter = new QFilter("billkind", "=", (Object)"1");
                orgFilter = this.getFilter("org", FieldDO.trip_orgField_grid.getFilterKey());
                if (orgFilter == null) {
                    orgFilter = nonFilter;
                }
                expenseitemFilter = this.getFilter("expenseitemval", FieldDO.trip_expenseitemField_grid.getFilterKey());
                List gridFilter = gridTableDO.getQFilters();
                this.addQFilter(gridFilter, traProjectFilter, tripexpenseFilter, gridKindFilter, orgFilter, currencyFilter, timeFilter, statusFilter, expenseitemFilter);
            }
        }
        return tables;
    }

    private void addQFilter(List<QFilter> qFilters, QFilter ... filters) {
        for (QFilter filter : filters) {
            qFilters.add(filter);
        }
    }

    private QFilter getFilter(String valField, String filterField) {
        DynamicObjectCollection coll;
        QFilter filter = null;
        Object val = this.getModel().getValue(valField);
        if (val instanceof DynamicObjectCollection && !(coll = (DynamicObjectCollection)val).isEmpty()) {
            filter = new QFilter(filterField, "in", coll.stream().map(v -> v.get("fbasedataid_id")).collect(Collectors.toList()));
        }
        return filter;
    }

    private QFilter getBillStatusFilter(DeptReimAnalysisTableMeta.BILLTYPE billtype) {
        String encashAmtField = null;
        encashAmtField = billtype == DeptReimAnalysisTableMeta.BILLTYPE.TRIPREIM || billtype == DeptReimAnalysisTableMeta.BILLTYPE.TRIPREIM_GRID ? FieldDO.trip_encashedAmtField.getName() : FieldDO.encashedAmtField.getName();
        boolean all_status = Boolean.TRUE.equals(this.getModel().getValue("allstatus_checked"));
        boolean inprocess_status = Boolean.TRUE.equals(this.getModel().getValue("inprocess_checked"));
        boolean done_status = Boolean.TRUE.equals(this.getModel().getValue("done_checked"));
        String inprocessval = (String)this.getModel().getValue("inprocessval");
        String doneval = (String)this.getModel().getValue("doneval");
        StringBuilder sb = new StringBuilder(JOINSTR);
        if (all_status || inprocess_status && done_status) {
            sb.append(inprocessval).append(JOINSTR).append(doneval).append("E");
            return new QFilter("billstatus", "in", (Object)this.format(sb, ""));
        }
        QFilter auditFilter = new QFilter("billstatus", "=", (Object)"E");
        if (inprocess_status) {
            sb.append(inprocessval);
            QFilter qFilter2 = new QFilter(encashAmtField, ">", (Object)BigDecimal.ZERO);
            return new QFilter("billstatus", "in", (Object)this.format(sb, "E")).or(auditFilter.and(qFilter2));
        }
        if (done_status) {
            sb.append(doneval);
            QFilter qFilter2 = new QFilter(encashAmtField, "<=", (Object)BigDecimal.ZERO);
            return new QFilter("billstatus", "in", (Object)this.format(sb, "E")).or(auditFilter.and(qFilter2));
        }
        return null;
    }

    private String[] format(StringBuilder sb, String removeStr) {
        String str = sb.toString();
        if (StringUtils.isNotBlank((CharSequence)removeStr)) {
            str = str.replaceAll(removeStr, "");
        }
        String replaceAll = sb.toString().replaceAll(",+", JOINSTR);
        int beginIndex = 0;
        int endIndex = replaceAll.length();
        if (replaceAll.startsWith(JOINSTR)) {
            beginIndex = 1;
        }
        if (replaceAll.endsWith(JOINSTR)) {
            --endIndex;
        }
        return replaceAll.substring(beginIndex, endIndex).split(JOINSTR);
    }

    private Map<DeptReimAnalysisTableMeta.BILLTYPE, String[]> getMeta() {
        Object allbilltype = this.getModel().getValue("allbilltype_checked");
        String dailyreimval = (String)this.getModel().getValue("dailyreimval");
        String tripreimval = (String)this.getModel().getValue("tripreimval");
        String pubreimval = (String)this.getModel().getValue("pubreimval");
        HashMap map = Maps.newHashMapWithExpectedSize((int)4);
        if (Boolean.TRUE.equals(allbilltype)) {
            map.put(DeptReimAnalysisTableMeta.BILLTYPE.DAILYREIM, dailyreimval.split(JOINSTR));
            map.put(DeptReimAnalysisTableMeta.BILLTYPE.TRIPREIM, tripreimval.split(JOINSTR));
            map.put(DeptReimAnalysisTableMeta.BILLTYPE.PUBREIM, pubreimval.split(JOINSTR));
        } else {
            if (Boolean.TRUE.equals(this.getModel().getValue("dailyreim_checked"))) {
                map.put(DeptReimAnalysisTableMeta.BILLTYPE.DAILYREIM, dailyreimval.split(JOINSTR));
            }
            if (Boolean.TRUE.equals(this.getModel().getValue("tripreim_checked"))) {
                map.put(DeptReimAnalysisTableMeta.BILLTYPE.TRIPREIM, tripreimval.split(JOINSTR));
            }
            if (Boolean.TRUE.equals(this.getModel().getValue("pubreim_checked"))) {
                map.put(DeptReimAnalysisTableMeta.BILLTYPE.PUBREIM, pubreimval.split(JOINSTR));
            }
        }
        return map;
    }

    private QFilter getTimeFilter(Date bizdate) {
        if (bizdate == null) {
            return null;
        }
        Integer monthrange = (Integer)this.getModel().getValue("monthrange");
        Calendar instance = Calendar.getInstance();
        instance.setTime(bizdate);
        instance.set(5, 0);
        instance.add(2, 1);
        Date endDate = instance.getTime();
        instance.add(2, 1 - monthrange);
        instance.set(5, 1);
        Date startDate = instance.getTime();
        return QFilter.of((String)"bizdate >= ? and bizdate <= ?", (Object[])new Object[]{startDate, endDate});
    }
}

