/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.report.mb.board.dept.reim;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.plugin.AbstractMobListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.fi.er.business.reportmb.core.FieldDO;
import kd.fi.er.business.reportmb.core.TableDO;
import kd.fi.er.formplugin.report.mb.meta.DeptReimAnalysisTableMeta;
import kd.fi.er.formplugin.report.mb.util.ReportDataProcessCenter;

public class DeptReimDetailListPlugin
extends AbstractMobListPlugin {
    private static final Log log = LogFactory.getLog(DeptReimDetailListPlugin.class);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_addbank"});
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                Map dataMap;
                DynamicObjectCollection collection = super.getData(start, limit);
                collection.clear();
                Object dateStr = DeptReimDetailListPlugin.this.getView().getFormShowParameter().getCustomParam("dateStr");
                IFormView mainPageView = DeptReimDetailListPlugin.this.getView().getParentView().getParentView();
                String data = DeptReimDetailListPlugin.this.getList(mainPageView);
                Map map = null;
                if (data != null) {
                    map = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                }
                if (map != null && (dataMap = (Map)map.get(dateStr)) != null && !dataMap.isEmpty()) {
                    for (Map.Entry entry : dataMap.entrySet()) {
                        String billtype = (String)entry.getKey();
                        this.setValue(billtype, collection, (List)entry.getValue());
                    }
                }
                BusinessDataReader.loadRefence((Object[])collection.toArray((Object[])new DynamicObject[collection.size()]), (IDataEntityType)collection.getDynamicObjectType());
                return collection;
            }

            private void setValue(String billtype, DynamicObjectCollection collection, List<List<Object>> value) {
                DynamicObjectType type = collection.getDynamicObjectType();
                TableDO tableDO = DeptReimAnalysisTableMeta.createTableDO(DeptReimAnalysisTableMeta.BILLTYPE.valueOf(billtype), null);
                Integer billnoIndex = tableDO.getFieldIndex(FieldDO.billnoField.getAlias());
                Integer billStatusIndex = tableDO.getFieldIndex(FieldDO.billStatusField.getAlias());
                Integer tripExpenseItemIndex = tableDO.getFieldIndex(FieldDO.trip_tripexpenseitemField.getAlias());
                Integer expenseItemIndex = tableDO.getFieldIndex(FieldDO.expenseitemField.getAlias());
                Integer bizDateIndex = tableDO.getFieldIndex(FieldDO.dateField.getAlias());
                Integer amountIndex = tableDO.getFieldIndex(FieldDO.amountField.getAlias());
                Integer descriptionIndex = tableDO.getFieldIndex(FieldDO.descriptionField.getAlias());
                Integer currencyFieldIndex = tableDO.getFieldIndex(FieldDO.currencyField.getAlias());
                Tuple s1 = Tuple.create((Object)"billno", (Object)billnoIndex);
                Tuple s2 = Tuple.create((Object)"billstatus", (Object)billStatusIndex);
                Tuple s3 = Tuple.create((Object)"bizdate", (Object)bizDateIndex);
                Tuple s4 = Tuple.create((Object)"entryamount", (Object)amountIndex);
                Tuple s6 = Tuple.create((Object)"travelitem", (Object)tripExpenseItemIndex);
                Tuple s7 = Tuple.create((Object)"expenseitem", (Object)expenseItemIndex);
                Tuple s8 = Tuple.create((Object)"description", (Object)descriptionIndex);
                Tuple s9 = Tuple.create((Object)"currency", (Object)currencyFieldIndex);
                for (List<Object> dataRow : value) {
                    DynamicObject row = (DynamicObject)type.createInstance(true);
                    collection.add((Object)row);
                    this.copyValue(row, dataRow, s1, s2, s3, s4, s6, s7, s8, s9);
                    row.set("billtype", this.convertBillType(billtype));
                }
            }

            private Object convertBillType(String billtype) {
                if (DeptReimAnalysisTableMeta.BILLTYPE.PUBREIM.name().equals(billtype)) {
                    return "er_publicreimbursebill";
                }
                if (DeptReimAnalysisTableMeta.BILLTYPE.DAILYREIM.name().equals(billtype)) {
                    return "er_dailyreimbursebill";
                }
                if (DeptReimAnalysisTableMeta.BILLTYPE.TRIPREIM.name().equals(billtype) || DeptReimAnalysisTableMeta.BILLTYPE.TRIPREIM_GRID.name().equals(billtype)) {
                    return "er_tripreimbursebill";
                }
                return null;
            }

            private void copyValue(DynamicObject row, List<Object> dataRow, Tuple<String, Integer> ... fields) {
                for (Tuple<String, Integer> tuple : fields) {
                    Integer index = (Integer)tuple.item2;
                    if (index == null) continue;
                    Object value = dataRow.get(index);
                    DynamicProperty property = row.getDynamicObjectType().getProperty((String)tuple.item1);
                    if (property instanceof BasedataProp) {
                        if (Long.parseLong(value.toString()) == 0L) continue;
                        ((BasedataProp)property).getRefIdProp().setValue((Object)row, value);
                        continue;
                    }
                    if (property.getPropertyType() == Date.class) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                        try {
                            value = sdf.parse(value.toString());
                        }
                        catch (ParseException e) {
                            log.error("ParseException", (Throwable)e);
                        }
                    }
                    property.setValue((Object)row, value);
                }
            }
        });
    }

    private String getList(IFormView mainPageView) {
        return ReportDataProcessCenter.getData("reim.groupByMonthDetailRows", mainPageView);
    }
}

