/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.report.mb.meta;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.fi.er.business.reportmb.core.FieldDO;
import kd.fi.er.business.reportmb.core.TableDO;

public class DeptLoanAnalysisTableMeta {
    private static Map<BILLTYPE, List<FieldDO>> metaMap = Maps.newHashMapWithExpectedSize((int)3);

    public static TableDO createTableDO(BILLTYPE billtype, String entityId) {
        List<FieldDO> fields = metaMap.get((Object)billtype);
        return new TableDO(fields, entityId, billtype.name());
    }

    static {
        ArrayList expFields = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList traFields = Lists.newArrayListWithExpectedSize((int)16);
        expFields.add(FieldDO.dateField);
        expFields.add(FieldDO.applierField);
        expFields.add(FieldDO.billnoField);
        expFields.add(FieldDO.entry_balanceAmtField);
        expFields.add(FieldDO.repayDateField);
        traFields.add(FieldDO.dateField);
        traFields.add(FieldDO.applierField);
        traFields.add(FieldDO.billnoField);
        traFields.add(FieldDO.trip_entry_balanceAmtField);
        traFields.add(FieldDO.repayDateField);
        metaMap.put(BILLTYPE.DAILYLOAN, expFields);
        metaMap.put(BILLTYPE.PREPAYBILL, expFields);
        metaMap.put(BILLTYPE.TRIPLOAN, traFields);
    }

    public static enum BILLTYPE {
        DAILYLOAN,
        PREPAYBILL,
        TRIPLOAN;

    }
}

