/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.report.mb.util;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.fi.er.business.reportmb.context.AbstractReportContext;
import kd.fi.er.business.reportmb.datahandler.IMBReportDataHandler;

public class ReportDataProcessCenter {
    public static <T> void doHandleProcess(IFormView mainPageView, AbstractReportContext reportCxt, String dataKey, IMBReportDataHandler<T> handler) {
        ThreadService.execute(() -> {
            Object handleData = handler.doHandler(reportCxt);
            ReportDataProcessCenter.putIntoPageCache(dataKey, mainPageView.getPageCache(), handleData);
        }, (TaskType)TaskType.ER_REPORT_QUERY, (RequestContext)RequestContext.get());
    }

    public static <T> Future<Object> doHandleProcessInFuture(final IFormView mainPageView, final AbstractReportContext reportCxt, final String dataKey, final IMBReportDataHandler<T> handler) {
        return ThreadService.submit((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Object handleData = handler.doHandler(reportCxt);
                ReportDataProcessCenter.putIntoPageCache(dataKey, mainPageView.getPageCache(), handleData);
                return handleData;
            }
        }, (TaskType)TaskType.ER_REPORT_QUERY, (RequestContext)RequestContext.get());
    }

    private static synchronized <T> void putIntoPageCache(String dataKey, IPageCache pageCache, T handleData) {
        pageCache.put(dataKey, SerializationUtils.toJsonString(handleData));
    }

    public static String getData(String dataKey, IFormView mainPageView) {
        int tryAgain = 2000;
        String data = null;
        for (int i = 0; i < tryAgain && (data = mainPageView.getPageCache().get(dataKey)) == null; ++i) {
            try {
                Thread.sleep(20L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return data;
    }
}

