/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.share;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.formplugin.util.OrgUtils;
import org.apache.commons.lang3.StringUtils;

public class CommonShareRulePlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit control = (BasedataEdit)this.getControl("entrycostdept_orgrule");
        if (control != null) {
            control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        OrgUtils.excludeFreezeOrg((Control)this.getControl("sdentrycostdept"));
        OrgUtils.excludeFreezeOrg((Control)this.getControl("entrycostdept_orgrule"));
        BasedataEdit entrycostcompany_orgrule = (BasedataEdit)this.getControl("entrycostcompany_orgrule");
        if (entrycostcompany_orgrule != null) {
            entrycostcompany_orgrule.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        ListShowParameter formShowParameter;
        if ("entrycostdept_orgrule".equals(arg.getProperty().getName())) {
            formShowParameter = (ListShowParameter)arg.getFormShowParameter();
            formShowParameter.setMultiSelect(Boolean.FALSE.booleanValue());
            int currentRow = arg.getRow();
            DynamicObject costcomany = (DynamicObject)this.getModel().getValue("entrycostcompany_orgrule", currentRow);
            if (costcomany != null) {
                ArrayList useOrgList = new ArrayList();
                List<Long> orgIds = Collections.singletonList(Long.valueOf(costcomany.get("masterid").toString()));
                QFilter treeTypeFilter = new QFilter("view.treetype", "=", (Object)"01");
                QFilter orgFilter = new QFilter("org", "=", costcomany.getPkValue());
                QFilter[] filters = new QFilter[]{treeTypeFilter, orgFilter};
                DynamicObject orgInfo = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"org", (QFilter[])filters);
                if (orgInfo != null) {
                    List allOrgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)1L, orgIds, (boolean)true);
                    useOrgList.addAll(allOrgList);
                }
                List relationOrgList = OrgUnitServiceHelper.getAdminOrgRelation(orgIds, (boolean)true);
                useOrgList.addAll(relationOrgList);
                if (useOrgList.size() > 0) {
                    QFilter qFilter = new QFilter("masterid", "in", useOrgList);
                    ListShowParameter cardF7Param = (ListShowParameter)arg.getFormShowParameter();
                    cardF7Param.getListFilterParameter().getQFilters().add(qFilter);
                    cardF7Param.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
                }
            }
        }
        if ("entrycostcompany_orgrule".equals(arg.getProperty().getName())) {
            formShowParameter = (ListShowParameter)arg.getFormShowParameter();
            if (ErCommonUtils.costcompanyonlyleaf()) {
                formShowParameter.setCustomParam("isOnlyDisplayOrgLeaves", (Object)true);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propNewValue = valueSet[0].getNewValue();
        int rowIndex = valueSet[0].getRowIndex();
        IDataModel dataModel = this.getModel();
        switch (propName) {
            case "std_entrycostcenter": {
                if (!"er_applyprojectbill".equals(this.getModel().getDataEntityType().toString()) || this.getModel().getEntryEntity("expenseentryentity").size() < rowIndex) break;
                DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("expenseentryentity").get(rowIndex);
                DynamicObjectCollection expenseentryentity_rule = dynamicObject.getDynamicObjectCollection("expenseentryentity_rule");
                for (int index = 0; index < expenseentryentity_rule.size(); ++index) {
                    this.getModel().setValue("std_entrycostcenter_crule", (Object)ErCommonUtils.getPk((Object)propNewValue), index, rowIndex);
                }
                break;
            }
            case "entrycostcompany_orgrule": {
                dataModel.setValue("entrycostdept_orgrule", null, rowIndex);
                break;
            }
            case "entrymonth_monthrule": {
                if (propNewValue == null) break;
                dataModel.setValue("entrymonth_monthrule", (Object)CommonServiceHelper.getLastDayOfMonthBy((Date)((Date)propNewValue)), rowIndex);
                break;
            }
            case "sharerule_startdate": {
                if (propNewValue == null) {
                    return;
                }
                Date eDate = (Date)dataModel.getValue("sharerule_enddate");
                if (eDate == null) {
                    return;
                }
                if (((Date)propNewValue).after(eDate)) {
                    dataModel.beginInit();
                    dataModel.setValue("sharerule_enddate", propNewValue);
                    dataModel.endInit();
                    this.getView().updateView("sharerule_enddate");
                }
                this.autoBuildEntry();
                break;
            }
            case "sharerule_enddate": {
                if (propNewValue == null) {
                    return;
                }
                Date sDate = (Date)dataModel.getValue("sharerule_startdate");
                if (sDate == null) {
                    return;
                }
                if (((Date)propNewValue).before(sDate)) {
                    dataModel.beginInit();
                    dataModel.setValue("sharerule_startdate", propNewValue);
                    dataModel.endInit();
                    this.getView().updateView("sharerule_startdate");
                }
                this.autoBuildEntry();
                break;
            }
            case "sharemethod": {
                if (StringUtils.equals((CharSequence)"amount", (CharSequence)String.valueOf(propNewValue)) || StringUtils.equals((CharSequence)"expenseitemrule", (CharSequence)dataModel.getValue("sharerule").toString())) {
                    dataModel.deleteEntryData("expenseentryentity_rule");
                }
                if (!StringUtils.equals((CharSequence)"rate", (CharSequence)String.valueOf(propNewValue)) && !StringUtils.equals((CharSequence)"avg", (CharSequence)String.valueOf(propNewValue))) break;
                DynamicObjectCollection ruleEntrys = dataModel.getEntryEntity("expenseentryentity_rule");
                if (ruleEntrys != null && ruleEntrys.size() > 0) {
                    for (int i = 0; i < ruleEntrys.size(); ++i) {
                        dataModel.setValue("sharerate_comrule", (Object)BigDecimal.ZERO, i);
                        if (ruleEntrys.getDynamicObjectType().getProperty("shareamount_comrule") != null) {
                            dataModel.setValue("shareamount_comrule", (Object)BigDecimal.ZERO, i);
                        }
                        if (ruleEntrys.getDynamicObjectType().getProperty("shareappamount_comrule") == null) continue;
                        dataModel.setValue("shareappamount_comrule", (Object)BigDecimal.ZERO, i);
                    }
                    break;
                }
                if (!StringUtils.equals((CharSequence)"monthrule", (CharSequence)dataModel.getValue("sharerule").toString())) break;
                Date sDate = (Date)dataModel.getValue("sharerule_startdate");
                Date eDate = (Date)dataModel.getValue("sharerule_enddate");
                if (sDate == null || eDate == null || !eDate.after(sDate)) break;
                this.autoBuildEntry();
            }
        }
    }

    private void autoBuildEntry() {
        DynamicObjectCollection ruleEntrys = null;
        IDataModel model = this.getModel();
        if (this.isShareBill()) {
            ruleEntrys = model.getDataEntity(true).getDynamicObjectCollection("expenseentryentity_rule");
        } else {
            DynamicObjectCollection expenEntrys = model.getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
            if (expenEntrys != null && expenEntrys.size() > 0) {
                int expenEntryIndex = model.getEntryCurrentRowIndex("expenseentryentity");
                ruleEntrys = ((DynamicObject)expenEntrys.get(expenEntryIndex)).getDynamicObjectCollection("expenseentryentity_rule");
            }
        }
        if (ruleEntrys == null || ruleEntrys.size() == 0 || ruleEntrys.size() == 1) {
            this.genRuleEntryByDate();
        } else {
            this.beforeConfirmRebuild();
        }
    }

    private void beforeConfirmRebuild() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u6839\u636e\u5206\u644a\u6708\u4efd\u91cd\u65b0\u751f\u6210\u5206\u644a\u4fe1\u606f\u8868?", (String)"CommonShareRulePlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("sharerule_date"));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("sharerule_date".equalsIgnoreCase(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.genRuleEntryByDate();
        }
    }

    private void genRuleEntryByDate() {
        DynamicObjectCollection ruleEntrys;
        IDataModel model = this.getModel();
        Date sDate = (Date)model.getValue("sharerule_startdate");
        Date eDate = (Date)model.getValue("sharerule_enddate");
        if (sDate == null || eDate == null) {
            return;
        }
        DynamicObject bill = model.getDataEntity(true);
        if (this.isShareBill()) {
            DynamicObjectCollection expenEntrys;
            Object shareMethod = model.getValue("sharemethod");
            String entityProp = ErEntityTypeUtils.isShareBill((String)this.getView().getEntityId()) ? "expenseentryentity_wait" : "expenseentryentity";
            if (StringUtils.equals((CharSequence)"amount", (CharSequence)String.valueOf(shareMethod)) && !ErEntityTypeUtils.isTripReimburseBill((String)this.getView().getEntityId()) && ((expenEntrys = bill.getDynamicObjectCollection(entityProp)) == null || expenEntrys.size() < 1)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8d39\u7528\u660e\u7ec6\u3002", (String)"CommonShareRulePlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            ruleEntrys = bill.getDynamicObjectCollection("expenseentryentity_rule");
            if (ruleEntrys != null && ruleEntrys.size() > 0) {
                if (StringUtils.equals((CharSequence)"amount", (CharSequence)String.valueOf(shareMethod)) && !ErEntityTypeUtils.isTripReimburseBill((String)this.getView().getEntityId())) {
                    int expenEntryIndex = model.getEntryCurrentRowIndex(entityProp);
                    DynamicObjectCollection expenEntrys2 = bill.getDynamicObjectCollection(entityProp);
                    DynamicObject expenEntry = (DynamicObject)expenEntrys2.get(expenEntryIndex);
                    Long entryId = (Long)expenEntry.getPkValue();
                    ArrayList needDelIndexs = Lists.newArrayList();
                    for (int i2 = 0; i2 < ruleEntrys.size(); ++i2) {
                        DynamicObject ruleEntry = (DynamicObject)ruleEntrys.get(i2);
                        Long waitId = ruleEntry.getLong("sharewaitid_comrule");
                        if (entryId.compareTo(waitId) != 0) continue;
                        needDelIndexs.add(i2);
                    }
                    if (!needDelIndexs.isEmpty()) {
                        model.deleteEntryRows("expenseentryentity_rule", needDelIndexs.stream().mapToInt(i -> i).toArray());
                    }
                } else {
                    model.deleteEntryData("expenseentryentity_rule");
                }
            }
        } else {
            int expenEntryIndex;
            DynamicObjectCollection expenEntrys = bill.getDynamicObjectCollection("expenseentryentity");
            if (expenEntrys != null && expenEntrys.size() > 0 && (ruleEntrys = ((DynamicObject)expenEntrys.get(expenEntryIndex = model.getEntryCurrentRowIndex("expenseentryentity"))).getDynamicObjectCollection("expenseentryentity_rule")) != null && ruleEntrys.size() > 0) {
                model.deleteEntryData("expenseentryentity_rule");
            }
        }
        Calendar min = Calendar.getInstance();
        min.setTime(sDate);
        min.set(min.get(1), min.get(2), 1);
        Calendar max = Calendar.getInstance();
        max.setTime(eDate);
        max.set(max.get(1), max.get(2), 2);
        Object shareRule = this.getModel().getValue("sharerule");
        int indexType = 2;
        if (StringUtils.equals((CharSequence)"yearrule", (CharSequence)String.valueOf(shareRule))) {
            indexType = 1;
            max.set(max.get(1), min.get(2), 2);
        }
        Calendar curr = min;
        while (curr.before(max)) {
            int index = model.createNewEntryRow("expenseentryentity_rule");
            model.setValue("entrymonth_monthrule", (Object)curr.getTime(), index);
            curr.add(indexType, 1);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        if ("expenseentryentity_rule".equalsIgnoreCase(entryName)) {
            RowDataEntity[] rowDataEntities;
            IDataModel model = this.getModel();
            Object shareRule = model.getValue("sharerule");
            if (StringUtils.equals((CharSequence)"orgrule", (CharSequence)String.valueOf(shareRule)) || StringUtils.equals((CharSequence)"monthrule", (CharSequence)String.valueOf(shareRule)) || StringUtils.equals((CharSequence)"yearrule", (CharSequence)String.valueOf(shareRule))) {
                rowDataEntities = e.getRowDataEntities();
                Object costcompanyId = ((DynamicObject)model.getValue("costcompany")).getPkValue();
                Object costdeptId = ((DynamicObject)model.getValue("costdept")).getPkValue();
                String entityType = model.getDataEntityType().toString();
                DynamicObject entrycostcenter = null;
                DynamicObject project = null;
                switch (entityType) {
                    case "er_publicreimbursebill": 
                    case "er_dailyreimbursebill": {
                        entrycostcenter = (DynamicObject)model.getValue("std_entrycostcenter", 0);
                        project = (DynamicObject)model.getValue("std_project", 0);
                        break;
                    }
                    case "er_tripreimbursebill": {
                        entrycostcenter = (DynamicObject)model.getValue("travelcostcenter", 0);
                        project = (DynamicObject)model.getValue("std_project", 0);
                        break;
                    }
                    case "er_expensesharebill": {
                        entrycostcenter = (DynamicObject)model.getValue("std_entrycostcenter_wait", 0);
                        project = (DynamicObject)model.getValue("std_project_wait", 0);
                        break;
                    }
                    case "er_applyprojectbill": {
                        EntryGrid expenseEntryGrid = (EntryGrid)this.getControl("expenseentryentity");
                        int[] selectRows = expenseEntryGrid.getSelectRows();
                        if (selectRows.length > 0) {
                            entrycostcenter = (DynamicObject)this.getModel().getValue("std_entrycostcenter", selectRows[0]);
                        }
                        if (entrycostcenter != null || model.getEntryEntity("expenseentryentity").size() <= 0) break;
                        entrycostcenter = ((DynamicObject)model.getEntryEntity("expenseentryentity").get(0)).getDynamicObject("std_entrycostcenter");
                    }
                }
                Object entrycostcenterId = null;
                if (entrycostcenter != null) {
                    entrycostcenterId = entrycostcenter.getPkValue();
                }
                for (RowDataEntity rowData : rowDataEntities) {
                    Object costdept_rule;
                    Object costcompany_rule;
                    Object std_project_waitrule;
                    int index = rowData.getRowIndex();
                    Object std_entrycostcenter_crule = rowData.getDataEntity().get("std_entrycostcenter_crule");
                    if (std_entrycostcenter_crule == null && entrycostcenterId != null) {
                        model.setValue("std_entrycostcenter_crule", entrycostcenterId, index);
                    }
                    if ((std_project_waitrule = rowData.getDataEntity().get("std_project_comrule")) == null && project != null) {
                        model.setValue("std_project_comrule", (Object)project, index);
                    }
                    if (StringUtils.equals((CharSequence)"amount", (CharSequence)model.getValue("sharemethod").toString())) {
                        int entryIndex = 0;
                        DynamicObject expenEntry = null;
                        switch (entityType) {
                            case "er_publicreimbursebill": 
                            case "er_dailyreimbursebill": {
                                entryIndex = model.getEntryCurrentRowIndex("expenseentryentity");
                                expenEntry = (DynamicObject)model.getEntryEntity("expenseentryentity").get(entryIndex);
                                if (expenEntry.getDynamicObject("entrycostcompany") != null) {
                                    costcompanyId = expenEntry.getDynamicObject("entrycostcompany").getPkValue();
                                }
                                if (expenEntry.getDynamicObject("entrycostdept") != null) {
                                    costdeptId = expenEntry.getDynamicObject("entrycostdept").getPkValue();
                                }
                                entrycostcenterId = expenEntry.getDynamicObject("std_entrycostcenter");
                                project = expenEntry.getDynamicObject("std_project");
                                break;
                            }
                            case "er_tripreimbursebill": {
                                entrycostcenterId = model.getValue("travelcostcenter", 0);
                                break;
                            }
                            case "er_expensesharebill": {
                                entryIndex = model.getEntryCurrentRowIndex("expenseentryentity_wait");
                                expenEntry = (DynamicObject)model.getEntryEntity("expenseentryentity_wait").get(entryIndex);
                                if (expenEntry.getDynamicObject("entrycostcompany_wait") != null) {
                                    costcompanyId = expenEntry.getDynamicObject("entrycostcompany_wait").getPkValue();
                                }
                                if (expenEntry.getDynamicObject("entrycostdept_wait") != null) {
                                    costdeptId = expenEntry.getDynamicObject("entrycostdept_wait").getPkValue();
                                }
                                entrycostcenterId = expenEntry.getDynamicObject("std_entrycostcenter_wait");
                                project = expenEntry.getDynamicObject("std_project_wait");
                            }
                        }
                        model.setValue("std_entrycostcenter_crule", entrycostcenterId, index);
                        if (project != null) {
                            model.setValue("std_project_comrule", (Object)project, index);
                        }
                    }
                    if ((costcompany_rule = rowData.getDataEntity().get("entrycostcompany_orgrule")) == null) {
                        model.setValue("entrycostcompany_orgrule", costcompanyId, index);
                    }
                    if ((costdept_rule = rowData.getDataEntity().get("entrycostdept_orgrule")) != null) continue;
                    model.setValue("entrycostdept_orgrule", costdeptId, index);
                }
            }
            if (StringUtils.equals((CharSequence)"monthrule", (CharSequence)String.valueOf(shareRule)) || StringUtils.equals((CharSequence)"yearrule", (CharSequence)String.valueOf(shareRule))) {
                for (RowDataEntity rowData : rowDataEntities = e.getRowDataEntities()) {
                    Date preDate;
                    int index = rowData.getRowIndex();
                    Date curDate = (Date)model.getValue("entrymonth_monthrule", index);
                    if (curDate != null) continue;
                    if (index == 0) {
                        Date startDate = (Date)model.getValue("sharerule_startdate");
                        if (startDate != null) {
                            model.setValue("entrymonth_monthrule", (Object)startDate, index);
                        } else {
                            model.setValue("entrymonth_monthrule", model.getValue("bizdate"), index);
                        }
                    }
                    if (index <= 0 || (preDate = (Date)model.getValue("entrymonth_monthrule", index - 1)) == null) continue;
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(preDate);
                    cal.add(2, 1);
                    model.setValue("entrymonth_monthrule", (Object)cal.getTime(), index);
                }
            }
        }
    }

    protected boolean isShareBill() {
        DynamicObject bill = this.getModel().getDataEntity(true);
        String billType = bill.getDynamicObjectType().getName();
        if (ErEntityTypeUtils.isApplyProjectBill((String)billType)) {
            return false;
        }
        return !ErEntityTypeUtils.isCostEstimateBill((String)billType);
    }
}

