/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.share;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.share.ErVerifyShareRuleHelper;
import kd.fi.er.business.share.ShareBillService;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.AttachmentCountUtils;
import kd.fi.er.business.utils.ErCostCenterUtil;
import kd.fi.er.business.utils.model.ChangeField;
import kd.fi.er.common.ErBillStatusEnum;
import kd.fi.er.formplugin.budget.BudgetCommonUtil;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostCenterF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeExpenseItemF7SelectListener;
import kd.fi.er.formplugin.daily.web.AbstractExpenseBaseBillPlugin;
import kd.fi.er.formplugin.daily.web.util.ShowUserInfoUtils;
import org.apache.commons.lang3.StringUtils;

public class ExpenseShareBillEditPlugin
extends AbstractExpenseBaseBillPlugin {
    private static final String BAR_CONFIRMSHARE = "confirmshare";
    private static final String BAR_CANCELSHARE = "cancelshare";
    private static final String TODO_ADVCONAP_CONTROL = "todo_advconap";
    private static final String DOING_ADVCONAP_CONTROL = "doing_advconap";

    public void registerListener(EventObject e) {
        BasedataEdit entryexpenseitemF7;
        super.registerListener(e);
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("expenseentryentity_wait");
        String number = this.getModel().getDataEntityType().getName();
        if (!dynamicObjectCollection.isEmpty()) {
            number = (String)this.getModel().getValue("srcbilltype", 0);
        }
        if (null != (entryexpenseitemF7 = (BasedataEdit)this.getControl("entryexpenseitem"))) {
            entryexpenseitemF7.addBeforeF7SelectListener((BeforeF7SelectListener)new BeforeExpenseItemF7SelectListener(this.getView(), number, "entrycostdept_orgrule"));
        }
        BasedataEdit std_entrycostcenter_crule = (BasedataEdit)this.getControl("std_entrycostcenter_crule");
        BeforeCostCenterF7SelectListener beforeCostCenterF7SelectListener = new BeforeCostCenterF7SelectListener(this.getView());
        if (std_entrycostcenter_crule != null) {
            std_entrycostcenter_crule.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCenterF7SelectListener);
        }
        this.costCenterF7Filter();
    }

    private void costCenterF7Filter() {
        BasedataEdit costCenterF7 = (BasedataEdit)this.getControl("std_costcenter");
        BasedataEdit entryCostCenterF7 = (BasedataEdit)this.getControl("std_entrycostcenter");
        BasedataEdit std_entrycostcenter_crule = (BasedataEdit)this.getControl("std_entrycostcenter_crule");
        BeforeCostCenterF7SelectListener beforeCostCenterF7SelectListener = new BeforeCostCenterF7SelectListener(this.getView());
        if (costCenterF7 != null) {
            costCenterF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCenterF7SelectListener);
        }
        if (entryCostCenterF7 != null) {
            entryCostCenterF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCenterF7SelectListener);
        }
        if (std_entrycostcenter_crule != null) {
            std_entrycostcenter_crule.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCenterF7SelectListener);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        CoreBaseBillServiceHelper.setBillCostOrgUseMode((IDataModel)this.getModel());
    }

    public void afterBindData(EventObject e) {
        DynamicObjectCollection waitEntrys;
        super.afterBindData(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        model.beginInit();
        boolean dataChanged = model.getDataChanged();
        DynamicObject costdept = (DynamicObject)model.getValue("costdept");
        DynamicObject costcompany = (DynamicObject)model.getValue("costcompany");
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        ShowUserInfoUtils.initUserInfo((IDataModel)model, (IFormView)view);
        if (costdept != null) {
            model.setValue("costdept", costdept.getPkValue());
        }
        if (costcompany != null) {
            model.setValue("costcompany", costcompany.getPkValue());
        }
        DynamicObjectCollection rule_entry = model.getEntryEntity("expenseentryentity_rule");
        if (costcompany != null && rule_entry != null && rule_entry.size() == 1 && ((DynamicObject)rule_entry.get(0)).getDynamicObject("entrycostcompany_orgrule") == null) {
            model.setValue("entrycostcompany_orgrule", costcompany.getPkValue(), 0);
        }
        if (currency != null) {
            model.setValue("currency", currency.getPkValue());
        }
        ErCostCenterUtil.initHeadCostCenter((IFormView)this.getView(), (boolean)false);
        model.endInit();
        view.updateView("company");
        if (rule_entry != null && rule_entry.size() == 1 && ((DynamicObject)rule_entry.get(0)).getDynamicObject("entrycostcompany_orgrule") != null) {
            view.updateView("entrycostcompany_orgrule", 0);
        }
        if ((waitEntrys = model.getDataEntity(true).getDynamicObjectCollection("expenseentryentity_wait")) != null && waitEntrys.size() > 0) {
            BigDecimal totalWaitApproveAmount = BigDecimal.ZERO;
            BigDecimal totalSharedAmount = BigDecimal.ZERO;
            HashSet<String> souceEntryIds = new HashSet<String>(4);
            for (int i = 0; i < waitEntrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)waitEntrys.get(i);
                totalWaitApproveAmount = totalWaitApproveAmount.add(entry.getBigDecimal("expeapprovecurramount_w"));
                String souceEntryId = entry.getString("sourceentryid");
                boolean flag = souceEntryIds.add(souceEntryId);
                if (!flag) continue;
                totalSharedAmount = totalSharedAmount.add(entry.getBigDecimal("entrysharedamount"));
            }
            if (totalWaitApproveAmount.compareTo(BigDecimal.ZERO) != 0) {
                int precision = AmountUtils.getCurrencyPrecision((IDataModel)model, (String)"currency");
                BigDecimal totalWaitRate = totalWaitApproveAmount.subtract(totalSharedAmount).multiply(BigDecimal.valueOf(100L)).divide(totalWaitApproveAmount, precision, RoundingMode.HALF_EVEN);
                model.setValue("cansharerate", (Object)totalWaitRate);
            }
        }
        this.controlTodoFlexEnable();
        model.setDataChanged(dataChanged);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propNewValue = valueSet[0].getNewValue();
        int rowIndex = valueSet[0].getRowIndex();
        int parentIndex = valueSet[0].getParentRowIndex();
        IDataModel dataModel = this.getModel();
        switch (propName) {
            case "expenseamount": {
                AmountUtils.refreshCurrAmount((IDataModel)dataModel, (BigDecimal)((BigDecimal)propNewValue), (String)"currexpenseamount", (String)"exchangerate", (String)"expquotetype", (int)rowIndex);
                BigDecimal noTaxAmount = ((BigDecimal)propNewValue).subtract((BigDecimal)dataModel.getValue("taxamount", rowIndex));
                dataModel.setValue("orientryamount", (Object)noTaxAmount, rowIndex);
                dataModel.setValue("expeapproveamount", propNewValue, rowIndex);
                AmountUtils.refreshCurrAmount((IDataModel)dataModel, (BigDecimal)((BigDecimal)propNewValue), (String)"expeapprovecurramount", (String)"exchangerate", (String)"expquotetype", (int)rowIndex);
                break;
            }
            case "taxamount": {
                BigDecimal currNoTaxAmount = ((BigDecimal)dataModel.getValue("expenseamount", rowIndex)).subtract((BigDecimal)propNewValue);
                dataModel.setValue("orientryamount", (Object)currNoTaxAmount, rowIndex);
                break;
            }
            case "expeapproveamount": {
                AmountUtils.refreshCurrAmount((IDataModel)dataModel, (BigDecimal)((BigDecimal)propNewValue), (String)"expeapprovecurramount", (String)"exchangerate", (String)"expquotetype", (int)rowIndex);
                BigDecimal taxRate = (BigDecimal)dataModel.getValue("taxrate", rowIndex);
                AmountChangeUtil.updateApproveInfo((IDataModel)dataModel, (int)rowIndex, (taxRate.compareTo(BigDecimal.ZERO) != 0 ? 1 : 0) != 0);
                break;
            }
            case "approvetax": 
            case "deductibletax": {
                AmountChangeUtil.updatePrice((IDataModel)this.getModel(), (IFormView)this.getView(), (String)"expenseentryentity", (String)"expeapproveamount", (int)rowIndex, (int)parentIndex, (String)"currency", (ChangeField)ChangeField.DEDUCTIBLE_TAX);
                break;
            }
            case "std_costcenter": {
                if (propNewValue == null || propNewValue == "") break;
                if (!ErCostCenterUtil.isLeafCostCenter((Object)propNewValue)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6210\u672c\u4e2d\u5fc3\u4e3a\u975e\u53f6\u5b50\u51e0\u70b9\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ExpenseBaseMobPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("std_costcenter", null);
                    break;
                }
                ErCostCenterUtil.headCostCenterChange((IFormView)this.getView(), (Object)propNewValue, (boolean)true);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        FormOperate operate = (FormOperate)evt.getSource();
        String operateKey = operate.getOperateKey();
        if (operateKey.equalsIgnoreCase(BAR_CONFIRMSHARE)) {
            String msg = ErVerifyShareRuleHelper.getVerifyShareRuleMsg((DynamicObject)this.getModel().getDataEntity(true));
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                this.getView().showTipNotification(msg);
                evt.setCancel(true);
                return;
            }
            this.delDoneEntry();
            IDataModel model = this.getModel();
            DynamicObject bill = model.getDataEntity(true);
            ShareBillService.buildDoneEntry((DynamicObject)bill);
            Boolean isQueryBudgetFlag = BudgetCommonUtil.getIsQueryBudgetFlag(this.getPageCache());
            if (isQueryBudgetFlag.booleanValue()) {
                BudgetCommonUtil.buildBudgetAmountField(this.getView());
            }
        }
        if (operate instanceof Save || operate instanceof Submit) {
            this.refreshBillHeadAmount();
        }
        AttachmentCountUtils.setAttachmentCount((FormOperate)operate, (IDataModel)this.getModel(), (IFormView)this.getView());
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        OperationResult result = evt.getOperationResult();
        if (result == null || !result.isSuccess()) {
            return;
        }
        this.controlTodoFlexEnable();
        String operateKey = evt.getOperateKey();
        if (operateKey.equalsIgnoreCase(BAR_CANCELSHARE)) {
            this.delDoneEntry();
        }
    }

    private void delDoneEntry() {
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
        entrys.clear();
    }

    private void controlTodoFlexEnable() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Container todo_advconap = (Container)this.getControl(TODO_ADVCONAP_CONTROL);
        Container doing_advconap = (Container)this.getControl(DOING_ADVCONAP_CONTROL);
        String sharestatus = (String)model.getValue("sharestatus");
        String billstatus = (String)model.getValue("billstatus");
        if (todo_advconap != null) {
            if ("C".equalsIgnoreCase(sharestatus) && ErBillStatusEnum.A.toString().equals(billstatus)) {
                todo_advconap.setCollapse(true);
            } else {
                todo_advconap.setCollapse(false);
            }
        }
        if (doing_advconap != null) {
            if ("C".equalsIgnoreCase(sharestatus) && ErBillStatusEnum.A.toString().equals(billstatus)) {
                doing_advconap.setCollapse(true);
                view.setEnable(Boolean.valueOf(false), new String[]{DOING_ADVCONAP_CONTROL});
            } else {
                doing_advconap.setCollapse(false);
                view.setEnable(Boolean.valueOf(true), new String[]{DOING_ADVCONAP_CONTROL});
            }
        }
    }

    private void refreshBillHeadAmount() {
        IDataModel dataModel = this.getModel();
        BigDecimal totalReimAmount = AmountUtils.getEntryAmount((IDataModel)dataModel, (String)"expenseentryentity", (String)"currexpenseamount");
        BigDecimal totalApproveAmount = AmountUtils.getEntryAmount((IDataModel)dataModel, (String)"expenseentryentity", (String)"expeapprovecurramount");
        BigDecimal totalWaitAmount = AmountUtils.getEntryAmount((IDataModel)dataModel, (String)"expenseentryentity_wait", (String)"currexpenseamount_wait");
        BigDecimal totalWaitApproveAmount = AmountUtils.getEntryAmount((IDataModel)dataModel, (String)"expenseentryentity_wait", (String)"expeapprovecurramount_w");
        dataModel.beginInit();
        dataModel.setValue("reimburseamount", (Object)totalReimAmount);
        dataModel.setValue("approveamount", (Object)totalApproveAmount);
        dataModel.setValue("waitamount", (Object)totalWaitAmount);
        dataModel.setValue("waitapproveamount", (Object)totalWaitApproveAmount);
        dataModel.endInit();
    }
}

