/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.share;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.servicehelper.ExpenseItemServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.formplugin.share.CommonShareRulePlugin;
import org.apache.commons.lang3.StringUtils;

public class ExpenseShareRulePlugin
extends CommonShareRulePlugin {
    private static Log logger = LogFactory.getLog(ExpenseShareRulePlugin.class);

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        DynamicObjectCollection ruleEntrys = model.getEntryEntity("expenseentryentity_rule");
        if (ruleEntrys != null && ruleEntrys.size() > 0) {
            DynamicObjectCollection expenEntrys;
            DynamicObject costCenter;
            Object shareRule = this.getModel().getValue("sharerule");
            if (StringUtils.equals((CharSequence)"orgrule", (CharSequence)String.valueOf(shareRule)) || StringUtils.equals((CharSequence)"monthrule", (CharSequence)String.valueOf(shareRule)) || StringUtils.equals((CharSequence)"yearrule", (CharSequence)String.valueOf(shareRule))) {
                if (model.getValue("costcompany") != null) {
                    Object costcompanyId = ((DynamicObject)model.getValue("costcompany")).getPkValue();
                    model.setValue("entrycostcompany_orgrule", costcompanyId, 0);
                }
                if (model.getValue("costdept") != null) {
                    Object costdeptId = ((DynamicObject)model.getValue("costdept")).getPkValue();
                    model.setValue("entrycostdept_orgrule", costdeptId, 0);
                }
            }
            if (StringUtils.equals((CharSequence)"monthrule", (CharSequence)String.valueOf(shareRule)) || StringUtils.equals((CharSequence)"yearrule", (CharSequence)String.valueOf(shareRule))) {
                model.setValue("entrymonth_monthrule", model.getValue("bizdate"), 0);
            }
            if ((costCenter = (DynamicObject)model.getValue("std_costcenter")) != null) {
                model.setValue("std_entrycostcenter_crule", (Object)costCenter, 0);
            }
            DynamicObject project = null;
            if (ErEntityTypeUtils.isShareBill((String)this.getView().getEntityId())) {
                DynamicObjectCollection expenEntrys2 = model.getEntryEntity("expenseentryentity_wait");
                if (expenEntrys2 != null && expenEntrys2.size() > 0) {
                    DynamicObject expenEntry = (DynamicObject)expenEntrys2.get(0);
                    project = expenEntry.getDynamicObject("std_project_wait");
                }
            } else if (ErEntityTypeUtils.isTripReimburseBill((String)this.getView().getEntityId()) || "er_tripreimbursebill_ssc".equals(this.getView().getEntityId())) {
                DynamicObjectCollection expenEntrys3 = model.getEntryEntity("tripentry");
                if (expenEntrys3 != null && expenEntrys3.size() > 0) {
                    DynamicObject expenEntry = (DynamicObject)expenEntrys3.get(0);
                    project = expenEntry.getDynamicObject("std_project");
                }
            } else if (model.getProperty("expenseentryentity") != null && (expenEntrys = model.getEntryEntity("expenseentryentity")) != null && expenEntrys.size() > 0) {
                DynamicObject expenEntry = (DynamicObject)expenEntrys.get(0);
                project = expenEntry.getDynamicObject("std_project");
            }
            if (project != null) {
                model.setValue("std_project_comrule", project, 0);
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propNewValue = valueSet[0].getNewValue();
        int rowIndex = valueSet[0].getRowIndex();
        IDataModel model = this.getModel();
        if ("sharerule".equals(propName)) {
            model.deleteEntryData("expenseentryentity_rule");
            model.setValue("sharerule_startdate", null);
            model.setValue("sharerule_enddate", null);
            if (StringUtils.equals((CharSequence)"orgrule", (CharSequence)String.valueOf(propNewValue))) {
                this.setMustInput(true, "entrycostcompany_orgrule", "entrycostdept_orgrule");
            }
            if (StringUtils.equals((CharSequence)"expenseitemrule", (CharSequence)String.valueOf(propNewValue))) {
                this.setMustInput(true, "entrycostcompany_orgrule", "entrycostdept_orgrule", "entryexpenseitem");
            }
            if (StringUtils.equals((CharSequence)"monthrule", (CharSequence)String.valueOf(propNewValue)) || StringUtils.equals((CharSequence)"yearrule", (CharSequence)String.valueOf(propNewValue))) {
                this.setMustInput(false, "entrycostcompany_orgrule", "entrycostdept_orgrule", "entryexpenseitem");
            }
        }
        if ("shareamount_comrule".equals(propName) && !ErEntityTypeUtils.isTripReimburseBill((String)this.getView().getEntityId())) {
            model.setValue("shareappamount_comrule", propNewValue, rowIndex);
        }
        if (!ErEntityTypeUtils.isShareBill((String)this.getView().getEntityId()) && !ErEntityTypeUtils.isTripReimburseBill((String)this.getView().getEntityId())) {
            Object shareMethod = model.getValue("sharemethod");
            if ("entrycurrency".equals(propName) && StringUtils.equals((CharSequence)"amount", (CharSequence)String.valueOf(shareMethod))) {
                DynamicObjectCollection expenEntrys = model.getEntryEntity("expenseentryentity");
                DynamicObject expenEntry = (DynamicObject)expenEntrys.get(rowIndex);
                Long entryId = (Long)expenEntry.getPkValue();
                DynamicObjectCollection ruleEntrys = model.getEntryEntity("expenseentryentity_rule");
                if (ruleEntrys != null && ruleEntrys.size() > 0) {
                    for (int i = 0; i < ruleEntrys.size(); ++i) {
                        DynamicObject ruleEntry = (DynamicObject)ruleEntrys.get(i);
                        Long waitId = ruleEntry.getLong("sharewaitid_comrule");
                        if (waitId.compareTo(entryId) != 0) continue;
                        model.setValue("sharecurrency_comrule", propNewValue, i);
                    }
                    this.getView().updateView("expenseentryentity_rule");
                }
            }
        }
        if ("entrycostdept_orgrule".equals(propName)) {
            this.checkShareExpenseItem((DynamicObject)propNewValue, rowIndex);
        }
        if ("entrycostcompany_orgrule".equals(propName)) {
            this.checkBdProject((DynamicObject)propNewValue, rowIndex);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate foper = (FormOperate)args.getSource();
        String key = foper.getOperateKey();
        if (StringUtils.contains((CharSequence)"newshareruleentry", (CharSequence)key)) {
            IDataModel model = this.getModel();
            Object shareMethod = model.getValue("sharemethod");
            Object shareRule = model.getValue("sharerule");
            if (StringUtils.equals((CharSequence)"amount", (CharSequence)String.valueOf(shareMethod)) || StringUtils.equals((CharSequence)"expenseitemrule", (CharSequence)String.valueOf(shareRule))) {
                int[] rowIndexs = null;
                if (ErEntityTypeUtils.isTripReimburseBill((String)this.getView().getEntityId())) {
                    return;
                }
                if (ErEntityTypeUtils.isShareBill((String)this.getView().getEntityId())) {
                    EntryGrid grid = (EntryGrid)this.getView().getControl("expenseentryentity_wait");
                    rowIndexs = grid.getSelectRows();
                } else {
                    EntryGrid grid = (EntryGrid)this.getView().getControl("expenseentryentity");
                    rowIndexs = grid.getSelectRows();
                }
                if (rowIndexs == null || rowIndexs.length != 1) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u5f85\u644a\u660e\u7ec6\u3002", (String)"ExpenseShareRulePlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if ("expenseentryentity_rule".equalsIgnoreCase(entryName)) {
            int seq;
            DynamicObject expenEntry;
            int expenEntryIndex;
            DynamicObjectCollection expenEntrys;
            String entityProp;
            IDataModel model = this.getModel();
            Object shareMethod = model.getValue("sharemethod");
            Object shareRule = model.getValue("sharerule");
            if (StringUtils.equals((CharSequence)"amount", (CharSequence)String.valueOf(shareMethod))) {
                RowDataEntity[] rowDataEntities;
                if (ErEntityTypeUtils.isTripReimburseBill((String)this.getView().getEntityId())) {
                    return;
                }
                entityProp = ErEntityTypeUtils.isShareBill((String)this.getView().getEntityId()) ? "expenseentryentity_wait" : "expenseentryentity";
                expenEntrys = model.getEntryEntity(entityProp);
                if (expenEntrys == null || expenEntrys.size() < 1) {
                    return;
                }
                expenEntryIndex = model.getEntryCurrentRowIndex(entityProp);
                expenEntry = (DynamicObject)expenEntrys.get(expenEntryIndex);
                seq = expenEntry.getInt("seq");
                DynamicObject entryCurrency = ErEntityTypeUtils.isShareBill((String)this.getView().getEntityId()) ? expenEntry.getDynamicObject("entrycurrency_wait") : expenEntry.getDynamicObject("entrycurrency");
                Long entryId = (Long)expenEntry.getPkValue();
                if (Objects.equals(entryId, 0L)) {
                    entryId = ORM.create().genLongId(this.getView().getEntityId());
                    expenEntry.set("id", (Object)entryId);
                }
                for (RowDataEntity rowData : rowDataEntities = e.getRowDataEntities()) {
                    int index = rowData.getRowIndex();
                    model.setValue("sharewaitseq_comrule", (Object)seq, index);
                    model.setValue("sharewaitid_comrule", (Object)entryId, index);
                    model.setValue("sharecurrency_comrule", (Object)entryCurrency, index);
                }
            }
            if (StringUtils.equals((CharSequence)"expenseitemrule", (CharSequence)String.valueOf(shareRule))) {
                RowDataEntity[] rowDataEntities;
                entityProp = ErEntityTypeUtils.isShareBill((String)this.getView().getEntityId()) ? "expenseentryentity_wait" : (ErEntityTypeUtils.isTripReimburseBill((String)this.getView().getEntityId()) ? "tripentry" : "expenseentryentity");
                expenEntrys = model.getEntryEntity(entityProp);
                if (expenEntrys == null || expenEntrys.size() < 1) {
                    return;
                }
                expenEntryIndex = model.getEntryCurrentRowIndex(entityProp);
                expenEntry = (DynamicObject)expenEntrys.get(expenEntryIndex);
                seq = expenEntry.getInt("seq");
                Long entryId = (Long)expenEntry.getPkValue();
                if (Objects.equals(entryId, 0L)) {
                    entryId = ORM.create().genLongId(this.getView().getEntityId());
                    expenEntry.set("id", (Object)entryId);
                }
                DynamicObject expenseitem = null;
                DynamicObject costCompany = null;
                DynamicObject costDept = null;
                DynamicObject costCenter = null;
                DynamicObject project = null;
                if ("expenseentryentity_wait".equals(entityProp)) {
                    expenseitem = expenEntry.getDynamicObject("expenseitem_wait");
                    costCompany = expenEntry.getDynamicObject("entrycostcompany_wait");
                    costDept = expenEntry.getDynamicObject("entrycostdept_wait");
                    costCenter = expenEntry.getDynamicObject("std_entrycostcenter_wait");
                    project = expenEntry.getDynamicObject("std_project_wait");
                } else if ("expenseentryentity".equals(entityProp)) {
                    expenseitem = expenEntry.getDynamicObject("expenseitem");
                    costCompany = expenEntry.getDynamicObject("entrycostcompany");
                    costDept = expenEntry.getDynamicObject("entrycostdept");
                    costCenter = expenEntry.getDynamicObject("std_entrycostcenter");
                    project = expenEntry.getDynamicObject("std_project");
                }
                for (RowDataEntity rowData : rowDataEntities = e.getRowDataEntities()) {
                    int index = rowData.getRowIndex();
                    model.setValue("entryexpenseitem", (Object)expenseitem, index);
                    model.setValue("entrycostcompany_orgrule", (Object)costCompany, index);
                    model.setValue("entrycostdept_orgrule", (Object)costDept, index);
                    model.setValue("sharewaitseq_comrule", (Object)seq, index);
                    model.setValue("sharewaitid_comrule", (Object)entryId, index);
                    model.setValue("std_entrycostcenter_crule", (Object)costCenter, index);
                    if (project == null) continue;
                    model.setValue("std_project_comrule", (Object)project, index);
                }
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        Object shareMethod = model.getValue("sharemethod");
        Object shareRule = model.getValue("sharerule");
        if (StringUtils.equals((CharSequence)"expenseentryentity", (CharSequence)entryName) && !ErEntityTypeUtils.isShareBill((String)this.getView().getEntityId()) && (StringUtils.equals((CharSequence)"amount", (CharSequence)String.valueOf(shareMethod)) || StringUtils.equals((CharSequence)"expenseitemrule", (CharSequence)String.valueOf(shareRule)))) {
            DynamicObjectCollection ruleEntrys = model.getEntryEntity("expenseentryentity_rule");
            if (ruleEntrys == null || ruleEntrys.size() < 1) {
                return;
            }
            DynamicObjectCollection expenEntrys = model.getEntryEntity("expenseentryentity");
            if (expenEntrys != null && expenEntrys.size() > 0) {
                Map<Long, Integer> entryIdSeqMap = expenEntrys.stream().collect(Collectors.toMap(expenEntry -> ErCommonUtils.getPk((Object)expenEntry.getPkValue()), expenEntry -> expenEntry.getInt("seq")));
                ArrayList needDelIndexs = Lists.newArrayListWithExpectedSize((int)ruleEntrys.size());
                for (int i = 0; i < ruleEntrys.size(); ++i) {
                    DynamicObject ruleEntry = (DynamicObject)ruleEntrys.get(i);
                    Long relId = ruleEntry.getLong("sharewaitid_comrule");
                    if (entryIdSeqMap.get(relId) != null) {
                        model.setValue("sharewaitseq_comrule", (Object)entryIdSeqMap.get(relId), i);
                        continue;
                    }
                    needDelIndexs.add(i);
                }
                if (!needDelIndexs.isEmpty()) {
                    model.deleteEntryRows("expenseentryentity_rule", needDelIndexs.stream().mapToInt(Integer::intValue).toArray());
                }
            } else {
                model.deleteEntryData("expenseentryentity_rule");
            }
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getPageCache().put("iscopybill", "true");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setMustInput(true, "entrycostcompany_orgrule", "entrycostdept_orgrule");
        IDataModel model = this.getModel();
        DynamicObjectCollection ruleEntrys = this.getModel().getEntryEntity("expenseentryentity_rule");
        Boolean isPush = model.getDataEntity().getDataEntityState().isPushChanged();
        Boolean iscopybill = Boolean.FALSE;
        if (this.getPageCache().get("iscopybill") != null) {
            iscopybill = Boolean.parseBoolean(this.getPageCache().get("iscopybill"));
        }
        boolean isImport = Boolean.FALSE;
        if (this.getPageCache().get("isImport") != null) {
            isImport = Boolean.parseBoolean(this.getPageCache().get("isImport"));
        }
        if (!isImport && !iscopybill.booleanValue() && isPush.booleanValue() && ruleEntrys != null && ruleEntrys.size() > 0) {
            Object shareRule = this.getModel().getValue("sharerule");
            if (StringUtils.equals((CharSequence)"orgrule", (CharSequence)String.valueOf(shareRule)) || StringUtils.equals((CharSequence)"monthrule", (CharSequence)String.valueOf(shareRule)) || StringUtils.equals((CharSequence)"yearrule", (CharSequence)String.valueOf(shareRule))) {
                if (model.getValue("costcompany") != null) {
                    Object costcompanyId = ((DynamicObject)model.getValue("costcompany")).getPkValue();
                    model.setValue("entrycostcompany_orgrule", costcompanyId, 0);
                }
                if (model.getValue("costdept") != null) {
                    Object costdeptId = ((DynamicObject)model.getValue("costdept")).getPkValue();
                    model.setValue("entrycostdept_orgrule", costdeptId, 0);
                }
            }
            if (StringUtils.equals((CharSequence)"monthrule", (CharSequence)String.valueOf(shareRule)) || StringUtils.equals((CharSequence)"yearrule", (CharSequence)String.valueOf(shareRule))) {
                model.setValue("entrymonth_monthrule", model.getValue("bizdate"), 0);
            }
        }
        this.getPageCache().remove("iscopybill");
        this.getPageCache().remove("isImport");
    }

    protected void checkShareExpenseItem(DynamicObject costDept, int rowIndex) {
        if (!ErEntityTypeUtils.isTripReimburseBill((String)this.getView().getEntityId())) {
            IDataEntityProperty shareExpItemProperty = this.getModel().getProperty("entryexpenseitem");
            if (shareExpItemProperty == null) {
                return;
            }
            Long shareExpItemId = ErCommonUtils.getPk((Object)this.getModel().getValue("entryexpenseitem", rowIndex));
            Long costDeptId = ErCommonUtils.getPk((Object)costDept);
            if (costDeptId == null) {
                this.getModel().setValue("entryexpenseitem", null, rowIndex);
                return;
            }
            QFilter qFilter = new QFilter("id", "=", (Object)shareExpItemId);
            Long costCompany = ErCommonUtils.getPk((Object)this.getModel().getValue("entrycostcompany_orgrule", rowIndex));
            String entityId = this.getView().getEntityId();
            List upBillExpitemIds = null;
            if (!ErEntityTypeUtils.isShareBill((String)this.getView().getEntityId())) {
                upBillExpitemIds = ExpenseItemServiceHelper.getUpBillExpItemId((DynamicObject)this.getModel().getDataEntity(true));
            } else {
                DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("expenseentryentity_wait");
                if (!dynamicObjectCollection.isEmpty()) {
                    entityId = (String)this.getModel().getValue("srcbilltype", 0);
                }
            }
            qFilter = qFilter.and(ExpenseItemServiceHelper.getExpItemFiltersExcludeBizitemAndProjecttype((String)entityId, (Long)costCompany, (Long)costDeptId, (boolean)true));
            if (upBillExpitemIds != null && upBillExpitemIds.size() > 0) {
                qFilter.or("id", "in", (Object)upBillExpitemIds);
            }
            if (!QueryServiceHelper.exists((String)"er_expenseitemedit", (QFilter[])new QFilter[]{qFilter})) {
                this.getModel().setValue("entryexpenseitem", null, rowIndex);
            }
        }
    }

    protected void checkBdProject(DynamicObject costcompany, int rowIndex) {
        Long bdProjectId = ErCommonUtils.getPk((Object)this.getModel().getValue("std_project_comrule", rowIndex));
        if (bdProjectId == null) {
            return;
        }
        Long costcompanyId = ErCommonUtils.getPk((Object)costcompany);
        if (costcompanyId == null) {
            this.getModel().setValue("std_project_comrule", null, rowIndex);
            return;
        }
        if (costcompany != null) {
            QFilter bdProjectFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_project", (Long)costcompanyId);
            QFilter[] bdProjectAndQFilter = new QFilter[]{bdProjectFilter, QFilter.of((String)"id=?", (Object[])new Object[]{bdProjectId})};
            boolean bdProjectExists = QueryServiceHelper.exists((String)"bd_project", (QFilter[])bdProjectAndQFilter);
            if (!bdProjectExists) {
                this.getModel().setValue("std_project_comrule", null, rowIndex);
            }
        }
    }

    private void setMustInput(boolean result, String ... controlIds) {
        if (!ErEntityTypeUtils.isTripReimburseBill((String)this.getView().getEntityId())) {
            FieldEdit[] controls;
            for (FieldEdit control : controls = (FieldEdit[])Arrays.stream(controlIds).map(arg_0 -> ((ExpenseShareRulePlugin)this).getControl(arg_0)).toArray(FieldEdit[]::new)) {
                if (control == null) continue;
                control.setMustInput(result);
            }
        }
    }
}

