/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.stakeholderchange.plugin;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.UserEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.CreditLevelServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.common.model.UserCurrentDeptInfo;
import kd.fi.er.formplugin.stakeholderchange.util.ErStakeHolderChangeBillUtil;
import kd.fi.er.model.FormModel;
import org.apache.commons.lang.StringUtils;

public class ErStakeHoldersChangeBillPlugin
extends AbstractBillPlugIn
implements RowClickEventListener {
    private Log logger = LogFactory.getLog(ErStakeHoldersChangeBillPlugin.class);
    protected IPageCache pageCache;

    public void initialize() {
        super.initialize();
        this.pageCache = this.getPageCache();
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"changeapplier", "creditlevel", "stakeholderafter", "changetype"});
        EntryGrid accountentry = (EntryGrid)this.getControl("changeentryentity");
        accountentry.addRowClickListener((RowClickEventListener)this);
        this.addItemClickListeners(new String[]{"changetoolbar"});
        this.initF7();
    }

    public void initF7() {
        UserEdit applierF7 = (UserEdit)this.getControl("applierafter");
        applierF7.setIsIncludeAllSub(Boolean.valueOf(true));
        applierF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject dept = this.getModel().getDataEntity(true).getDynamicObject("org");
            Long deptId = dept != null ? (Long)dept.getPkValue() : Long.valueOf(0L);
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("changeentryentity");
            DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getModel().getDataEntity(true).get("changeentryentity");
            Object billtype = ((DynamicObject)dynamicObjects.get(entryCurrentRowIndex)).get("oribilltype");
            QFilter qFilterApplierF7 = CoreBaseBillServiceHelper.getApplierSelectFilterByCurOrgId((Long)deptId, (String)(billtype == null ? "" : billtype.toString()));
            listShowParameter.getListFilterParameter().getQFilters().add(qFilterApplierF7);
            List nests = qFilterApplierF7.getNests(true);
            if (nests.size() != 0) {
                QFilter idFilter = null;
                for (QFilter.QFilterNest nest : nests) {
                    if (!Arrays.toString(nest.getFilter().getProperties()).contains("id")) continue;
                    idFilter = nest.getFilter();
                }
                if (idFilter != null) {
                    Set applierIds = (Set)idFilter.getValue();
                    listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("entryentity.dpt", "in", (Object)BusinessDataServiceHelper.loadFromCache((String)"bos_user", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)applierIds)}).values().stream().flatMap(e -> e.getDynamicObjectCollection("entryentity").stream()).map(r -> ErCommonUtils.getPk((Object)r.get("dpt"))).distinct().toArray()));
                }
            }
            QFilter freezeFilter = new QFilter("entryentity.orgstructure.isfreeze", "=", (Object)false);
            listShowParameter.getListFilterParameter().setFilter(freezeFilter);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "applierafter"));
            listShowParameter.setCustomParam("ismergerows", (Object)false);
            listShowParameter.setMultiSelect(false);
        });
    }

    public void afterCreateNewData(EventObject e) {
        this.initInfo();
    }

    private void initInfo() {
        IDataModel model = this.getView().getModel();
        Long currentUserID = 0L;
        RequestContext requestContext = RequestContext.get();
        currentUserID = Long.valueOf(requestContext.getUserId());
        Map billMap = CoreBaseBillServiceHelper.createNewData((Long)currentUserID);
        Map custom = this.getView().getFormShowParameter().getCustomParams();
        Object parameterStr = custom.get("userInfo");
        if (parameterStr != null && StringUtils.isNotBlank((String)parameterStr.toString())) {
            UserCurrentDeptInfo userInfo = (UserCurrentDeptInfo)JSON.parseObject((String)parameterStr.toString(), UserCurrentDeptInfo.class);
            billMap = CoreBaseBillServiceHelper.createNewData((Long)userInfo.getUserId(), (Long)userInfo.getDeptId());
        }
        CoreBaseBillServiceHelper.initObjByMap((Object)model, (Map)billMap);
    }

    public void afterBindData(EventObject e) {
        this.initUserInfo();
        IDataModel model = this.getModel();
        this.setApplierVisible();
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("changeentryentity");
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return;
        }
        Map<Object, List<DynamicObject>> billTypeMap = dynamicObjects.stream().collect(Collectors.groupingBy(dynamicObject -> dynamicObject.get("oribilltype")));
        HashMap billNoAndBillIdMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap billEntryIdAndBillIdMap = Maps.newHashMapWithExpectedSize((int)16);
        billTypeMap.forEach((entityid, v) -> {
            Set billNos = v.stream().map(obj -> obj.get("oribillno")).collect(Collectors.toSet());
            DynamicObjectCollection data = QueryServiceHelper.query((String)entityid.toString(), (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("billno", "in", billNos)});
            billNoAndBillIdMap.putAll(data.stream().collect(Collectors.toMap(obj -> obj.getString("billno"), obj -> obj.getLong("id"))));
            List oriBillIds = data.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            billEntryIdAndBillIdMap.put(entityid.toString(), oriBillIds);
        });
        int size = dynamicObjects.size();
        Map<Long, DynamicObjectCollection> resultMap = ErStakeHolderChangeBillUtil.dealProjectOwner(billEntryIdAndBillIdMap);
        for (int i = 0; i < size; ++i) {
            long billId;
            DynamicObject dynamicObject2 = (DynamicObject)dynamicObjects.get(i);
            String billNo = dynamicObject2.getString("oribillno");
            Long oribillid = (Long)billNoAndBillIdMap.get(billNo);
            DynamicObjectCollection dynamicObjectCollection = dynamicObject2.getDynamicObjectCollection("stakeholderafter");
            if (CollectionUtils.isNotEmpty((Collection)dynamicObjectCollection) || oribillid == null || !StringUtils.isNotEmpty((String)oribillid.toString()) || !resultMap.containsKey(billId = Long.parseLong(oribillid.toString()))) continue;
            DynamicObjectCollection datas = resultMap.get(billId);
            model.setValue("stakeholderafter", (Object)(datas.size() == 0 ? "" : datas), i);
        }
    }

    private void setApplierVisible() {
        IDataModel model = this.getModel();
        Object value = model.getValue("changetype");
        if (!Objects.isNull(value)) {
            String valueStr = (String)value;
            if ("1".equals(valueStr)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"applierbefore"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"applierafter"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"applierbefore"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"applierafter"});
            }
        }
    }

    private void initUserInfo() {
        IDataModel model = this.getModel();
        String applierStr = null;
        String deptStr = null;
        String applierPicUrl = null;
        String positionStr = null;
        DynamicObject applier = (DynamicObject)model.getValue("applier");
        DynamicObject dept = (DynamicObject)model.getValue("org");
        positionStr = model.getValue("applierpositionstr").toString();
        String telStr = (String)model.getValue("tel");
        if (applier != null) {
            applierStr = applier.getLocaleString("name").getLocaleValue();
            applierPicUrl = ErCommonUtils.getUserImageFullPath((Long)((Long)applier.getPkValue()));
        }
        if (dept != null) {
            deptStr = dept.getLocaleString("name").getLocaleValue();
        }
        ((Label)this.getControl("applierv")).setText(applierStr);
        ((Label)this.getControl("orgv")).setText(deptStr);
        telStr = this.pageCache.get("newtel") != null ? this.pageCache.get("newtel") : telStr;
        model.setValue("tel", (Object)telStr);
        ((Label)this.getControl("telv")).setText(telStr);
        ((Label)this.getControl("applierpositionv")).setText(positionStr);
        Image applierPic = (Image)this.getControl("applierpic");
        applierPic.setUrl(applierPicUrl);
        if (applier != null) {
            String appilerIdStr = String.valueOf(applier.getPkValue());
            String creditlevelStr = CreditLevelServiceHelper.getCreditLevelByUserAndView((Object)appilerIdStr, (IFormView)this.getView());
            if (StringUtils.isEmpty((String)creditlevelStr)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"creditlevel"});
            } else {
                ((Label)this.getControl("creditlevel")).setText(creditlevelStr);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null) {
            return;
        }
        int rowIndex = changeSet[0].getRowIndex();
        IDataModel model = this.getModel();
        Object propValue = changeSet[0].getNewValue();
        switch (propName) {
            case "oribilltype": {
                DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)model.getDataEntity(true).get("changeentryentity");
                if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
                    return;
                }
                Object clearEntry = model.getValue("isclearentry");
                if (!Objects.isNull(clearEntry) && !StringUtils.equals((String)"", (String)clearEntry.toString()) && !"true".equals(clearEntry.toString())) break;
                EntryGrid entry = (EntryGrid)this.getControl("changeentryentity");
                List s = entry.getFieldEdits();
                for (FieldEdit fieldEdit : s) {
                    String field = fieldEdit.getKey();
                    if (propName.equals(field)) continue;
                    model.setValue(field, null, rowIndex);
                }
                break;
            }
            case "applier": 
            case "applierpositionstr": 
            case "tel": 
            case "org": {
                ErStakeHolderChangeBillUtil.refreshBaseInfoLabel(propValue, (Label)this.getControl(propName + "V"));
                break;
            }
            case "company": {
                break;
            }
            case "changetype": {
                this.setApplierVisible();
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "changeapplier": {
                HashMap<String, String> customParam = new HashMap<String, String>();
                customParam.put("showProps", "applierprops");
                FormModel formModel = new FormModel("er_changeapplier", ResManager.loadKDString((String)"\u4e2a\u4eba\u4fe1\u606f", (String)"CoreBaseBillEdit_3", (String)"fi-er-formplugin", (Object[])new Object[0]), "1", true, customParam);
                formModel.setShowType(ShowType.Modal);
                ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
                break;
            }
            case "creditlevel": {
                DynamicObject applier = (DynamicObject)this.getModel().getValue("applier");
                CreditLevelServiceHelper.showCreditFilesForm((IFormView)this.getView(), (String)String.valueOf(applier.getPkValue()));
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid source;
        EntryGrid entryGrid = source = evt.getSource() instanceof EntryGrid ? (EntryGrid)evt.getSource() : null;
        assert (source != null);
        String key = source.getEntryKey();
        int row = evt.getRow();
        if (row < 0) {
            return;
        }
        block3 : switch (key) {
            case "changeentryentity": {
                String focusField;
                switch (focusField = source.getEntryState().getFocusField()) {
                    case "oribillno": {
                        Object billStatus = this.getModel().getValue("billstatus");
                        if (Objects.isNull(billStatus)) {
                            return;
                        }
                        String billStatusStr = (String)billStatus;
                        if (!"A".equals(billStatusStr)) {
                            Object billtype = this.getModel().getValue("oribilltype");
                            Object billno = this.getModel().getValue("oribillno");
                            if (billtype == null || billno == null) {
                                return;
                            }
                            QFilter[] filters = new QFilter[]{new QFilter("billno", "=", (Object)billno.toString())};
                            DynamicObject dailyloanbill = QueryServiceHelper.queryOne((String)billtype.toString(), (String)"id", (QFilter[])filters);
                            if (dailyloanbill != null) {
                                Object pkValue = dailyloanbill.get("id");
                                ShowPageUtils.openLinkedForm((Object)pkValue, (String)billtype.toString(), (IFormView)this.getView());
                                break block3;
                            }
                        } else {
                            if (!this.judgeRelateFieldIsNotNull("oribilltype")) {
                                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d\u3002", (String)"ErStakeHoldersChangeBillPlugin_02", (String)"fi-er-formplugin", (Object[])new Object[0]), this.getLocaleName("oribilltype")));
                                return;
                            }
                            this.getModel().setValue("isclearentry", (Object)"false");
                            this.listOriBillDataByBillType("oribilltype", row);
                        }
                    }
                }
            }
        }
    }

    private void listOriBillDataByBillType(String formId, int rowIndex) {
        if (rowIndex < 0) {
            return;
        }
        IDataModel model = this.getModel();
        String entryId = model.getValue(formId).toString();
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)model.getDataEntity(true).get("changeentryentity");
        DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(rowIndex);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("er_stakeholderbillrelated");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ""));
        formShowParameter.setCustomParam("entryId", (Object)entryId);
        formShowParameter.setCustomParam("currentUserId", (Object)ErCommonUtils.getPk((Object)model.getValue("applier")));
        formShowParameter.setCustomParam("currentRowIndex", (Object)rowIndex);
        if (dynamicObject.get("oribillno") != null && !StringUtils.equals((String)"", (String)dynamicObject.get("oribillno").toString())) {
            formShowParameter.setCustomParam("update", (Object)1);
        } else {
            formShowParameter.setCustomParam("update", (Object)0);
        }
        List billNos = dynamicObjects.stream().filter(obj -> obj.get("oribillno") != null).map(obj -> obj.get("oribillno")).collect(Collectors.toList());
        formShowParameter.setCustomParam("billNos", billNos);
        this.getView().showForm(formShowParameter);
    }

    private String getLocaleName(String relateField) {
        IDataEntityProperty property = this.getModel().getProperty(relateField);
        String displayNameStr = "";
        try {
            LocaleString displayName = (LocaleString)property.getClass().getMethod("getDisplayName", new Class[0]).invoke((Object)property, new Object[0]);
            displayNameStr = displayName.getLocaleValue();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u6807\u7b7e\u540d\u79f0\u5931\u8d25:" + e.getMessage());
        }
        return displayNameStr;
    }

    private boolean judgeRelateFieldIsNotNull(String relateField) {
        IDataModel model = this.getModel();
        Object value = model.getValue(relateField);
        return !Objects.isNull(value) && !StringUtils.equals((String)"", (String)value.toString());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        this.getModel().setValue("isclearentry", (Object)"true");
        String actionId = closedCallBackEvent.getActionId();
        IDataModel model = this.getView().getModel();
        if ("er_changeapplier".equals(actionId)) {
            if (closedCallBackEvent.getReturnData() != null) {
                Map map = (Map)closedCallBackEvent.getReturnData();
                long deptId = Long.parseLong(map.get("deptId").toString());
                String userId = map.get("consignorId").toString();
                String newtel = map.get("newtel").toString();
                DynamicObject applier = (DynamicObject)model.getValue("applier");
                String applierId = applier.getPkValue().toString();
                IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
                if (!applierId.equals(userId)) {
                    model.setValue("applier", (Object)Long.valueOf(userId));
                    String applierPicUrl = ErCommonUtils.getUserImageFullPath((Long)Long.valueOf(userId));
                    Image applierPic = (Image)this.getControl("applierpic");
                    applierPic.setUrl(applierPicUrl);
                    model.setValue("tel", (Object)newtel);
                    ((Label)this.getView().getControl("telv")).setText(newtel);
                    pageCache.put("consignorId", userId);
                    applier = (DynamicObject)model.getValue("applier");
                    DynamicObjectCollection dynamicObjectCollection = model.getDataEntity(true).getDynamicObjectCollection("changeentryentity");
                    if (CollectionUtils.isNotEmpty((Collection)dynamicObjectCollection)) {
                        model.deleteEntryData("changeentryentity");
                    }
                }
                model.setValue("applierpositionstr", (Object)((String)map.get("newPositionStr")));
                ((Label)this.getView().getControl("applierpositionv")).setText((String)map.get("newPositionStr"));
                model.setValue("company", map.get("newCompanyId"));
                model.setValue("org", (Object)deptId);
                model.setValue("costdept", (Object)deptId);
                pageCache.put("newtel", newtel);
                String creditlevelStr = CreditLevelServiceHelper.getCreditLevelByUserAndView((Object)userId, (IFormView)this.getView());
                if (StringUtils.isEmpty((String)creditlevelStr)) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"creditlevel"});
                } else {
                    ((Label)this.getControl("creditlevel")).setText(creditlevelStr);
                }
            }
        } else if ("applierafter".equals(actionId)) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (null == returnData) {
                return;
            }
            if (returnData.size() < 1) {
                return;
            }
            ListSelectedRow listSelectedRow = returnData.get(0);
            Long userId = (Long)listSelectedRow.getPrimaryKeyValue();
            DynamicObject user = CommonServiceHelper.getUser((Long)userId);
            Long entryPkValue = (Long)listSelectedRow.getEntryPrimaryKeyValue();
            DynamicObjectCollection deptEntrys = user.getDynamicObjectCollection("entryentity");
            DynamicObject deptEntry = null;
            deptEntry = entryPkValue == null ? (DynamicObject)deptEntrys.stream().filter(deptE -> !deptE.getBoolean("ispartjob")).findAny().orElse(null) : (DynamicObject)deptEntrys.stream().filter(deptE -> Objects.equals(entryPkValue, deptE.getPkValue())).findAny().orElse(null);
            if (deptEntry != null) {
                Long dpt = ErCommonUtils.getPk((Object)deptEntry.getDynamicObject("dpt"));
                Long costCompany = CoreBaseBillServiceHelper.getAccountOrgId((boolean)true, (Long)dpt);
                Long companyId = CoreBaseBillServiceHelper.initCompanyByDept((Long)dpt);
                DynamicObject currency = BaseCurrencyServiceHelper.getBaseCurrencyObject((Object)companyId, (Object)costCompany);
                if (currency == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u672c\u4f4d\u5e01\u3002", (String)"ChangeApplier_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                }
                model.setValue("applierafter", (Object)userId, model.getEntryCurrentRowIndex("changeentryentity"));
                model.setValue("srcdeptid", (Object)dpt);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        this.logger.info("\u83b7\u53d6\u53d8\u66f4\u6570\u636e\u5165\u53e3");
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((String)"get_changebilldata", (String)itemKey)) {
            ArrayList needDataEntryId = Lists.newArrayListWithCapacity((int)3);
            needDataEntryId.add("er_dailyloanbill");
            needDataEntryId.add("er_tripreqbill");
            needDataEntryId.add("er_prepaybill");
            DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getModel().getDataEntity(true).get("changeentryentity");
            this.delEntryByNeedDataEntryId(needDataEntryId, dynamicObjects);
            this.getNeedData(needDataEntryId);
        }
    }

    private void delEntryByNeedDataEntryId(List<String> needDataEntryId, DynamicObjectCollection dynamicObjects) {
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return;
        }
        List delEntryData = dynamicObjects.stream().filter(obj -> obj.get("oribilltype") != null && needDataEntryId.contains(obj.get("oribilltype").toString())).collect(Collectors.toList());
        ArrayList delIndex = Lists.newArrayListWithCapacity((int)delEntryData.size());
        if (CollectionUtils.isEmpty(delEntryData)) {
            return;
        }
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
            if (!delEntryData.contains(dynamicObject)) continue;
            delIndex.add(i);
        }
        int[] tem = new int[delIndex.size()];
        for (int i = 0; i < delIndex.size(); ++i) {
            tem[i] = (Integer)delIndex.get(i);
        }
        this.getModel().deleteEntryRows("changeentryentity", tem);
    }

    private void getNeedData(List<String> needDataEntryId) {
        int i;
        IDataModel model = this.getModel();
        Long applierId = ErCommonUtils.getPk((Object)model.getValue("applier"));
        String billStatus = "G";
        QFilter qFilter = new QFilter("creator", "=", (Object)applierId).or(new QFilter("applier", "=", (Object)applierId)).and(new QFilter("billstatus", "=", (Object)billStatus)).and(new QFilter("balanceamount", ">", (Object)0));
        DynamicObjectCollection totalData = new DynamicObjectCollection();
        HashMap<String, DynamicObjectCollection> entryMap = new HashMap<String, DynamicObjectCollection>(16);
        HashMap<Long, DynamicObjectCollection> userMap = new HashMap<Long, DynamicObjectCollection>(16);
        HashMap billEntryIdAndBillIdMap = Maps.newHashMapWithExpectedSize((int)16);
        for (i = 0; i < needDataEntryId.size(); ++i) {
            DynamicObjectCollection data = QueryServiceHelper.query((String)needDataEntryId.get(i), (String)"id,billno,bizdate,description,projectower as projectname,applier", (QFilter[])new QFilter[]{qFilter});
            if (CollectionUtils.isEmpty((Collection)data)) continue;
            List oriBillIds = data.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            billEntryIdAndBillIdMap.put(needDataEntryId.get(i), oriBillIds);
            entryMap.put(needDataEntryId.get(i), data);
        }
        userMap.putAll(ErStakeHolderChangeBillUtil.dealProjectOwner(billEntryIdAndBillIdMap));
        for (i = 0; i < needDataEntryId.size(); ++i) {
            DynamicObjectCollection data;
            String entityId = needDataEntryId.get(i);
            if (!entryMap.containsKey(entityId) || CollectionUtils.isEmpty((Collection)(data = (DynamicObjectCollection)entryMap.get(entityId)))) continue;
            this.setData(data, model, userMap, entityId);
            totalData.addAll((Collection)data);
        }
        if (CollectionUtils.isEmpty((Collection)totalData)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e\u3002", (String)"ErStakeHoldersChangeBillPlugin", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
    }

    private void setData(DynamicObjectCollection totalData, IDataModel model, Map<Long, DynamicObjectCollection> userMap, String s) {
        this.logger.info(totalData.size() + ",\u957f\u5ea6");
        for (int i = 0; i < totalData.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)totalData.get(i);
            int newRowIndex = model.createNewEntryRow("changeentryentity");
            model.setValue("isclearentry", (Object)"false");
            ErStakeHolderChangeBillUtil.setDataByIndex(model, newRowIndex, dynamicObject, s);
            model.setValue("oribillid", (Object)dynamicObject.getLong("id"));
            try {
                DynamicObjectCollection dynamicObjects;
                model.setValue("stakeholderbefore", (Object)"", newRowIndex);
                if (dynamicObject.get("id") == null || !StringUtils.isNotEmpty((String)dynamicObject.getString("id")) || (dynamicObjects = userMap.get(dynamicObject.getLong("id"))) == null) continue;
                dynamicObject.set("projectname", (Object)ErStakeHolderChangeBillUtil.dealUserName(dynamicObjects));
                model.setValue("stakeholderbefore", dynamicObject.get("projectname"), newRowIndex);
                model.setValue("stakeholderafter", (Object)(dynamicObjects.size() == 0 ? "" : dynamicObjects), newRowIndex);
                continue;
            }
            catch (Exception e) {
                this.logger.error("\u95ee\u9898\u5b9a\u4f4d:" + i + "\u5bf9\u8c61:" + dynamicObject + "\u7528\u6237map:" + userMap + "\u4f7f\u7528\u5b57\u6bb5:" + dynamicObject.get("id"));
            }
        }
    }

    public void afterLoadData(EventObject e) {
        CoreBaseBillServiceHelper.setFromStatus((AbstractFormPlugin)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        String objectId = eventArgs.getOperateKey();
        IFormView view = this.getView();
        switch (objectId) {
            case "unsubmit": {
                if (!eventArgs.getOperationResult().isSuccess()) break;
                ((IBillView)view).setBillStatus(BillOperationStatus.EDIT);
                break;
            }
            case "invalidbtn": {
                if (!eventArgs.getOperationResult().isSuccess()) break;
                ((IBillView)view).setBillStatus(BillOperationStatus.AUDIT);
            }
        }
    }
}

