/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.base;

import com.google.common.collect.Maps;
import java.util.Base64;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class ErPrivateKeyPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(ErPrivateKeyPlugin.class);
    private static final String BTN_OK = "btnok";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void beforeClick(BeforeClickEvent evt) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Object privateKey = model.getValue("privatekey_tag");
        if (Objects.isNull(privateKey) || StringUtils.isEmpty((CharSequence)privateKey.toString())) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u79d8\u94a5\uff01", (String)"ErPrivateKeyPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        try {
            Control control = (Control)evt.getSource();
            String key = control.getKey();
            if (BTN_OK.equals(key)) {
                String privateKeyStr = this.getModel().getValue("privatekey_tag").toString();
                String s = Base64.getEncoder().encodeToString(privateKeyStr.getBytes());
                HashMap returnMap = Maps.newHashMapWithExpectedSize((int)2);
                returnMap.put("privateKey", s);
                this.getView().returnDataToParent((Object)returnMap);
                this.getView().close();
            }
        }
        catch (Exception e) {
            logger.error("Line 55", (Throwable)e);
        }
    }
}

