/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.checking;

import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.ShowPageUtils;
import org.apache.commons.lang3.StringUtils;

public class CheckingBillEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    private static final String CONFIRM_BTN = "bar_confirm";
    private static final String DEL_BTN = "bar_del";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{CONFIRM_BTN, DEL_BTN});
        AbstractGrid invoiceEntry = (AbstractGrid)this.getControl("invoiceentry");
        if (invoiceEntry != null) {
            invoiceEntry.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        String billnum = this.getView().getModel().getDataEntity(true).getString("billnum");
        if (StringUtils.equals((CharSequence)key, (CharSequence)CONFIRM_BTN)) {
            QFilter qFilter = new QFilter("billnum", "like", (Object)(billnum.substring(0, billnum.indexOf("-")) + "%"));
            DynamicObjectCollection allSelectedListDate = QueryServiceHelper.query((String)"er_checkingbill", (String)"billnum", (QFilter[])new QFilter[]{qFilter});
            if (null == allSelectedListDate || allSelectedListDate.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u8d26\u5355\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"CheckingBillEdit_01", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            StringBuilder billNums = new StringBuilder();
            for (DynamicObject dynamicObject : allSelectedListDate) {
                billNums.append(dynamicObject.get("billnum"));
                billNums.append(" \n");
            }
            String title2 = ResManager.loadKDString((String)"\u5373\u5c06\u786e\u8ba4\u4ee5\u4e0b\u8d26\u5355\uff1a  \n", (String)"CheckingBillEdit_2", (String)"fi-er-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(title2, billNums.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("ok"));
            return;
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)DEL_BTN)) {
            QFilter qFilter = new QFilter("billnum", "=", (Object)billnum);
            DynamicObject idSelectedDate = QueryServiceHelper.queryOne((String)"er_checkingbill", (String)"billnum,formid", (QFilter[])new QFilter[]{qFilter});
            if (null == idSelectedDate) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u8d26\u5355\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"CheckingBillEdit_01", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            String formid = idSelectedDate.getString("formid");
            DynamicObjectCollection listDate = QueryServiceHelper.query((String)formid, (String)"id", (QFilter[])new QFilter[]{qFilter = new QFilter("checkingbillnum", "=", (Object)billnum)});
            if (null != listDate && !listDate.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6708\u7ed3\u8d26\u5355\u5b58\u5728\u7ed3\u7b97\u660e\u7ec6\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"CheckingBillEdit_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (StringUtils.equals((CharSequence)"ok", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            this.getView().invokeOperation("confirmchecking", operateOption);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("er_getcheckingbill".equals(actionId)) {
            Map returnData = (Map)event.getReturnData();
            if (returnData == null || returnData.size() == 0) {
                return;
            }
            Boolean isSuccess = (Boolean)returnData.get("isSuccess");
            if (isSuccess.booleanValue()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u8d26\u5355\u6210\u529f", (String)"CheckingBillEdit_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
            } else {
                String detail = (String)returnData.get("detail");
                this.getView().showErrorNotification(detail);
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if (!StringUtils.equalsAny((CharSequence)fieldName, (CharSequence[])new CharSequence[]{"invoiceno", "checkingbillno"})) {
            return;
        }
        IDataModel model = this.getModel();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        IFormView view = this.getView();
        switch (fieldName) {
            case "invoiceno": {
                Object downLoadUrl = model.getValue("innerdownloadurl", rowIndex);
                if (downLoadUrl == null) break;
                String innerDownLoadUrl = downLoadUrl.toString();
                if (StringUtils.isNotEmpty((CharSequence)innerDownLoadUrl)) {
                    view.openUrl(innerDownLoadUrl);
                    break;
                }
                view.showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u53d1\u7968\u5730\u5740\u3002", (String)"CheckingBillEdit_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
                break;
            }
            case "checkingbillno": {
                Object formid = model.getValue("formid");
                Object checkingbillno = model.getValue("checkingbillno", rowIndex);
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)formid.toString(), (String)"id", (QFilter[])new QFilter[]{new QFilter("ordernum", "=", checkingbillno)});
                if (dynamicObject == null) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5e94\u7684\u7ed3\u7b97\u5355\u3002", (String)"CheckingBillEdit_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    break;
                }
                ShowPageUtils.openLinkedForm((Object)ErCommonUtils.getPk((Object)dynamicObject), (String)formid.toString(), (IFormView)view);
            }
        }
    }
}

