/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.checking;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.trip.service.factory.TripServiceFactory;
import kd.fi.er.business.trip.service.iservice.ITripService;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;

public class ErSettlementBillCommonPlugin
extends AbstractBillPlugIn
implements ClickListener,
RowClickEventListener {
    private static final Log logger = LogFactory.getLog(ErSettlementBillCommonPlugin.class);
    private static final String QUERY_IMAGE = "queryimage";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{QUERY_IMAGE});
    }

    public void afterLoadData(EventObject e) {
        this.loadSettleInfo();
        this.setChoiceBoxValue();
        if (this.getModel().getDataEntity(true).containsProperty("vehicletype")) {
            ComboEdit comboEdit = (ComboEdit)this.getControl("vehicletype");
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
            QFilter qA = new QFilter("enable", "=", (Object)"1");
            DynamicObjectCollection dynamices = QueryServiceHelper.query((String)"er_trip_vehicle_setting", (String)"number,name,vehicletype", (QFilter[])new QFilter[]{qA});
            if (null != dynamices && !dynamices.isEmpty()) {
                for (DynamicObject dynamice : dynamices) {
                    ComboItem comboItem = new ComboItem();
                    comboItem.setCaption(new LocaleString(dynamice.getString("name")));
                    comboItem.setValue(dynamice.getString("number"));
                    comboItems.add(comboItem);
                }
                List comboItems1 = ((ComboProp)comboEdit.getProperty()).getComboItems();
                for (ValueMapItem valueMapItem : comboItems1) {
                    ComboItem comboItem = new ComboItem();
                    comboItem.setCaption(valueMapItem.getName());
                    comboItem.setValue(valueMapItem.getValue());
                    comboItems.add(comboItem);
                }
                comboEdit.setComboItems(comboItems);
            }
        }
        this.getModel().setDataChanged(false);
    }

    private void setChoiceBoxValue() {
        IDataModel dataModel = this.getModel();
        DynamicObject allOrderBase = (DynamicObject)dataModel.getValue("allorderbase");
        if (allOrderBase != null) {
            dataModel.setValue("orderisinvoicerep", allOrderBase.get("needbilling"));
            dataModel.setValue("orderisrembureq", allOrderBase.get("isreimburse"));
            dataModel.setValue("bookeddatereq", allOrderBase.get("bookeddate"));
            dataModel.setValue("orderisapproverep", allOrderBase.get("isapprove"));
            dataModel.setValue("reimbursenum", allOrderBase.get("reimbursenum"));
            if (null != dataModel.getProperty("isconfirm")) {
                dataModel.setValue("isconfirm", allOrderBase.get("isconfirm"));
            }
        }
    }

    private void loadSettleInfo() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("er_seinvoice_entryinfo");
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.InContainer);
        openStyle.setTargetKey("flex_invoice");
        formShowParameter.setCustomParam("settleid", this.getModel().getDataEntity().getPkValue());
        this.getView().showForm(formShowParameter);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.click((EventObject)evt);
        switch (key = evt.getItemKey()) {
            case "queryimage": {
                if (!Supplier.CHAILVYIHAO.name().equals(this.getModel().getValue("server"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u529f\u80fd\u6682\u65f6\u53ea\u652f\u6301\u5dee\u65c5\u58f9\u53f7\u3002", (String)"ErSettlementBillCommonPlugin_01", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                String ordernum = this.getModel().getDataEntity(true).getString("ordernum");
                ITripService tTripServiceImage = TripServiceFactory.getTripService((String)"TTripService");
                HashMap params = new HashMap();
                ArrayList<String> orderIds = new ArrayList<String>();
                orderIds.add(ordernum.split("-")[0]);
                params.put("orderIds", orderIds);
                try {
                    tTripServiceImage.synImageFromTrip(params);
                }
                catch (Exception e) {
                    logger.info("\u884c\u7a0b\u5355\u5f71\u50cf\u83b7\u53d6\u5931\u8d25\uff1a{}", (Object)e);
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u884c\u7a0b\u5355\u5f71\u50cf\u5931\u8d25\uff0c%s", (String)"ErSettlementBillCommonPlugin_02", (String)"fi-er-formplugin", (Object[])new Object[0]), e.getMessage()));
                    return;
                }
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u884c\u7a0b\u5355\u5f71\u50cf\u83b7\u53d6\u6210\u529f\u3002", (String)"ErSettlementBillCommonPlugin_03", (String)"fi-er-formplugin", (Object[])new Object[0]), new Object[0]));
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        int paramValue = TripSyncConfigUtil.getIntValue((String)"Ctrip_Billing_method", (int)1);
        if (paramValue == 1 || paramValue == 2) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"subbatchno"});
        }
    }
}

