/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.fieldmapping;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.metadata.entity.rule.IBizRuleEditor;
import kd.bos.metadata.treebuilder.EntityFieldTreeBuildOption;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.util.CollectionUtils;

public class FormulaEdit
extends AbstractFormPlugin
implements TreeNodeClickListener,
IBizRuleEditor,
SearchEnterListener {
    static final Map<String, String> operationCharacter = new HashMap<String, String>(){
        private static final long serialVersionUID = 2684322634410225042L;
        {
            this.put("plus", "+");
            this.put("subtract", "-");
            this.put("multiple", "*");
            this.put("divide", "/");
            this.put("equal", "=");
            this.put("less", "<");
            this.put("greater", ">");
            this.put("lessequal", "<=");
            this.put("greaterequal", ">=");
            this.put("squarebrackets", "<>");
            this.put("leftparentheses", "(");
            this.put("rightparentheses", ")");
            this.put("and", "AND");
            this.put("or", "OR");
            this.put("if", "IF(,,)");
            this.put("clr", "CLR");
            this.put("backspace", "Backspace");
        }
    };

    public void initialize() {
        Button btn = null;
        for (Map.Entry<String, String> entry : operationCharacter.entrySet()) {
            String key = entry.getKey().toLowerCase();
            btn = (Button)this.getControl(key);
            btn.addClickListener((ClickListener)this);
        }
        btn = (Button)this.getControl("btnok");
        btn.addClickListener((ClickListener)this);
        btn = (Button)this.getControl("btncancel");
        btn.addClickListener((ClickListener)this);
        TreeView tree = (TreeView)this.getView().getControl("tv_fields");
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getView().getControl("searchfield");
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        TreeNode root = null;
        String treeNode = (String)this.getView().getFormShowParameter().getCustomParam("treenodes");
        String entitynumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        TreeView tree = (TreeView)this.getView().getControl("tv_fields");
        if (null != treeNode) {
            root = (TreeNode)SerializationUtils.fromJsonString((String)treeNode, TreeNode.class);
        }
        if (null != entitynumber && !entitynumber.isEmpty()) {
            if (this.getView().getFormShowParameter().getCustomParam("entitynumber") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a,\u8bf7\u91cd\u8bd5", (String)"FormulaEdit_3", (String)"bos-designer-plugin", (Object[])new Object[0]));
                return;
            }
            EntityFieldTreeBuildOption option = new EntityFieldTreeBuildOption();
            option.setIncludePKField(true);
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)entitynumber);
            root = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)type, (PropTreeBuildOption)option);
        }
        if (root != null) {
            root.setIsOpened(true);
            tree.addNode(root);
        }
        String formula = (String)this.getView().getFormShowParameter().getCustomParam("formula");
        this.getModel().setValue("formulatxt", (Object)formula);
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        String key = btn.getKey();
        if ("btnok".equalsIgnoreCase(key)) {
            this.closeAndReturn();
        } else if ("btncancel".equalsIgnoreCase(key)) {
            this.getView().close();
        } else if (key != null) {
            this.operation(key);
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
    }

    public void treeNodeClick(TreeNodeEvent e) {
        if (e.getNodeId() != null && !"".equals(e.getNodeId().toString().trim())) {
            String character = e.getNodeId().toString();
            FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)"tv_fields", (String)"formulatxt", (String)character);
        }
    }

    public boolean checkConfig() {
        Object formula = this.getModel().getValue("formulatxt");
        if (kd.bos.util.StringUtils.isEmpty((String)((String)formula))) {
            String expression = ((String)formula).trim();
            try {
                FormulaEngine.parseFormula((String)expression);
            }
            catch (Exception var4) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bef:%s", (String)"FormulaEdit_4", (String)"bos-designer-plugin", (Object[])new Object[0]), var4.getMessage()));
                return false;
            }
        }
        return true;
    }

    public String getOutConfig() {
        String formula = (String)this.getModel().getValue("formulatxt");
        return formula;
    }

    public void operation(String xx) {
        String character = operationCharacter.get(xx);
        if (character.equalsIgnoreCase("clr")) {
            this.getModel().setValue("formulatxt", (Object)"");
            FormulaEditHelper.setCursorIndex((IFormView)this.getView(), (String)"formulatxt", (int)0);
        } else if ("backspace".equalsIgnoreCase(character)) {
            FormulaEditHelper.backSpaceExpression((IFormView)this.getView(), (String)xx, (String)"formulatxt");
        } else {
            FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)xx, (String)"formulatxt", (String)character);
        }
    }

    private void closeAndReturn() {
        Object formula = this.getModel().getValue("formulatxt");
        if (!kd.bos.util.StringUtils.isEmpty((String)((String)formula))) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            Object treeNode = showParameter.getCustomParam("treeNode");
            String expression = ((String)formula).trim();
            if (treeNode == null) {
                try {
                    FormulaEngine.parseFormula((String)expression);
                }
                catch (Exception var7) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bef:%s", (String)"FormulaEdit_4", (String)"bos-designer-plugin", (Object[])new Object[0]), var7.getMessage()));
                    return;
                }
            }
            HashMap<String, String> para = new HashMap<String, String>();
            para.put("expression", expression);
            this.getView().returnDataToParent(para);
            this.getView().close();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (String)"FormulaEdit_5", (String)"bos-designer-plugin", (Object[])new Object[0]));
        }
    }

    public void search(SearchEnterEvent evt) {
        Search search = (Search)evt.getSource();
        if (StringUtils.equals((CharSequence)"searchfield", (CharSequence)search.getKey())) {
            String searchText = evt.getText();
            this.doSearch(searchText);
        }
    }

    private void doSearch(String searchText) {
        String entitynumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        String json = (String)this.getView().getFormShowParameter().getCustomParam("treenodes");
        TreeNode rootNode = new TreeNode();
        if (StringUtils.isNotBlank((CharSequence)json)) {
            rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
        } else if (StringUtils.isNotBlank((CharSequence)entitynumber)) {
            PropTreeBuildOption option = new PropTreeBuildOption();
            option.setIncludePKField(true);
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)entitynumber);
            rootNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)type, (PropTreeBuildOption)option);
        }
        TreeView tree = (TreeView)this.getView().getControl("tv_fields");
        if (StringUtils.isNotBlank((CharSequence)searchText) && CollectionUtils.isNotEmpty((Collection)rootNode.getChildren())) {
            rootNode.setChildren(this.getContains(rootNode.getChildren(), searchText));
        }
        rootNode.setIsOpened(true);
        tree.updateNode(rootNode);
    }

    private List<TreeNode> getContains(List<TreeNode> childrens, String searchText) {
        Iterator<TreeNode> iterator = childrens.iterator();
        while (iterator.hasNext()) {
            TreeNode treeNode = iterator.next();
            treeNode.setIsOpened(true);
            if (CollectionUtils.isNotEmpty((Collection)treeNode.getChildren())) {
                treeNode.setChildren(this.getContains(treeNode.getChildren(), searchText));
            }
            if (!CollectionUtils.isEmpty((Collection)treeNode.getChildren()) || treeNode.getText().contains(searchText)) continue;
            iterator.remove();
        }
        return childrens;
    }
}

