/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.order;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.message.ErMessageServiceHelper;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.ConvertUtil;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.trip.order.OrderBillList;
import kd.fi.er.formplugin.trip.util.BatchEditUtil;
import kd.fi.er.model.FormModel;
import org.apache.commons.lang.StringUtils;

public class OrderBillListForEM
extends OrderBillList {
    private static String existfeedback = "existfeedback";
    private static String returnList = "returnList";
    private static final Log logger = LogFactory.getLog(OrderBillListForEM.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"pushmessage", "batchedit"});
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter mainOrgQFilter = e.getMainOrgQFilter();
        if (mainOrgQFilter != null) {
            Object mainOrgValue = mainOrgQFilter.getValue();
            String cp = mainOrgQFilter.getCP();
            mainOrgQFilter.or(new QFilter("company", cp, mainOrgValue)).or(new QFilter("expcommitcomnum", cp, mainOrgValue));
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
    }

    @Override
    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        args.getQFilters().add(new QFilter("orgpattern", "in", (Object)new Object[]{1, 2, 5}));
    }

    @Override
    public String getEntity(String entity) {
        return entity;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (!"updateticketstatus".equals(afterDoOperationEventArgs.getOperateKey()) || !afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        IListView listView = (IListView)this.getView();
        if (listView.getSelectedRows().size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"OrderBillListForEM_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        if (listView.getSelectedRows().size() > 1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"OrderBillListForEM_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRow selectedRow = listView.getSelectedRows().get(0);
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", selectedRow.getPrimaryKeyValue())};
        DynamicObject row = QueryServiceHelper.queryOne((String)listView.getListModel().getEntityId(), (String)"id, ticketstatus", (QFilter[])qFilters);
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("er_updata_planebill");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("billtype", listView.getListModel().getEntityId());
        map.put("billid", row.getLong("id"));
        map.put("ticketstatus", row.getString("ticketstatus"));
        fsp.setCustomParams(map);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fsp.getFormId()));
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData;
        super.closedCallBack(closedCallBackEvent);
        if ("er_updata_planebill".equals(closedCallBackEvent.getActionId())) {
            Object data = closedCallBackEvent.getReturnData();
            if (data instanceof Map && ((Map)data).get("result") != null && Boolean.parseBoolean(((Map)data).get("result").toString())) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f\u3002", (String)"OrderBillListForEM_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            }
        } else if ("er_batch_modify".equals(closedCallBackEvent.getActionId()) && (returnData = (Map)closedCallBackEvent.getReturnData()) != null) {
            IListView listView = (IListView)this.getView();
            ListSelectedRowCollection selectedRows = listView.getSelectedRows();
            this.modifyData(selectedRows, returnData);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f\u3002", (String)"OrderBillListForEM_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("pushmessage".equals(itemKey)) {
            IListView listView = (IListView)this.getView();
            int selectedSize = listView.getSelectedRows().size();
            if (selectedSize == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"OrderBillListForEM_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            List ids = Arrays.stream(listView.getSelectedRows().toArray()).map(e -> ((ListSelectedRow)e).getPrimaryKeyValue()).collect(Collectors.toList());
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", ids)};
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)listView.getListModel().getEntityId(), (String)"isconfirm,feedback", (QFilter[])qFilters);
            long confirmedSize = dynamicObjects.stream().filter(e -> e.getBoolean("isconfirm")).count();
            long feedbackSize = dynamicObjects.stream().filter(e -> StringUtils.isNotBlank((String)e.getString("feedback"))).count();
            if ((long)selectedSize == confirmedSize) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u9009\u62e9\u8ba2\u5355\u5747\u5df2\u786e\u8ba4\uff0c\u65e0\u9700\u518d\u6b21\u786e\u8ba4\u3002\u8bf7\u91cd\u65b0\u9009\u62e9\u672a\u786e\u8ba4\u8ba2\u5355\u8fdb\u884c\u63a8\u9001\u3002", (String)"OrderBillListForEM_01", (String)"fi-er-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            } else if (confirmedSize == 0L) {
                if (feedbackSize == (long)selectedSize) {
                    this.getView().getPageCache().put(returnList, "true");
                    this.getView().getPageCache().put(existfeedback, "true");
                    MessageBoxOptions messageBoxOptions = MessageBoxOptions.YesNo;
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u9009\u62e9\u8ba2\u5355\u5747\u5df2\u53cd\u9988\uff0c\u662f\u5426\u91cd\u65b0\u63a8\u9001\u786e\u8ba4\u6d88\u606f\u3002", (String)"OrderBillListForEM_02", (String)"fi-er-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9009\u62e9\u201c\u5426\u201d\u5c06\u8fd4\u56de\u5217\u8868\u754c\u9762\u3002\u9009\u62e9\u201c\u662f\u201d\u5c06\u91cd\u65b0\u5168\u90e8\u63a8\u9001\u3002", (String)"OrderBillListForEM_03", (String)"fi-er-formplugin", (Object[])new Object[0]), messageBoxOptions, null, new ConfirmCallBackListener("ok", (IFormPlugin)this));
                } else if (feedbackSize == 0L) {
                    this.getView().getPageCache().put(returnList, "true");
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u662f\u5426\u63a8\u9001\u901a\u77e5\uff1f", (String)"OrderBillListForEM_04", (String)"fi-er-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("ok", (IFormPlugin)this));
                } else {
                    this.getView().getPageCache().put(existfeedback, "true");
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u5df2\u53cd\u9988\u7684\u6570\u636e\u3002\u662f\u5426\u91cd\u65b0\u63a8\u9001\u6b64\u90e8\u5206\u6570\u636e\uff1f", (String)"OrderBillListForEM_05", (String)"fi-er-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5426\uff1a\u4ec5\u63a8\u9001\u672a\u53cd\u9988\u7684\u8ba2\u5355\uff1b\u662f\uff1a\u63a8\u9001\u5168\u90e8\u8ba2\u5355\u3002", (String)"OrderBillListForEM_06", (String)"fi-er-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, null, new ConfirmCallBackListener("ok", (IFormPlugin)this));
                }
            } else {
                long unConfirmedAndFeedbackSize;
                long unConfirmedSize = dynamicObjects.stream().filter(e -> !e.getBoolean("isconfirm")).count();
                if (unConfirmedSize == (unConfirmedAndFeedbackSize = dynamicObjects.stream().filter(e -> !e.getBoolean("isconfirm")).filter(e -> StringUtils.isNotBlank((String)e.getString("feedback"))).count())) {
                    this.getView().getPageCache().put(existfeedback, "true");
                    this.getView().getPageCache().put(returnList, "true");
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u9009\u62e9\u8ba2\u5355\u5747\u4e3a\u5df2\u786e\u8ba4/\u5df2\u53cd\u9988\u8ba2\u5355\u3002\u5df2\u786e\u8ba4\u8ba2\u5355\u65e0\u9700\u518d\u6b21\u786e\u8ba4\uff0c\u5df2\u53cd\u9988\u8ba2\u5355\u662f\u5426\u9700\u8981\u91cd\u65b0\u63a8\u9001\u786e\u8ba4\u6d88\u606f\u3002", (String)"OrderBillListForEM_07", (String)"fi-er-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9009\u62e9\u201c\u5426\u201d\u5c06\u8fd4\u56de\u5217\u8868\u754c\u9762\u3002\u9009\u62e9\u201c\u662f\u201d\u5c06\u91cd\u65b0\u63a8\u9001\u5df2\u53cd\u9988\u8ba2\u5355\u3002", (String)"OrderBillListForEM_08", (String)"fi-er-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, null, new ConfirmCallBackListener("ok", (IFormPlugin)this));
                } else if (unConfirmedAndFeedbackSize == 0L) {
                    this.getView().getPageCache().put(returnList, "true");
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u9009\u62e9\u8ba2\u5355\u5305\u542b\u5df2\u786e\u8ba4\u8ba2\u5355\u3002\u5df2\u786e\u8ba4\u8ba2\u5355\u65e0\u9700\u518d\u6b21\u786e\u8ba4\uff0c\u5269\u4f59\u8ba2\u5355\u662f\u5426\u786e\u8ba4\u63a8\u9001\u901a\u77e5\u3002", (String)"OrderBillListForEM_09", (String)"fi-er-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("ok", (IFormPlugin)this));
                } else {
                    this.getView().getPageCache().put(existfeedback, "true");
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u9009\u62e9\u8ba2\u5355\u5305\u542b\u5df2\u786e\u8ba4/\u5df2\u53cd\u9988\u8ba2\u5355\u3002\u5df2\u786e\u8ba4\u8ba2\u5355\u65e0\u9700\u518d\u6b21\u786e\u8ba4\uff0c\u5df2\u53cd\u9988\u8ba2\u5355\u662f\u5426\u9700\u8981\u91cd\u65b0\u63a8\u9001\u786e\u8ba4\u6d88\u606f\u3002", (String)"OrderBillListForEM_13", (String)"fi-er-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5426\uff1a\u4ec5\u63a8\u9001\u672a\u53cd\u9988\u7684\u8ba2\u5355\uff1b\u662f\uff1a\u63a8\u9001\u5168\u90e8\u8ba2\u5355\u3002", (String)"OrderBillListForEM_06", (String)"fi-er-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, null, new ConfirmCallBackListener("ok", (IFormPlugin)this));
                }
            }
        } else if ("batchedit".equals(itemKey)) {
            IListView listView = (IListView)this.getView();
            ListSelectedRowCollection selectedRows = listView.getSelectedRows();
            int selectedSize = selectedRows.size();
            if (selectedSize == 0) {
                return;
            }
            this.openBatchEditPage();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        List ids = Arrays.stream(((ListView)this.getView()).getSelectedRows().toArray()).map(e -> ((ListSelectedRow)e).getPrimaryKeyValue()).collect(Collectors.toList());
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId()));
        if (Boolean.parseBoolean(this.getView().getPageCache().get(returnList)) && (messageBoxClosedEvent.getResult() == MessageBoxResult.Cancel || messageBoxClosedEvent.getResult() == MessageBoxResult.No)) {
            return;
        }
        List<DynamicObject> total = Stream.of(dynamicObjects).collect(Collectors.toList());
        List confrimList = total.stream().filter(e -> e.getBoolean("isconfirm")).collect(Collectors.toList());
        List<Object> feedbackList = new ArrayList(1);
        if (Boolean.parseBoolean(this.getView().getPageCache().get(existfeedback)) && (messageBoxClosedEvent.getResult() == MessageBoxResult.No || messageBoxClosedEvent.getResult() == MessageBoxResult.Cancel)) {
            feedbackList = total.stream().filter(e -> StringUtils.isNotBlank((String)e.getString("feedback"))).collect(Collectors.toList());
            if (total.stream().allMatch(e -> e.getBoolean("isconfirm"))) {
                return;
            }
        }
        this.getView().getPageCache().remove(existfeedback);
        this.getView().getPageCache().remove(returnList);
        total.removeAll(confrimList);
        total.removeAll(feedbackList);
        HashSet set = new HashSet(confrimList);
        set.addAll(feedbackList);
        StringBuilder sb = new StringBuilder(ResManager.loadKDString((String)"\u6210\u529f\u63a8\u9001\u6d88\u606f", (String)"OrderBillListForEM_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
        sb.append(total.size()).append(ResManager.loadKDString((String)"\u6761\uff0c\u5931\u8d25", (String)"OrderBillListForEM_7", (String)"fi-er-formplugin", (Object[])new Object[0])).append(set.size()).append(ResManager.loadKDString((String)"\u6761\u3002", (String)"OrderBillListForEM_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
        if (feedbackList.size() + confrimList.size() > 0) {
            if (feedbackList.size() > 0) {
                sb.append(ResManager.loadKDString((String)"\u8ba2\u5355\uff1a", (String)"OrderBillListForEM_9", (String)"fi-er-formplugin", (Object[])new Object[0])).append(feedbackList.stream().map(e -> e.getString("ordernum")).collect(Collectors.toList())).append(ResManager.loadKDString((String)"\u5df2\u53cd\u9988", (String)"OrderBillListForEM_10", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if (confrimList.size() > 0) {
                if (feedbackList.size() > 0) {
                    sb.append("\uff0c");
                }
                sb.append(ResManager.loadKDString((String)"\u8ba2\u5355\uff1a", (String)"OrderBillListForEM_9", (String)"fi-er-formplugin", (Object[])new Object[0])).append(confrimList.stream().map(e -> e.getString("ordernum")).collect(Collectors.toList())).append(ResManager.loadKDString((String)"\u5df2\u786e\u8ba4", (String)"OrderBillListForEM_11", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if (confrimList.size() > 0 || feedbackList.size() > 0) {
                sb.append("\u3002");
            }
        }
        if (total.size() > 0) {
            List list = ErMessageServiceHelper.sendTripOrderConfrimMessage((DynamicObject[])total.toArray(new DynamicObject[0]), (String)((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId(), (boolean)false, (boolean)true);
            this.getView().showSuccessNotification(sb.toString());
        } else {
            logger.info("\u5546\u65c5\u96c6\u6210, \u6ca1\u6709\u9700\u8981\u53d1\u9001\u6d88\u606f\u7684\u8ba2\u5355");
            this.getView().showTipNotification(sb.toString());
        }
    }

    private void openBatchEditPage() {
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        String entityId = param.getBillFormId();
        HashMap<String, String> customParamMap = new HashMap<String, String>(16);
        customParamMap.put("entityId", entityId);
        FormModel formModel = new FormModel("er_batch_modify", ResManager.loadKDString((String)"\u6279\u91cf\u64cd\u4f5c", (String)"TravelExpenseBillPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]), "1", true, customParamMap);
        formModel.setShowType(ShowType.Modal);
        ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
    }

    private boolean checkPropIsExist(String prop, String entityId) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        DynamicProperty property = mainEntityType.getProperty(prop);
        return property != null;
    }

    private void modifyData(ListSelectedRowCollection selectedRows, Map<String, Object> returnData) {
        Object modifyProp = returnData.get("key");
        Object modifyValue = returnData.get("value");
        String relatedEntityId = returnData.get("relatedEntityId").toString();
        boolean allOrderFlag = this.checkPropIsExist(modifyProp.toString(), "er_allorderbill");
        boolean allCheckingFlag = this.checkPropIsExist(modifyProp.toString(), "er_allcheckingbill");
        boolean checkingBillFlag = this.checkPropIsExist(modifyProp.toString(), relatedEntityId);
        for (ListSelectedRow selectedRow : selectedRows) {
            DynamicObject billRow = BusinessDataServiceHelper.loadSingle((Object)selectedRow.getPrimaryKeyValue(), (String)returnData.get("entityId").toString());
            BatchEditUtil.getOpAppLogInfo(returnData, modifyProp, modifyValue, billRow, this.getView());
            if (billRow == null) continue;
            billRow.set(modifyProp.toString(), modifyValue);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billRow});
            if (allOrderFlag) {
                DynamicObject allOrder = BusinessDataServiceHelper.loadSingle((String)"er_allorderbill", (String)("id," + modifyProp.toString()), (QFilter[])new QFilter[]{new QFilter("orderid", "=", (Object)billRow.getPkValue().toString())});
                this.updateOtherTableData(modifyProp, modifyValue, allOrder);
            }
            if (allCheckingFlag && BatchEditUtil.checkIsModify(relatedEntityId, modifyProp.toString(), modifyValue.toString())) {
                DynamicObject allChecking = BusinessDataServiceHelper.loadSingle((String)"er_allcheckingbill", (String)("id,batchno," + modifyProp.toString()), (QFilter[])new QFilter[]{new QFilter("billno", "=", billRow.get("ordernum"))});
                this.updateOtherTableData(modifyProp, modifyValue, allChecking);
            }
            if (!checkingBillFlag || !BatchEditUtil.checkIsModify(relatedEntityId, modifyProp.toString(), modifyValue.toString())) continue;
            DynamicObject load = BusinessDataServiceHelper.loadSingle((String)relatedEntityId, (String)("id," + modifyProp.toString()), (QFilter[])new QFilter[]{new QFilter("billno", "=", billRow.get("ordernum"))});
            this.updateOtherTableData(modifyProp, modifyValue, load);
        }
    }

    private void updateOtherTableData(Object modifyProp, Object modifyValue, DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return;
        }
        dynamicObject.set(modifyProp.toString(), modifyValue);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void packageData(PackageDataEvent e) {
        try {
            DynamicObject datum = e.getRowData();
            Object totalamount = datum.get("totalamount");
            if (totalamount != null) {
                String colKey = e.getColKey();
                BigDecimal bigDecimal = new BigDecimal(totalamount.toString());
                if ("totalamount".equalsIgnoreCase(colKey) && bigDecimal.compareTo(ConvertUtil.getOrderAmountInit()) == 0) {
                    e.setFormatValue((Object)"-");
                }
            }
        }
        catch (Exception ex) {
            logger.error("packageData error", (Throwable)ex);
        }
    }

    @Override
    protected boolean getHasRight() {
        return false;
    }
}

