/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.payinvoice;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.utils.ErCommonUtils;

public class ErInvoiceSettleRelatedPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid settleInfoEntry = (EntryGrid)this.getControl("settleinfo");
        EntryGrid invoiceInfoEntry = (EntryGrid)this.getControl("invoiceinfo");
        settleInfoEntry.addHyperClickListener((HyperLinkClickListener)this);
        invoiceInfoEntry.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Object invoiceId = formShowParameter.getCustomParam("invoiceid");
        if (invoiceId != null && !StringUtils.isEmpty((String)invoiceId.toString())) {
            view.setVisible(Boolean.valueOf(true), new String[]{"settleinfo"});
            view.setVisible(Boolean.valueOf(false), new String[]{"invoiceinfo"});
            IErDao settleInvoiceRelDao = ErDaoFactory.getInstance((String)"er_invoicesettle_rel");
            DynamicObject[] invoiceRelDyns = settleInvoiceRelDao.query("id, serviceitem, systemtaxrate, totalamount, taxamount, settleid, settleformid", new QFilter("invoiceid", "=", invoiceId));
            DynamicObject[] settleDyns = null;
            if (invoiceRelDyns != null && invoiceRelDyns.length > 0) {
                Set settleIds = Stream.of(invoiceRelDyns).map(v -> v.getLong("settleid")).collect(Collectors.toSet());
                String formid = invoiceRelDyns[0].getString("settleformid");
                IErDao settleDao = ErDaoFactory.getInstance((String)formid);
                settleDyns = settleDao.query("id, ordernum, billno, sourcebookedid, allorderbase, allorderbase.company, allorderbase.expcommitcomnum", new QFilter("id", "in", settleIds));
                Map<Long, DynamicObject> settleMapping = Stream.of(settleDyns).collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
                IDataModel dataModel = this.getModel();
                dataModel.batchCreateNewEntryRow("settleinfo", invoiceRelDyns.length);
                dataModel.setValue("formid", (Object)formid);
                for (int i = 0; i < invoiceRelDyns.length; ++i) {
                    DynamicObject invoiceRelD = invoiceRelDyns[i];
                    long settleIdTemp = invoiceRelD.getLong("settleid");
                    DynamicObject settleDyn = settleMapping.get(settleIdTemp);
                    if (null == settleDyn) continue;
                    dataModel.setValue("settle_seq", (Object)(i + 1), i);
                    dataModel.setValue("settleid", settleDyn.get("id"), i);
                    dataModel.setValue("settlebillno", settleDyn.get("ordernum"), i);
                    dataModel.setValue("settlebatchno", settleDyn.get("billno"), i);
                    dataModel.setValue("sourceuserid", settleDyn.get("sourcebookedid"), i);
                    dataModel.setValue("org", (Object)ErCommonUtils.getPk((Object)settleDyn.getDynamicObject("allorderbase").get("company")), i);
                    dataModel.setValue("exporg", (Object)ErCommonUtils.getPk((Object)settleDyn.getDynamicObject("allorderbase").get("expcommitcomnum")), i);
                    dataModel.setValue("serviceitem", invoiceRelD.get("serviceitem"), i);
                    dataModel.setValue("systemtaxrate", invoiceRelD.get("systemtaxrate"), i);
                    BigDecimal amount = invoiceRelD.getBigDecimal("totalamount");
                    BigDecimal tax = invoiceRelD.getBigDecimal("taxamount");
                    dataModel.setValue("settleamountnotax", (Object)amount.subtract(tax), i);
                    dataModel.setValue("taxamount", (Object)tax, i);
                    dataModel.setValue("settleamountwithtax", (Object)amount, i);
                }
            }
            return;
        }
        Object settleId = formShowParameter.getCustomParam("settleid");
        if (settleId != null && !StringUtils.isEmpty((String)settleId.toString())) {
            view.setVisible(Boolean.valueOf(false), new String[]{"settleinfo"});
            view.setVisible(Boolean.valueOf(true), new String[]{"invoiceinfo"});
            IErDao settleInvoiceRelDao = ErDaoFactory.getInstance((String)"er_invoicesettle_rel");
            DynamicObject[] invoiceRelDyns = settleInvoiceRelDao.query("id, serviceitem, systemtaxrate, totalamount, taxamount, invoiceid", new QFilter("settleid", "=", settleId));
            DynamicObject[] invoiceDyns = null;
            if (invoiceRelDyns != null && invoiceRelDyns.length > 0) {
                Set invoiceIds = Stream.of(invoiceRelDyns).map(v -> v.getLong("invoiceid")).collect(Collectors.toSet());
                IErDao invoiceDao = ErDaoFactory.getInstance((String)"er_invoiceorderbill");
                invoiceDyns = invoiceDao.query("id, billno, invoicestatus, invoicenum, invoicecode", new QFilter("id", "in", invoiceIds));
                Map<Long, DynamicObject> invoiceMapping = Stream.of(invoiceDyns).collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
                IDataModel dataModel = this.getModel();
                dataModel.batchCreateNewEntryRow("invoiceinfo", invoiceRelDyns.length);
                for (int i = 0; i < invoiceRelDyns.length; ++i) {
                    DynamicObject invoiceRelD = invoiceRelDyns[i];
                    long invoiceIdTemp = invoiceRelD.getLong("invoiceid");
                    DynamicObject invoiceDyn = invoiceMapping.get(invoiceIdTemp);
                    dataModel.setValue("invoice_seq", (Object)(i + 1), i);
                    dataModel.setValue("invoice_billno", invoiceDyn.get("billno"), i);
                    dataModel.setValue("invoice_status", invoiceDyn.get("invoicestatus"), i);
                    dataModel.setValue("invoice_serviceitem", invoiceRelD.get("serviceitem"), i);
                    dataModel.setValue("invoice_systemtaxrate", invoiceRelD.get("systemtaxrate"), i);
                    BigDecimal amount = invoiceRelD.getBigDecimal("totalamount");
                    BigDecimal tax = invoiceRelD.getBigDecimal("taxamount");
                    dataModel.setValue("invoice_amountnotax", (Object)amount.subtract(tax), i);
                    dataModel.setValue("invoice_taxamount", (Object)tax, i);
                    dataModel.setValue("invoice_amountwithtax", (Object)amount, i);
                    dataModel.setValue("invoice_number", invoiceDyn.get("invoicenum"), i);
                    dataModel.setValue("invoice_code", invoiceDyn.get("invoicecode"), i);
                    dataModel.setValue("invoice_id", invoiceDyn.get("id"), i);
                }
            }
            return;
        }
        view.setVisible(Boolean.valueOf(false), new String[]{"invoiceinfo", "settleinfo"});
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        if ("invoice_billno".equals(fieldName)) {
            Object invoiceId = this.getModel().getValue("invoice_id", event.getRowIndex());
            BillShowParameter bill = new BillShowParameter();
            bill.setFormId("er_invoiceorderbill");
            bill.setPkId(invoiceId);
            bill.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)bill);
        } else {
            Object invoiceId = this.getModel().getValue("settleid", event.getRowIndex());
            BillShowParameter bill = new BillShowParameter();
            bill.setFormId(this.getModel().getValue("formid") + "");
            bill.setPkId(invoiceId);
            bill.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)bill);
        }
    }
}

