/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.refreshorder;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.formplugin.trip.sso.util.TripSSOUtils;

public class TripRefreshOrderBillSelectMobPlugin
extends AbstractMobBillPlugIn
implements RowClickEventListener {
    private final Log logger = LogFactory.getLog(TripRefreshOrderBillSelectMobPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"reqcardentryflexpanelap"});
    }

    public void afterCreateNewData(EventObject e) {
        try {
            IDataModel model = this.getModel();
            long currUserId = RequestContext.get().getCurrUserId();
            QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"E");
            QFilter commonFilter = new QFilter("applier", "=", (Object)currUserId).or(new QFilter("creator", "=", (Object)currUserId));
            QFilter reqFilter = commonFilter.or(new QFilter("multitravelers.fbasedataid", "=", (Object)currUserId));
            DynamicObjectCollection reqBills = QueryServiceHelper.query((String)"er_tripreqbill", (String)"billno,bizdate,description", (QFilter[])new QFilter[]{billStatusFilter.and(reqFilter), new QFilter("isloan", "=", (Object)"0")}, (String)"bizdate desc");
            TripSSOUtils.setBillDatas(reqBills, model, "req", "reqbillentryentity");
        }
        catch (Exception ex) {
            this.logger.error("kd.fi.er.formplugin.trip.refreshorder.TripRefreshOrderBillSelectMobPlugin.afterCreateNewData \u6570\u636e\u67e5\u8be2\u6709\u8bef", (Throwable)ex);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u663e\u793a\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TripRefreshOrderBillSelectMobPlugin_02", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        try {
            Control ctl;
            String key;
            if (source instanceof Control && "reqcardentryflexpanelap".equals(key = (ctl = (Control)source).getKey())) {
                IDataModel model = this.getModel();
                IFormView view = this.getView();
                int index = model.getEntryCurrentRowIndex("reqbillentryentity");
                DynamicObjectCollection entry = model.getEntryEntity("reqbillentryentity");
                if (CollectionUtils.isEmpty((Collection)entry) || index > entry.size()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8fdb\u5165\u9875\u9762\u540e\u518d\u8fdb\u884c\u9009\u62e9\u3002", (String)"TripRefreshOrderBillSelectMobPlugin_01", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject dynamicObject = (DynamicObject)entry.get(index);
                String billNo = dynamicObject.getString("reqbillno");
                HashMap paramMap = Maps.newHashMapWithExpectedSize((int)2);
                paramMap.put("billNo", billNo);
                view.returnDataToParent((Object)paramMap);
                view.close();
            }
        }
        catch (Exception ex) {
            this.logger.error("kd.fi.er.formplugin.trip.refreshorder.TripRefreshOrderBillSelectMobPlugin.click \u51fa\u73b0\u4e86\u9519\u8bef", (Throwable)ex);
            this.getView().close();
        }
    }
}

