/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.refreshorder;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.fi.er.business.trip.dailybiz.TripNotReimbursedOrderUtil;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.formplugin.trip.sso.util.TripSSOUtils;

public class TripRefreshOrderMobPlugin
extends AbstractMobBillPlugIn
implements RowClickEventListener {
    static final List<String> CLICK_LISTENER = Arrays.asList("travelnoone_home", "corp_home");
    private final Log logger = LogFactory.getLog(TripRefreshOrderMobPlugin.class);
    private static final String RIGHT_STYLES = "eyJ0eXBlIjowLCJjb250ZW50IjoiJHtcbmhlaWdodDo0NXB4O1xufVxuJDo6YWZ0ZXJ7XG4gIGNvbnRlbnQ6IFwiXCI7XG4gIHdpZHRoOiA1cHg7XG4gIGhlaWdodDogMTBweDtcbiAgYm9yZGVyOiBzb2xpZCBkb2RnZXJibHVlO1xuICBib3JkZXItd2lkdGg6IDAgM3B4IDNweCAwO1xuICB0cmFuc2Zvcm06IHJvdGF0ZSg0NWRlZyk7XG59In0=";
    private static final String CANCEL_RIGHT_STYLES = "eyJ0eXBlIjowLCJjb250ZW50IjoiXG4kIHtcbsKgwqBoZWlnaHQ6NDVweDtcbsKgfVxuXG4kOjphZnRlcntcbiBcbn0ifQ==";

    public void registerListener(EventObject e) {
        this.addClickListeners(CLICK_LISTENER.toArray(new String[0]));
        Control entryentity = this.getControl("billentryentity");
        if (entryentity instanceof CardEntry) {
            ((CardEntry)entryentity).addRowClickListener((RowClickEventListener)this);
        }
        this.addClickListeners(new String[]{"sync"});
    }

    public void afterBindData(EventObject e) {
        TripSSOUtils.judgeTrialOrg(this.getView(), new HashSet<String>(Arrays.asList(Supplier.CHAILVYIHAO.getValue(), Supplier.XIECHENG.getValue())));
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        IFormView view = this.getView();
        ArrayList tmpList = Lists.newArrayList(CLICK_LISTENER);
        if (tmpList.contains(key)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("cstyles", RIGHT_STYLES);
            view.updateControlMetadata(key, map);
            tmpList.remove(key);
            for (String s : tmpList) {
                HashMap<String, String> otherMap = new HashMap<String, String>();
                otherMap.put("cstyles", CANCEL_RIGHT_STYLES);
                view.updateControlMetadata(s, otherMap);
            }
            IPageCache pageCache = this.getPageCache();
            String server = TripSSOUtils.SERVER_AND_CONTROLKEY_MAP.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey)).getOrDefault(key, "");
            if (StringUtils.isNotEmpty((String)server)) {
                pageCache.put("server", server);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u672a\u652f\u6301\u8be5\u670d\u52a1\u5546\u8fdb\u884c\u66f4\u65b0\u8ba2\u5355\uff0c\u656c\u8bf7\u671f\u5f85\u3002", (String)"TripRefreshOrderMobPlugin_01", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        } else if ("sync".equals(key)) {
            try {
                IPageCache pageCache = this.getPageCache();
                String server = pageCache.get("server");
                if (StringUtils.isEmpty((String)server)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u670d\u52a1\u5546\u3002", (String)"TripSyncApplyBillMobPlugin_02", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                String billNo = pageCache.get("billNo");
                if (StringUtils.isEmpty((String)billNo)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7533\u8bf7\u5355\u3002", (String)"TripRefreshOrderMobPlugin_02", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (Supplier.CHAILVYIHAO.getValue().equals(server)) {
                    TripNotReimbursedOrderUtil.callTravelNoOneFunction(Collections.singletonList(billNo));
                } else if (Supplier.XIECHENG.getValue().equals(server)) {
                    TripNotReimbursedOrderUtil.callCtripFunction(Collections.singletonList(billNo));
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u66f4\u65b0\u5546\u65c5\u8ba2\u5355\u4fe1\u606f\u3002", (String)"TripReqBillBookList_11", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            catch (Exception ex) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u5546\u65c5\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\u3002", (String)"TripReqBillBookList_12", (String)"fi-er-formplugin", (Object[])new Object[0]));
                this.logger.error("kd.fi.er.formplugin.trip.refreshorder.TripRefreshOrderMobPlugin.click \u70b9\u51fb\u4e8b\u4ef6\u51fa\u73b0\u4e86\u95ee\u9898,\u8bf7\u67e5\u770b\u65e5\u5fd7", (Throwable)ex);
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        CardEntry entry;
        Object source = evt.getSource();
        if (source instanceof CardEntry && "billentryentity".equals((entry = (CardEntry)source).getEntryKey())) {
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.setFormId("er_trip_bill_select");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "er_trip_bill_select"));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        String actionId = closedCallBackEvent.getActionId();
        IPageCache pageCache = this.getPageCache();
        if ("er_trip_bill_select".equals(actionId) && (returnData = closedCallBackEvent.getReturnData()) instanceof Map) {
            Map returnMap = (Map)returnData;
            String billNo = returnMap.getOrDefault("billNo", "");
            pageCache.put("billNo", billNo);
            IFormView view = this.getView();
            Label labelap = (Label)view.getControl("label_select");
            labelap.setText(billNo + "\t>");
            view.updateView("billentryentity");
        }
    }
}

