/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.common.PayerTypeEnum;
import org.apache.commons.lang3.StringUtils;

abstract class AbstractMultiCurrencyAutoPayPlugin
extends AbstractFormPlugin {
    private static final String MULTICURRENCYPAY_BTN = "multicurrencyautopay";

    AbstractMultiCurrencyAutoPayPlugin() {
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)MULTICURRENCYPAY_BTN, (CharSequence)itemKey)) {
            IDataModel model = this.getModel();
            if (this.isAllowMultiCurrencyAutoPay(model)) {
                DynamicObject billObj = model.getDataEntity(true);
                this.fillAcctEntry(this.getMuiltCurrencyAccAmountInfoOApplier(billObj), model);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u51b2\u501f\u6b3e\uff0c\u4e0d\u652f\u6301\u591a\u5e01\u79cd\u6536\u6b3e\u81ea\u52a8\u6536\u6b3e\u3002", (String)"AbstractMultiCurrencyPayPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        }
    }

    protected abstract Map<Object, List<BigDecimal>> getMuiltCurrencyAccAmountInfoOApplier(DynamicObject var1);

    private void fillAcctEntry(Map<Object, List<BigDecimal>> accAmountInfoColl, IDataModel model) {
        if (accAmountInfoColl == null || accAmountInfoColl.size() <= 0) {
            return;
        }
        Long applierId = (Long)((DynamicObject)model.getValue("applier")).getPkValue();
        model.deleteEntryData("accountentry");
        List payerAccInfo = PayeeServiceHelper.getPayerAccountByPayerID((Long)applierId, (boolean)false);
        Map<Object, List<DynamicObject>> payerInfoGroupByCurcy = payerAccInfo.stream().filter(payerInfo -> payerInfo.getDynamicObject("CURRENCY") != null && payerInfo.getDynamicObject("payer").getPkValue().equals(applierId)).collect(Collectors.groupingBy(payerInfo -> payerInfo.getDynamicObject("CURRENCY").getPkValue()));
        Iterator<Map.Entry<Object, List<BigDecimal>>> iterator = accAmountInfoColl.entrySet().iterator();
        ArrayList<String> missCurrency = new ArrayList<String>();
        Object currencyID = ((DynamicObject)model.getValue("currency")).getPkValue();
        int currencyIndex = -1;
        while (iterator.hasNext()) {
            int rowIndex;
            BigDecimal oriReceiveAmount;
            Map.Entry<Object, List<BigDecimal>> entry = iterator.next();
            Object entryCurrencyID = entry.getKey();
            List<BigDecimal> amtList = entry.getValue();
            List<DynamicObject> accInfoList = payerInfoGroupByCurcy.get(entryCurrencyID);
            if (accInfoList != null && accInfoList.size() > 0) {
                oriReceiveAmount = amtList.get(0);
                if (currencyID.equals(entryCurrencyID)) {
                    if (currencyIndex == -1) {
                        currencyIndex = model.createNewEntryRow("accountentry");
                        model.setValue("payertype", (Object)PayerTypeEnum.PAYER.getType(), currencyIndex);
                        CoreBaseBillServiceHelper.fillAccountEntry((IDataModel)model, (int)currencyIndex, (DynamicObject)this.getDefaultPayerFromMuiltCurrrency(accInfoList));
                    } else {
                        oriReceiveAmount = oriReceiveAmount.add((BigDecimal)model.getValue("orireceiveamount", currencyIndex));
                    }
                    rowIndex = currencyIndex;
                } else {
                    rowIndex = model.createNewEntryRow("accountentry");
                    model.setValue("payertype", (Object)PayerTypeEnum.PAYER.getType(), rowIndex);
                    CoreBaseBillServiceHelper.fillAccountEntry((IDataModel)model, (int)rowIndex, (DynamicObject)this.getDefaultPayerFromMuiltCurrrency(accInfoList));
                }
            } else {
                amtList.set(2, BigDecimal.ONE);
                oriReceiveAmount = amtList.get(1);
                if (currencyIndex == -1) {
                    currencyIndex = model.createNewEntryRow("accountentry");
                    model.setValue("payertype", (Object)PayerTypeEnum.PAYER.getType(), currencyIndex);
                    List<DynamicObject> currencyAcctInfoList = payerInfoGroupByCurcy.get(currencyID);
                    if (currencyAcctInfoList == null || currencyAcctInfoList.size() == 0) {
                        model.setValue("payer", null, currencyIndex);
                        if ("er_tripreqbill".equalsIgnoreCase(model.getDataEntityType().toString())) {
                            model.beginInit();
                            model.setValue("payername", null, currencyIndex);
                            model.endInit();
                            this.getView().updateView("payername", currencyIndex);
                            DynamicObject paymode = (DynamicObject)model.getValue("paymode", currencyIndex);
                            String settlementtype = null;
                            if (paymode != null) {
                                settlementtype = paymode.getString("settlementtype");
                            }
                            if ("0".equals(settlementtype)) {
                                return;
                            }
                            model.setValue("payeraccount02", null, currencyIndex);
                            model.setValue("payeraccount", null, currencyIndex);
                            model.setValue("payeraccount01", null, currencyIndex);
                            model.setValue("payerbank", null, currencyIndex);
                        }
                        model.setValue("accountcurrency", currencyID, currencyIndex);
                        String currencyName = ((DynamicObject)model.getValue("accountcurrency", currencyIndex)).getLocaleString("name").getLocaleValue();
                        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"%s\u5e01\u79cd\u6ca1\u6709\u81ea\u52a8\u4ea7\u751f\u6536\u6b3e\u4fe1\u606f\uff0c\u8bf7\u624b\u5de5\u6dfb\u52a0\u3002", (String)"AbstractMultiCurrencyPayPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]), currencyName), MessageBoxOptions.OK);
                    } else {
                        CoreBaseBillServiceHelper.fillAccountEntry((IDataModel)model, (int)currencyIndex, (DynamicObject)this.getDefaultPayerFromMuiltCurrrency(currencyAcctInfoList));
                    }
                } else {
                    oriReceiveAmount = oriReceiveAmount.add((BigDecimal)model.getValue("orireceiveamount", currencyIndex));
                }
                rowIndex = currencyIndex;
                DynamicObject entryCurrency = BusinessDataServiceHelper.loadSingleFromCache((Object)entryCurrencyID, (String)"bd_currency");
                if (entryCurrency != null) {
                    missCurrency.add(entryCurrency.getLocaleString("name").getLocaleValue());
                }
            }
            model.setValue("orireceiveamount", (Object)oriReceiveAmount, rowIndex);
            model.beginInit();
            model.setValue("accexchangerate", (Object)amtList.get(2), rowIndex);
            model.endInit();
        }
        if (!missCurrency.isEmpty()) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"%s\u5e01\u79cd\u6ca1\u6709\u81ea\u52a8\u4ea7\u751f\u6536\u6b3e\u4fe1\u606f\uff0c\u5df2\u6309\u5355\u636e\u672c\u4f4d\u5e01\u6362\u7b97\u6536\u6b3e\u3002", (String)"AbstractMultiCurrencyPayPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]), missCurrency), MessageBoxOptions.OK);
        }
    }

    private boolean isAllowMultiCurrencyAutoPay(IDataModel model) {
        DynamicObjectCollection dynamicObjectCollection;
        if ("er_tripreqbill".equalsIgnoreCase(model.getDataEntityType().getName())) {
            return true;
        }
        String writeLoanNumber = this.getWriteOffLoanEntryNumber();
        return StringUtils.isEmpty((CharSequence)writeLoanNumber) || (dynamicObjectCollection = model.getEntryEntity(writeLoanNumber)) == null || dynamicObjectCollection.size() <= 0;
    }

    protected abstract String getWriteOffLoanEntryNumber();

    private DynamicObject getDefaultPayerFromMuiltCurrrency(List<DynamicObject> accInfoList) {
        DynamicObject defaultAcct = accInfoList.get(0);
        for (int i = 1; i < accInfoList.size(); ++i) {
            DynamicObject tempDy = accInfoList.get(i);
            if (!tempDy.getBoolean("isdefault")) continue;
            defaultAcct = tempDy;
            break;
        }
        return defaultAcct;
    }
}

