/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.DailyBillServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.constant.ErTripExpenseItemConstant;
import kd.fi.er.common.type.RVehicleEnum;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostCompanyF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostDeptF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeExpenseItemF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeProjectF7SelectListener;
import kd.fi.er.formplugin.daily.web.util.TempCheckExpenseItemUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractTripReimburseBillEditNew
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.setHeadExpenseItemF7Filter();
        this.setProjectF7Filter();
        this.setCostDeptF7Filter();
        this.setCostCompanyF7Filter();
    }

    protected void setCostDeptF7Filter() {
        BasedataEdit costDeptF7 = (BasedataEdit)this.getControl("costdept");
        if (costDeptF7 != null) {
            BeforeCostDeptF7SelectListener beforeCostDeptF7SelectListener = new BeforeCostDeptF7SelectListener(this.getModel());
            costDeptF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostDeptF7SelectListener);
        }
    }

    protected void setCostCompanyF7Filter() {
        boolean isNotRelated;
        BasedataEdit costCompanyF7 = (BasedataEdit)this.getControl("costcompany");
        Object costDept = this.getModel().getValue("costdept");
        Object company = this.getModel().getValue("company");
        int showType = ErCommonUtils.getExpenseAssumeShowTypes((long)ErCommonUtils.getPk((Object)this.getModel().getValue("company")));
        boolean bl = isNotRelated = "2".equals(ErStdConfig.get((String)"Costcompany Unbinding")) && showType == 1;
        if (!isNotRelated && costCompanyF7 != null && costDept != null) {
            BeforeCostCompanyF7SelectListener beforeCostCompanyF7SelectListener = new BeforeCostCompanyF7SelectListener(ErCommonUtils.getPk((Object)costDept), ErCommonUtils.getPk((Object)company));
            costCompanyF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCompanyF7SelectListener);
        }
    }

    private void setProjectF7Filter() {
        BasedataEdit projectF7 = (BasedataEdit)this.getControl("headproject");
        if (projectF7 != null) {
            projectF7.addBeforeF7SelectListener((BeforeF7SelectListener)new BeforeProjectF7SelectListener((Long)((DynamicObject)this.getModel().getValue("applier")).getPkValue(), (Long)((DynamicObject)this.getModel().getValue("company")).getPkValue()));
        }
    }

    protected void setHeadExpenseItemF7Filter() {
        String number = this.getView().getEntityId();
        BasedataEdit expenseitemF7 = (BasedataEdit)this.getControl("headexpenseitem");
        if (expenseitemF7 != null) {
            expenseitemF7.addBeforeF7SelectListener((BeforeF7SelectListener)new BeforeExpenseItemF7SelectListener(this.getView(), number, "costdept"));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DailyBillServiceHelper.initEntryForNewTripReim((IDataModel)this.getModel());
        this.initTravles();
        if (this.getModel().getProperty("billkind") != null) {
            this.getModel().setValue("billkind", (Object)"1");
            BillShowParameter formShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
            if (!StringUtils.equals((CharSequence)formShowParameter.getFormId(), (CharSequence)this.getView().getEntityId())) {
                this.getModel().setValue("stdbilltype", (Object)this.getBillTypeId());
            }
        }
    }

    protected abstract String getBillTypeId();

    private void initTravles() {
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        if (entryRowCount > 0) {
            Object[] currentUserID = new Object[]{CommonServiceHelper.getCurrentUserID()};
            for (int i = 0; i < entryRowCount; ++i) {
                this.getModel().setValue("trip2travelers", (Object)currentUserID, i, 0);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propName) {
            case "istravelers": {
                Boolean isMultiTravelers = (Boolean)newValue;
                if (isMultiTravelers.booleanValue()) break;
                IDataModel model = this.getModel();
                Long applierId = ErCommonUtils.getPk((Object)model.getValue("applier"));
                Object[] applierIds = new Object[]{applierId};
                DynamicObject dataEntity = model.getDataEntity(true);
                DynamicObjectCollection tripEntryDOs = dataEntity.getDynamicObjectCollection("tripentry");
                for (int tripEntryIndex = 0; tripEntryIndex < tripEntryDOs.size(); ++tripEntryIndex) {
                    DynamicObjectCollection tripItemEntryDOs = ((DynamicObject)tripEntryDOs.get(tripEntryIndex)).getDynamicObjectCollection("entryentity");
                    for (int tripItemEntryIndex = 0; tripItemEntryIndex < tripItemEntryDOs.size(); ++tripItemEntryIndex) {
                        model.setValue("trip2travelers", (Object)applierIds, tripItemEntryIndex, tripEntryIndex);
                    }
                }
                break;
            }
            case "costdept": {
                TempCheckExpenseItemUtils.checkExpenseItemTripHead((DynamicObject)((DynamicObject)newValue), (IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save || args.getSource() instanceof Submit) {
            this.buildTripEntry();
        }
    }

    protected void buildTripEntry() {
        this.getModel().beginInit();
        this.setValueFromHead("tripexpenseitem", "headexpenseitem");
        this.setValueFromHead("entrycostdept", "costdept");
        this.setValueFromHead("entrycostcompany", "costcompany");
        DynamicObject entry = this.getHadValueEntry();
        if (entry != null) {
            this.setValueFromEntry("startdate", "trip2startdate", entry);
            this.setValueFromEntry("enddate", "trip2enddate", entry);
            this.setValueFromEntry("from", "trip2from", entry);
            this.setValueFromEntry("to", "trip2to", entry);
            this.setValueFromEntry("tripentryarea", "triparea", entry);
            String vehicle = this.getVehicleByTripExpense();
            this.getModel().setValue("vehicle", (Object)vehicle, 0);
            this.getModel().setValue("vehicles", (Object)vehicle, 0);
        }
        this.getModel().endInit();
    }

    private String getVehicleByTripExpense() {
        DynamicObjectCollection entryColl = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry").get(0)).getDynamicObjectCollection("entryentity");
        if (!entryColl.isEmpty()) {
            for (DynamicObject entry : entryColl) {
                DynamicObject tripExpenseItem;
                if (entry.getBigDecimal("orientryamount").compareTo(BigDecimal.ZERO) <= 0 || (tripExpenseItem = entry.getDynamicObject("expenseitem")) == null) continue;
                Object attribute = tripExpenseItem.get("attribute");
                if (!ErTripExpenseItemConstant.Attribute.getVehicleLst().contains(attribute)) continue;
                return this.getVehicle(attribute);
            }
        }
        return RVehicleEnum.OTHER.getValue();
    }

    private String getVehicle(Object attribute) {
        if (ErTripExpenseItemConstant.Attribute.AirPlane.getValue().equals(attribute)) {
            return RVehicleEnum.AIR.getValue();
        }
        if (ErTripExpenseItemConstant.Attribute.Train.getValue().equals(attribute)) {
            return RVehicleEnum.TRAIN.getValue();
        }
        if (ErTripExpenseItemConstant.Attribute.Car.getValue().equals(attribute)) {
            return RVehicleEnum.CAR.getValue();
        }
        if (ErTripExpenseItemConstant.Attribute.Ship.getValue().equals(attribute)) {
            return RVehicleEnum.SHIP.getValue();
        }
        return null;
    }

    private void setValueFromEntry(String tripEntryProp, String entryProp, DynamicObject entry) {
        this.getModel().setValue(tripEntryProp, entry.get(entryProp), 0);
    }

    private DynamicObject getHadValueEntry() {
        DynamicObjectCollection entryColl = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry").get(0)).getDynamicObjectCollection("entryentity");
        if (!entryColl.isEmpty()) {
            for (int i = 0; i < entryColl.size(); ++i) {
                DynamicObject entry = (DynamicObject)entryColl.get(i);
                if (entry.getBigDecimal("orientryamount").compareTo(BigDecimal.ZERO) <= 0 || entry.get("trip2enddate") == null || entry.get("trip2to") == null) continue;
                return entry;
            }
            return (DynamicObject)entryColl.get(0);
        }
        return null;
    }

    private void setValueFromHead(String tripEntryProp, String headProp) {
        this.getModel().setValue(tripEntryProp, this.getModel().getValue(headProp), 0);
    }
}

