/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.er.business.utils.ErChangeAccountConvertUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import org.apache.commons.lang3.StringUtils;

public class AccountChangeSelectBillViewPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"switch", "btnok"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.refreshEntry("er_tripreimbursebill");
        this.getPageCache().put("switch", "er_tripreimbursebill");
    }

    private void refreshEntry(String billType) {
        String filedS = "billno, description,billstatus, id as sourcebillid,   accountentry.id as sourceentryid, accountentry.seq as row, accountentry.payertype as payertype,  accountentry.payername as payername, accountentry.payeraccount as payeraccount,accountentry.accountcurrency as currency,accountentry.orireceiveamount as amount,accountentry.buildedamount as buildedamount";
        QFilter commontQfilter = new QFilter("applier.id", "=", (Object)ErCommonUtils.getPk((Object)this.getView().getParentView().getModel().getValue("applier")));
        QFilter originQfilter = new QFilter("billstatus", "=", (Object)"F").and("accountentry.buildedamount", "=", (Object)0).or("billstatus", "=", (Object)"E");
        commontQfilter.and(originQfilter);
        List existEntryIds = (List)this.getView().getFormShowParameter().getCustomParam(billType);
        if (existEntryIds != null && !existEntryIds.isEmpty()) {
            commontQfilter.and(new QFilter("accountentry.id", "not in", (Object)existEntryIds));
        }
        commontQfilter = this.qfilterPostProcess(billType, commontQfilter);
        DynamicObjectCollection records = QueryServiceHelper.query((String)billType, (String)filedS, (QFilter[])new QFilter[]{commontQfilter});
        this.removeRepeatBill(records, billType);
        DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (records.isEmpty()) {
            this.getModel().deleteEntryData("entryentity");
            return;
        }
        Object[] currencyId = (Long[])records.stream().map(record -> record.getLong("currency")).distinct().toArray(Long[]::new);
        Map currencyMap = BusinessDataServiceHelper.loadFromCache((Object[])currencyId, (String)"bd_currency");
        if (entry.size() > records.size()) {
            int[] index = IntStream.range(records.size(), entry.size()).toArray();
            this.getModel().deleteEntryRows("entryentity", index);
        }
        DataEntityPropertyCollection properties = ((DynamicObject)records.get(0)).getDataEntityType().getProperties();
        for (int i = 0; i < records.size(); ++i) {
            DynamicObject record2 = (DynamicObject)records.get(i);
            DynamicObject row = i >= entry.size() ? entry.addNew() : (DynamicObject)entry.get(i);
            for (IDataEntityProperty property : properties) {
                String propName = property.getName();
                if (StringUtils.equals((CharSequence)"currency", (CharSequence)propName)) {
                    row.set(propName, currencyMap.get(record2.get(propName)));
                    continue;
                }
                row.set(propName, record2.get(propName));
            }
        }
        BusinessDataReader.loadRefence((Object[])entry.toArray((Object[])new DynamicObject[entry.size()]), (IDataEntityType)entry.getDynamicObjectType());
        this.getView().updateView("entryentity");
    }

    private QFilter qfilterPostProcess(String billType, QFilter qFilter) {
        if (ErEntityTypeUtils.isTripReqBill((String)billType)) {
            return qFilter.and("isloan", "=", (Object)Boolean.TRUE);
        }
        if (ErEntityTypeUtils.isPublicReimburseBill((String)billType)) {
            String removeNestFilters = String.join((CharSequence)",", "billstatus", "accountentry.buildedamount");
            qFilter.getNests(true).stream().filter(nest -> removeNestFilters.contains(nest.getFilter().getProperty())).forEach(QFilter.QFilterNest::maskCurrent);
            qFilter.and(new QFilter("billstatus", "=", (Object)"E").or(new QFilter("billstatus", "=", (Object)"F")));
            return qFilter;
        }
        return qFilter;
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        IFormView view = this.getView();
        String billType = (String)this.getModel().getValue("billType");
        switch (key) {
            case "switch": {
                String preBiiType = this.getPageCache().get("switch");
                if (StringUtils.equals((CharSequence)preBiiType, (CharSequence)billType)) {
                    return;
                }
                this.refreshEntry(billType);
                this.getPageCache().put("switch", billType);
                break;
            }
            case "btnok": {
                int[] selectRow = ((EntryGrid)this.getControl("entryentity")).getSelectRows();
                if (selectRow.length == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u884c\u6570\u636e\u3002", (String)"AccountChangeSelectBillViewPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                view.returnDataToParent(this.getAllSelectRows(selectRow));
                view.sendFormAction(view.getParentView());
                view.close();
            }
        }
    }

    private Map<String, ListSelectedRowCollection> getAllSelectRows(int[] rowIndexs) {
        IDataModel model = this.getModel();
        HashMap<String, ListSelectedRowCollection> returnData = new HashMap<String, ListSelectedRowCollection>();
        int index = 0;
        for (int i : rowIndexs) {
            String formType = (String)model.getValue("billType", i);
            ListSelectedRowCollection listSelectedRowCollection = (ListSelectedRowCollection)returnData.get(formType);
            if (listSelectedRowCollection == null) {
                listSelectedRowCollection = new ListSelectedRowCollection();
                returnData.put(formType, listSelectedRowCollection);
            }
            ListSelectedRow listSelectedRow = new ListSelectedRow((Object)Long.valueOf((String)model.getValue("sourcebillid", i)), Boolean.valueOf(true));
            listSelectedRow.setBillNo((String)model.getValue("billno", i));
            listSelectedRow.setEntryEntityKey("accountentry");
            listSelectedRow.setEntryPrimaryKeyValue((Object)Long.parseLong((String)model.getValue("sourceentryid", i)));
            listSelectedRow.setPageIndex(0);
            listSelectedRow.setRowKey(index++);
            listSelectedRow.setFormID(formType);
            listSelectedRowCollection.add((Object)listSelectedRow);
        }
        return returnData;
    }

    private void removeRepeatBill(DynamicObjectCollection records, String billType) {
        Long[] billIDs = (Long[])records.stream().map(record -> record.getLong("sourcebillid")).toArray(Long[]::new);
        Long tableID = EntityMetadataCache.loadTableDefine((String)"er_accountchangebill", (String)"originalentry").getTableId();
        List bfRows = BFTrackerServiceHelper.loadTargetRowIds((String)billType, (Long[])billIDs, null);
        Set exsitPushEntry = bfRows.stream().filter(bfRow -> bfRow.getId().getTableId().compareTo(tableID) == 0).map(bfRow -> bfRow.getId().getEntryId()).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("originalentry.id", "in", exsitPushEntry);
        qFilter.and("billstatus", "not in", (Object)new String[]{"E", "I"});
        DynamicObjectCollection exsitChangeBill = QueryServiceHelper.query((String)"er_accountchangebill", (String)"originalentry.sourceentryid", (QFilter[])new QFilter[]{qFilter});
        Set sourceEntryIds = exsitChangeBill.stream().map(row -> Long.valueOf(row.getString("originalentry.sourceentryid"))).collect(Collectors.toSet());
        records.removeIf(row -> sourceEntryIds.contains(row.getLong("sourceentryid")));
        if (ErEntityTypeUtils.isPublicReimburseBill((String)billType)) {
            ErChangeAccountConvertUtils.PublicReimBurseBFRowDataHandler handler = ErChangeAccountConvertUtils.PublicReimBurseBFRowDataHandlerBuilder().setBFRow(bfRows).build();
            Map finApbill = handler.getFinApbill();
            Set ApplyPayBill = handler.getAccountEntryAssociateWithApplyPayBill();
            records.removeIf(row -> {
                boolean buildeAmountEqZero;
                if (!finApbill.isEmpty() && finApbill.containsKey(row.getLong("sourcebillid"))) {
                    return true;
                }
                String billstatus = row.getString("billstatus");
                if ("E".equals(billstatus)) {
                    return false;
                }
                BigDecimal buildedamount = row.getBigDecimal("buildedamount");
                boolean waitPayBillStatus = "F".equals(billstatus);
                boolean bl = buildeAmountEqZero = (buildedamount == null ? BigDecimal.ZERO : buildedamount).compareTo(BigDecimal.ZERO) == 0;
                if (buildeAmountEqZero) {
                    return !waitPayBillStatus;
                }
                if (waitPayBillStatus && !ApplyPayBill.isEmpty() && ApplyPayBill.contains(row.getLong("sourceentryid"))) {
                    return false;
                }
                return waitPayBillStatus;
            });
        }
    }
}

