/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.fi.er.business.bean.CostDeptF7ChangePram;
import kd.fi.er.business.invoicecloud.util.InvoicePackageUtil;
import kd.fi.er.business.reimamountctl.utils.QuotaCtrlUtil;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.CreditLevelServiceHelper;
import kd.fi.er.business.servicehelper.DailyBillServiceHelper;
import kd.fi.er.business.task.datacheck.util.ErDataCheckUtil;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountFormatsUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErCostCenterUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.TripBillTravelerUtils;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.common.model.UserCurrentDeptInfo;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostCenterF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostCompanyF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostDeptF7SelectListener;
import kd.fi.er.formplugin.daily.web.ReceiveEntryPlugin;
import kd.fi.er.formplugin.daily.web.util.ShowUserInfoUtils;
import kd.fi.er.formplugin.daily.web.util.TempCheckExpenseItemUtils;
import kd.fi.er.formplugin.util.DataCopyUtils;
import kd.fi.er.formplugin.util.FormOperateUtil;
import kd.fi.er.model.FormModel;
import org.apache.commons.lang.StringUtils;

public class CoreBaseBillEdit
extends AbstractBillPlugIn
implements ClickListener,
RowClickEventListener,
BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(CoreBaseBillEdit.class);
    protected static final String VIEW_LOAN_REPAYMENT = "bar_viewloanrepayment";
    public static final String CHANGE_APPLIER = "changeapplier";
    public static final String SUBMIT = "submit";
    public static final String SAVE = "save";
    public static final String DRAFT = "draft";
    private static final String ISCOPY = "iscopy";
    protected boolean flag = false;
    protected IPageCache pageCache;

    public void initialize() {
        super.initialize();
        this.pageCache = this.getPageCache();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CHANGE_APPLIER, VIEW_LOAN_REPAYMENT, "creditlevel"});
        BasedataEdit payerF7 = (BasedataEdit)this.getControl("payer");
        payerF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit payModeF7 = (BasedataEdit)this.getControl("paymode");
        payModeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setMultiSelect(Boolean.FALSE.booleanValue());
        });
        BasedataEdit currencyF7 = (BasedataEdit)this.getControl("currency");
        currencyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setMultiSelect(Boolean.FALSE.booleanValue());
        });
        this.setCostDeptF7Filter();
        this.setCostCompanyF7Filter();
        this.costCenterF7Filter();
    }

    private void costCenterF7Filter() {
        BasedataEdit costCenterF7 = (BasedataEdit)this.getControl("std_costcenter");
        BasedataEdit entryCostCenterF7 = (BasedataEdit)this.getControl("std_entrycostcenter");
        BasedataEdit secEntryCostCenterF7 = (BasedataEdit)this.getControl("travelcostcenter");
        BasedataEdit std_entrycostcenter_crule = (BasedataEdit)this.getControl("std_entrycostcenter_crule");
        BeforeCostCenterF7SelectListener beforeCostCenterF7SelectListener = new BeforeCostCenterF7SelectListener(this.getView());
        if (costCenterF7 != null) {
            costCenterF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCenterF7SelectListener);
        }
        if (entryCostCenterF7 != null) {
            entryCostCenterF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCenterF7SelectListener);
        }
        if (secEntryCostCenterF7 != null) {
            secEntryCostCenterF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCenterF7SelectListener);
        }
        if (std_entrycostcenter_crule != null) {
            std_entrycostcenter_crule.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCenterF7SelectListener);
        }
    }

    protected void setCostDeptF7Filter() {
        BasedataEdit costDeptF7 = (BasedataEdit)this.getControl("costdept");
        if (costDeptF7 != null) {
            BeforeCostDeptF7SelectListener beforeCostDeptF7SelectListener = new BeforeCostDeptF7SelectListener(this.getModel());
            costDeptF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostDeptF7SelectListener);
        }
    }

    protected void setCostCompanyF7Filter() {
        BasedataEdit costCompanyF7 = (BasedataEdit)this.getControl("costcompany");
        Object costDept = this.getModel().getValue("costdept");
        Object company = this.getModel().getValue("company");
        if (company != null) {
            boolean isNotRelated;
            int showType = ErCommonUtils.getExpenseAssumeShowTypes((long)ErCommonUtils.getPk((Object)this.getModel().getValue("company")));
            boolean bl = isNotRelated = "2".equals(ErStdConfig.get((String)"Costcompany Unbinding")) && showType == 1;
            if (!isNotRelated && costCompanyF7 != null && costDept != null) {
                BeforeCostCompanyF7SelectListener beforeCostCompanyF7SelectListener = new BeforeCostCompanyF7SelectListener(ErCommonUtils.getPk((Object)costDept), ErCommonUtils.getPk((Object)company));
                costCompanyF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCompanyF7SelectListener);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getView().getModel();
        Long currentUserID = 0L;
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        if (pageCache.get("consignorId") != null) {
            currentUserID = Long.valueOf(pageCache.get("consignorId"));
            pageCache.remove("consignorId");
        } else {
            RequestContext requestContext = RequestContext.get();
            currentUserID = Long.valueOf(requestContext.getUserId());
        }
        Map billMap = StringUtils.isNotEmpty((String)((String)this.getView().getFormShowParameter().getCustomParam("package_import_pc"))) ? InvoicePackageUtil.createNewData((Map)this.getView().getFormShowParameter().getCustomParams()) : CoreBaseBillServiceHelper.createNewData((Long)currentUserID);
        Map custom = this.getView().getFormShowParameter().getCustomParams();
        Object parameterStr = custom.get("userInfo");
        if (parameterStr != null && StringUtils.isNotBlank((String)parameterStr.toString())) {
            UserCurrentDeptInfo userInfo = (UserCurrentDeptInfo)JSON.parseObject((String)parameterStr.toString(), UserCurrentDeptInfo.class);
            logger.info("CoreBaseBillEdit>>>\u83b7\u53d6\u5230\u7684userInfo\u4e3a\uff1a" + parameterStr.toString());
            billMap = CoreBaseBillServiceHelper.createNewData((Long)userInfo.getUserId(), (Long)userInfo.getDeptId());
            logger.info("CoreBaseBillEdit>>>\u6839\u636euserInfo\u751f\u6210\u7684billmap\u4e3a\uff1a" + billMap.toString());
        }
        CoreBaseBillServiceHelper.extService((IFormView)this.getView(), (Map)billMap);
        CoreBaseBillServiceHelper.initObjByMap((Object)model, (Map)billMap);
        ErCostCenterUtil.initHeadCostCenter((IFormView)this.getView(), (boolean)false);
        ErCostCenterUtil.checkCostOrg((AbstractFormPlugin)this, (String)"1");
        Object currency = model.getValue("currency");
        if (model.getValue("company") != null && currency == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u672c\u4f4d\u5e01\u3002", (String)"CoreBaseBillEdit_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
        DataCopyUtils.setOriginValue((IFormView)this.getView());
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        CoreBaseBillServiceHelper.setFromStatus((AbstractFormPlugin)this);
        int accountIndex = this.getModel().getEntryRowCount("accountentry");
        if (CommonServiceHelper.isSSC((IFormView)this.getView()) && accountIndex > 1) {
            for (int i = 0; i < accountIndex; ++i) {
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"orireceiveamount"});
            }
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        DataCopyUtils.afterCopyBill((IDataModel)this.getModel(), (IFormView)this.getView());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        this.initUserInfo();
        this.createNewDetailData(model);
        String billStatus = (String)model.getValue("billstatus");
        this.hiddenChangeApplier(view);
        if (FormOperateUtil.isCopyOperate((EventObject)e) && StringUtils.equalsIgnoreCase((String)billStatus, (String)"A")) {
            DataCopyUtils.handleData((IDataModel)this.getModel(), (IFormView)this.getView());
        }
        CoreBaseBillServiceHelper.setBillCostOrgUseMode((IDataModel)model);
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        if (null != company) {
            String mode = ErCommonUtils.getCostOrgUseMode((Long)((Long)company.getPkValue()));
            if (!"0".equals(mode)) {
                BasedataEdit secEntryCostCenter;
                BasedataEdit costCenter = (BasedataEdit)this.getControl("std_costcenter");
                if (costCenter != null) {
                    costCenter.setMustInput(true);
                }
                if ((secEntryCostCenter = (BasedataEdit)this.getControl("travelcostcenter")) != null) {
                    secEntryCostCenter.setMustInput(true);
                }
            }
            if ("2".equals(mode)) {
                BasedataEdit costCompany = (BasedataEdit)this.getControl("costcompany");
                costCompany.setMustInput(false);
                BasedataEdit costCenter = (BasedataEdit)this.getControl("std_costcenter");
                costCenter.setMustInput(false);
            }
        }
    }

    protected void hiddenChangeApplier(IFormView view) {
        ShowUserInfoUtils.hiddenChangeApplier((IFormView)view);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "changeapplier": {
                HashMap<String, String> customParam = new HashMap<String, String>();
                customParam.put("showProps", "applierprops");
                FormModel formModel = new FormModel("er_changeapplier", ResManager.loadKDString((String)"\u4e2a\u4eba\u4fe1\u606f", (String)"CoreBaseBillEdit_3", (String)"fi-er-formplugin", (Object[])new Object[0]), "1", true, customParam);
                formModel.setShowType(ShowType.Modal);
                ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
                break;
            }
            case "bar_viewloanrepayment": {
                FormModel formModel = new FormModel("er_loanrepaymentrpt", ResManager.loadKDString((String)"\u501f\u8fd8\u6b3e\u4f59\u989d\u8868", (String)"CoreBaseBillEdit_4", (String)"fi-er-formplugin", (Object[])new Object[0]), "3");
                HashMap customParam = new HashMap();
                formModel.setCustomParam(customParam);
                ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
                break;
            }
            case "creditlevel": {
                DynamicObject applier = (DynamicObject)this.getModel().getValue("applier");
                CreditLevelServiceHelper.showCreditFilesForm((IFormView)this.getView(), (String)String.valueOf(applier.getPkValue()));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        int rowIndex = valueSet[0].getRowIndex();
        if (null != this.pageCache && null != this.pageCache.get("flag")) {
            this.flag = Boolean.parseBoolean(this.pageCache.get("flag"));
        }
        switch (propName) {
            case "applier": {
                int rowCount;
                boolean isloan = (Boolean)model.getValue("isloan");
                if (isloan && (rowCount = model.getEntryRowCount("accountentry")) > 0) {
                    CoreBaseBillServiceHelper.initDefaultAccountEntry((IDataModel)model, (int)0);
                }
                this.applierInfoChange(propName, propValue);
                break;
            }
            case "applierpositionstr": 
            case "tel": {
                this.applierInfoChange(propName, propValue);
                break;
            }
            case "org": {
                this.deptChange((DynamicObject)propValue);
                break;
            }
            case "payer": {
                if (propValue == null) break;
                this.payerChange(rowIndex, (DynamicObject)propValue);
                break;
            }
            case "costdept": {
                if (propValue == null) {
                    propValue = valueSet[0].getOldValue();
                    this.getModel().setValue("costdept", (Object)ErCommonUtils.getPk((Object)valueSet[0].getOldValue()));
                }
                this.costDeptChange(propName, (DynamicObject)propValue);
                break;
            }
            case "entrycostdept": {
                this.entryCostDeptChange((DynamicObject)propValue, rowIndex);
                this.checkExpenseItem((DynamicObject)propValue, rowIndex);
                break;
            }
            case "entrycostcompany": {
                this.entryCostCompany((DynamicObject)propValue, rowIndex);
                break;
            }
            case "payeraccount": {
                ReceiveEntryPlugin.refreshPayerAcount(model, rowIndex, propValue);
                break;
            }
            case "iscurrency": {
                int i;
                DynamicObjectCollection entryEntity;
                String isgetaccountcurrency = "0";
                if (model.getValue("company") != null) {
                    isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((Long)((DynamicObject)model.getValue("company")).getPkValue()));
                }
                if (!"0".equals(isgetaccountcurrency)) break;
                Long currency = ErCommonUtils.getPk((Object)model.getValue("currency"));
                DataEntityPropertyCollection properties = model.getDataEntityType().getProperties();
                if (properties.containsKey((Object)"accountentry") && (entryEntity = model.getEntryEntity("accountentry")) != null && entryEntity.size() > 0) {
                    for (i = 0; i < entryEntity.size(); ++i) {
                        model.setValue("accountcurrency", (Object)currency, i);
                    }
                }
                if (!properties.containsKey((Object)"tripentry") || (entryEntity = model.getEntryEntity("tripentry")) == null || entryEntity.size() <= 0) break;
                for (i = 0; i < entryEntity.size(); ++i) {
                    model.setValue("tripcurrency", (Object)currency, i);
                    this.setExpenseEntryCurrency(model, currency, entryEntity, i);
                }
                this.sumTirpEntryAmount();
                break;
            }
            case "costcompany": {
                if (propValue == null) {
                    this.getModel().setValue(propName, valueSet[0].getOldValue());
                    break;
                }
                DailyBillServiceHelper.refreshCurrency((IFormView)this.getView(), (ChangeData[])valueSet);
                ErCostCenterUtil.headCostCompanyChange((DynamicObject)((DynamicObject)propValue), (IFormView)this.getView());
                this.costCompanyChange((DynamicObject)propValue);
                break;
            }
            case "company": {
                if (propValue == null) {
                    this.getModel().setValue(propName, valueSet[0].getOldValue());
                    break;
                }
                DailyBillServiceHelper.refreshCurrency((IFormView)this.getView(), (ChangeData[])valueSet);
                CoreBaseBillServiceHelper.setBillCostOrgUseMode((IDataModel)model);
                break;
            }
            case "travelcostcompany": {
                if (propValue == null) {
                    Long companyId = (Long)((DynamicObject)this.getModel().getValue("company")).getPkValue();
                    if (!"0".equals(ErCommonUtils.getCostOrgUseMode((Long)companyId))) break;
                    this.getModel().setValue(propName, valueSet[0].getOldValue());
                    break;
                }
                this.travelCostCompanyChange((DynamicObject)propValue, rowIndex);
                break;
            }
            case "travelcostdept": {
                if (propValue == null) {
                    this.getModel().setValue(propName, valueSet[0].getOldValue());
                    break;
                }
                this.travelCostDeptChange((DynamicObject)propValue, rowIndex, valueSet[0].getParentRowIndex());
                break;
            }
            case "istravelers": {
                if (((Boolean)propValue).booleanValue()) break;
                CoreBaseBillServiceHelper.refreshEntryCostOrgByHeadCostOrg((IDataModel)model);
                break;
            }
            case "std_costcenter": {
                if (propValue == null || propValue == "" || !ErCostCenterUtil.isLeafCostCenter((Object)propValue)) break;
                ErCostCenterUtil.costCenterChangeForTrip((IFormView)this.getView(), (Object)propValue);
                break;
            }
            case "std_entrycostcenter": {
                ErCostCenterUtil.costEntryCenterChangeForTripPC((IFormView)this.getView(), (Object)propValue, (int)rowIndex);
                break;
            }
            case "travelcostcenter": {
                ErCostCenterUtil.travelEntryCostCenterChangeForPC((IFormView)this.getView(), (Object)propValue, (int)rowIndex, (int)valueSet[0].getParentRowIndex());
                break;
            }
        }
    }

    protected void sumTirpEntryAmount() {
        BigDecimal entryAmount = BigDecimal.ZERO;
        Boolean isloan = this.getModel().getDataEntity(true).getBoolean("isloan");
        if (isloan.booleanValue()) {
            entryAmount = AmountUtils.getEntryAmount((IDataModel)this.getModel(), (String)"tripentry", (String)"triporiamount");
        } else {
            List entryEntitys = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry").stream().flatMap(tripEntry -> tripEntry.getDynamicObjectCollection("entryentity").stream()).collect(Collectors.toList());
            entryAmount = AmountChangeUtil.sumAmountBy(entryEntitys, (String)"entryamount");
        }
        this.refreshTripAmountLabel(entryAmount);
    }

    protected void refreshTripAmountLabel(BigDecimal amount) {
        this.refreshTripAmountLabel(amount, null);
    }

    protected void refreshTripAmountLabel(BigDecimal amount, BigDecimal appamount) {
        Label tripEntryAppAmountTotalLable;
        IDataModel model = this.getModel();
        Label tripamtlabel = (Label)this.getControl("totaltripamtlabel");
        String currencySign = "";
        int amountPrecition = 4;
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        if (currency != null) {
            currencySign = currency.getString("sign");
            amountPrecition = currency.getInt("amtprecision");
        }
        if (tripamtlabel != null) {
            amount = amount.setScale(amountPrecition, 4);
            String amountStr = AmountFormatsUtil.getLabelAmountAfterFormat((String)currencySign, (BigDecimal)amount, (int)amountPrecition);
            tripamtlabel.setText(amountStr);
        }
        if ((tripEntryAppAmountTotalLable = (Label)this.getControl("totaltripappamtlabel")) != null && appamount != null) {
            appamount = appamount.setScale(amountPrecition, 4);
            String amountStr = AmountFormatsUtil.getLabelAmountAfterFormat((String)currencySign, (BigDecimal)appamount, (int)amountPrecition);
            tripEntryAppAmountTotalLable.setText(amountStr);
        }
    }

    private void setExpenseEntryCurrency(IDataModel model, Object currency, DynamicObjectCollection entryEntity, int i) {
        DynamicObjectCollection expenseEntity = ((DynamicObject)entryEntity.get(i)).getDynamicObjectCollection("entryentity");
        if (expenseEntity != null && expenseEntity.size() > 0) {
            for (int j = 0; j < expenseEntity.size(); ++j) {
                model.setValue("entrycurrency", currency, j, i);
            }
        }
    }

    protected Set<Long> getTripEntryCurrencyCount() {
        IDataModel model = this.getModel();
        HashSet<Long> tripEntryCurrencyIdSet = new HashSet<Long>();
        DynamicObjectCollection tripentrys = model.getEntryEntity("tripentry");
        if (tripentrys != null && tripentrys.size() > 0) {
            for (DynamicObject tripentry : tripentrys) {
                DynamicObject tripEntrycurrency = tripentry.getDynamicObject("tripcurrency");
                if (tripEntrycurrency == null) continue;
                Long tripEntrycurrencyId = (Long)tripEntrycurrency.getPkValue();
                tripEntryCurrencyIdSet.add(tripEntrycurrencyId);
            }
        }
        return tripEntryCurrencyIdSet;
    }

    protected DynamicObject refreshAccCurrency(IDataModel model, Set<Long> tripEntryCurrencyIdSet) {
        int tripEntryCurrencyIdCount = tripEntryCurrencyIdSet.size();
        DynamicObject accCurrency = (DynamicObject)model.getValue("currency");
        int accountentryRowCount = model.getEntryRowCount("accountentry");
        String isgetaccountcurrency = "0";
        if (this.getModel().getValue("company") != null) {
            isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((Long)((DynamicObject)model.getValue("company")).getPkValue()));
        }
        if (accountentryRowCount > 0 && "0".equals(isgetaccountcurrency)) {
            if (tripEntryCurrencyIdCount == 1) {
                DynamicObjectCollection tripentrys = model.getDataEntity(true).getDynamicObjectCollection("tripentry");
                accCurrency = ((DynamicObject)tripentrys.get(0)).getDynamicObject("tripcurrency");
            }
            model.setValue("accountcurrency", (Object)ErCommonUtils.getPk((Object)accCurrency), 0);
            ErCommonUtils.updateView((IFormView)this.getView(), (int)0, (String[])new String[]{"accountcurrency"});
        }
        return accCurrency;
    }

    protected void deptChange(DynamicObject dept) {
        if (dept != null) {
            int showType;
            IDataModel model = this.getModel();
            Long newCompanyId = CoreBaseBillServiceHelper.initCompanyByDept((Long)((Long)dept.getPkValue()));
            if (TripBillTravelerUtils.needRecoverTravels((Long)((Long)((DynamicObject)model.getValue("company")).getPkValue()), (Long)newCompanyId)) {
                TripBillTravelerUtils.initGetTravelerDefaultValue((IDataModel)this.getModel());
            }
            model.setValue("company", (Object)newCompanyId);
            if (newCompanyId != null && (showType = ErCommonUtils.getExpenseAssumeShowTypes((long)newCompanyId)) == 2) {
                DynamicObjectCollection tripEntrys = model.getDataEntity(true).getDynamicObjectCollection("tripentry");
                int entryRowCount = model.getEntryRowCount("tripentry");
                for (int i = 0; i < entryRowCount; ++i) {
                    DynamicObjectCollection entryEntrys;
                    if (!ErEntityTypeUtils.isTripReimburseBill((String)this.getView().getEntityId()) || (entryEntrys = ((DynamicObject)tripEntrys.get(i)).getDynamicObjectCollection("entryentity")) == null || entryEntrys.size() <= 0) continue;
                    for (int j = 0; j < entryEntrys.size(); ++j) {
                        Long quotaDeptId = QuotaCtrlUtil.getQuotaCtrlDeptId((DynamicObject)((DynamicObject)this.getModel().getValue("travelexpenseitem", j, i)), (DynamicObject)((DynamicObject)this.getModel().getValue("travelcostdept", j, i)), (IDataModel)this.getModel());
                        this.getModel().setValue("travelquotactldept", (Object)quotaDeptId, j, i);
                    }
                }
            }
        }
        this.refreshBaseInfoLabel("org", dept);
    }

    protected void checkExpenseItem(DynamicObject costDept, int rowIndex) {
        TempCheckExpenseItemUtils.checkExpenseItemTrip((DynamicObject)costDept, (IDataModel)this.getModel(), (IFormView)this.getView(), (int)rowIndex);
    }

    protected void costDeptChange(String propName, DynamicObject costDept) {
        if (costDept == null) {
            return;
        }
        IDataModel model = this.getModel();
        this.refreshBaseInfoLabel(propName, costDept);
        DynamicObject company = (DynamicObject)model.getValue("company");
        if (company == null) {
            return;
        }
        int showType = ErCommonUtils.getExpenseAssumeShowTypes((long)((Long)company.getPkValue()));
        model.setValue("expensesassumeshowtypes", (Object)String.valueOf(showType));
        boolean isNotRelated = "2".equals(ErStdConfig.get((String)"Costcompany Unbinding")) && showType == 1;
        DynamicObject costCompany = (DynamicObject)model.getValue("costcompany");
        boolean isModeOne = "0".equals(ErCommonUtils.getCostOrgUseMode((Long)((Long)company.getPkValue())));
        if (!isNotRelated && isModeOne) {
            if (showType == 3) {
                if (model.getEntryRowCount("tripentry") > 0) {
                    model.setValue("entrycostdept", (Object)costDept, 0);
                }
                return;
            }
            CostDeptF7ChangePram costDeptF7ChangePram = new CostDeptF7ChangePram(Boolean.TRUE, (Object)costDept, (Object)costCompany, (Object)company);
            Long costCompanyId = CoreBaseBillServiceHelper.getAccountOrgId((CostDeptF7ChangePram)costDeptF7ChangePram);
            model.setValue("costcompany", (Object)costCompanyId);
            costCompany = (DynamicObject)model.getValue("costcompany");
            this.refreshBaseInfoLabel("costcompany", costCompany);
            if (costCompanyId == null || costCompanyId.compareTo(Long.valueOf("0")) == 0) {
                return;
            }
            if (showType == 1) {
                int tripCount = model.getEntryRowCount("tripentry");
                for (int i = 0; i < tripCount; ++i) {
                    DynamicObjectCollection entryEntrys;
                    model.setValue("entrycostcompany", (Object)costCompanyId, i);
                    model.setValue("entrycostdept", (Object)costDept, i);
                    if (!ErEntityTypeUtils.isTripReimburseBill((String)this.getView().getEntityId()) || (entryEntrys = ((DynamicObject)model.getEntryEntity("tripentry").get(i)).getDynamicObjectCollection("entryentity")) == null || entryEntrys.size() <= 0) continue;
                    for (int j = 0; j < entryEntrys.size(); ++j) {
                        model.setValue("travelcostcompany", (Object)costCompanyId, j, i);
                        model.setValue("travelcostdept", (Object)costDept, j, i);
                        Long quotaDeptId = QuotaCtrlUtil.getQuotaCtrlDeptId((DynamicObject)((DynamicObject)this.getModel().getValue("travelexpenseitem", j, i)), (DynamicObject)((DynamicObject)this.getModel().getValue("travelcostdept", j, i)), (IDataModel)this.getModel());
                        this.getModel().setValue("travelquotactldept", (Object)quotaDeptId, j, i);
                    }
                }
            }
        } else {
            int tripCount = model.getEntryRowCount("tripentry");
            for (int i = 0; i < tripCount; ++i) {
                DynamicObjectCollection entryEntrys;
                model.setValue("entrycostcompany", (Object)costCompany, i);
                model.setValue("entrycostdept", (Object)costDept, i);
                if (!ErEntityTypeUtils.isTripReimburseBill((String)this.getView().getEntityId()) || (entryEntrys = ((DynamicObject)model.getEntryEntity("tripentry").get(i)).getDynamicObjectCollection("entryentity")) == null || entryEntrys.size() <= 0) continue;
                for (int j = 0; j < entryEntrys.size(); ++j) {
                    model.setValue("travelcostcompany", (Object)costCompany, j, i);
                    model.setValue("travelcostdept", (Object)costDept, j, i);
                    Long quotaDeptId = QuotaCtrlUtil.getQuotaCtrlDeptId((DynamicObject)((DynamicObject)this.getModel().getValue("travelexpenseitem", j, i)), (DynamicObject)((DynamicObject)this.getModel().getValue("travelcostdept", j, i)), (IDataModel)this.getModel());
                    this.getModel().setValue("travelquotactldept", (Object)quotaDeptId, j, i);
                }
            }
        }
        if (!isModeOne) {
            ErCostCenterUtil.initHeadCostCenter((IFormView)this.getView(), (boolean)true);
        }
    }

    protected void costCompanyChange(DynamicObject cotsCompany) {
        IDataModel model = this.getModel();
        Object company = model.getValue("company");
        if (company == null) {
            return;
        }
        int showType = ErCommonUtils.getExpenseAssumeShowTypes((long)ErCommonUtils.getPk((Object)company));
        if (showType == 1 || showType == 3) {
            DynamicObjectCollection tripEntrys = model.getDataEntity(true).getDynamicObjectCollection("tripentry");
            int entryRowCount = model.getEntryRowCount("tripentry");
            for (int i = 0; i < entryRowCount; ++i) {
                DynamicObjectCollection entryEntrys;
                model.setValue("entrycostcompany", (Object)cotsCompany, i);
                if (!ErEntityTypeUtils.isTripReimburseBill((String)this.getView().getEntityId()) || (entryEntrys = ((DynamicObject)tripEntrys.get(i)).getDynamicObjectCollection("entryentity")) == null || entryEntrys.size() <= 0) continue;
                for (int j = 0; j < entryEntrys.size(); ++j) {
                    model.setValue("travelcostcompany", (Object)cotsCompany, j, i);
                }
            }
        }
    }

    protected void applierInfoChange(String propName, Object propValue) {
        this.refreshBaseInfoLabel(propName, propValue);
    }

    protected void refreshBaseInfoLabel(String propName, Object propValue) {
        String propStr = null;
        if (propValue instanceof DynamicObject) {
            ILocaleString name = ((DynamicObject)propValue).getLocaleString("name");
            propStr = name.getLocaleValue();
        } else if (propValue instanceof String) {
            propStr = (String)propValue;
        }
        Label propControl = (Label)this.getControl(propName + "V");
        if (propControl != null) {
            propControl.setText(propStr);
        }
    }

    protected void payerChange(int rowIndex, DynamicObject payer) {
        String settlementtype;
        IDataModel model = this.getModel();
        model.setValue("payername", payer == null ? null : payer.get("outpayer"), rowIndex);
        DynamicObject payMode = (DynamicObject)model.getValue("paymode", rowIndex);
        if (payMode != null && "0".equals(settlementtype = payMode.getString("settlementtype"))) {
            return;
        }
        model.setValue("payeraccount02", payer == null ? null : payer.get("payeraccount02"), rowIndex);
        model.setValue("payeraccount", payer == null ? null : payer.get("payeraccount"), rowIndex);
        model.setValue("payeraccount01", payer == null ? null : payer.get("payeraccount01"), rowIndex);
        model.setValue("payeraccountname", payer == null ? null : payer.get("payeraccountname"), rowIndex);
        if (payer != null) {
            DynamicObject currency;
            model.setValue("payerbank", (Object)ErCommonUtils.getPk((Object)payer.get("payerbank")), rowIndex);
            Boolean isCurrency = (Boolean)model.getValue("iscurrency");
            if (isCurrency.booleanValue() && (currency = payer.getDynamicObject("CURRENCY")) != null) {
                model.setValue("accountcurrency", currency.getPkValue(), rowIndex);
            }
        } else {
            model.setValue("payerbank", null, rowIndex);
        }
    }

    protected void initUserInfo() {
        IDataModel model = this.getModel();
        String applierStr = null;
        String deptStr = null;
        String applierPicUrl = null;
        String costDeptStr = null;
        String positionStr = null;
        String costCompanyStr = null;
        DynamicObject applier = (DynamicObject)model.getValue("applier");
        DynamicObject dept = (DynamicObject)model.getValue("org");
        positionStr = model.getValue("applierpositionstr").toString();
        DynamicObject costDept = (DynamicObject)model.getValue("costdept");
        DynamicObject costCompany = (DynamicObject)model.getValue("costcompany");
        String telStr = (String)model.getValue("tel");
        if (applier != null) {
            applierStr = applier.getLocaleString("name").getLocaleValue();
            applierPicUrl = ErCommonUtils.getUserImageFullPath((Long)((Long)applier.getPkValue()));
        }
        if (dept != null) {
            deptStr = dept.getLocaleString("name").getLocaleValue();
        }
        if (costDept != null) {
            costDeptStr = costDept.getLocaleString("name").getLocaleValue();
        }
        if (costCompany != null) {
            costCompanyStr = costCompany.getLocaleString("name").getLocaleValue();
        }
        ((Label)this.getControl("applierv")).setText(applierStr);
        ((Label)this.getControl("orgv")).setText(deptStr);
        telStr = this.pageCache.get("newtel") != null ? this.pageCache.get("newtel") : telStr;
        model.setValue("tel", (Object)telStr);
        ((Label)this.getControl("telv")).setText(telStr);
        ((Label)this.getControl("costdeptv")).setText(costDeptStr);
        ((Label)this.getControl("applierpositionv")).setText(positionStr);
        ((Label)this.getControl("costcompanyv")).setText(costCompanyStr);
        Image applierPic = (Image)this.getControl("applierpic");
        applierPic.setUrl(applierPicUrl);
        if (applier != null) {
            String appilerIdStr = String.valueOf(applier.getPkValue());
            String creditlevelStr = CreditLevelServiceHelper.getCreditLevelByUserAndView((Object)appilerIdStr, (IFormView)this.getView());
            if (StringUtils.isEmpty((String)creditlevelStr)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"creditlevel"});
            } else {
                ((Label)this.getControl("creditlevel")).setText(creditlevelStr);
            }
        }
    }

    protected BigDecimal refreshTotalAmount(String entryField, String entryAmountField, String totalAmountField) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        IDataModel model = this.getModel();
        int entryRowCount = model.getEntryRowCount(entryField);
        for (int i = 0; i < entryRowCount; ++i) {
            BigDecimal tripAmount = (BigDecimal)model.getValue(entryAmountField, i);
            totalAmount = totalAmount.add(tripAmount);
        }
        if (totalAmountField != null) {
            model.setValue(totalAmountField, (Object)totalAmount);
        }
        return totalAmount;
    }

    protected void createNewDetailData(IDataModel model) {
        if (this.initAccount()) {
            this.initAccountEntryDefaultData(model);
        }
    }

    protected boolean initAccount() {
        int accRowCount = this.getModel().getEntryRowCount("accountentry");
        String billStatus = "";
        Object statusObj = this.getModel().getValue("billstatus");
        if (statusObj instanceof String) {
            billStatus = (String)statusObj;
        }
        return accRowCount == 0 && (StringUtils.equals((String)"A", (String)billStatus) || StringUtils.equals((String)"D", (String)billStatus));
    }

    protected int initAccountEntryDefaultData(IDataModel model) {
        return CoreBaseBillServiceHelper.initDefaultAccountEntry((IDataModel)model);
    }

    protected void initEntryDefaultData(IDataModel model, int rowIndex) {
        model.setValue("entrycurrency", (Object)ErCommonUtils.getPk((Object)model.getValue("currency")), rowIndex);
        model.setValue("exchangerate", (Object)BigDecimal.ONE, rowIndex);
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        String objectId = eventArgs.getOperateKey();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        IFormView view = this.getView();
        switch (objectId) {
            case "save": 
            case "submit": {
                if (!eventArgs.getOperationResult().isSuccess()) break;
                Object iscopy = null;
                if (customParams != null) {
                    iscopy = customParams.get(ISCOPY);
                }
                if (customParams == null || customParams.get("edit-from-list") == null && (iscopy == null || !Boolean.parseBoolean(iscopy.toString()))) break;
                int tripentryrows = this.getModel().getEntryRowCount("tripentry");
                EntryGrid tripentry = (EntryGrid)this.getControl("tripentry");
                if (tripentryrows <= 0) break;
                tripentry.selectRows(0);
                break;
            }
            case "unsubmit": {
                if (!eventArgs.getOperationResult().isSuccess()) break;
                ((IBillView)view).setBillStatus(BillOperationStatus.EDIT);
                break;
            }
            case "invalidbtn": {
                if (!eventArgs.getOperationResult().isSuccess()) break;
                ((IBillView)view).setBillStatus(BillOperationStatus.AUDIT);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject applier = (DynamicObject)this.getModel().getValue("applier");
        CoreBaseBillServiceHelper.setPayeeF7Filter((ListShowParameter)((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()), (DynamicObject)applier, (List)CoreBaseBillServiceHelper.getMultiReimburserIdCollection((IFormView)this.getView()));
    }

    protected void entryCostCompany(DynamicObject costCompany, int rowIndex) {
        if (costCompany == null) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        if (company != null) {
            int showType = ErCommonUtils.getExpenseAssumeShowTypes((long)((Long)company.getPkValue()));
            if (rowIndex == 0 && showType == 2) {
                model.setValue("costcompany", (Object)costCompany);
            }
        }
    }

    protected void entryCostDeptChange(DynamicObject costDept, int rowIndex) {
        if (costDept == null) {
            return;
        }
        IDataModel model = this.getModel();
        Long costDeptId = (Long)costDept.getPkValue();
        DynamicObject company = (DynamicObject)model.getValue("company");
        DynamicObject costCompany = (DynamicObject)model.getValue("entrycostcompany", rowIndex);
        CostDeptF7ChangePram costDeptF7ChangePram = new CostDeptF7ChangePram(Boolean.TRUE, (Object)costDept, (Object)costCompany, (Object)company);
        Long costCompanyId = CoreBaseBillServiceHelper.getAccountOrgId((CostDeptF7ChangePram)costDeptF7ChangePram);
        if (company != null) {
            int showType = ErCommonUtils.getExpenseAssumeShowTypes((long)((Long)company.getPkValue()));
            if (rowIndex == 0 && showType == 2) {
                model.beginInit();
                model.setValue("costdept", (Object)costDeptId);
                model.endInit();
            } else if (rowIndex == 0 && showType == 3) {
                model.setValue("costdept", (Object)costDeptId);
            }
        }
    }

    protected void travelCostCompanyChange(DynamicObject costCompany, int rowIndex) {
    }

    protected void travelCostDeptChange(DynamicObject costDept, int rowIndex) {
        int parentRowIndex = this.getModel().getEntryCurrentRowIndex("tripentry");
        this.travelCostDeptChange(costDept, rowIndex, parentRowIndex);
    }

    protected void travelCostDeptChange(DynamicObject costDept, int rowIndex, int parentRowIndex) {
        if (costDept == null) {
            return;
        }
        IDataModel model = this.getModel();
        Long costDeptId = (Long)costDept.getPkValue();
        DynamicObject company = (DynamicObject)model.getValue("company");
        String costMode = ErCommonUtils.getCostOrgUseMode((Long)(company == null ? Long.valueOf(0L) : (Long)company.getPkValue()));
        DynamicObject costCompany = (DynamicObject)model.getValue("entrycostcompany", rowIndex, parentRowIndex);
        CostDeptF7ChangePram costDeptF7ChangePram = new CostDeptF7ChangePram(Boolean.TRUE, (Object)costDept, (Object)costCompany, (Object)company);
        int showType = ErCommonUtils.getExpenseAssumeShowTypes((long)ErCommonUtils.getPk((Object)company));
        if (showType != 3) {
            Long costCompanyId = CoreBaseBillServiceHelper.getAccountOrgId((CostDeptF7ChangePram)costDeptF7ChangePram);
            if ("0".equals(costMode)) {
                model.setValue("travelcostcompany", (Object)costCompanyId, rowIndex, parentRowIndex);
            }
        }
        Long quotaDeptId = QuotaCtrlUtil.getQuotaCtrlDeptId((DynamicObject)((DynamicObject)this.getModel().getValue("travelexpenseitem", rowIndex, parentRowIndex)), (DynamicObject)((DynamicObject)this.getModel().getValue("travelcostdept", rowIndex, parentRowIndex)), (IDataModel)this.getModel());
        this.getModel().setValue("travelquotactldept", (Object)quotaDeptId, rowIndex, parentRowIndex);
        if (!"0".equals(costMode)) {
            ErCostCenterUtil.initEntryCostCenter((IDataModel)model, (String)"entryentity", (int)rowIndex, (int)parentRowIndex);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        Object costDept;
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        String showType = CommonServiceHelper.getBillCostOrgShowType((IFormView)this.getView());
        if ("tripentry".equals(entryName)) {
            int[] rowIndexs = e.getRowIndexs();
            int count = this.getModel().getEntryRowCount("tripentry");
            if (count == 0) {
                return;
            }
            for (int row : rowIndexs) {
                if (row != 0) continue;
                Object entrycostcompany = this.getModel().getValue("entrycostcompany", 0);
                costDept = this.getModel().getValue("entrycostdept", 0);
                if (costDept == null) break;
                this.getModel().beginInit();
                this.getModel().setValue("costdept", costDept);
                this.getModel().endInit();
                this.getView().updateView("costdept");
                if (entrycostcompany == null || !org.apache.commons.lang3.StringUtils.equalsAny((CharSequence)showType, (CharSequence[])new CharSequence[]{"2", "3"})) break;
                this.getModel().setValue("costcompany", entrycostcompany);
                break;
            }
        }
        if ("entryentity".equals(entryName)) {
            int[] rowIndexs;
            int tripRowIndex = this.getModel().getEntryCurrentRowIndex("tripentry");
            for (int row : rowIndexs = e.getRowIndexs()) {
                if (row != 0) continue;
                int count = this.getModel().getEntryRowCount("entryentity");
                if (count <= 0 || (costDept = this.getModel().getValue("travelcostdept", 0, tripRowIndex)) == null) break;
                this.travelCostDeptChange((DynamicObject)costDept, 0, tripRowIndex);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("ok".equalsIgnoreCase(messageBoxClosedEvent.getCallBackId())) {
            if (!(this.getView() instanceof ListView)) {
                this.getModel().setDataChanged(false);
            }
            this.getView().close();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        IDataModel model = this.getModel();
        ErDataCheckUtil.recordEntryCount((String)operateKey, (IDataModel)model, (Log)logger);
    }
}

