/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.utils.ErEntityTypeUtils;

public class ErBotpTripCurrencyHandlerFormPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(ErBotpTripCurrencyHandlerFormPlugin.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getModel().getDataEntity().getDataEntityState().isPushChanged() || Boolean.TRUE.equals((Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy"))) {
            Boolean isCurrency = (Boolean)this.getModel().getValue("iscurrency");
            if (!isCurrency.booleanValue()) {
                this.getModel().setDataChanged(false);
                return;
            }
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            String entityId = this.getView().getEntityId();
            if (ErEntityTypeUtils.isTripReimburseBill((String)entityId)) {
                int tripEntryRow = this.getModel().getEntryRowCount("tripentry");
                logger.info("\u5f00\u59cb\u5faa\u73af");
                for (int index = 0; index < tripEntryRow; ++index) {
                    DynamicObject tripCurrency = (DynamicObject)this.getModel().getValue("tripcurrency", index);
                    BigDecimal tripExchangerate = (BigDecimal)this.getModel().getValue("tripexchangerate", index);
                    if (currency == null || tripCurrency == null || currency.getPkValue() == tripCurrency.getPkValue() || tripExchangerate.compareTo(BigDecimal.ONE) == 0) continue;
                    this.buildReimIsPushMap();
                    logger.info("tripexchangerate:0index:" + index + ";");
                    this.getModel().setValue("tripexchangerate", (Object)0, index);
                    this.buildReimIsPushMap();
                    logger.info("tripexchangerate:" + tripExchangerate + "index:" + index + ";");
                    this.getModel().setValue("tripexchangerate", (Object)tripExchangerate, index);
                    DynamicObjectCollection detailEntry = (DynamicObjectCollection)this.getModel().getValue("entryentity", index);
                    for (int detailIndex = 0; detailIndex < detailEntry.size(); ++detailIndex) {
                        this.buildReimIsPushMap();
                        logger.info("exchangerate:" + tripExchangerate + "detailIndex:" + detailIndex + ";index:" + index);
                        this.getModel().setValue("exchangerate", (Object)tripExchangerate, detailIndex, index);
                    }
                    this.RemoveCachedValue();
                }
                logger.info("\u7ed3\u675f\u5faa\u73af");
            }
            this.getModel().setDataChanged(false);
        }
    }

    private void RemoveCachedValue() {
        ThreadCache.remove((Object)"reimIsPushVar");
        ThreadCache.remove((Object)"reimPropertychangedRowmap");
    }

    private void buildReimIsPushMap() {
        Map<String, AtomicInteger> reimPushMap = this.buildPushAtomicIntegerMap();
        ThreadCache.put((Object)"reimIsPushVar", reimPushMap);
        Map<Integer, HashSet<Integer>> buildPushExcutedMap = this.buildPushExcutedMap();
        ThreadCache.put((Object)"reimPropertychangedRowmap", buildPushExcutedMap);
    }

    private Map<String, AtomicInteger> buildPushAtomicIntegerMap() {
        HashMap<String, AtomicInteger> map = new HashMap<String, AtomicInteger>();
        AtomicInteger tripEntrysAtomic = new AtomicInteger(0);
        AtomicInteger tripEntryEntirysAtomic = new AtomicInteger(0);
        AtomicInteger propertyChangedCountAtomic = new AtomicInteger(0);
        AtomicInteger tripEntrysCountAtomic = new AtomicInteger(0);
        AtomicInteger tripEntryEntirysCountAtomic = new AtomicInteger(0);
        map.put("reimTripEntryIndex", tripEntrysAtomic);
        map.put("reimTripEntryentityIndex", tripEntryEntirysAtomic);
        map.put("reimTripEntryInvokeCount", tripEntrysCountAtomic);
        map.put("reimTripEntryentityInvokeCount", tripEntryEntirysCountAtomic);
        map.put("reimPropertyChangedInvokeCount", propertyChangedCountAtomic);
        return map;
    }

    private Map<Integer, HashSet<Integer>> buildPushExcutedMap() {
        HashMap<Integer, HashSet<Integer>> excutedMap = new HashMap<Integer, HashSet<Integer>>();
        return excutedMap;
    }
}

