/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.ConvertUtil;

public class MainpageEmChart
extends AbstractFormPlugin {
    protected HistogramChart customChart = null;
    protected static final List<String> names = new ArrayList<String>();
    protected static final List<BigDecimal> values = new ArrayList<BigDecimal>();

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.fetchData();
        this.paintChart(names, values);
    }

    private void fetchData() {
        QFilter filter = new QFilter("totalamount", "is not null", (Object)"");
        filter.and("totalamount", "!=", (Object)ConvertUtil.getOrderAmountInit());
        filter.and(new QFilter("isapprove", "=", (Object)"0"));
        filter.and(new QFilter("isreimburse", "=", (Object)"0"));
        filter.and(new QFilter("happenddate", "is not null", null));
        filter.and(new QFilter("producttype", "!=", (Object)"2"));
        DynamicObjectCollection orderBills = QueryServiceHelper.query((String)"er_allorderbill", (String)"totalamount,company,company.name", (QFilter[])new QFilter[]{filter});
        if (orderBills == null || orderBills.isEmpty()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flex_quesheng"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap1"});
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flex_quesheng"});
        Map<String, List<DynamicObject>> byCompany = orderBills.parallelStream().collect(Collectors.groupingBy(d -> d.getString("company")));
        ArrayList<String> xName = new ArrayList<String>();
        ArrayList<BigDecimal> yValue = new ArrayList<BigDecimal>();
        for (Map.Entry<String, List<DynamicObject>> entry : byCompany.entrySet()) {
            List<DynamicObject> companys = entry.getValue();
            String expCompanyName = null;
            BigDecimal totalAmount = new BigDecimal(0);
            for (DynamicObject obj : companys) {
                totalAmount = obj.getBigDecimal(0).add(totalAmount);
                expCompanyName = obj.getString(2);
                if (expCompanyName != null) continue;
                expCompanyName = ResManager.loadKDString((String)"\u672a\u540d\u516c\u53f8", (String)"MainpageEmChart_0", (String)"fi-er-formplugin", (Object[])new Object[0]);
            }
            if (totalAmount == null || totalAmount.intValue() <= 0) continue;
            xName.add(expCompanyName);
            yValue.add(totalAmount.setScale(2, 2));
        }
        names.clear();
        values.clear();
        int length = yValue.size() > 11 ? 10 : yValue.size();
        ArrayList<BigDecimal> tmp = new ArrayList<BigDecimal>();
        tmp.addAll(yValue);
        for (int i = 0; i < length; ++i) {
            BigDecimal max = new BigDecimal(0);
            int index = 0;
            for (int j = 0; j < yValue.size(); ++j) {
                if (!(((BigDecimal)tmp.get(j)).subtract(max).doubleValue() > 0.0)) continue;
                index = j;
                max = (BigDecimal)tmp.get(j);
            }
            names.add((String)xName.get(index));
            values.add((BigDecimal)yValue.get(index));
            tmp.set(index, new BigDecimal(0));
        }
    }

    private void paintChart(List<String> xName, List<BigDecimal> yValue) {
        this.customChart = (HistogramChart)this.getControl("expchart");
        this.customChart.clearData();
        this.customChart.setDraggable(true);
        this.customChart.setShowTooltip(true);
        this.customChart.setTitleAlign(XAlign.left, YAlign.top);
        this.customChart.setMargin(Position.left, "30px");
        this.customChart.setMargin(Position.right, "10px");
        BarSeries barSeries = this.customChart.createBarSeries(ResManager.loadKDString((String)"\u7d2f\u8ba1\u91d1\u989d", (String)"MainpageEmChart_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
        if (xName.size() < 5) {
            barSeries.setBarWidth("100");
        } else if (xName.size() < 9) {
            barSeries.setBarWidth("50");
        } else if (xName.size() < 11) {
            barSeries.setBarWidth("45");
        } else {
            barSeries.setBarWidth("4");
        }
        Axis xAxis = this.customChart.createXAxis(ResManager.loadKDString((String)"\u672a\u62a5\u9500\u516c\u53f8", (String)"MainpageEmChart_2", (String)"fi-er-formplugin", (Object[])new Object[0]), AxisType.category);
        HashMap axisLabel = new HashMap();
        xAxis.setPropValue("axisLabel", axisLabel);
        xAxis.setCategorys(xName);
        Axis yAxis = this.customChart.createYAxis(ResManager.loadKDString((String)"\u5355\u4f4d: \u5343\u5143 ", (String)"MainpageEmChart_3", (String)"fi-er-formplugin", (Object[])new Object[0]), AxisType.value);
        barSeries.setColor("#5F8AFF");
        for (BigDecimal amount : yValue) {
            barSeries.addData((Number)amount.divide(new BigDecimal(1000), 2, 2));
        }
        this.setLableStyle(barSeries);
        this.setLinearGradient(barSeries, "#5E80EB", "#83bff6");
        this.setLineColor(xAxis, "#666666");
        this.setLineColor(yAxis, "#666666");
        this.customChart.refresh();
    }

    private void setLableStyle(BarSeries barSeries) {
        Label label = new Label();
        label.setShow(true);
        label.setPosition(Position.top);
        label.setColor("#5F8AFF");
        label.setFormatter("function(itemValue,index){var itemData = itemValue.value;return itemData.toFixed(2).replace(/\\d{1,3}(?=(\\d{3})+(\\.\\d*)?$)/g,'$&,');}");
        barSeries.setLabel(label);
        ArrayList<String> funPath = new ArrayList<String>();
        funPath.add("label");
        funPath.add("normal");
        funPath.add("formatter");
        barSeries.addFuncPath(funPath);
    }

    private void setLinearGradient(BarSeries barSeries, String color1, String color2) {
        ArrayList<String> funPath = new ArrayList<String>();
        funPath.add("itemStyle");
        funPath.add("normal");
        funPath.add("color");
        barSeries.addFuncPath(funPath);
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> normap = new HashMap<String, HashMap<String, String>>();
        map.put("color", "new echarts.graphic.LinearGradient(0, 1, 0, 0, [{\"offset\": 0,\"color\": '" + color1 + "'}, {\"offset\": 1, \"color\": '" + color2 + "'}])");
        normap.put("normal", map);
        barSeries.setPropValue("itemStyle", normap);
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }
}

