/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang.StringUtils;

public class ReimburseBillViewForPayablePlugin
extends AbstractBillPlugIn {
    private static final String KEY_SUBMIT = "submit";
    private static final String OPPARAM_AFTERCONFIRM = "afterconfirm";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView thisView = this.getView();
        String appId = thisView.getFormShowParameter().getAppId();
        if (this.getModel().getValue("company") != null) {
            Long companyId = (Long)((DynamicObject)this.getModel().getValue("company")).getPkValue();
            if (!StringUtils.equalsIgnoreCase((String)"em", (String)appId) || !SystemParamterUtil.isPublicreimToPayable((Long)companyId)) {
                thisView.setVisible(Boolean.valueOf(false), new String[]{"iscrepayableentry"});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operationKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operationKey = operate.getOperateKey()) {
            case "submit": {
                boolean isAfterConfirm = operate.getOption().tryGetVariableValue(OPPARAM_AFTERCONFIRM, new RefObject());
                boolean isHaveToWrite = this.isHaveLoanBillToWriteValidate(isAfterConfirm);
                if (!isHaveToWrite) break;
                args.setCancel(true);
            }
        }
    }

    private boolean isHaveLoanBillToWriteValidate(boolean isAfterConfirm) {
        Long companyId = (Long)((DynamicObject)this.getModel().getValue("company")).getPkValue();
        if (isAfterConfirm || !SystemParamterUtil.isPublicreimToPayable((Long)companyId)) {
            return false;
        }
        boolean isHave = Boolean.FALSE;
        DynamicObject reimBill = this.getModel().getDataEntity();
        Object applierId = reimBill.getDynamicObject("applier").getPkValue();
        DynamicObjectCollection accountEntrys = reimBill.getDynamicObjectCollection("accountentry");
        DynamicObjectCollection writeLoanEntry = reimBill.getDynamicObjectCollection("writeoffmoney");
        if (accountEntrys != null && accountEntrys.size() > 0) {
            ArrayList<Long> sourceBillIdList = new ArrayList<Long>();
            for (DynamicObject writeEntry : writeLoanEntry) {
                String sourceBillId = writeEntry.getString("sourcebillid");
                if (sourceBillId == null) continue;
                sourceBillIdList.add(Long.valueOf(sourceBillId));
            }
            String payerName = ((DynamicObject)accountEntrys.get(0)).getString("payername");
            BigDecimal receivAmount = ((DynamicObject)accountEntrys.get(0)).getBigDecimal("orireceiveamount");
            if (receivAmount.compareTo(BigDecimal.ZERO) == 0) {
                return false;
            }
            QFilter[] qFilters = new QFilter[]{new QFilter("applier", "=", applierId), new QFilter("accountentry.payername", "=", (Object)payerName), new QFilter("balanceamount", ">", (Object)0), new QFilter("billstatus", "=", (Object)"G"), new QFilter("id", "not in", sourceBillIdList)};
            DynamicObjectCollection loanBill = QueryServiceHelper.query((String)"er_dailyloanbill", (String)"id", (QFilter[])qFilters);
            if (loanBill.size() > 0) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(KEY_SUBMIT, (IFormPlugin)this);
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u4eba:%s\u5b58\u5728\u9884\u4ed8\u6b3e\u672a\u51b2\u9500\uff0c\u786e\u8ba4\u662f\u5426\u63d0\u4ea4\uff1f", (String)"ReimburseBillViewForPayablePlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]), payerName), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                return true;
            }
        }
        return isHave;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((String)KEY_SUBMIT, (String)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(OPPARAM_AFTERCONFIRM, "true");
            this.getView().invokeOperation(KEY_SUBMIT, operateOption);
        }
    }
}

