/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.ext.data.idi.formplugin.SmartPanelPlugin;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.TextEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.ErEntityTypeUtils;

public class RelationInfoPlugin
extends SmartPanelPlugin
implements TabSelectListener,
HyperLinkClickListener,
RowClickEventListener {
    public static final String TABAP = "tabap";
    public static final String RELATION_ENTRY = "relationentry";
    public static final String FLOD = "flod";
    public static final String RELATIONTAB = "relationtab";
    public static final String RELATION_USER = "relationuser";
    public static final String RELATION_BILL_NAME = "relationbillname";
    public static final String RELATION_NAME = "relationname";
    public static final String RELATION_BILLNO = "relationbillno";
    public static final String BILL_TAG = "billtag";
    public static final String BILL_ID = "billid";
    private static final Log logger = LogFactory.getLog(RelationInfoPlugin.class);
    private static final int pageSize = 10;

    public void registerListener(EventObject e) {
        Tab tab;
        super.registerListener(e);
        if (ErEntityTypeUtils.isContractBill((String)this.getView().getEntityId())) {
            tab = (Tab)this.getView().getControl(TABAP);
            tab.addTabSelectListener((TabSelectListener)this);
        } else if (ErEntityTypeUtils.isApplyProjectBill((String)this.getView().getEntityId()) || ErEntityTypeUtils.isDailyLoanBill((String)this.getView().getEntityId()) || ErEntityTypeUtils.isDailyApplyBill((String)this.getView().getEntityId())) {
            tab = (Tab)this.getView().getControl("tabap_approvede");
            tab.addTabSelectListener((TabSelectListener)this);
        }
        TextEdit textEdit = (TextEdit)this.getView().getControl(RELATION_BILLNO);
        textEdit.addClickListener((ClickListener)this);
        CardEntry cardEntry = (CardEntry)this.getView().getControl(RELATION_ENTRY);
        cardEntry.addRowClickListener((RowClickEventListener)this);
        cardEntry.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{FLOD});
    }

    public void tabSelected(TabSelectEvent arg0) {
        String key;
        switch (key = arg0.getTabKey()) {
            case "relationtab": {
                this.createRelationEntity("DEFAULT");
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "flod": {
                this.createRelationEntity("ALLINFO");
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        long billId = this.getModel().getDataEntity().getLong("id");
        if (billId == 0L) {
            this.getView().setVisible(Boolean.FALSE, new String[]{RELATIONTAB});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{RELATIONTAB});
        }
    }

    public void createRelationEntity(String showType) {
        AbstractFormDataModel formModel = (AbstractFormDataModel)this.getModel();
        int pageIndex = 1;
        boolean isChanged = formModel.getDataChanged();
        if (showType.equals("ALLINFO")) {
            pageIndex = 40;
        }
        int showSize = 10 * pageIndex;
        formModel.deleteEntryData(RELATION_ENTRY);
        List<Map<String, Object>> list = this.getOtherInfo(showSize);
        if (list.size() > 0) {
            formModel.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField(RELATION_USER, new Object[0]);
            vs.addField(RELATION_BILL_NAME, new Object[0]);
            vs.addField(RELATION_NAME, new Object[0]);
            vs.addField(RELATION_BILLNO, new Object[0]);
            vs.addField(BILL_TAG, new Object[0]);
            vs.addField(BILL_ID, new Object[0]);
            for (int i = 0; i < list.size(); ++i) {
                vs.addRow(list.get(i).values().toArray());
            }
            formModel.batchCreateNewEntryRow(RELATION_ENTRY, vs);
            formModel.endInit();
            this.getView().updateView(RELATION_ENTRY);
        }
        boolean isFlod = showSize > list.size() ? Boolean.FALSE : Boolean.TRUE;
        this.getView().setVisible(Boolean.valueOf(isFlod), new String[]{FLOD});
        if (!isChanged) {
            formModel.setDataChanged(isChanged);
        }
    }

    private List<Map<String, Object>> getOtherInfo(int pageSize) {
        int currentShowSize = 1;
        IDataModel model = this.getModel();
        long billId = (Long)model.getValue("id");
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        LinkedHashMap<String, Object> map = null;
        String dataEntityType = model.getDataEntityType().getName();
        logger.info(String.format("find source and target bill, dataEntityType[%s], billId[%s]", dataEntityType, billId));
        if (StringUtils.isNull((String)dataEntityType) || billId == 0L) {
            return list;
        }
        Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)dataEntityType, (Long[])new Long[]{billId});
        logger.info(String.format("find source bill, dataEntityType[%s], billId[%s], result[%s]", dataEntityType, billId, sourceBills));
        for (Map.Entry entry : sourceBills.entrySet()) {
            String mapKey = (String)entry.getKey();
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)mapKey);
            HashSet mapValue = (HashSet)entry.getValue();
            for (Long billno : mapValue) {
                DynamicObject bill = this.getBillInfo(type.getName(), billno);
                if (!this.canOpenBill(bill)) continue;
                map = new LinkedHashMap<String, Object>();
                DynamicObject creator = bill.getDynamicObject("creator");
                long creatorId = 0L;
                if (creator != null) {
                    creatorId = creator.getLong("id");
                }
                map.put(RELATION_USER, creatorId);
                map.put(RELATION_BILL_NAME, String.format("%1$s\uff1a", type.getDisplayName().toString()));
                map.put(RELATION_NAME, ResManager.loadKDString((String)"\u4e0a\u6e38\u5355\u636e", (String)"RelationInfoPlugin_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                String numPrpo = "";
                DataEntityPropertyCollection proColls = bill.getDataEntityType().getProperties();
                if (null != proColls.get((Object)"billno")) {
                    numPrpo = "billno";
                } else if (null != proColls.get((Object)"number")) {
                    numPrpo = "number";
                } else {
                    return list;
                }
                map.put(RELATION_BILLNO, bill.get(numPrpo));
                map.put(BILL_TAG, mapKey);
                map.put(BILL_ID, billno);
                list.add(map);
                if (currentShowSize == pageSize) {
                    return list;
                }
                ++currentShowSize;
            }
        }
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)dataEntityType, (Long[])new Long[]{billId});
        logger.info(String.format("find target bill, dataEntityType[%s], billId[%s], result[%s]", dataEntityType, billId, targetBills));
        for (Map.Entry entry : targetBills.entrySet()) {
            String mapKey = (String)entry.getKey();
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)mapKey);
            HashSet mapValue = (HashSet)entry.getValue();
            for (Long billno : mapValue) {
                DynamicObject bill = this.getBillInfo(type.getName(), billno);
                if (!this.canOpenBill(bill)) continue;
                map = new LinkedHashMap();
                DynamicObject creator = bill.getDynamicObject("creator");
                long creatorId = 0L;
                if (creator != null) {
                    creatorId = creator.getLong("id");
                }
                map.put(RELATION_USER, creatorId);
                map.put(RELATION_BILL_NAME, String.format("%1$s\uff1a", type.getDisplayName().toString()));
                map.put(RELATION_NAME, ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e", (String)"RelationInfoPlugin_1", (String)"fi-arapcommon", (Object[])new Object[0]));
                map.put(RELATION_BILLNO, bill.get("billno"));
                map.put(BILL_TAG, mapKey);
                map.put(BILL_ID, billno);
                list.add(map);
                if (currentShowSize == pageSize) {
                    return list;
                }
                ++currentShowSize;
            }
        }
        return list;
    }

    private boolean canOpenBill(DynamicObject bill) {
        IDataEntityType billType = bill.getDataEntityType();
        String appId = this.getView().getFormShowParameter().getAppId();
        boolean isFullApp = CommonServiceHelper.isFullApp((String)appId);
        ArrayList billTypeList = Lists.newArrayList((Object[])new String[]{"cas_paybill", "cas_agentpaybill", "fa_engineeringbill", "ap_finapbill", "ap_payapply"});
        if (billType.getName().endsWith("er_loanbill_ds") || "cas_bankjournal".equals(billType.getName())) {
            return false;
        }
        return !isFullApp || !billTypeList.contains(billType.getName());
    }

    private DynamicObject getBillInfo(String dataEntityType, long billId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)billId, (String)dataEntityType);
        return dynamicObject;
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        String key = arg0.getFieldName();
        if (RELATION_BILLNO.equals(key)) {
            this.dealRelation(arg0);
        }
    }

    public void dealRelation(HyperLinkClickEvent evt) {
        int n;
        Control con = (Control)evt.getSource();
        if (RELATION_ENTRY.equals(con.getKey()) && (n = evt.getRowIndex()) > -1) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(RELATION_ENTRY, n);
            String[] str = new String[2];
            if (entryRowEntity != null) {
                if (RELATION_BILLNO.equals(evt.getFieldName())) {
                    str[0] = entryRowEntity.getString(BILL_TAG);
                    str[1] = entryRowEntity.getString(BILL_ID);
                }
                this.showBillForm(str[0], str[1]);
            }
        }
    }

    private void showBillForm(String billtag, String billid) {
        if (StringUtils.isBlank((String)billid)) {
            return;
        }
        BillShowParameter formshowParameter = new BillShowParameter();
        formshowParameter.setBillStatus(BillOperationStatus.EDIT);
        formshowParameter.setStatus(OperationStatus.EDIT);
        formshowParameter.setFormId(billtag);
        formshowParameter.setPkId((Object)billid);
        formshowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)formshowParameter);
    }
}

