/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.mvc.bill.MobileBillView;
import kd.bos.mvc.form.MobileFormView;
import kd.fi.er.business.bean.CostDeptF7ChangePram;
import kd.fi.er.business.reimamountctl.utils.QuotaCtrlUtil;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostCompanyF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostDeptF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeExpenseItemF7SelectListener;
import org.apache.commons.lang3.StringUtils;

public class TripReimMulitExpensePlugin
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.setTravelExpenseItemF7Filter();
        this.setTravelCostDeptF7Filter();
        this.setTravelCostCompanyF7Filter();
    }

    private boolean isPCView() {
        boolean isPCView = false;
        IFormView view = this.getView();
        if (!(view instanceof IMobileView)) {
            isPCView = true;
        }
        return isPCView;
    }

    private boolean isMobView() {
        boolean isMobView = false;
        IFormView view = this.getView();
        if (view instanceof IMobileView) {
            isMobView = true;
        }
        return isMobView;
    }

    private void setTravelCostCompanyF7Filter() {
        BasedataEdit costCompanyF7 = (BasedataEdit)this.getControl("travelcostcompany");
        if (costCompanyF7 == null) {
            return;
        }
        DynamicObject costDept = null;
        if (this.isPCView()) {
            int tripRowCount = this.getModel().getEntryRowCount("tripentry");
            int entryRowCount = this.getModel().getEntryRowCount("entryentity");
            if (tripRowCount < 1 || entryRowCount < 1) {
                return;
            }
            int tripIndex = this.getModel().getEntryCurrentRowIndex("tripentry");
            int entryIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            if (tripIndex < 0 || entryIndex < 0) {
                return;
            }
            costDept = (DynamicObject)this.getModel().getValue("travelcostdept", entryIndex, tripIndex);
        } else {
            costDept = (DynamicObject)this.getModel().getValue("travelcostdept", 0);
        }
        Object company = this.getModel().getValue("company");
        if (costDept != null && company != null) {
            BeforeCostCompanyF7SelectListener beforeCostCompanyF7SelectListener = new BeforeCostCompanyF7SelectListener(ErCommonUtils.getPk((Object)costDept), ErCommonUtils.getPk((Object)company));
            costCompanyF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCompanyF7SelectListener);
        }
    }

    private void setTravelCostDeptF7Filter() {
        BasedataEdit costDeptF7 = (BasedataEdit)this.getControl("travelcostdept");
        if (costDeptF7 != null) {
            IDataModel model = null;
            model = this.isPCView() ? this.getModel() : this.getView().getParentView().getModel();
            BeforeCostDeptF7SelectListener beforeCostDeptF7SelectListener = "er_tripitem_edit_mb".equals(this.getView().getEntityId()) ? new BeforeCostDeptF7SelectListener(this.getView()) : new BeforeCostDeptF7SelectListener(model);
            costDeptF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostDeptF7SelectListener);
        }
    }

    private void setTravelExpenseItemF7Filter() {
        BasedataEdit expenseitemF7 = (BasedataEdit)this.getControl("travelexpenseitem");
        if (expenseitemF7 != null) {
            String number = this.getView().getEntityId();
            if (this.isPCView()) {
                int tripRowCount = this.getModel().getEntryRowCount("tripentry");
                int entryRowCount = this.getModel().getEntryRowCount("entryentity");
                if (tripRowCount < 1 || entryRowCount < 1) {
                    return;
                }
                int tripIndex = this.getModel().getEntryCurrentRowIndex("tripentry");
                int entryIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                if (tripIndex < 0 || entryIndex < 0) {
                    return;
                }
            } else if (this.isMobView()) {
                IFormView view = this.getView();
                if (view instanceof MobileFormView) {
                    number = view.getParentView().getEntityId();
                } else if (view instanceof MobileBillView) {
                    number = view.getEntityId();
                }
            }
            expenseitemF7.addBeforeF7SelectListener((BeforeF7SelectListener)new BeforeExpenseItemF7SelectListener(this.getView(), number, "travelcostdept"));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BasedataEdit headExpenseItemF7 = (BasedataEdit)this.getControl("headexpenseitem");
        if (headExpenseItemF7 != null && Boolean.FALSE.equals(this.getModel().getValue("ismultiexpitem"))) {
            headExpenseItemF7.setMustInput(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowindex = e.getChangeSet()[0].getRowIndex();
        switch (propName) {
            case "ismultiexpitem": {
                BasedataEdit headExpenseItemF7 = (BasedataEdit)this.getControl("headexpenseitem");
                if (Boolean.FALSE.equals(newValue)) {
                    DynamicObject bill = this.getModel().getDataEntity(true);
                    DynamicObject headexpenseitem = bill.getDynamicObject("headexpenseitem");
                    Date headhappendate = bill.getDate("headhappendate");
                    this.setTripEntryColumn("tripexpenseitem", headexpenseitem);
                    this.setTripEntryColumn("triphappendate", headhappendate);
                    this.setTrip2EntryColumn("travelexpenseitem", headexpenseitem);
                    this.setTrip2EntryColumn("travelhappendate", headhappendate);
                    headExpenseItemF7.setMustInput(true);
                    break;
                }
                if (!Boolean.TRUE.equals(newValue)) break;
                headExpenseItemF7.setMustInput(false);
                break;
            }
            case "headexpenseitem": {
                this.setTripEntryColumn("tripexpenseitem", newValue);
                this.setTrip2EntryColumn("travelexpenseitem", newValue);
                break;
            }
            case "headhappendate": {
                this.setTripEntryColumn("triphappendate", newValue);
                this.setTrip2EntryColumn("travelhappendate", newValue);
                break;
            }
            case "travelexpenseitem": {
                if (rowindex == 0 && this.isPCView()) {
                    this.getModel().beginInit();
                    this.getModel().setValue("headexpenseitem", newValue);
                    this.getModel().endInit();
                    this.getView().updateView("headexpenseitem");
                }
            }
            case "travelcostdept": {
                if (this.isPCView()) {
                    int tripRowIndex = this.getModel().getEntryCurrentRowIndex("tripentry");
                    Long quotaDeptId = QuotaCtrlUtil.getQuotaCtrlDeptId((DynamicObject)((DynamicObject)this.getModel().getValue("travelexpenseitem", rowindex, tripRowIndex)), (DynamicObject)((DynamicObject)this.getModel().getValue("travelcostdept", rowindex, tripRowIndex)), (IDataModel)this.getModel());
                    this.getModel().setValue("travelquotactldept", (Object)quotaDeptId, rowindex, tripRowIndex);
                    break;
                }
                Long quotaCtrlDeptId = QuotaCtrlUtil.getQuotaCtrlDeptId((DynamicObject)((DynamicObject)this.getModel().getValue("travelexpenseitem", rowindex)), (DynamicObject)((DynamicObject)this.getModel().getValue("travelcostdept", rowindex)), (IDataModel)this.getModel());
                this.getModel().setValue("travelquotactldept", (Object)quotaCtrlDeptId, rowindex);
                if (!propName.equals("travelcostdept") || newValue == null) break;
                DynamicObject costDept = (DynamicObject)newValue;
                DynamicObject company = (DynamicObject)this.getModel().getValue("company");
                DynamicObject costCompany = (DynamicObject)this.getModel().getValue("travelcostcompany", rowindex);
                CostDeptF7ChangePram costDeptF7ChangePram = new CostDeptF7ChangePram(Boolean.TRUE, (Object)costDept, (Object)costCompany, (Object)company);
                Long costCompanyId = CoreBaseBillServiceHelper.getAccountOrgId((CostDeptF7ChangePram)costDeptF7ChangePram);
                this.getModel().setValue("travelcostcompany", (Object)costCompanyId, rowindex);
                break;
            }
            case "trip2startdate": {
                Date startDate = (Date)newValue;
                if (startDate == null) {
                    return;
                }
                if (this.isPCView()) {
                    int tripRowIndex = this.getModel().getEntryCurrentRowIndex("tripentry");
                    if (this.getModel().getValue("travelhappendate", rowindex, tripRowIndex) != null) break;
                    this.getModel().setValue("travelhappendate", (Object)startDate, rowindex, tripRowIndex);
                    break;
                }
                if (this.getModel().getValue("travelhappendate", rowindex) != null) break;
                this.getModel().setValue("travelhappendate", (Object)startDate, rowindex);
                break;
            }
        }
    }

    private void setTripEntryColumn(String columnName, Object data) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection tripEntrys = dataEntity.getDynamicObjectCollection("tripentry");
        if (tripEntrys == null || tripEntrys.isEmpty()) {
            return;
        }
        for (int i = 0; i < tripEntrys.size(); ++i) {
            this.getModel().setValue(columnName, data, i);
        }
    }

    private void setTrip2EntryColumn(String columnName, Object data) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection tripEntrys = dataEntity.getDynamicObjectCollection("tripentry");
        if (tripEntrys == null || tripEntrys.isEmpty()) {
            return;
        }
        for (int i = 0; i < tripEntrys.size(); ++i) {
            DynamicObject tripEntry = (DynamicObject)tripEntrys.get(i);
            DynamicObjectCollection entryEntrys = tripEntry.getDynamicObjectCollection("entryentity");
            if (entryEntrys == null || entryEntrys.size() <= 0) continue;
            for (int j = 0; j < entryEntrys.size(); ++j) {
                this.getModel().setValue(columnName, data, j, i);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String name = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"entryentity")) {
            IDataModel model = this.getModel();
            DynamicObject bill = model.getDataEntity(true);
            DynamicObject costcompany = bill.getDynamicObject("costcompany");
            DynamicObject costdept = bill.getDynamicObject("costdept");
            Date headhappendate = bill.getDate("headhappendate");
            DynamicObject headexpenseitem = bill.getDynamicObject("headexpenseitem");
            int tripRowIndex = model.getEntryCurrentRowIndex("tripentry");
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            Boolean isCopy = Boolean.valueOf((String)ThreadCache.get((Object)"copyentryentityrow"));
            this.getPageCache().remove("copyentryentityrow");
            for (RowDataEntity row : rowDataEntities) {
                int rowIndex = row.getRowIndex();
                model.setValue("travelcostcompany", (Object)costcompany, rowIndex, tripRowIndex);
                model.setValue("travelcostdept", (Object)costdept, rowIndex, tripRowIndex);
                model.setValue("travelhappendate", (Object)headhappendate, rowIndex, tripRowIndex);
                if (isCopy.booleanValue()) continue;
                model.setValue("travelexpenseitem", (Object)headexpenseitem, rowIndex, tripRowIndex);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"copyentryentityrow")) {
            ThreadCache.put((Object)"copyentryentityrow", (Object)"true");
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        Boolean ismultiexpite = false;
        if (this.getModel().getProperty("ismultiexpitem") != null) {
            ismultiexpite = (Boolean)this.getModel().getValue("ismultiexpitem");
        }
        if (ismultiexpite.booleanValue() && "entryentity".equals(e.getEntryProp().getName())) {
            this.getModel().beginInit();
            this.getModel().setValue("headexpenseitem", this.getModel().getValue("travelexpenseitem", 0, 0));
            this.getModel().endInit();
            this.getView().updateView("headexpenseitem");
        }
    }
}

