/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.trip.dailybiz.TripNotReimbursedOrderUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang.StringUtils;

public class TripReqSelectBillList
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        e.setSpecialDataPermQFilter(null);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String warningStr = this.getNotUsedOrderWarningStrByReq();
        if (StringUtils.isNotBlank((String)warningStr)) {
            evt.setCancel(true);
            this.getView().showTipNotification(warningStr);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String warningStr = this.getNotUsedOrderWarningStrByReq();
        if (StringUtils.isNotBlank((String)warningStr)) {
            args.setCancel(true);
            this.getView().showTipNotification(warningStr);
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        String warningStr = this.getNotUsedOrderWarningStrByReq();
        if (StringUtils.isNotBlank((String)warningStr)) {
            evt.setCancel(true);
            this.getView().showTipNotification(warningStr);
        }
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        super.listRowDoubleClick(evt);
        String warningStr = this.getNotUsedOrderWarningStrByReq();
        if (StringUtils.isNotBlank((String)warningStr)) {
            evt.setCancel(true);
            this.getView().showTipNotification(warningStr);
        }
    }

    private String getNotUsedOrderWarningStrByReq() {
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectBill = list.getSelectedRows();
        IDataModel pModel = this.getView().getParentView().getModel();
        Object company = pModel.getValue("company");
        int reqbilltoreimbursecount = SystemParamterUtil.getloancheckparam((long)ErCommonUtils.getPk((Object)company), (String)"reqbilltoreimbursecount");
        if (reqbilltoreimbursecount > 0) {
            return "";
        }
        List ids = selectBill.stream().map(v -> v.getPrimaryKeyValue()).collect(Collectors.toList());
        StringBuilder orderWarningStr = new StringBuilder();
        ArrayList reqBillIds = new ArrayList();
        ArrayList reqBillNos = new ArrayList();
        DynamicObjectCollection reqBills = QueryServiceHelper.query((String)"er_tripreqbill", (String)"id,billno,company,tripentry.id", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        reqBills.stream().forEach(v -> {
            reqBillIds.add(v.getLong("id"));
            reqBillNos.add(v.getString("billno"));
        });
        List notReimbursedOrderList = TripNotReimbursedOrderUtil.queryNotReimbursedOrdersByReq(reqBillIds, reqBillNos, (Long)ErCommonUtils.getPk((Object)company));
        if (notReimbursedOrderList == null || notReimbursedOrderList.isEmpty()) {
            return orderWarningStr.toString();
        }
        for (DynamicObject orderBill : notReimbursedOrderList) {
            if (TripNotReimbursedOrderUtil.checkAvailableOrder((DynamicObject)orderBill)) continue;
            orderWarningStr.append(orderBill.getString("oabillnum"));
            orderWarningStr.append(ResManager.loadKDString((String)"\u51fa\u5dee\u7533\u8bf7\u5355\u5b58\u5728\u672a\u4f7f\u7528\u7684\u5546\u65c5\u8ba2\u5355\uff0c\u4e0d\u80fd\u8fdb\u884c\u62a5\u9500\uff1b\u5982\u5b9e\u9645\u5df2\u4f7f\u7528\uff0c\u72b6\u6001\u66f4\u65b0\u4f1a\u6709\u5ef6\u8fdf\uff1b", (String)"TripReqSelectBillList_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            orderWarningStr.append("\n");
            orderWarningStr.append(ResManager.loadKDString((String)"\u7cfb\u7edf\u6b63\u5728\u4e3a\u60a8\u81ea\u52a8\u66f4\u65b0\u8ba2\u5355\u4fe1\u606f\uff0c\u8bf7\u7b49\u5f853-5\u79d2\u540e\u5c1d\u8bd5\u91cd\u65b0\u62a5\u9500\uff1b\u82e5\u4ecd\u62a5\u9500\u5931\u8d25\uff0c\u8bf7\u7b49\u5f851-2\u5929\u540e\u91cd\u8bd5\u3002", (String)"TripReqSelectBillList_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            break;
        }
        return orderWarningStr.toString();
    }
}

