/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.projectcostshare;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.utils.SystemParamterUtil;

public class ReimbursementList
extends AbstractListPlugin {
    private static final String RELATIONPUSH = "relationpush";
    private static final String BAR_PUSHPAYABLEBILL = "bar_pushpayablebill";
    private static final String BAR_PUSHPURCHASE = "bar_pushpurchase";
    private static final String BAR_ENGINEERINGBILL = "bar_engineeringbill";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{RELATIONPUSH});
        this.addItemClickListeners(new String[]{BAR_PUSHPAYABLEBILL});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "relationpush": {
                this.checkIsEnableShare(evt);
                break;
            }
            case "bar_pushpayablebill": {
                this.checkIsEnablePay(evt);
                break;
            }
            case "bar_pushpurchase": 
            case "bar_engineeringbill": {
                this.checkIsEnableToPurchaseBill(evt);
            }
        }
    }

    private void checkIsEnableToPurchaseBill(BeforeItemClickEvent evt) {
        List<Long> companyIds = this.getSelectCompanyIds();
        boolean isToPurchasebill = companyIds.stream().allMatch(SystemParamterUtil::isToPurchasebill);
        if (!isToPurchasebill) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u542f\u7528\u7cfb\u7edf\u53c2\u6570\u201c\u751f\u6210\u56fa\u5b9a\u8d44\u4ea7\u5355\u636e\u201d\u3002", (String)"ReimbursementList_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    private void checkIsEnableShare(BeforeItemClickEvent evt) {
        List<Long> companyIds = this.getSelectCompanyIds();
        boolean isAllEnable = ReimbursementList.getIsAllEnableProShare(companyIds);
        if (!isAllEnable) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u542f\u7528\u751f\u6210\u9879\u76ee\u6210\u672c\u5206\u644a\u53c2\u6570\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ReimbursementList_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    private void checkIsEnablePay(BeforeItemClickEvent evt) {
        List<Long> companyIds = this.getSelectCompanyIds();
        boolean isAllEnable = ReimbursementList.getIsAllEnablePushFiBill(companyIds);
        if (!isAllEnable) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5c06\u7cfb\u7edf\u53c2\u6570\u201c\u5bf9\u516c\u62a5\u9500\u5355\u751f\u6210\u5e94\u4ed8\u5355\u201d\u8bbe\u7f6e\u4e3a\u201c\u662f\u201d\uff0c\u7136\u540e\u8fdb\u884c\u5bf9\u516c\u62a5\u9500\u5355\u751f\u6210\u5e94\u4ed8\u5355\u64cd\u4f5c\u3002", (String)"ReimbursementList_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    private List<Long> getSelectCompanyIds() {
        IListView listView = (IListView)this.getView();
        String entityName = listView.getListModel().getEntityId();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        ArrayList<String> billNos = new ArrayList<String>(selectedRows.size());
        for (ListSelectedRow selectedRow : selectedRows) {
            billNos.add(selectedRow.getBillNo());
        }
        QFilter qf = new QFilter("billno", "in", billNos);
        DynamicObjectCollection pubreimBills = QueryServiceHelper.query((String)entityName, (String)"id,company", (QFilter[])new QFilter[]{qf});
        ArrayList<Long> companyIds = new ArrayList<Long>(pubreimBills.size());
        for (DynamicObject pubreimBill : pubreimBills) {
            if (pubreimBill.get("company") == null) continue;
            String company = pubreimBill.get("company").toString();
            companyIds.add(Long.parseLong(company));
        }
        return companyIds;
    }

    private static boolean getIsAllEnableProShare(List<Long> companyIds) {
        boolean isAllEnable = false;
        for (Long companyId : companyIds) {
            boolean isEnable = SystemParamterUtil.isEnableProjectShare((long)companyId);
            isAllEnable = isEnable || isAllEnable;
        }
        return isAllEnable;
    }

    private static boolean getIsAllEnablePushFiBill(List<Long> companyIds) {
        boolean isAllEnable = false;
        for (Long companyId : companyIds) {
            boolean isEnable = SystemParamterUtil.isEnablePushFinapbill((long)companyId);
            isAllEnable = isEnable || isAllEnable;
        }
        return isAllEnable;
    }
}

