/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripstandard;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.DailyBillServiceHelper;
import kd.fi.er.business.tripstd.context.StdPreCalContext;
import kd.fi.er.business.tripstd.context.data.DepCompanyObj;
import kd.fi.er.business.tripstd.context.data.IncludeEmployeeObj;
import kd.fi.er.business.tripstd.context.data.UserComReimLevelObj;
import kd.fi.er.business.tripstd.context.data.UserDynamicObj;
import kd.fi.er.business.tripstd.model.TripStandardDetail;
import kd.fi.er.business.tripstd.service.IErTripStdService;
import kd.fi.er.business.tripstd.service.imp.ErTripStdServiceImp;
import kd.fi.er.business.tripstd.service.imp.ErTripStdServiceProxy;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.CalculateTripSumUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.TripHighSeasonStandardUtil;
import kd.fi.er.business.utils.TripStandardCheckUtil;
import kd.fi.er.common.ControlMethodEnum;
import kd.fi.er.common.ErBillStatusEnum;
import kd.fi.er.common.SettlementTypeEnum;
import kd.fi.er.common.constant.ErTripExpenseItemConstant;
import kd.fi.er.common.constant.formproperties.mainbill.trip.TripReimburseBill;
import kd.fi.er.common.type.SubsidiesDayParamEnum;
import kd.fi.er.formplugin.web.tripstandard.BeforeMulSeatgradeF7SelectListener;
import kd.fi.er.formplugin.web.tripstandard.util.TripStandardUtils;
import kd.fi.er.formplugin.web.tripstandard.util.TripVehicleStandardUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractTripStdCtrlPlugin
extends AbstractBillPlugIn {
    private static Log logger = LogFactory.getLog(AbstractTripStdCtrlPlugin.class);
    private static final String OP_SUBMIT = "submit";
    private static final String OP_SAVE = "save";
    private static final String CONFIRM_AFTERSTDVALIDATE = "afterStdVdConfirm";
    private static final String TRIPEXP_CTRLTYPE = "ctrltype";
    protected static final String TRIPEXP_ATTRIBUTE = "attribute";
    protected static String EXPENSE_ITEM_SUBSIDY = "1";
    protected static final String EXPENSE_ITEM_ACCOMMODATION = "5";
    protected static final String[] ACCD_ALLOWANCE_ATTRIBUTE = new String[]{"5", "1"};
    protected static final String[] VEHIC_ATTRIBUTE = new String[]{"2", "4", "7"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit mulSeatGrade = (BasedataEdit)this.getView().getControl("mulseatgrade");
        if (mulSeatGrade != null) {
            mulSeatGrade.addBeforeF7SelectListener((BeforeF7SelectListener)new BeforeMulSeatgradeF7SelectListener("entryentity", "expenseitem"));
        }
    }

    public void afterCopyData(EventObject e) {
        this.setStdControlFieldOnBillHead();
        this.refreshAllCalDayCount();
        this.updateAllStd(true, true);
    }

    public void afterCreateNewData(EventObject e) {
        this.setStdControlFieldOnBillHead();
        this.updateAllStd(false, false);
    }

    public void afterLoadData(EventObject e) {
        this.setStdControlFieldOnBillHead();
        this.updateAllStd(false, false);
    }

    public void afterBindData(EventObject e) {
        String formId;
        super.afterBindData(e);
        if (this.getModel().getDataEntity().getDataEntityState().isPushChanged()) {
            IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            if (parentView != null && parentView.getPageCache().get("viewTripIndex") != null) {
                ActionLocalCache.get().put("isDeleteEntryEntity", (Object)true);
            }
            this.setStdControlFieldOnBillHead();
            this.getModel().updateCache();
            boolean firstCalDayCount = Boolean.TRUE;
            if (this.getPageCache().get("firstCalDayCount") != null) {
                firstCalDayCount = Boolean.parseBoolean(this.getPageCache().get("firstCalDayCount"));
            }
            if (parentView != null && parentView.getPageCache().get("firstCalDayCount") != null) {
                firstCalDayCount = Boolean.parseBoolean(this.getPageCache().get("firstCalDayCount"));
            }
            if (firstCalDayCount) {
                this.refreshAllCalDayCount();
            }
            this.getPageCache().put("firstCalDayCount", "false");
            this.refreshAllHighSeasonDay();
            this.updateAllStd(true, true);
        }
        String billstatus = (String)this.getModel().getValue("billstatus");
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        if ("A".equalsIgnoreCase(billstatus) && null != billShowParameter.getBillStatus() && billShowParameter.getBillStatus().equals((Object)BillOperationStatus.EDIT)) {
            DynamicObjectCollection tripEntryCollction = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
            for (int tripEntryIndex = 0; tripEntryIndex < tripEntryCollction.size(); ++tripEntryIndex) {
                DynamicObject tripEntry = (DynamicObject)tripEntryCollction.get(tripEntryIndex);
                DynamicObjectCollection detailEntryCollction = tripEntry.getDynamicObjectCollection("entryentity");
                for (int detailEntryIndex = 0; detailEntryIndex < detailEntryCollction.size(); ++detailEntryIndex) {
                    this.getPageCache().put("isafterbinddata", "true");
                    this.calculateAllowanceAndSet(detailEntryIndex, tripEntryIndex);
                }
            }
        }
        if (!StringUtils.equals((CharSequence)(formId = this.getView().getFormShowParameter().getFormId()), (CharSequence)"er_tripreimconsumer_mb")) {
            this.checkIsTravelers();
        }
    }

    protected void checkIsTravelers() {
        if (!"A".equals(this.getModel().getValue("billstatus"))) {
            return;
        }
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObjectCollection tripEntryCollction = this.getModel().getEntryEntity("tripentry");
        Optional<Boolean> ite = tripEntryCollction.stream().map(it -> it.getDynamicObjectCollection("entryentity").stream().anyMatch(dynamicObject -> SettlementTypeEnum.MONTH_SETTLEMENT.getCode().equals(dynamicObject.get("settlementtype")) && dynamicObject.get("entrycurrency") != null && !dynamicObject.getDynamicObject("entrycurrency").getPkValue().equals(currency.getPkValue()))).filter(b -> b.equals(Boolean.TRUE)).findFirst();
        if (ite.isPresent() && ite.get().booleanValue()) {
            this.getPageCache().put("AbstractTripStdCtrlPlugin-iscurrency-settlementtype", "true");
            this.getModel().beginInit();
            this.getModel().setValue("iscurrency", (Object)true);
            this.getModel().endInit();
            this.getView().updateView("iscurrency");
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"iscurrency"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"iscurrency"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (OP_SUBMIT.equals(operateKey)) {
            TripStandardUtils.threadLocal.set("AbstractTripStdCtrlPlugin-submit-" + this.getModel().getValue("billno"));
            ActionLocalCache.get().put("isDeleteEntryEntity", (Object)true);
            this.updateAllStd(false, false);
            this.getView().updateView("tripentry");
            TripStandardUtils.threadLocal.remove();
        }
        switch (operateKey) {
            case "save": 
            case "submit": {
                boolean isHaveOver = this.isHaveStdOverEntry();
                if (isHaveOver && StringUtils.equals((CharSequence)operateKey, (CharSequence)OP_SUBMIT) && !args.isCancel()) {
                    args.setCancel(!this.confirmValidateStdBeforeOp(operate, ResManager.loadKDString((String)"\u8d85\u6807\uff0c\u662f\u5426\u786e\u8ba4\u63d0\u4ea4\uff1f", (String)"AbstractTripStdCtrlForGridStylePlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0])));
                }
                this.getModel().setValue("stdover", (Object)isHaveOver);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        this.checkIsTravelers();
        if (!this.isOpenTripDateControl()) {
            return;
        }
        String billTypeNumber = ((DynamicObject)this.getModel().getValue("stdbilltype")).getString("number");
        if (StringUtils.equals((CharSequence)"er_tripreimbursebill_BT_CLS", (CharSequence)billTypeNumber) && StringUtils.equals((CharSequence)"tripentry", (CharSequence)entryName) || StringUtils.equals((CharSequence)"er_tripreimbursebill_BT_S", (CharSequence)billTypeNumber) && StringUtils.equals((CharSequence)"entryentity", (CharSequence)entryName)) {
            this.refreshAllCalDayCount();
        }
    }

    protected boolean confirmValidateStdBeforeOp(FormOperate operate, String stdOverConfirmTip) {
        StdConfirm stdConfirm = this.getConfirmMessageForStd();
        boolean allow = true;
        boolean isNeedConfirm = stdConfirm.isNeedConfirm();
        if (isNeedConfirm) {
            RefObject afterConfirm = new RefObject();
            if (!operate.getOption().tryGetVariableValue(CONFIRM_AFTERSTDVALIDATE, afterConfirm)) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(OP_SUBMIT, (IFormPlugin)this);
                String confirmTip = stdConfirm.getConfirmMessage();
                if (stdConfirm.isAppendSuffix()) {
                    confirmTip = confirmTip + stdOverConfirmTip;
                }
                this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                allow = false;
            }
        }
        return allow;
    }

    protected boolean isHaveStdOverEntry() {
        boolean isHave = false;
        DynamicObjectCollection tripEntryColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
        for (DynamicObject tripEntry : tripEntryColl) {
            DynamicObject detailEntry;
            String isOver;
            DynamicObjectCollection detailEntryColl = tripEntry.getDynamicObjectCollection("entryentity");
            Iterator iterator = detailEntryColl.iterator();
            while (iterator.hasNext() && !(isHave = StringUtils.equals((CharSequence)(isOver = (detailEntry = (DynamicObject)iterator.next()).getString("isover")), (CharSequence)"1"))) {
            }
            if (!isHave) continue;
            break;
        }
        return isHave;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)OP_SUBMIT, (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(CONFIRM_AFTERSTDVALIDATE, "true");
                this.getView().invokeOperation(OP_SUBMIT, operateOption);
            }
        } else if (StringUtils.equals((CharSequence)OP_SAVE, (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(CONFIRM_AFTERSTDVALIDATE, "true");
                this.getView().invokeOperation(OP_SAVE, operateOption);
            }
        } else if (StringUtils.equals((CharSequence)"istravelerchange", (CharSequence)messageBoxClosedEvent.getCallBackId()) || StringUtils.equals((CharSequence)"istravelerchangeStd", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.refreshAllCalDayCount();
                int focusRow = ((EntryGrid)this.getView().getControl("tripentry")).getEntryState().getFocusRow();
                if (focusRow != -1) {
                    this.getModel().setEntryCurrentRowIndex("tripentry", focusRow);
                    DynamicObjectCollection detailEntry = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry").get(focusRow)).getDynamicObjectCollection("entryentity");
                    IntStream.range(0, detailEntry.size()).forEach(idx -> this.getView().updateView("entryentity", idx, focusRow));
                }
                return;
            }
            this.getPageCache().put("istravelersreverse", JSONObject.toJSONString((Object)Boolean.TRUE));
            if (StringUtils.equals((CharSequence)"istravelerchange", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
                this.getModel().setValue("istravelers", (Object)((Boolean)this.getModel().getValue("istravelers") == false ? 1 : 0));
            } else {
                this.getModel().setValue("travelerssamestd", (Object)((Boolean)this.getModel().getValue("travelerssamestd") == false ? 1 : 0));
            }
        }
    }

    private StdConfirm getConfirmMessageForStd() {
        int length;
        boolean isNeedConfirm = false;
        StringBuilder message = new StringBuilder();
        Long companyId = this.getCompanyId();
        boolean appendSuffix = true;
        ControlMethodEnum accStdCtrlEnum = SystemParamterUtil.getTripStandardControlLevel((long)companyId);
        ControlMethodEnum vhcStdCtrlEnum = SystemParamterUtil.getVehicleStdControlLevel((long)companyId);
        if (ControlMethodEnum.TIP_CONTROL == accStdCtrlEnum || ControlMethodEnum.TIP_CONTROL == vhcStdCtrlEnum) {
            DynamicObjectCollection tripEntryColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
            int i = 0;
            for (DynamicObject tripEntry : tripEntryColl) {
                List<DynamicObject> vehicDtailEntryList;
                int j;
                boolean isOverBool;
                String isOver;
                List<DynamicObject> accDtailEntryList;
                ++i;
                DynamicObjectCollection detailEntryColl = tripEntry.getDynamicObjectCollection("entryentity");
                Map<String, List<DynamicObject>> groupDetailMap = this.groupDetailEntryByAttribute(detailEntryColl);
                if (ControlMethodEnum.TIP_CONTROL == accStdCtrlEnum && (accDtailEntryList = groupDetailMap.get(Arrays.asList(ACCD_ALLOWANCE_ATTRIBUTE).toString())) != null) {
                    for (DynamicObject detailEntry : accDtailEntryList) {
                        isOver = detailEntry.getString("isover");
                        isOverBool = StringUtils.equals((CharSequence)isOver, (CharSequence)"1");
                        if (!isOverBool) continue;
                        isNeedConfirm = isNeedConfirm || isOverBool;
                        j = detailEntryColl.indexOf((Object)detailEntry) + 1;
                        message.append(this.makeUpTipNumbers(j, i));
                        if (TripStandardCheckUtil.checkTripArea((DynamicObject)detailEntry)) {
                            message.append(String.format(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u51fa\u5dee\u5730\u57df\u201d\u3002", (String)"AbstractTripStdCtrlForGridStylePlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]), new Object[0]));
                            appendSuffix = false;
                            continue;
                        }
                        message.append(String.format(ResManager.loadKDString((String)"\u62a5\u9500\u91d1\u989d\uff0c", (String)"AbstractTripStdCtrlForGridStylePlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]), new Object[0]));
                    }
                }
                if (ControlMethodEnum.TIP_CONTROL != vhcStdCtrlEnum || (vehicDtailEntryList = groupDetailMap.get(Arrays.asList(VEHIC_ATTRIBUTE).toString())) == null) continue;
                for (DynamicObject detailEntry : vehicDtailEntryList) {
                    isOver = detailEntry.getString("isover");
                    isOverBool = StringUtils.equals((CharSequence)isOver, (CharSequence)"1");
                    if (!isOverBool) continue;
                    isNeedConfirm = isNeedConfirm || isOverBool;
                    j = detailEntryColl.indexOf((Object)detailEntry) + 1;
                    message.append(this.makeUpTipNumbers(j, i));
                    message.append(ResManager.loadKDString((String)"\u5ea7\u4f4d\u7b49\u7ea7", (String)"AbstractTripStdCtrlForGridStylePlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    appendSuffix = true;
                    message.append("\uff0c");
                }
            }
        }
        if ((length = message.length()) > 0 && message.lastIndexOf("\uff0c") == length - 1) {
            message.deleteCharAt(length - 1);
        }
        StdConfirm confirm = new StdConfirm(isNeedConfirm, message.toString(), appendSuffix);
        return confirm;
    }

    private Map<String, List<DynamicObject>> groupDetailEntryByAttribute(DynamicObjectCollection detailEntryColl) {
        HashMap<String, List<DynamicObject>> resultMap = new HashMap<String, List<DynamicObject>>();
        List<String> accAttributeList = Arrays.asList(ACCD_ALLOWANCE_ATTRIBUTE);
        List<String> vehicAttributeList = Arrays.asList(VEHIC_ATTRIBUTE);
        for (DynamicObject detailEntry : detailEntryColl) {
            DynamicObject tripExp = detailEntry.getDynamicObject("expenseitem");
            if (tripExp == null) continue;
            String attribute = tripExp.getString(TRIPEXP_ATTRIBUTE);
            if (accAttributeList.contains(attribute)) {
                ArrayList<DynamicObject> accDtailEntryList = (ArrayList<DynamicObject>)resultMap.get(accAttributeList.toString());
                if (accDtailEntryList == null) {
                    accDtailEntryList = new ArrayList<DynamicObject>();
                }
                accDtailEntryList.add(detailEntry);
                resultMap.put(accAttributeList.toString(), accDtailEntryList);
                continue;
            }
            if (!vehicAttributeList.contains(attribute)) continue;
            ArrayList<DynamicObject> vehicDtailEntryList = (ArrayList<DynamicObject>)resultMap.get(vehicAttributeList.toString());
            if (vehicDtailEntryList == null) {
                vehicDtailEntryList = new ArrayList<DynamicObject>();
            }
            vehicDtailEntryList.add(detailEntry);
            resultMap.put(vehicAttributeList.toString(), vehicDtailEntryList);
        }
        return resultMap;
    }

    private void setStdControlFieldOnBillHead() {
        IDataModel model = this.getModel();
        boolean dataChange = model.getDataChanged();
        Long companyId = this.getCompanyId();
        boolean isOpenTripStd = SystemParamterUtil.isEnableTripStandard((Long)companyId);
        boolean isOpenHighSeasonTripStd = SystemParamterUtil.isEnableHighSeasonTripStandard((Long)companyId);
        ControlMethodEnum accStdCtrlEnum = SystemParamterUtil.getTripStandardControlLevel((long)companyId);
        ControlMethodEnum vhcStdCtrlEnum = SystemParamterUtil.getVehicleStdControlLevel((long)companyId);
        logger.info("\u4f4f\u5bbf\u8865\u52a9\u63a7\u5236\u7ea7\u522b: " + accStdCtrlEnum + ", \u4ea4\u901a\u5de5\u5177\u63a7\u5236\u7ea7\u522b: " + vhcStdCtrlEnum);
        if (ControlMethodEnum.NO_CONTROL == accStdCtrlEnum) {
            model.setValue("tripstandcon", (Object)Boolean.FALSE);
        } else {
            model.setValue("tripstandcon", (Object)Boolean.TRUE);
        }
        if (ControlMethodEnum.NO_CONTROL == vhcStdCtrlEnum) {
            model.setValue("isnoctrltripvhcctrlv", (Object)Boolean.FALSE);
        } else {
            model.setValue("isnoctrltripvhcctrlv", (Object)Boolean.TRUE);
        }
        model.setValue("isopentripstd", (Object)isOpenTripStd);
        model.setValue("isopenhighseasontripstd", (Object)isOpenHighSeasonTripStd);
        String mulTraStdCtrType = SystemParamterUtil.getMultiTravelerStdControlType((long)companyId);
        logger.info(String.format(ResManager.loadKDString((String)"\u8ba2\u5355\u53f7\uff1a%1$s\uff0c\u542f\u7528\u5dee\u65c5\u6807\u51c6\uff1a%2$s\uff0c\u4f4f\u5bbf\u8865\u52a9\u63a7\u5236\u7ea7\u522b\uff1a%3$s\uff0c\u4ea4\u901a\u5de5\u5177\u63a7\u5236\u7ea7\u522b\uff1a%4$s\uff0c\u542f\u7528\u65fa\u5b63\u5dee\u65c5\u6807\u51c6\uff1a%5$s\uff0c\u591a\u51fa\u5dee\u4eba\uff1a%6$s\u3002", (String)"AbstractTripStdCtrlPlugin_11", (String)"fi-er-formplugin", (Object[])new Object[0]), this.getModel().getValue("billno"), isOpenTripStd, accStdCtrlEnum.getValue(), vhcStdCtrlEnum.getValue(), isOpenHighSeasonTripStd, mulTraStdCtrType));
        model.setValue("trippartneraccstdtype", (Object)mulTraStdCtrType);
        model.setDataChanged(dataChange);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        int parentIndex = e.getChangeSet()[0].getParentRowIndex();
        IDataModel model = this.getModel();
        switch (propName) {
            case "company": {
                this.setStdControlFieldOnBillHead();
                this.refreshAllDetailEntryTripArea();
                this.refreshAllCalDayCount();
                this.updateAllStd(true, true);
                this.getView().updateView("tripentry");
                break;
            }
            case "trip2to": {
                Long companyId = this.getCompanyId();
                DynamicObjectCollection tripEntryCollction = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
                DynamicObject oldTripArea = ((DynamicObject)((DynamicObject)tripEntryCollction.get(parentIndex)).getDynamicObjectCollection("entryentity").get(rowIndex)).getDynamicObject("triparea");
                Object oldPkValue = oldTripArea == null ? null : oldTripArea.getPkValue();
                this.setDetailEntryTripArea(rowIndex, parentIndex, newValue, companyId, oldPkValue);
                break;
            }
            case "expenseitem": {
                if (newValue != null && oldValue != null && ErCommonUtils.getPk((Object)oldValue).longValue() == ErCommonUtils.getPk((Object)newValue).longValue()) {
                    return;
                }
                this.getModel().beginInit();
                this.refreshSeatGradeByTripExpItemChange(oldValue, newValue, parentIndex, rowIndex);
                this.updateCalDayCount(parentIndex, rowIndex);
                this.getModel().setEntryCurrentRowIndex("tripentry", parentIndex);
                this.getView().updateView("mulseatgrade", rowIndex);
                this.getView().updateView("caldaycount", rowIndex);
                this.getModel().endInit();
                this.upDateLastIndexCalDayCount(rowIndex, parentIndex, (DynamicObject)newValue);
                this.upDateLastIndexCalDayCount(rowIndex, parentIndex, (DynamicObject)oldValue);
                this.calcuHighSeasonDay(rowIndex, parentIndex, true, this.getTripDelayDay(parentIndex, rowIndex, this.getCompanyId()));
                this.entryPropertyUpdateStd(parentIndex, rowIndex);
                break;
            }
            case "entrycurrency": {
                this.entryPropertyUpdateStd(parentIndex, rowIndex);
                break;
            }
            case "triparea": {
                this.calcuHighSeasonDay(rowIndex, parentIndex, true, this.getTripDelayDay(parentIndex, rowIndex, this.getCompanyId()));
                this.entryPropertyUpdateStd(parentIndex, rowIndex);
                break;
            }
            case "trip2travelers": {
                this.entryPropertyUpdateStd(parentIndex, rowIndex);
                break;
            }
            case "caldaycount": {
                boolean caldaycountchange;
                BigDecimal calDayCount = this.calDayCount(parentIndex, rowIndex);
                if (((BigDecimal)newValue).compareTo(calDayCount) > 0 && !(caldaycountchange = SystemParamterUtil.isCalDayCountChange((Long)this.getCompanyId()))) {
                    model.setValue("caldaycount", oldValue, rowIndex, parentIndex);
                    return;
                }
                model.beginInit();
                if (TripHighSeasonStandardUtil.checkAndSetHighSeasonDay((IDataModel)this.getModel(), (int)rowIndex, (int)parentIndex)) {
                    this.getView().updateView("highseasondaycount", rowIndex, parentIndex);
                }
                model.endInit();
                boolean check = this.calculateAllowanceAndSet(rowIndex, parentIndex);
                if (this.validateIsOverMaxCalDayCount(newValue, parentIndex, rowIndex) || check) break;
                this.checkEntryStdIsOver(parentIndex, rowIndex);
                CalculateTripSumUtil.setTripOver((DynamicObject)this.getModel().getDataEntity(true), (IFormView)this.getView(), (int)parentIndex);
                break;
            }
            case "highseasondaycount": {
                this.getModel().beginInit();
                boolean flag = TripHighSeasonStandardUtil.checkAndSetHighSeasonDays((IFormView)this.getView(), (IDataModel)this.getModel(), (int)rowIndex, (int)parentIndex, (BigDecimal)((BigDecimal)oldValue));
                if (flag) {
                    this.getView().updateView("highseasondaycount", rowIndex);
                }
                this.getModel().endInit();
                if (this.isOpenHighSeasonStd() && this.calculateAllowanceAndSet(rowIndex, parentIndex)) break;
                this.checkEntryStdIsOver(parentIndex, rowIndex);
                break;
            }
            case "mulseatgrade": 
            case "orientryamount": 
            case "daycount": {
                this.checkEntryStdIsOver(parentIndex, rowIndex);
                break;
            }
            case "isover": {
                if (!"0".equals(newValue)) break;
                this.getModel().setValue("overdesc", (Object)"", rowIndex, parentIndex);
                break;
            }
            case "enddate": {
                if (!this.isOpenTripDateControl()) {
                    return;
                }
                DynamicObjectCollection tripEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
                if (rowIndex + 1 >= tripEntry.size() || null == tripEntry.get(rowIndex + 1) || null == ((DynamicObject)tripEntry.get(rowIndex + 1)).getDynamicObjectCollection("entryentity")) break;
                IntStream.range(0, ((DynamicObject)tripEntry.get(rowIndex + 1)).getDynamicObjectCollection("entryentity").size()).forEach(idx -> {
                    this.updateCalDayCount(rowIndex + 1, idx);
                    this.calcuHighSeasonDay(idx, rowIndex + 1, true, this.getTripDelayDay(rowIndex + 1, idx, this.getCompanyId()));
                });
                break;
            }
            case "trip2enddate": {
                DynamicObjectCollection detail;
                Optional<DynamicObject> lastRow;
                DynamicObject expenseItem;
                Object billkind = model.getValue("billkind");
                if (newValue != null && this.isOpenTripDateControl() && billkind.toString().equals("0") && (expenseItem = (DynamicObject)this.getModel().getValue("expenseitem", rowIndex, parentIndex)) != null && StringUtils.equals((CharSequence)ErTripExpenseItemConstant.Attribute.Subsidy.getValue(), (CharSequence)expenseItem.getString(TRIPEXP_ATTRIBUTE)) && (lastRow = IntStream.range(rowIndex + 1, (detail = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry").get(0)).getDynamicObjectCollection("entryentity")).size()).mapToObj(idx -> (DynamicObject)detail.get(idx)).filter(row -> row.getDynamicObject("expenseitem") != null && row.getDynamicObject("expenseitem").getLong("id") == expenseItem.getLong("id") && row.getDate("trip2startdate") != null && row.getDate("trip2enddate") != null).sorted(Comparator.comparing(row -> row.getInt("seq"))).findFirst()).isPresent()) {
                    this.updateCalDayCount(0, lastRow.get().getInt("seq") - 1);
                    this.calcuHighSeasonDay(lastRow.get().getInt("seq") - 1, parentIndex, true, this.getTripDelayDay(parentIndex, rowIndex, this.getCompanyId()));
                }
                this.updateCalDayCount(parentIndex, rowIndex);
                this.calcuHighSeasonDay(rowIndex, parentIndex, true, this.getTripDelayDay(parentIndex, rowIndex, this.getCompanyId()));
                break;
            }
            case "trip2startdate": {
                this.updateCalDayCount(parentIndex, rowIndex);
                this.calcuHighSeasonDay(rowIndex, parentIndex, true, this.getTripDelayDay(parentIndex, rowIndex, this.getCompanyId()));
                break;
            }
            case "travelerssamestd": 
            case "istravelers": {
                if (this.getPageCache().get("istravelersreverse") != null) {
                    this.getPageCache().remove("istravelersreverse");
                    return;
                }
                DynamicObjectCollection tripEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
                boolean isEmpty = tripEntry.stream().allMatch(card -> card.getDynamicObjectCollection("entryentity").size() == 0);
                if (isEmpty || !SystemParamterUtil.isOpenTripDateControl((Long)this.getCompanyId()) || !((Boolean)this.getModel().getValue("isopentripstd")).booleanValue()) break;
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("istravelerchange", (IFormPlugin)this);
                ConfirmCallBackListener confirmCallBacksStd = new ConfirmCallBackListener("istravelerchangeStd", (IFormPlugin)this);
                if (propName.equals("istravelers")) {
                    if (((Boolean)newValue).booleanValue()) {
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u5f00\u542f\u201c\u884c\u7a0b\u671f\u95f4\u63a7\u5236\u201d\u7cfb\u7edf\u53c2\u6570\uff0c\u5207\u6362\u81f3\u591a\u51fa\u5dee\u4eba\uff0c\u8865\u52a9\u5929\u6570\u4f1a\u91cd\u65b0\u8ba1\u7b97\u3002\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"AbstractTripStdCtrlPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                        break;
                    }
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u5f00\u542f\u201c\u884c\u7a0b\u671f\u95f4\u63a7\u5236\u201d\u7cfb\u7edf\u53c2\u6570\uff0c\u5207\u6362\u81f3\u5355\u51fa\u5dee\u4eba\uff0c\u8865\u52a9\u5929\u6570\u4f1a\u91cd\u65b0\u8ba1\u7b97\u3002\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"AbstractTripStdCtrlPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                    break;
                }
                if (!((Boolean)this.getModel().getValue("istravelers")).booleanValue()) break;
                if (((Boolean)newValue).booleanValue()) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u5f00\u542f\u201c\u884c\u7a0b\u671f\u95f4\u63a7\u5236\u201d\u7cfb\u7edf\u53c2\u6570\uff0c\u5728\u5f00\u542f\u201c\u591a\u51fa\u5dee\u4eba\u201d\u7684\u60c5\u51b5\u4e0b\uff0c\u5982\u679c\u5173\u95ed\u201c\u591a\u51fa\u5dee\u4eba\u540c\u884c\u7a0b\u201d\uff0c\u8865\u52a9\u5929\u6570\u5c06\u91cd\u65b0\u8ba1\u7b97\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5173\u95ed\uff1f", (String)"AbstractTripStdCtrlPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacksStd);
                    break;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u5f00\u542f\u201c\u884c\u7a0b\u671f\u95f4\u63a7\u5236\u201d\u7cfb\u7edf\u53c2\u6570\uff0c\u5f00\u542f\u591a\u51fa\u5dee\u4eba\u4e0b\uff0c\u5173\u95ed\u591a\u51fa\u5dee\u4eba\u540c\u884c\u7a0b\uff0c\u8865\u52a9\u5929\u6570\u4f1a\u91cd\u65b0\u8ba1\u7b97\u3002\u662f\u5426\u5207\u6362\uff1f", (String)"AbstractTripStdCtrlPlugin_6", (String)"fi-er-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacksStd);
                break;
            }
            case "exchangerate": {
                this.setStdexchangerateWhenExchangerateChanged(newValue, rowIndex, parentIndex);
            }
        }
    }

    private boolean setStdexchangerateWhenExchangerateChanged(Object newValue, int rowIndex, int parentIndex) {
        Long stdEntryCurrency;
        Long entryCurrency = ErCommonUtils.getPk((Object)this.getModel().getValue("entrycurrency", rowIndex, parentIndex));
        if (Objects.equals(entryCurrency, stdEntryCurrency = ErCommonUtils.getPk((Object)this.getModel().getValue("stdentrycurrency", rowIndex, parentIndex)))) {
            this.getModel().setValue("stdexchangerate", newValue, rowIndex, parentIndex);
            Object val = this.getModel().getValue("detailquotetype", rowIndex, parentIndex);
            if (val != null) {
                this.getModel().setValue("stdexpquotetype", val, rowIndex, parentIndex);
            }
            return true;
        }
        return false;
    }

    protected void calcuHighSeasonDay(int rowIndex, int parentIndex, boolean fireCalcuHighDays, BigDecimal delay) {
        String billKind;
        DynamicObject area = (DynamicObject)this.getModel().getValue("triparea", rowIndex, parentIndex);
        Date begin = (Date)this.getModel().getValue("trip2startdate", rowIndex, parentIndex);
        Date end = (Date)this.getModel().getValue("trip2enddate", rowIndex, parentIndex);
        DynamicObject expenseitem = (DynamicObject)this.getModel().getValue("expenseitem", rowIndex, parentIndex);
        if (area != null && begin != null && end != null && expenseitem != null) {
            boolean isHighSeaon = false;
            TripReimburseBill.objectThreadLocal.set(false);
            BigDecimal days = this.getHighSeasonDaysByPage(parentIndex, rowIndex, begin, end, area, expenseitem);
            if (days != null && days.compareTo(BigDecimal.ZERO) > 0 || TripReimburseBill.objectThreadLocal.get() != null && ((Boolean)TripReimburseBill.objectThreadLocal.get()).booleanValue()) {
                isHighSeaon = true;
            }
            TripReimburseBill.objectThreadLocal.remove();
            this.getModel().setValue("highseason", (Object)(isHighSeaon ? "1" : "0"), rowIndex, parentIndex);
            this.getModel().setValue("originhighseasondays", (Object)days, rowIndex, parentIndex);
            BigDecimal caldaycount = (BigDecimal)this.getModel().getValue("caldaycount", rowIndex, parentIndex);
            BigDecimal highseasondaycount = (BigDecimal)this.getModel().getValue("highseasondaycount", rowIndex, parentIndex);
            if (fireCalcuHighDays && caldaycount != null && days != null && days.compareTo(caldaycount) <= 0) {
                this.getModel().setValue("highseasondaycount", (Object)days, rowIndex, parentIndex);
            } else if (fireCalcuHighDays && caldaycount != null) {
                this.getModel().setValue("highseasondaycount", (Object)caldaycount, rowIndex, parentIndex);
            } else if (!fireCalcuHighDays && days != null && caldaycount != null && highseasondaycount != null && highseasondaycount.compareTo(days) > 0) {
                this.getModel().setValue("highseasondaycount", (Object)(days.compareTo(caldaycount) < 0 ? days : caldaycount), rowIndex, parentIndex);
            }
        }
        if ("0".equals(billKind = this.getModel().getDataEntity().getString("billkind"))) {
            Date tripBegin = (Date)this.getModel().getValue("startdate", parentIndex);
            Date tripEnd = (Date)this.getModel().getValue("enddate", parentIndex);
            DynamicObject tripArea = (DynamicObject)this.getModel().getValue("tripentryarea", parentIndex);
            if (tripBegin != null && tripEnd != null && tripArea != null && expenseitem != null) {
                this.getModel().setValue("originhighseasondays", (Object)this.getHighSeasonDaysByPage(parentIndex, rowIndex, begin, end, area, expenseitem), rowIndex, parentIndex);
            }
        }
    }

    @Deprecated
    protected void calcuHighSeasonDay(int rowIndex, int parentIndex, boolean init) {
    }

    private void updateCalDayCount(int parentEntryIndex, int curEntryIndex) {
        DynamicObjectCollection tripEntryCollction = this.getModel().getEntryEntity("tripentry");
        DynamicObject detailEntry = (DynamicObject)((DynamicObject)tripEntryCollction.get(parentEntryIndex)).getDynamicObjectCollection("entryentity").get(curEntryIndex);
        Long dayCount = CommonServiceHelper.calcDays((Date)detailEntry.getDate("trip2startdate"), (Date)detailEntry.getDate("trip2enddate"));
        this.updateCalDayCount(dayCount.intValue(), parentEntryIndex, curEntryIndex);
    }

    private BigDecimal calDayCount(int parentEntryIndex, int curEntryIndex) {
        String attributeType;
        DynamicObject tripExp;
        DynamicObject detailEntry = (DynamicObject)((DynamicObject)this.getModel().getEntryEntity("tripentry").get(parentEntryIndex)).getDynamicObjectCollection("entryentity").get(curEntryIndex);
        Long dayCount = CommonServiceHelper.calcDays((Date)detailEntry.getDate("trip2startdate"), (Date)detailEntry.getDate("trip2enddate"));
        BigDecimal calDayCount = new BigDecimal(dayCount);
        if (this.isOpenTripStd() && (tripExp = detailEntry.getDynamicObject("expenseitem")) != null && StringUtils.equals((CharSequence)EXPENSE_ITEM_SUBSIDY, (CharSequence)(attributeType = tripExp.getString(TRIPEXP_ATTRIBUTE)))) {
            Long companyId = this.getCompanyId();
            calDayCount = calDayCount.add(this.getTripDelayDay(parentEntryIndex, curEntryIndex, companyId));
        }
        return calDayCount;
    }

    private void updateCalDayCount(int dayCount, int parentEntryIndex, int curEntryIndex) {
        BigDecimal oldCalDayCount;
        String attributeType;
        DynamicObject tripExp;
        DynamicObjectCollection tripEntryCollction = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
        DynamicObject detailEntry = (DynamicObject)((DynamicObject)tripEntryCollction.get(parentEntryIndex)).getDynamicObjectCollection("entryentity").get(curEntryIndex);
        boolean isOpenAccdAndAllowanceStd = this.isOpenTripStd();
        BigDecimal caldaycount = new BigDecimal(dayCount);
        if (isOpenAccdAndAllowanceStd && (tripExp = detailEntry.getDynamicObject("expenseitem")) != null && StringUtils.equals((CharSequence)EXPENSE_ITEM_SUBSIDY, (CharSequence)(attributeType = tripExp.getString(TRIPEXP_ATTRIBUTE)))) {
            Long companyId = this.getCompanyId();
            caldaycount = new BigDecimal(dayCount).add(this.getTripDelayDay(parentEntryIndex, curEntryIndex, companyId));
        }
        if ((oldCalDayCount = detailEntry.getBigDecimal("caldaycount")).compareTo(caldaycount) != 0) {
            this.getModel().setValue("caldaycount", (Object)caldaycount, curEntryIndex, parentEntryIndex);
        }
    }

    private boolean validateIsOverMaxCalDayCount(Object newValue, int tripEntryRowIndex, int tripDetailRowIndex) {
        DynamicObject detailEntry;
        DynamicObject tripExpItem;
        DynamicObjectCollection detailEntryColl;
        DynamicObjectCollection tripEntryColl;
        boolean isOverMax = false;
        Long companyId = this.getCompanyId();
        SubsidiesDayParamEnum subsidiesDaysCalculationType = SystemParamterUtil.getSubsidiesDaysCalculationType((long)companyId);
        boolean caldaycountchange = SystemParamterUtil.isCalDayCountChange((Long)companyId);
        if ((subsidiesDaysCalculationType == SubsidiesDayParamEnum.ADD_ONE_CONTROL || SystemParamterUtil.isOpenTripDateControl((Long)companyId)) && !caldaycountchange && (tripEntryColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry")).size() > tripEntryRowIndex && (detailEntryColl = ((DynamicObject)tripEntryColl.get(tripEntryRowIndex)).getDynamicObjectCollection("entryentity")).size() > tripDetailRowIndex && (tripExpItem = (detailEntry = (DynamicObject)detailEntryColl.get(tripDetailRowIndex)).getDynamicObject("expenseitem")) != null && tripExpItem.getString(TRIPEXP_ATTRIBUTE).equals(EXPENSE_ITEM_SUBSIDY)) {
            Date dateBegin = detailEntry.getDate("trip2startdate");
            Date dateEnd = detailEntry.getDate("trip2enddate");
            Long dayCount = CommonServiceHelper.calcDays((Date)detailEntry.getDate("trip2startdate"), (Date)detailEntry.getDate("trip2enddate"));
            int maxDayCount = dayCount.intValue() + 1;
            if (((BigDecimal)newValue).compareTo(BigDecimal.valueOf(maxDayCount)) > 0) {
                isOverMax = true;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5c5e\u6027\u4e3a\u8865\u52a9\u7684\u5dee\u65c5\u660e\u7ec6\u6807\u51c6\u5929\u6570\u4e0d\u5141\u8bb8\u6539\u5927\u3002", (String)"AbstractTripStdCtrlPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                this.updateCalDayCount(dayCount.intValue(), tripEntryRowIndex, tripDetailRowIndex);
            }
        }
        return isOverMax;
    }

    private void refreshSeatGradeByTripExpItemChange(Object oldValue, Object newValue, int parentIndex, int curIndex) {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObject deatailEntry = (DynamicObject)((DynamicObject)dataEntity.getDynamicObjectCollection("tripentry").get(parentIndex)).getDynamicObjectCollection("entryentity").get(curIndex);
        DynamicObjectCollection detailSeatGrade = deatailEntry.getDynamicObjectCollection("mulseatgrade");
        if (!(newValue != null && oldValue != null && ((DynamicObject)oldValue).getString(TRIPEXP_ATTRIBUTE).equals(((DynamicObject)newValue).getString(TRIPEXP_ATTRIBUTE)) || detailSeatGrade == null || detailSeatGrade.size() <= 0)) {
            model.setValue("mulseatgrade", null, curIndex, parentIndex);
        }
        if (newValue != null) {
            String itemFrom;
            DynamicObject tripItem = (DynamicObject)newValue;
            String attribute = tripItem.getString(TRIPEXP_ATTRIBUTE);
            DynamicObjectCollection expItemSeatGrade = deatailEntry.getDynamicObjectCollection("mulseatgrade");
            if (!expItemSeatGrade.isEmpty()) {
                return;
            }
            if (Arrays.asList(VEHIC_ATTRIBUTE).contains(attribute) && (StringUtils.equals((CharSequence)"1", (CharSequence)(itemFrom = deatailEntry.getString("itemfrom"))) || StringUtils.equals((CharSequence)"3", (CharSequence)itemFrom))) {
                TripVehicleStandardUtils.setExpenseSeatGrade((IDataModel)model, (long)((Long)deatailEntry.getPkValue()), (int)parentIndex, (int)curIndex, (String)attribute);
            }
        }
    }

    private void setDetailEntryTripArea(int rowIndex, int parentIndex, Object to, Long orgId, Object oldValuePk) {
        if (to == null) {
            this.getModel().setValue("triparea", null, rowIndex, parentIndex);
            return;
        }
        Long toCityId = (Long)((DynamicObject)to).getPkValue();
        String orgType = ErCommonUtils.getTripAreaOrgType();
        DynamicObject org = (DynamicObject)this.getModel().getValue(orgType);
        IErTripStdService stdService = new ErTripStdServiceProxy((IErTripStdService)new ErTripStdServiceImp(), this.getModel().getDataEntity()).getInstance();
        DynamicObject tripArea = stdService.getTripAreaByCityIdAndCompanyId(toCityId, ErCommonUtils.getPk((Object)org));
        if (tripArea != null) {
            if (oldValuePk == null || oldValuePk != null && !tripArea.getPkValue().equals(oldValuePk)) {
                this.getModel().setValue("triparea", tripArea.getPkValue(), rowIndex, parentIndex);
            }
        } else {
            this.getModel().setValue("triparea", null, rowIndex, parentIndex);
        }
    }

    private void refreshAllDetailEntryTripArea() {
        Long companyId = this.getCompanyId();
        if (companyId.compareTo(0L) == 0) {
            return;
        }
        DynamicObjectCollection tripEntryCollction = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
        logger.info("\u5f00\u59cb\u5faa\u73af");
        for (int tripEntryIndex = 0; tripEntryIndex < tripEntryCollction.size(); ++tripEntryIndex) {
            DynamicObject tripEntry = (DynamicObject)tripEntryCollction.get(tripEntryIndex);
            DynamicObjectCollection detailEntryCollction = tripEntry.getDynamicObjectCollection("entryentity");
            for (int detailEntryIndex = 0; detailEntryIndex < detailEntryCollction.size(); ++detailEntryIndex) {
                DynamicObject detailEntry = (DynamicObject)detailEntryCollction.get(detailEntryIndex);
                DynamicObject oldTripArea = detailEntry.getDynamicObject("triparea");
                Object oldPkValue = oldTripArea == null ? null : oldTripArea.getPkValue();
                this.setDetailEntryTripArea(detailEntryIndex, tripEntryIndex, detailEntry.get("trip2to"), companyId, oldPkValue);
            }
        }
        logger.info("\u7ed3\u675f\u5faa\u73af");
    }

    protected void entryPropertyUpdateStd(int parentEntryIndex, int curEntryIndex) {
        DynamicObjectCollection tripEntryCollction = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
        DynamicObject detailEntry = (DynamicObject)((DynamicObject)tripEntryCollction.get(parentEntryIndex)).getDynamicObjectCollection("entryentity").get(curEntryIndex);
        if (this.isControlEntryStd(detailEntry, parentEntryIndex, curEntryIndex)) {
            this.entryPropertyUpdateStd(detailEntry, parentEntryIndex, curEntryIndex, true, null);
        }
    }

    protected void entryPropertyUpdateStd(DynamicObject entry, int parentEntryIndex, int curEntryIndex, boolean flag, StdPreCalContext stdPreCalContext) {
        Long companyId = this.getCompanyId();
        if (entry == null) {
            return;
        }
        DynamicObject tripExpenseItem = entry.getDynamicObject("expenseitem");
        if (tripExpenseItem == null) {
            return;
        }
        Set<Long> userSet = this.getTravelersOfEntry(entry, parentEntryIndex, curEntryIndex);
        if (userSet.isEmpty()) {
            return;
        }
        String attribute = tripExpenseItem.getString(TRIPEXP_ATTRIBUTE);
        if (this.isOnlySetTripStdShowInfoOfEntry(parentEntryIndex, curEntryIndex)) {
            this.setTripStdShowInfo(entry, attribute, parentEntryIndex, curEntryIndex);
            return;
        }
        List<Long> userList = userSet.stream().collect(Collectors.toList());
        if (Arrays.asList(ACCD_ALLOWANCE_ATTRIBUTE).contains(attribute)) {
            ControlMethodEnum tripStandCtrTypeEnum = SystemParamterUtil.getTripStandardControlLevel((long)companyId);
            String mulTraStdCtrType = SystemParamterUtil.getMultiTravelerStdControlType((long)companyId);
            this.updateAccdAndAllowanceStd(userList, tripStandCtrTypeEnum, mulTraStdCtrType, entry, tripExpenseItem, parentEntryIndex, curEntryIndex, this.getExtMap(entry, parentEntryIndex, curEntryIndex), flag, stdPreCalContext);
        } else if (Arrays.asList(VEHIC_ATTRIBUTE).contains(attribute)) {
            ControlMethodEnum tripStandCtrTypeEnum = SystemParamterUtil.getVehicleStdControlLevel((long)companyId);
            HashMap<String, Object> map = this.getExtMap(entry, parentEntryIndex, curEntryIndex);
            map = map == null ? new HashMap<String, Object>(4) : map;
            this.updateTripVehicStd(userList, companyId, tripStandCtrTypeEnum, attribute, entry, parentEntryIndex, curEntryIndex, map, stdPreCalContext);
        }
        this.checkEntryStdIsOver(entry, attribute, parentEntryIndex, curEntryIndex, stdPreCalContext);
    }

    protected Map<String, Object> getExtMap(DynamicObject entry, int parentEntryIndex, int curEntryIndex) {
        Map map = this.buildExtMap(entry, parentEntryIndex, curEntryIndex);
        IDataEntityProperty dataEntityProperty = this.getModel().getProperty("company");
        if (dataEntityProperty != null) {
            Object company = this.getModel().getValue("company");
            map.put("applyCompany", company);
        }
        return map;
    }

    protected boolean isOnlySetTripStdShowInfoOfEntry(int parentEntryIndex, int curEntryIndex) {
        IDataModel model = this.getModel();
        String billstatus = (String)model.getValue("billstatus");
        return !ErBillStatusEnum.A.name().equals(billstatus) && !ErBillStatusEnum.D.name().equals(billstatus);
    }

    protected Set<Long> getTravelersOfEntry(DynamicObject entry, int parentEntryIndex, int curEntryIndex) {
        return entry.getDynamicObjectCollection("trip2travelers").stream().filter(traveler -> traveler.get("fbasedataid") != null).map(traveler -> traveler.getLong("fbasedataid_id")).collect(Collectors.toSet());
    }

    protected boolean checkEntryStdIsOver(int parentEntryIndex, int curEntryIndex) {
        DynamicObjectCollection tripEntryCollction = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
        DynamicObject detailEntry = (DynamicObject)((DynamicObject)tripEntryCollction.get(parentEntryIndex)).getDynamicObjectCollection("entryentity").get(curEntryIndex);
        DynamicObject tripExpenseItem = detailEntry.getDynamicObject("expenseitem");
        if (tripExpenseItem != null && (this.isOpenAccdAndAllowanceStd() || this.isOpenVehicStd())) {
            String attribute = tripExpenseItem.getString(TRIPEXP_ATTRIBUTE);
            return this.checkEntryStdIsOver(detailEntry, attribute, parentEntryIndex, curEntryIndex, null);
        }
        return false;
    }

    protected boolean checkEntryStdIsOver(DynamicObject entry, String attribute, int parentEntryIndex, int curEntryIndex, StdPreCalContext stdPreCalContext) {
        String isOver;
        boolean isOverStd = false;
        StringBuilder stdBuilder = new StringBuilder(0);
        stdBuilder.append("ACCD_ALLOWANCE_ATTRIBUTE:").append(Arrays.stream(ACCD_ALLOWANCE_ATTRIBUTE).collect(Collectors.toList()).toString()).append(";");
        stdBuilder.append("VEHIC_ATTRIBUTE:").append(Arrays.stream(VEHIC_ATTRIBUTE).collect(Collectors.toList()).toString()).append(";");
        stdBuilder.append("attribute:").append(attribute).append(";");
        stdBuilder.append("isOpenAccdAndAllowanceStd:").append(this.isOpenAccdAndAllowanceStd()).append(";");
        stdBuilder.append("isOpenVehicStd:").append(this.isOpenVehicStd()).append(";");
        logger.debug(stdBuilder.toString());
        if (Arrays.asList(ACCD_ALLOWANCE_ATTRIBUTE).contains(attribute) && this.isOpenAccdAndAllowanceStd()) {
            isOverStd = this.checkAccdAllowanceEntryStdIsOver(entry, parentEntryIndex, curEntryIndex, stdPreCalContext);
            logger.debug("ACCD_ALLOWANCE_ATTRIBUTE");
        } else if (Arrays.asList(VEHIC_ATTRIBUTE).contains(attribute) && this.isOpenVehicStd()) {
            isOverStd = this.checkVehicEntryStdIsOver(entry, parentEntryIndex, curEntryIndex);
            logger.debug("VEHIC_ATTRIBUTE");
        }
        logger.info(String.format(ResManager.loadKDString((String)"\u8ba2\u5355\u53f7\uff1a%1$s\uff0c\u5c5e\u6027\uff1a%2$s\uff0c\u7d22\u5f15-P>%3$s-%4$s\uff0c\u662f\u5426\u8d85\u6807\uff1a%5$s\u3002", (String)"AbstractTripStdCtrlPlugin_12", (String)"fi-er-formplugin", (Object[])new Object[0]), this.getModel().getValue("billno"), attribute, parentEntryIndex, curEntryIndex, isOverStd));
        String string = isOver = isOverStd ? "1" : "0";
        if (!isOver.equalsIgnoreCase(entry.getString("isover"))) {
            this.getModel().setValue("isover", (Object)isOver, curEntryIndex, parentEntryIndex);
        }
        this.setTripStdShowInfo(entry, attribute, parentEntryIndex, curEntryIndex);
        CheckEntryStdResult result = this.afterCheckEntryStdIsOver(isOverStd, parentEntryIndex, curEntryIndex);
        return result.isOver();
    }

    protected CheckEntryStdResult afterCheckEntryStdIsOver(boolean entryIsOver, int tripEntryIndex, int detailIndex) {
        return new CheckEntryStdResult(entryIsOver, tripEntryIndex, detailIndex);
    }

    protected boolean checkAccdAllowanceEntryStdIsOver(DynamicObject entry, int parentEntryIndex, int curEntryIndex, StdPreCalContext stdPreCalContext) {
        boolean isOverStd = false;
        boolean isCancelOrder = entry.getBoolean("iscancelorder");
        BigDecimal oriEntryAmount = entry.getBigDecimal("orientryamount");
        boolean userOutStdCtrl = entry.getBoolean("useroutstdctrl");
        BigDecimal oriMaxStdAmount = TripHighSeasonStandardUtil.getStandardamountTotal((boolean)this.isOpenHighSeasonStd(), (DynamicObject)entry);
        StringBuilder builder = new StringBuilder(0);
        builder.append("userOutStdCtrl:").append(userOutStdCtrl).append(";");
        builder.append("isCancelOrder:").append(isCancelOrder).append(";");
        builder.append("oriEntryAmount:").append(oriEntryAmount).append(";");
        builder.append("oriMaxStdAmount:").append(oriMaxStdAmount).append(";");
        logger.debug(builder.toString());
        if (!userOutStdCtrl && !isCancelOrder && oriEntryAmount.compareTo(oriMaxStdAmount) > 0) {
            this.getModel().setValue("tripstdsumupover", (Object)Boolean.TRUE, curEntryIndex, parentEntryIndex);
            isOverStd = true;
            logger.debug("std over");
        } else {
            this.getModel().setValue("tripstdsumupover", (Object)Boolean.FALSE, curEntryIndex, parentEntryIndex);
            logger.debug("std not over");
        }
        logger.debug("isOverStd : " + isOverStd);
        return isOverStd;
    }

    protected boolean checkVehicEntryStdIsOver(DynamicObject entry, int parentEntryIndex, int curEntryIndex) {
        DynamicObjectCollection entrySeatGrade = entry.getDynamicObjectCollection("mulseatgrade");
        DynamicObjectCollection seatGradeStd = entry.getDynamicObjectCollection("stdseatgrade");
        boolean isCancelOrder = entry.getBoolean("iscancelorder");
        boolean isOverStd = TripStandardUtils.isOverVhcStd((DynamicObjectCollection)entrySeatGrade, (DynamicObjectCollection)seatGradeStd) && !isCancelOrder;
        this.getModel().setValue("isovervhcstd", (Object)isOverStd, curEntryIndex, parentEntryIndex);
        return isOverStd;
    }

    protected void updateAllStd(boolean fireCalcuHighDays, boolean updateEntryAmount) {
        DynamicObjectCollection tripEntryCollction = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
        this.clearAllEntryStdShow(tripEntryCollction);
        HashSet<Long> allUserIds = new HashSet<Long>(tripEntryCollction.size());
        for (int tripEntryIndex = 0; tripEntryIndex < tripEntryCollction.size(); ++tripEntryIndex) {
            DynamicObject tripEntry = (DynamicObject)tripEntryCollction.get(tripEntryIndex);
            DynamicObjectCollection detailEntryCollction = tripEntry.getDynamicObjectCollection("entryentity");
            for (int detailEntryIndex = 0; detailEntryIndex < detailEntryCollction.size(); ++detailEntryIndex) {
                DynamicObject detailEntry = (DynamicObject)detailEntryCollction.get(detailEntryIndex);
                Set<Long> userSet = this.getTravelersOfEntry(detailEntry, tripEntryIndex, detailEntryIndex);
                allUserIds.addAll(userSet);
            }
        }
        this.beforeLoopTrip(allUserIds);
        StdPreCalContext stdPreCalContext = this.buildStdPreCalContext(tripEntryCollction);
        logger.info("updateAllStd \u5f00\u59cb\u5faa\u73af");
        for (int tripEntryIndex = 0; tripEntryIndex < tripEntryCollction.size(); ++tripEntryIndex) {
            DynamicObject tripEntry = (DynamicObject)tripEntryCollction.get(tripEntryIndex);
            DynamicObjectCollection detailEntryCollction = tripEntry.getDynamicObjectCollection("entryentity");
            for (int detailEntryIndex = 0; detailEntryIndex < detailEntryCollction.size(); ++detailEntryIndex) {
                DynamicObject detailEntry = (DynamicObject)detailEntryCollction.get(detailEntryIndex);
                if (!this.isControlEntryStd(detailEntry, tripEntryIndex, detailEntryIndex)) continue;
                if (!this.isOnlySetTripStdShowInfoOfEntry(tripEntryIndex, detailEntryIndex)) {
                    this.calcuHighSeasonDay(detailEntryIndex, tripEntryIndex, fireCalcuHighDays, this.getTripDelayDay(tripEntryIndex, detailEntryIndex, this.getCompanyId()));
                }
                this.entryPropertyUpdateStd(detailEntry, tripEntryIndex, detailEntryIndex, updateEntryAmount, stdPreCalContext);
            }
        }
        logger.info("updateAllStd \u7ed3\u675f\u5faa\u73af");
    }

    private StdPreCalContext buildStdPreCalContext(DynamicObjectCollection tripEntryCollction) {
        StdPreCalContext stdPreCalContext = new StdPreCalContext();
        if (tripEntryCollction != null && tripEntryCollction.size() > 0) {
            UserDynamicObj userDynamicObj = this.buildUserDynObj(tripEntryCollction);
            stdPreCalContext.setUserDynamicObj(userDynamicObj);
            DepCompanyObj depCompanyObj = this.buildDepCompanyObj(userDynamicObj);
            stdPreCalContext.setDepCompanyObj(depCompanyObj);
            IncludeEmployeeObj includeEmployeeObj = this.buildIncludeEmployeeObj(userDynamicObj);
            stdPreCalContext.setIncludeEmployeeObj(includeEmployeeObj);
            UserComReimLevelObj userComReimLevelObj = this.buildUserComReimLevelObj(userDynamicObj, depCompanyObj);
            stdPreCalContext.setUserComReimLevelObj(userComReimLevelObj);
        }
        return stdPreCalContext;
    }

    private UserComReimLevelObj buildUserComReimLevelObj(UserDynamicObj userDynamicObj, DepCompanyObj depCompanyObj) {
        UserComReimLevelObj userComReimLevelObj = new UserComReimLevelObj();
        Map userObjMap = userDynamicObj.getUserObjMap();
        Set userIds = userObjMap.keySet();
        HashSet orgIds = new HashSet(0);
        Set userDepIds = userObjMap.entrySet().stream().flatMap(userDynObj -> ((DynamicObject)userDynObj.getValue()).getDynamicObjectCollection("entryentity").stream()).map(userEntity -> userEntity.getLong("dpt.id")).collect(Collectors.toSet());
        Map orgByPattern = depCompanyObj.getOrgByPattern();
        Set companys = orgByPattern.values().stream().map(m -> (Long)m.get("id")).collect(Collectors.toSet());
        orgIds.addAll(userDepIds);
        orgIds.addAll(companys);
        userComReimLevelObj.initialUserReimLevel(userIds, orgIds);
        return userComReimLevelObj;
    }

    private IncludeEmployeeObj buildIncludeEmployeeObj(UserDynamicObj userDynamicObj) {
        IncludeEmployeeObj includeEmployeeObj = new IncludeEmployeeObj();
        Map userObjMap = userDynamicObj.getUserObjMap();
        Set userIds = userObjMap.keySet();
        includeEmployeeObj.initialAccIncludeEmployeeObj(userIds);
        includeEmployeeObj.initialVehicleIncludeEmployeeObj(userIds);
        return includeEmployeeObj;
    }

    private DepCompanyObj buildDepCompanyObj(UserDynamicObj userDynamicObj) {
        DepCompanyObj depCompanyObj = new DepCompanyObj();
        Map userObjMap = userDynamicObj.getUserObjMap();
        Set userDepIds = userObjMap.values().stream().filter(v -> v.get("entryentity") != null).flatMap(v -> v.getDynamicObjectCollection("entryentity").stream()).filter(userEntryEntity -> userEntryEntity.get("dpt") != null).map(userEntryEntity -> userEntryEntity.getDynamicObject("dpt").getLong("id")).collect(Collectors.toSet());
        depCompanyObj.initialMapByOrgs(userDepIds);
        return depCompanyObj;
    }

    private UserDynamicObj buildUserDynObj(DynamicObjectCollection tripEntryCollction) {
        UserDynamicObj userDynamicObj = new UserDynamicObj();
        HashSet<Object> tripUserSet = new HashSet<Object>(0);
        for (int tripEntryIndex = 0; tripEntryIndex < tripEntryCollction.size(); ++tripEntryIndex) {
            DynamicObject tripEntry = (DynamicObject)tripEntryCollction.get(tripEntryIndex);
            DynamicObjectCollection detailEntryCollction = tripEntry.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection travelers = tripEntry.getDynamicObjectCollection("travelers");
            List userIds = travelers.stream().filter(traveler -> traveler.get("fbasedataid") != null).map(traveler -> traveler.getLong("fbasedataid_id")).collect(Collectors.toList());
            tripUserSet.addAll(userIds);
            if (detailEntryCollction == null) continue;
            for (int detailEntryIndex = 0; detailEntryIndex < detailEntryCollction.size(); ++detailEntryIndex) {
                DynamicObject detailEntry = (DynamicObject)detailEntryCollction.get(detailEntryIndex);
                if (!this.isControlEntryStd(detailEntry, tripEntryIndex, detailEntryIndex)) continue;
                Set<Long> userSet = this.getTravelersOfEntry(detailEntry, tripEntryIndex, detailEntryIndex);
                tripUserSet.addAll(userSet);
            }
        }
        userDynamicObj.initialMapByUser(tripUserSet);
        return userDynamicObj;
    }

    private void beforeLoopTrip(Set<Long> allUserIds) {
        ActionLocalCache resultMap = ActionLocalCache.get();
        Map userMap = CommonServiceHelper.getUsers(allUserIds);
        resultMap.put("kd.fi.er.business.servicehelper.CommonServiceHelper.USER_DYNAMIC_OBJECT_MAP", (Object)userMap);
        HashSet allOrgIds = new HashSet(userMap.size());
        for (Object user : userMap.values()) {
            Set orgs = user.getDynamicObjectCollection("entryentity").stream().map(v -> v.getLong("dpt.id")).collect(Collectors.toSet());
            allOrgIds.addAll(orgs);
        }
        logger.info("allOrgIds.size: " + allOrgIds.size());
        HashMap<Long, Long> orgCompanyMap = new HashMap<Long, Long>(allOrgIds.size());
        for (Long orgId : allOrgIds) {
            Map companyByOrg = OrgUnitServiceHelper.getCompanyfromOrg((Long)orgId);
            Long companyId = companyByOrg.getOrDefault("id", 0L);
            orgCompanyMap.put(orgId, companyId);
        }
        resultMap.put("kd.fi.er.business.tripstd.service.imp.ErTripStdServiceImp.ORG_COMPANY", orgCompanyMap);
        logger.info("getCompanyFromOrg finished");
        HashMap userCompanysMap = new HashMap(userMap.size());
        for (DynamicObject user : userMap.values()) {
            long userId = user.getLong("id");
            Set companyIds = user.getDynamicObjectCollection("entryentity").stream().map(v -> v.getLong("dpt.id")).map(v -> (Long)orgCompanyMap.get(v)).collect(Collectors.toSet());
            userCompanysMap.put(userId, companyIds);
        }
        resultMap.put("kd.fi.er.business.tripstd.service.imp.ErTripStdServiceImp.USER_COMPANYS", userCompanysMap);
    }

    @Deprecated
    protected void updateAllStd() {
        this.updateAllStd(true, true);
    }

    private void updateAccdAndAllowanceStd(List<Long> userIds, ControlMethodEnum controlMethodEnum, String mulTraStdCtrType, DynamicObject entry, DynamicObject tripExpenseItem, int parentEntryIndex, int curEntryIndex, Map<String, Object> extMap, boolean flag, StdPreCalContext stdPreCalContext) {
        IDataModel model = this.getModel();
        model.setValue("controlmethod", (Object)controlMethodEnum.getValue(), curEntryIndex, parentEntryIndex);
        DynamicObject entryCurrency = this.getEntryCurrency(entry);
        DynamicObject tripArea = this.getTripAreaOfEntry(entry, parentEntryIndex, curEntryIndex);
        TripStandardDetail tripStdDetail = null;
        if (entryCurrency != null && tripArea != null) {
            List tripStdDetailList = TripStandardUtils.getAccmodationStdFromPageCache(userIds, (AbstractFormPlugin)this, (String)mulTraStdCtrType, (Object)entryCurrency.getPkValue(), (Object)tripArea.getPkValue(), (DynamicObject)entry.getDynamicObject("expenseitem"), extMap, (StdPreCalContext)stdPreCalContext);
            tripStdDetail = tripStdDetailList == null || tripStdDetailList.isEmpty() ? null : (TripStandardDetail)tripStdDetailList.get(0);
        }
        BigDecimal tripSTDAmount = tripStdDetail == null ? BigDecimal.ZERO : tripStdDetail.getStandardamount();
        BigDecimal highSeasonTripSTDAmount = tripStdDetail == null ? BigDecimal.ZERO : tripStdDetail.getHighSeasonStandardamount();
        String attribute = tripExpenseItem.getString(TRIPEXP_ATTRIBUTE);
        if (EXPENSE_ITEM_ACCOMMODATION.equals(attribute) && "max".equals(mulTraStdCtrType)) {
            tripSTDAmount = tripSTDAmount.multiply(BigDecimal.valueOf(userIds.size()));
            highSeasonTripSTDAmount = highSeasonTripSTDAmount.multiply(BigDecimal.valueOf(userIds.size()));
        }
        model.setValue("tripstandardamount", (Object)tripSTDAmount, curEntryIndex, parentEntryIndex);
        model.setValue("hightripstandardamount", (Object)highSeasonTripSTDAmount, curEntryIndex, parentEntryIndex);
        this.setDetailQuoteType(parentEntryIndex, curEntryIndex, model, tripStdDetail);
        String ctrltype = tripExpenseItem.getString(TRIPEXP_CTRLTYPE);
        boolean userOutStdCtrl = tripStdDetail == null ? Boolean.FALSE : tripStdDetail.getUserOutStdCtrl();
        Object itemfrom = model.getValue("itemfrom", curEntryIndex, parentEntryIndex);
        Boolean isDeleteEntry = (Boolean)ActionLocalCache.get().getDefaultIfNull("isDeleteEntryEntity", (Object)false);
        if ((StringUtils.equals((CharSequence)ctrltype, (CharSequence)"1") || StringUtils.equals((CharSequence)ctrltype, (CharSequence)"3") && !isDeleteEntry.booleanValue()) && StringUtils.equals((CharSequence)EXPENSE_ITEM_SUBSIDY, (CharSequence)attribute) && !userOutStdCtrl && flag && !"3".equals(itemfrom)) {
            BigDecimal oriMaxStdAmount = TripHighSeasonStandardUtil.getStandardamountTotal((boolean)this.isOpenHighSeasonStd(), (DynamicObject)entry);
            BigDecimal oldStdAmount = (BigDecimal)model.getValue("orientryamount", curEntryIndex, parentEntryIndex);
            if (oldStdAmount.compareTo(oriMaxStdAmount) != 0) {
                model.setValue("orientryamount", (Object)oriMaxStdAmount, curEntryIndex, parentEntryIndex);
                String quoteType = (String)model.getValue("detailquotetype", curEntryIndex, parentEntryIndex);
                BigDecimal exchangeRate = (BigDecimal)model.getValue("exchangerate", curEntryIndex, parentEntryIndex);
                if (quoteType != null && exchangeRate != null) {
                    BigDecimal entryAmount = AmountUtils.getCurrencyAmount((BigDecimal)oriMaxStdAmount, (BigDecimal)exchangeRate, (int)AmountUtils.getCurrencyPrecision((IDataModel)model, (String)"currency"), (String)quoteType);
                    model.setValue("entryamount", (Object)entryAmount, curEntryIndex, parentEntryIndex);
                }
            }
        }
        model.setValue("isovervhcstd", (Object)Boolean.FALSE, curEntryIndex, parentEntryIndex);
        model.setValue("useroutstdctrl", (Object)userOutStdCtrl, curEntryIndex, parentEntryIndex);
        TripStandardUtils.setStdDetail((IDataModel)this.getModel(), (TripStandardDetail)tripStdDetail, (int)curEntryIndex, (int)parentEntryIndex);
    }

    private void setDetailQuoteType(int parentEntryIndex, int curEntryIndex, IDataModel model, TripStandardDetail tripStdDetail) {
        if (tripStdDetail == null) {
            model.setValue("stdentrycurrency", (Object)0, curEntryIndex, parentEntryIndex);
            model.setValue("stdexchangerate", (Object)BigDecimal.ONE, curEntryIndex, parentEntryIndex);
            return;
        }
        Object exchangerate = this.getModel().getValue("exchangerate", curEntryIndex, parentEntryIndex);
        if (this.setStdexchangerateWhenExchangerateChanged(exchangerate, curEntryIndex, parentEntryIndex)) {
            return;
        }
        BigDecimal exchangeRate = BigDecimal.ONE;
        String quoteType = "0";
        Long srcCurrencyId = Long.valueOf(tripStdDetail.getCurrency());
        Long targetCurrencyId = ErCommonUtils.getPk((Object)this.getModel().getValue("currency"));
        Map exchangeRateAndQuoteType = CommonServiceHelper.getExchangeRateFromSysParams((Object)this.getModel().getValue("company"), (Object)this.getModel().getValue("costcompany"), (Long)srcCurrencyId, (Long)targetCurrencyId, (Object)this.getModel());
        quoteType = (String)ObjectUtils.defaultIfNull(exchangeRateAndQuoteType.get("quoteType"), (Object)"0");
        exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull(exchangeRateAndQuoteType.get("exchangeRate"), (Object)BigDecimal.ONE);
        model.setValue("stdexpquotetype", (Object)quoteType, curEntryIndex, parentEntryIndex);
        model.setValue("stdentrycurrency", (Object)srcCurrencyId, curEntryIndex, parentEntryIndex);
        model.setValue("stdexchangerate", (Object)exchangeRate, curEntryIndex, parentEntryIndex);
    }

    protected DynamicObject getEntryCurrency(DynamicObject entry) {
        return entry.getDynamicObject("entrycurrency");
    }

    protected DynamicObject getTripAreaOfEntry(DynamicObject entry, int parentEntryIndex, int curEntryIndex) {
        DynamicObject tripArea = entry.getDynamicObject("triparea");
        return tripArea;
    }

    private void updateTripVehicStd(List<Long> userList, Long companyId, ControlMethodEnum tripStandCtrTypeEnum, String attribute, DynamicObject entry, int parentEntryIndex, int curEntryIndex, Map<String, Object> extMap, StdPreCalContext stdPreCalContext) {
        IDataModel model = this.getModel();
        DynamicObjectCollection stdSeatGradeColl = entry.getDynamicObjectCollection("stdseatgrade");
        stdSeatGradeColl.removeAll((Collection)stdSeatGradeColl);
        Map seatGradeStd = TripStandardUtils.getVhcSeatGradeStd(userList, (Long)companyId, (String)attribute, (IPageCache)this.getView().getPageCache(), (AbstractFormPlugin)this, extMap, (StdPreCalContext)stdPreCalContext);
        if (!seatGradeStd.isEmpty()) {
            for (Map.Entry seatGrade : seatGradeStd.entrySet()) {
                DynamicObject entrySeatGrade = stdSeatGradeColl.addNew();
                entrySeatGrade.set("fbasedataid", seatGrade.getValue());
            }
        }
        model.setValue("controlmethod", (Object)tripStandCtrTypeEnum.getValue(), curEntryIndex, parentEntryIndex);
        if (entry.getBoolean("tripstdsumupover")) {
            model.setValue("tripstdsumupover", (Object)Boolean.FALSE, curEntryIndex, parentEntryIndex);
        }
        TripStandardUtils.setStdDetail((IDataModel)this.getModel(), extMap, (int)curEntryIndex, (int)parentEntryIndex);
    }

    protected void setTripStdShowInfo(DynamicObject entry, String attribute, int parentEntryIndex, int curEntryIndex) {
        logger.info("\u8bbe\u7f6e\u5dee\u65c5\u6807\u51c6 (setTripStdShowInfo) \u65b9\u6cd5\u53c2\u6570\uff0cparentEntryIndex: {}, curEntryIndex: {}", (Object)parentEntryIndex, (Object)curEntryIndex);
        String stdShow = "";
        String highSeason = "";
        if (!entry.getBoolean("useroutstdctrl")) {
            stdShow = TripStandardUtils.getTripStdShowInfoByDetailEntry((DynamicObject)entry, (String)attribute);
        }
        this.getModel().setValue("tripstdshow", (Object)stdShow, curEntryIndex, parentEntryIndex);
        if (Arrays.asList(ACCD_ALLOWANCE_ATTRIBUTE).contains(attribute) && !entry.getBoolean("useroutstdctrl")) {
            highSeason = TripStandardUtils.getTripStdShowInfoByDetailEntry((String)"", (DynamicObject)entry, (String)attribute, (String)"hightripstandardamount");
        }
        this.getModel().setValue("highseasontripstdshow", (Object)highSeason, curEntryIndex, parentEntryIndex);
        if (entry.getBoolean("useroutstdctrl") && Arrays.asList(ACCD_ALLOWANCE_ATTRIBUTE).contains(attribute)) {
            TripStandardUtils.resetStdDetail((IDataModel)this.getModel(), (int)curEntryIndex, (int)parentEntryIndex);
        }
    }

    private boolean isControlEntryStd(DynamicObject entry, int tripEntryIndex, int detailEntryIndex) {
        DynamicObject tripExpenseItem;
        boolean isNeed = true;
        if (entry != null && (tripExpenseItem = entry.getDynamicObject("expenseitem")) != null) {
            String attribute = tripExpenseItem.getString(TRIPEXP_ATTRIBUTE);
            isNeed = Arrays.asList(ACCD_ALLOWANCE_ATTRIBUTE).contains(attribute) ? isNeed && this.isOpenAccdAndAllowanceStd() : (Arrays.asList(VEHIC_ATTRIBUTE).contains(attribute) ? isNeed && this.isOpenVehicStd() : false);
            if (!Arrays.asList(ACCD_ALLOWANCE_ATTRIBUTE).contains(attribute)) {
                this.getModel().setValue("highseasondaycount", (Object)BigDecimal.ZERO, detailEntryIndex, tripEntryIndex);
            }
        }
        if (entry != null && !isNeed) {
            this.clearEntryStd(entry, tripEntryIndex, detailEntryIndex);
        }
        return isNeed;
    }

    private void clearEntryStd(DynamicObject entry, int tripEntryIndex, int detailEntryIndex) {
        DynamicObjectCollection seatGrade;
        IDataModel model = this.getModel();
        if (entry.getBoolean("isovervhcstd")) {
            model.setValue("isovervhcstd", (Object)Boolean.FALSE, detailEntryIndex, tripEntryIndex);
        }
        if (entry.getBigDecimal("tripstandardamount").compareTo(BigDecimal.ZERO) > 0) {
            model.setValue("tripstandardamount", (Object)BigDecimal.ZERO, detailEntryIndex, tripEntryIndex);
        }
        if (entry.getBigDecimal("hightripstandardamount").compareTo(BigDecimal.ZERO) > 0) {
            model.setValue("hightripstandardamount", (Object)BigDecimal.ZERO, detailEntryIndex, tripEntryIndex);
        }
        if ((seatGrade = entry.getDynamicObjectCollection("stdseatgrade")) != null && seatGrade.size() > 0) {
            model.setValue("stdseatgrade", null, detailEntryIndex, tripEntryIndex);
        }
        if (entry.getBoolean("tripstdsumupover")) {
            model.setValue("tripstdsumupover", (Object)Boolean.FALSE, detailEntryIndex, tripEntryIndex);
        }
        if (entry.getBoolean("isover")) {
            model.setValue("isover", (Object)"0", detailEntryIndex, tripEntryIndex);
        }
        if (StringUtils.isNotEmpty((CharSequence)entry.getString("tripstdshow"))) {
            model.setValue("tripstdshow", null, detailEntryIndex, tripEntryIndex);
        }
        if (StringUtils.isNotEmpty((CharSequence)entry.getString("highseasontripstdshow"))) {
            model.setValue("highseasontripstdshow", null, detailEntryIndex, tripEntryIndex);
        }
        TripStandardUtils.resetStdDetail((IDataModel)this.getModel(), (int)detailEntryIndex, (int)tripEntryIndex);
    }

    private void clearAllEntryStdShow(DynamicObjectCollection tripEntryCollction) {
        logger.info("clearAllEntryStdShow \u5f00\u59cb\u5faa\u73af");
        for (int tripEntryIndex = 0; tripEntryIndex < tripEntryCollction.size(); ++tripEntryIndex) {
            DynamicObject tripEntry = (DynamicObject)tripEntryCollction.get(tripEntryIndex);
            DynamicObjectCollection detailEntryCollction = tripEntry.getDynamicObjectCollection("entryentity");
            for (int detailEntryIndex = 0; detailEntryIndex < detailEntryCollction.size(); ++detailEntryIndex) {
                if (!StringUtils.isNotEmpty((CharSequence)((DynamicObject)detailEntryCollction.get(detailEntryIndex)).getString("tripstdshow"))) continue;
                this.getModel().setValue("tripstdshow", null, detailEntryIndex, tripEntryIndex);
            }
        }
        logger.info("clearAllEntryStdShow \u7ed3\u675f\u5faa\u73af");
    }

    protected Long getCompanyId() {
        Object company = this.getModel().getValue("company");
        Long companyId = company == null ? Long.valueOf(0L) : (Long)((DynamicObject)company).getPkValue();
        return companyId;
    }

    protected boolean isOpenAccdAndAllowanceStd() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        return this.isOpenTripStd() && dataEntity.getBoolean("tripstandcon");
    }

    private boolean isOpenTripStd() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        return dataEntity.getBoolean("isopentripstd");
    }

    protected boolean isOpenHighSeasonStd() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        return this.isOpenAccdAndAllowanceStd() && dataEntity.getBoolean("isopenhighseasontripstd");
    }

    protected boolean isOpenVehicStd() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        return this.isOpenTripStd() && dataEntity.getBoolean("isnoctrltripvhcctrlv");
    }

    protected boolean calculateAllowanceAndSet(int detailEntryIndex, int tripEntryIndex) {
        DynamicObjectCollection tripEntryCollction = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
        DynamicObject entry = (DynamicObject)((DynamicObject)tripEntryCollction.get(tripEntryIndex)).getDynamicObjectCollection("entryentity").get(detailEntryIndex);
        if (!this.isOpenAccdAndAllowanceStd()) {
            return false;
        }
        DynamicObject tripExpenseItem = entry.getDynamicObject("expenseitem");
        if (tripExpenseItem == null) {
            return false;
        }
        String attribute = tripExpenseItem.getString(TRIPEXP_ATTRIBUTE);
        boolean userOutStdCtrl = entry.getBoolean("useroutstdctrl");
        String settlementtype = entry.getString("settlementtype");
        String ctrltype = tripExpenseItem.getString(TRIPEXP_CTRLTYPE);
        BigDecimal oriMaxStdAmount = TripHighSeasonStandardUtil.getStandardamountTotal((boolean)this.isOpenHighSeasonStd(), (DynamicObject)entry);
        if ((StringUtils.equals((CharSequence)ctrltype, (CharSequence)"1") || StringUtils.equals((CharSequence)ctrltype, (CharSequence)"3") && !"true".equals(this.getPageCache().get("isafterbinddata"))) && StringUtils.equals((CharSequence)EXPENSE_ITEM_SUBSIDY, (CharSequence)attribute) && !userOutStdCtrl && !"2".equals(settlementtype) && oriMaxStdAmount.compareTo((BigDecimal)this.getModel().getValue("orientryamount", detailEntryIndex, tripEntryIndex)) != 0) {
            this.getModel().setValue("orientryamount", (Object)oriMaxStdAmount, detailEntryIndex, tripEntryIndex);
            return true;
        }
        return false;
    }

    private String makeUpTipNumbers(int row, int parentIndex) {
        String noticeCoordinate = DailyBillServiceHelper.isNewTripReim((DynamicObject)this.getModel().getDataEntity()) ? String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6", (String)"AbstractTripStdCtrlPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]), row) : String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6bb5\u884c\u7a0b\u7b2c%2$s\u884c\u660e\u7ec6", (String)"AbstractTripStdCtrlPlugin_7", (String)"fi-er-formplugin", (Object[])new Object[0]), parentIndex, row);
        return noticeCoordinate;
    }

    protected BigDecimal getTripDelayDay(int cardIndex, int rowIndex, Long companyId) {
        IDataModel model = this.getModel();
        String formId = this.getView().getFormShowParameter().getFormId();
        boolean isCardMobSecondPage = false;
        if (StringUtils.equals((CharSequence)formId, (CharSequence)"er_tripreimconsumer_mb")) {
            model = this.getView().getParentView().getModel();
            isCardMobSecondPage = true;
        }
        String billKind = this.getModel().getDataEntity().getString("billkind");
        DynamicObjectCollection mainPageTripEntry = model.getDataEntity(true).getDynamicObjectCollection("tripentry");
        DynamicObjectCollection tripEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
        DynamicObjectCollection detailEntry = ((DynamicObject)tripEntry.get(isCardMobSecondPage ? 0 : cardIndex)).getDynamicObjectCollection("entryentity");
        DynamicObject curRow = (DynamicObject)detailEntry.get(rowIndex);
        if (curRow.getDynamicObject("expenseitem") == null || !StringUtils.equals((CharSequence)ErTripExpenseItemConstant.Attribute.Subsidy.getValue(), (CharSequence)curRow.getDynamicObject("expenseitem").getString(TRIPEXP_ATTRIBUTE))) {
            return BigDecimal.ZERO;
        }
        if (!this.isOpenTripDateControl()) {
            return TripHighSeasonStandardUtil.getDelayDay((Long)companyId);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        switch (billKind) {
            case "0": {
                if (isCardMobSecondPage) {
                    Integer index = (Integer)this.getView().getFormShowParameter().getCustomParam("index");
                    int n = cardIndex = index == null ? mainPageTripEntry.size() : index.intValue();
                }
                if (cardIndex == 0) {
                    return TripHighSeasonStandardUtil.getDelayDay((Long)companyId);
                }
                Date preTripEndDay = ((DynamicObject)mainPageTripEntry.get(cardIndex - 1)).getDate("enddate");
                Date curTripStartDay = ((DynamicObject)tripEntry.get(isCardMobSecondPage ? 0 : cardIndex)).getDate("startdate");
                if (preTripEndDay != null && curTripStartDay != null && !simpleDateFormat.format(preTripEndDay).equals(simpleDateFormat.format(curTripStartDay))) {
                    return TripHighSeasonStandardUtil.getDelayDay((Long)companyId);
                }
                return BigDecimal.ZERO;
            }
            case "1": {
                if (curRow.getDate("trip2startdate") == null || curRow.getDate("trip2enddate") == null) {
                    return BigDecimal.ZERO;
                }
                if (rowIndex == 0) {
                    return TripHighSeasonStandardUtil.getDelayDay((Long)companyId);
                }
                List expenseItemList = detailEntry.stream().filter(v -> {
                    try {
                        return Integer.parseInt(v.getString("seq")) < Integer.parseInt(curRow.getString("seq")) && v.getDynamicObject("expenseitem") != null && v.getDynamicObject("expenseitem").getLong("id") == curRow.getDynamicObject("expenseitem").getLong("id") && v.getDate("trip2startdate") != null && v.getDate("trip2enddate") != null && simpleDateFormat.parse(simpleDateFormat.format(v.getDate("trip2enddate"))).compareTo(simpleDateFormat.parse(simpleDateFormat.format(curRow.getDate("trip2startdate")))) >= 0;
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                        logger.error((Throwable)e);
                        return false;
                    }
                }).collect(Collectors.toList());
                if (expenseItemList.isEmpty()) {
                    return TripHighSeasonStandardUtil.getDelayDay((Long)companyId);
                }
                return BigDecimal.ZERO;
            }
        }
        return BigDecimal.ZERO;
    }

    private void refreshAllHighSeasonDay() {
        DynamicObjectCollection tripEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
        IntStream.range(0, tripEntry.size()).forEach(pIdx -> {
            DynamicObjectCollection detailEntry = ((DynamicObject)tripEntry.get(pIdx)).getDynamicObjectCollection("entryentity");
            IntStream.range(0, detailEntry.size()).forEach(idx -> this.calcuHighSeasonDay(idx, pIdx, true, this.getTripDelayDay(pIdx, idx, this.getCompanyId())));
        });
    }

    private void refreshAllCalDayCount() {
        DynamicObjectCollection tripEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
        IntStream.range(0, tripEntry.size()).forEach(pIdx -> {
            DynamicObjectCollection detailEntry = ((DynamicObject)tripEntry.get(pIdx)).getDynamicObjectCollection("entryentity");
            IntStream.range(0, detailEntry.size()).forEach(idx -> this.updateCalDayCountByRow(this.getModel(), pIdx, idx));
        });
    }

    private boolean isOpenTripDateControl() {
        return SystemParamterUtil.isOpenTripDateControl((Long)this.getCompanyId()) && ((Boolean)this.getModel().getValue("istravelers") == false || (Boolean)this.getModel().getValue("istravelers") != false && (Boolean)this.getModel().getValue("travelerssamestd") != false) && (Boolean)this.getModel().getValue("isopentripstd") != false;
    }

    private void updateCalDayCountByRow(IDataModel model, int parentIndex, int rowIndex) {
        Date begin = (Date)model.getValue("trip2startdate", rowIndex, parentIndex);
        Date end = (Date)model.getValue("trip2enddate", rowIndex, parentIndex);
        BigDecimal calDay = new BigDecimal(CommonServiceHelper.calcDays((Date)begin, (Date)end));
        if (begin != null && end != null) {
            calDay = calDay.add(this.getTripDelayDay(parentIndex, rowIndex, this.getCompanyId()));
        }
        model.setValue("caldaycount", (Object)calDay, rowIndex, parentIndex);
    }

    private BigDecimal getHighSeasonDaysByPage(Integer parentIndex, Integer rowIndex, Date begin, Date end, DynamicObject tripArea, DynamicObject expenseItem) {
        String billKind;
        if (begin == null || end == null || expenseItem == null || tripArea == null || end.before(begin)) {
            return BigDecimal.ZERO;
        }
        DynamicObjectCollection tripEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
        Date preRowEndDate = null;
        switch (billKind = this.getModel().getDataEntity().getString("billkind")) {
            case "0": {
                if (StringUtils.equals((CharSequence)this.getView().getFormShowParameter().getFormId(), (CharSequence)"er_tripreimconsumer_mb")) {
                    tripEntry = this.getView().getParentView().getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
                    parentIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("index");
                }
                Integer preIndex = parentIndex != null && parentIndex != -1 ? parentIndex - 1 : tripEntry.size() - 1;
                OptionalInt preRowIndexOp = IntStream.range(0, tripEntry.size()).filter(idx -> idx == preIndex).findFirst();
                preRowEndDate = preRowIndexOp.isPresent() ? ((DynamicObject)tripEntry.get(preRowIndexOp.getAsInt())).getDate("enddate") : null;
                break;
            }
            case "1": {
                DynamicObjectCollection detailEntry = ((DynamicObject)tripEntry.get(0)).getDynamicObjectCollection("entryentity");
                List preIndexs = IntStream.range(0, detailEntry.size()).filter(idx -> idx < rowIndex && ((DynamicObject)detailEntry.get(idx)).getDynamicObject("expenseitem") != null && ((DynamicObject)detailEntry.get(idx)).getDynamicObject("expenseitem").getLong("id") == ErCommonUtils.getPk((Object)expenseItem).longValue()).boxed().collect(Collectors.toList());
                preRowEndDate = preIndexs.isEmpty() ? null : ((DynamicObject)detailEntry.get(((Integer)preIndexs.get(preIndexs.size() - 1)).intValue())).getDate("trip2enddate");
            }
        }
        return TripHighSeasonStandardUtil.getHighSeasonDays((Long)this.getCompanyId(), preRowEndDate, (Date)begin, (Date)end, (DynamicObject)tripArea, (DynamicObject)expenseItem, (boolean)this.isOpenTripDateControl());
    }

    private Integer getNextSameRowIndex(int rowIndex, DynamicObject expenseItem) {
        DynamicObjectCollection detailEntry = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry").get(0)).getDynamicObjectCollection("entryentity");
        OptionalInt lastIndex = IntStream.range(rowIndex + 1, detailEntry.size()).filter(idx -> ((DynamicObject)detailEntry.get(idx)).getDynamicObject("expenseitem") != null && ((DynamicObject)detailEntry.get(idx)).getDynamicObject("expenseitem").getLong("id") == ErCommonUtils.getPk((Object)expenseItem).longValue() && ((DynamicObject)detailEntry.get(idx)).getDate("trip2startdate") != null && ((DynamicObject)detailEntry.get(idx)).getDate("trip2enddate") != null).findFirst();
        return lastIndex.isPresent() ? Integer.valueOf(lastIndex.getAsInt()) : null;
    }

    private void upDateLastIndexCalDayCount(int rowIndex, int parentIndex, DynamicObject expenseItem) {
        Integer lastIndex;
        if (expenseItem != null && this.isOpenTripDateControl() && StringUtils.equals((CharSequence)this.getModel().getDataEntity().getString("billkind"), (CharSequence)"1") && (lastIndex = this.getNextSameRowIndex(rowIndex, expenseItem)) != null) {
            this.updateCalDayCount(parentIndex, lastIndex);
            this.calcuHighSeasonDay(lastIndex, parentIndex, true, this.getTripDelayDay(parentIndex, lastIndex, this.getCompanyId()));
        }
    }

    private Map buildExtMap(DynamicObject entry, int parentEntryIndex, int curEntryIndex) {
        return TripStandardUtils.buildExtMap((IFormView)this.getView(), (DynamicObject)entry, (int)parentEntryIndex, (int)curEntryIndex);
    }

    protected static class CheckEntryStdResult {
        private boolean isOver;
        private int tripEntryIndex;
        private int detailIndex;

        public CheckEntryStdResult(boolean isOver, int tripEntryIndex, int detailIndex) {
            this.isOver = isOver;
            this.tripEntryIndex = tripEntryIndex;
            this.detailIndex = detailIndex;
        }

        public void setTripEntryIndex(int tripEntryIndex) {
            this.tripEntryIndex = tripEntryIndex;
        }

        public void setOver(boolean over) {
            this.isOver = over;
        }

        public void setDetailIndex(int detailIndex) {
            this.detailIndex = detailIndex;
        }

        public boolean isOver() {
            return this.isOver;
        }

        public int getTripEntryIndex() {
            return this.tripEntryIndex;
        }

        public int getDetailIndex() {
            return this.detailIndex;
        }
    }

    private static class StdConfirm {
        private boolean isNeedConfirm;
        private String message;
        private boolean appendSuffix = true;

        public StdConfirm(boolean isNeedConfirm, String message, boolean appendSuffix) {
            this.isNeedConfirm = isNeedConfirm;
            this.message = message;
            this.appendSuffix = appendSuffix;
        }

        public boolean isNeedConfirm() {
            return this.isNeedConfirm;
        }

        public String getConfirmMessage() {
            return this.message;
        }

        public boolean isAppendSuffix() {
            return this.appendSuffix;
        }

        public void setAppendSuffix(boolean appendSuffix) {
            this.appendSuffix = appendSuffix;
        }
    }
}

