/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripstandard;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.common.ErBillStatusEnum;
import kd.fi.er.common.constant.ErTripExpenseItemConstant;
import kd.fi.er.formplugin.web.tripstandard.util.TripStandardUtils;
import org.apache.commons.lang3.StringUtils;

public class TripStandardAccomdationEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit control = (BasedataEdit)this.getControl("tripstandardtype");
        control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit reimLevelSelect = (BasedataEdit)this.getControl("reimburselevel");
        reimLevelSelect.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit triparea = (BasedataEdit)this.getControl("triparea");
        triparea.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit outTripStdCtrlUser = (BasedataEdit)this.getControl("outtripstdctrluser");
        outTripStdCtrlUser.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        if (this.getModel().getValue("createorg") == null) {
            return;
        }
        String entryName = e.getEntryProp().getName();
        if ("entryentity".equals(entryName)) {
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            Long createorg = (Long)((DynamicObject)this.getModel().getValue("createorg")).getPkValue();
            Long currencyId = BaseCurrencyServiceHelper.getBaseCurrencyId((Long)createorg);
            IDataModel model = this.getModel();
            for (RowDataEntity rowDataEntity : rowDataEntities) {
                int rowIndex = rowDataEntity.getRowIndex();
                model.setValue("currency", (Object)currencyId, rowIndex);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long companyId = TripStandardUtils.getCurrentUserCompanyId();
        this.getModel().setValue("company", (Object)companyId);
        if (this.getModel().getValue("createorg") == null) {
            return;
        }
        Long createorg = (Long)((DynamicObject)this.getModel().getValue("createorg")).getPkValue();
        Long currencyId = BaseCurrencyServiceHelper.getBaseCurrencyId((Long)createorg);
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < rowCount; ++i) {
            this.getModel().setValue("currency", (Object)currencyId, i);
        }
        TextProp property = (TextProp)this.getModel().getProperty("includeperson");
        property.setDefValue((Object)ResManager.loadKDString((String)"\u672a\u6dfb\u52a0", (String)"TripStandardAccomdationEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        QFilter baseDataProFilter;
        List qFilters;
        DynamicObject createOrg;
        String propertyName = arg0.getProperty().getName();
        ListShowParameter cardF7Param = (ListShowParameter)arg0.getFormShowParameter();
        if ("tripstandardtype".equals(arg0.getProperty().getName())) {
            List qFilters2 = cardF7Param.getListFilterParameter().getQFilters();
            qFilters2.add(new QFilter("attribute", "in", Arrays.asList(ErTripExpenseItemConstant.Attribute.Subsidy.getValue(), ErTripExpenseItemConstant.Attribute.Accommodation.getValue())));
        }
        if ("reimburselevel".equals(arg0.getProperty().getName())) {
            createOrg = (DynamicObject)this.getModel().getValue("createorg");
            qFilters = cardF7Param.getListFilterParameter().getQFilters();
            if (createOrg != null) {
                baseDataProFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_reimburselevel", (Long)((Long)createOrg.get("id")));
                qFilters.add(baseDataProFilter);
            } else {
                qFilters.add(new QFilter("1", "!=", (Object)"1"));
            }
        }
        if ("triparea".equals(arg0.getProperty().getName())) {
            createOrg = (DynamicObject)this.getModel().getValue("createorg");
            qFilters = cardF7Param.getListFilterParameter().getQFilters();
            if (createOrg != null) {
                baseDataProFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_triparea", (Long)((Long)createOrg.get("id")));
                if (null != baseDataProFilter) {
                    qFilters.add(baseDataProFilter);
                }
            } else {
                qFilters.add(new QFilter("1", "!=", (Object)"1"));
            }
        }
        if ("outtripstdctrluser".equals(propertyName)) {
            this.outStdCtrlUserBeforeF7Select(cardF7Param);
        }
    }

    protected void outStdCtrlUserBeforeF7Select(ListShowParameter cardF7Param) {
        Set levelIdSet = this.getModel().getDataEntity().getDynamicObjectCollection("reimburselevel").stream().filter(level -> level.get("fbasedataid") != null).map(level -> level.getLong("fbasedataid_id")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("reimburselevel", "in", levelIdSet);
        Set userNumberSet = QueryServiceHelper.query((String)"er_reimbursesetting_rel", (String)"user.number", (QFilter[])new QFilter[]{qFilter}).stream().filter(user -> user != null).map(user -> (String)user.get("user.number")).collect(Collectors.toSet());
        QFilter deafaultFilter = new QFilter("number", "in", userNumberSet);
        if (levelIdSet.contains(587648782179519488L)) {
            deafaultFilter = deafaultFilter.or(new QFilter("reimburselevel", "=", (Object)0L));
            deafaultFilter = deafaultFilter.or(new QFilter("auditstatus", "!=", (Object)ErBillStatusEnum.C.name()));
        } else {
            deafaultFilter = deafaultFilter.and("auditstatus", "=", (Object)ErBillStatusEnum.C.name());
        }
        Set userIdSet = QueryServiceHelper.query((String)"er_reimbursesetting", (String)"id", (QFilter[])new QFilter[]{deafaultFilter}).stream().filter(user -> user != null).map(user -> (Long)user.get("id")).collect(Collectors.toSet());
        cardF7Param.getListFilterParameter().getQFilters().add(new QFilter("id", "in", userIdSet));
        cardF7Param.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if (StringUtils.equals((CharSequence)"reimburselevel", (CharSequence)propertyName)) {
            DynamicObjectCollection oldValue = (DynamicObjectCollection)changeData.getOldValue();
            DynamicObjectCollection newValue = (DynamicObjectCollection)changeData.getNewValue();
            this.reimburseLevelChanged(oldValue, newValue);
        }
    }

    private void reimburseLevelChanged(DynamicObjectCollection oldValue, DynamicObjectCollection newValue) {
        Set oldLevelIdSet = oldValue.stream().filter(level -> level.get("fbasedataid") != null).map(level -> level.getLong("fbasedataid_id")).collect(Collectors.toSet());
        Set newLevelIdSet = newValue.stream().filter(level -> level.get("fbasedataid") != null).map(level -> level.getLong("fbasedataid_id")).collect(Collectors.toSet());
        HashSet<Long> removeDiff = new HashSet<Long>();
        for (Long oldLevelId : oldLevelIdSet) {
            if (newLevelIdSet.contains(oldLevelId)) continue;
            removeDiff.add(oldLevelId);
        }
        this.clearOutStdCtrlUserByReimburseLevel(removeDiff);
    }

    private void clearOutStdCtrlUserByReimburseLevel(Set<Long> removeDiffLevel) {
        if (removeDiffLevel.size() <= 0) {
            return;
        }
        DynamicObjectCollection stdDetailCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (int i = 0; i < stdDetailCollection.size(); ++i) {
            DynamicObjectCollection outStdCtrlUserColl = ((DynamicObject)stdDetailCollection.get(i)).getDynamicObjectCollection("outtripstdctrluser");
            outStdCtrlUserColl = this.removeOurStdCtrlUserByDiffLevel(outStdCtrlUserColl, removeDiffLevel);
            this.getModel().setValue("outtripstdctrluser", (Object)outStdCtrlUserColl, i);
            this.getView().updateView("outtripstdctrluser", i);
        }
    }

    private DynamicObjectCollection removeOurStdCtrlUserByDiffLevel(DynamicObjectCollection outStdCtrlUserColl, Set<Long> removeDiffLevel) {
        Set userIdSet = outStdCtrlUserColl.stream().filter(user -> user.get("fbasedataid") != null).map(user -> user.getLong("fbasedataid_id")).collect(Collectors.toSet());
        if (removeDiffLevel.contains(587648782179519488L)) {
            removeDiffLevel.add(0L);
        }
        QFilter removeFilter = new QFilter("id", "in", userIdSet).and(new QFilter("reimburselevel", "in", removeDiffLevel));
        userIdSet = QueryServiceHelper.query((String)"er_reimbursesetting", (String)"id", (QFilter[])new QFilter[]{removeFilter}).stream().filter(user -> user != null).map(user -> (Long)user.getPkValue()).collect(Collectors.toSet());
        Iterator iterator = outStdCtrlUserColl.iterator();
        while (iterator.hasNext()) {
            DynamicObject outStdUser = (DynamicObject)iterator.next();
            if (!userIdSet.contains(outStdUser.getLong("fbasedataid_id"))) continue;
            iterator.remove();
        }
        return outStdCtrlUserColl;
    }
}

