/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.report.query;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.servicehelper.ErPermissionServiceHelper;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.ConvertUtil;
import org.apache.commons.lang3.StringUtils;

public class ErUnReimbursementOrderReport
extends AbstractReportListDataPlugin {
    private static final String RELATE_ENTITY_ALL_ORDER = "er_allorderbill";
    private static final String RELATE_ENTITY_REQUEST_BILL = "er_tripreqbill";
    private static final String SUMMARY_TYPE = "summarytype";
    private static final String SUMMARY_ROW_INDEX = "sourcebookedname";
    private static final String ORDER_FIELD_INDEX = "index";
    private static final String LEFT_SELECT_FIELDS = "id,sourcebookedid.number sourcebookedcode,sourcebookedid.name sourcebookedname,company.id companycol,expcommitcomnum.id expcommitcomcol,server servercol,operationtype operationtypecol,ordernum,happenddate happenddatecol,totalamount,currency.id currencycol,oabillnum,0 as summarytype,orderformid";
    private static final String[] LEFT_SELECT_ALIAS_FIELDS = new String[]{"id", "sourcebookedcode", "sourcebookedname", "companycol", "expcommitcomcol", "servercol", "operationtypecol", "ordernum", "happenddatecol", "totalamount", "currencycol", "oabillnum", "0 as summarytype", "sourcebookedcode as index"};
    private static final String[] LEFT_SELECT_RESULT_FIELDS = new String[]{"id", "sourcebookedcode", "sourcebookedname", "companycol", "expcommitcomcol", "servercol", "operationtypecol", "ordernum", "happenddatecol", "totalamount", "currencycol", "oabillnum", "summarytype", "index", "reqidcol", "billno", "orgcol", "orgcolname", "orgcolid"};
    private static final String[] DATASET_SELECT_FIELDS = new String[]{"id", "sourcebookedcode", "sourcebookedname", "companycol", "expcommitcomcol", "servercol", "operationtypecol", "ordernum", "happenddatecol", "totalamount", "currencycol", "oabillnum", "summarytype", "index", "reqidcol", "billno", "orgcol", "orgcolname", "orgcolid", "case when remindday = null THEN DATEDIF(Now(),DATEADD('Day',0,happenddatecol),'D') ELSE DATEDIF(Now(),DATEADD('Day',remindday,happenddatecol),'D') END billaging"};
    private static final String[] DATASET_SELECT_FIELDS2 = new String[]{"id", "sourcebookedcode", "sourcebookedname", "companycol", "expcommitcomcol", "servercol", "operationtypecol", "ordernum", "happenddatecol", "totalamount", "currencycol", "oabillnum", "summarytype", "index", "reqidcol", "billno", "orgcol", "orgcolname", "orgcolid", "billaging", "case when billaging < 0 THEN 1 ELSE 0 END expireflag"};
    private static final String RIGHT_SELECT_FIELDS = "id reqidcol,billno,org orgcol,org.name as orgcolname,org.id as orgcolid";
    private static final String RIGHT_SELECT_ALIAS_FIELDS = "reqidcol,billno,orgcol,orgcolname,orgcolid";

    private void buildFilters(ReportQueryParam queryParam, List<QFilter> orderFilterList, List<QFilter> resultFilters) {
        FilterInfo commonFilterInfo = queryParam.getFilter();
        commonFilterInfo.getFilterItems().forEach(filterItem -> {
            String propName = filterItem.getPropName();
            Object value = filterItem.getValue();
            String compareType = filterItem.getCompareType();
            if ("filter_orgcol.name".equals(propName)) {
                resultFilters.add(new QFilter("orgcolname", compareType, value));
            } else if ("filter_orgcol.id".equals(propName)) {
                resultFilters.add(new QFilter("orgcolid", compareType, value));
            } else if ("happenddate".equals(propName) || "company.id".equals(propName) || "company.name".equals(propName)) {
                orderFilterList.add(new QFilter(propName, compareType, value));
            } else if ("filter_sourcebookedcode".equals(propName)) {
                orderFilterList.add(new QFilter("sourcebookedid.number", compareType, value));
            } else if ("filter_sourcebookedname".equals(propName)) {
                orderFilterList.add(new QFilter("sourcebookedid.name", compareType, value));
            } else if ("filter_expcommitcomcol.name".equals(propName)) {
                orderFilterList.add(new QFilter("expcommitcomnum.name", compareType, value));
            } else if ("filter_expcommitcomcol.id".equals(propName)) {
                orderFilterList.add(new QFilter("expcommitcomnum.id", compareType, value));
            } else if ("filter_servercol".equals(propName)) {
                orderFilterList.add(new QFilter("server", compareType, value));
            } else if ("filter_operationtypecol".equals(propName)) {
                orderFilterList.add(new QFilter("operationtype", compareType, value));
            } else if ("filter_ordernum".equals(propName)) {
                orderFilterList.add(new QFilter("ordernum", compareType, value));
            } else if ("filter_totalamount".equals(propName)) {
                orderFilterList.add(new QFilter("totalamount", compareType, value));
            } else if ("filter_oabillnum".equals(propName)) {
                orderFilterList.add(new QFilter("oabillnum", compareType, value));
            }
        });
        if (commonFilterInfo.getFilterItems("company.id") == null) {
            ErPermissionServiceHelper.setOrgFilterByPerm(orderFilterList, (String)"company.id", null, (String)"er_not_reimbursed_bill", null);
        }
    }

    public DataSet query(ReportQueryParam queryParam, Object arg1) throws Throwable {
        ArrayList<QFilter> mainFilters = new ArrayList<QFilter>();
        ArrayList<QFilter> resultFilters = new ArrayList<QFilter>();
        this.buildFilters(queryParam, mainFilters, resultFilters);
        DataSet detailDataSet = this.buildDetailRows(mainFilters, resultFilters);
        DataSet subTotalDataSet = this.buildSummaryRows(detailDataSet, ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"ErUnReimbursementOrderReport_0", (String)"fi-er-report", (Object[])new Object[0]), "2", new String[]{SUMMARY_ROW_INDEX, ORDER_FIELD_INDEX});
        DataSet totalDataSet = this.buildSummaryRows(subTotalDataSet, ResManager.loadKDString((String)"\u5408\u8ba1", (String)"ErUnReimbursementOrderReport_1", (String)"fi-er-report", (Object[])new Object[0]), "1", new String[0]);
        return detailDataSet.union(subTotalDataSet).orderBy(new String[]{ORDER_FIELD_INDEX, SUMMARY_TYPE}).union(totalDataSet);
    }

    private DataSet buildSummaryRows(DataSet detail, String summaryName, String summaryType, String[] groupBy) {
        DataSet totalRowDataSet = detail.copy();
        totalRowDataSet = totalRowDataSet.groupBy(groupBy).sum("totalamount").finish();
        Field[] totalFields = totalRowDataSet.getRowMeta().getFields();
        HashSet totalExistFields = new HashSet();
        Stream.of(totalFields).forEach(v -> totalExistFields.add(v.getAlias().toUpperCase()));
        Field[] allFields = detail.getRowMeta().getFields();
        ArrayList groupSelectFields = Lists.newArrayListWithExpectedSize((int)32);
        for (Field field : allFields) {
            String fieldName;
            String temp = fieldName = field.getAlias().toUpperCase();
            if (!totalExistFields.contains(fieldName)) {
                temp = "null as " + fieldName;
                if (SUMMARY_TYPE.equalsIgnoreCase(fieldName)) {
                    temp = String.format("%s as %s", summaryType, fieldName);
                }
            }
            if (SUMMARY_ROW_INDEX.equalsIgnoreCase(fieldName)) {
                temp = String.format("'%s' as %s", summaryName, fieldName);
            }
            groupSelectFields.add(temp);
        }
        totalRowDataSet = totalRowDataSet.select(groupSelectFields.toArray(new String[groupSelectFields.size()]));
        return totalRowDataSet;
    }

    private DataSet buildDetailRows(List<QFilter> mainFilters, List<QFilter> resultFilters) {
        mainFilters.add(new QFilter("isapprove", "=", (Object)"0"));
        mainFilters.add(new QFilter("isreimburse", "=", (Object)"0"));
        mainFilters.add(new QFilter("happenddate", "is not null", null));
        mainFilters.add(new QFilter("producttype", "!=", (Object)"2"));
        mainFilters.add(new QFilter("totalamount", "!=", (Object)BigDecimal.ZERO));
        mainFilters.add(new QFilter("totalamount", "!=", (Object)ConvertUtil.getOrderAmountInit()));
        DataSet mainDataSet = ErDaoFactory.getInstance((String)RELATE_ENTITY_ALL_ORDER).queryDataSet(((Object)((Object)this)).getClass().getName(), LEFT_SELECT_FIELDS, mainFilters.toArray(new QFilter[mainFilters.size()]));
        HashSet billNOs = new HashSet();
        mainDataSet = this.removeVehicleBills(mainDataSet, mainFilters);
        ArrayList<QFilter> billFilters = new ArrayList<QFilter>();
        if (!mainFilters.isEmpty()) {
            DataSet mainDataSetCopy = mainDataSet.copy();
            mainDataSetCopy.iterator().forEachRemaining(v -> billNOs.add(v.getString("oabillnum")));
            billFilters.add(new QFilter("billno", "in", billNOs));
            mainDataSetCopy.close();
        }
        DataSet requestDataSet = ErDaoFactory.getInstance((String)RELATE_ENTITY_REQUEST_BILL).queryDataSet(((Object)((Object)this)).getClass().getName(), RIGHT_SELECT_FIELDS, billFilters.toArray(new QFilter[billFilters.size()]));
        DataSet orderbillAndReqbillDataset = mainDataSet.join(requestDataSet, JoinType.LEFT).on("oabillnum", "billno").select(LEFT_SELECT_ALIAS_FIELDS, RIGHT_SELECT_ALIAS_FIELDS.split(",")).finish();
        DataSet overTimesDataset = ErDaoFactory.getInstance((String)"er_overtime_setting").queryDataSet(((Object)((Object)this)).getClass().getName(), "isp,servicetype,remindday", null);
        DataSet resultDataset = orderbillAndReqbillDataset.join(overTimesDataset, JoinType.LEFT).on("servercol", "isp").on("operationtypecol", "servicetype").select(LEFT_SELECT_RESULT_FIELDS, new String[]{"remindday"}).finish();
        resultDataset = resultDataset.select(DATASET_SELECT_FIELDS);
        resultDataset = resultDataset.select(DATASET_SELECT_FIELDS2);
        StringBuilder resultFilter = new StringBuilder();
        resultFilters.forEach(v -> {
            resultFilter.append(" and ");
            resultFilter.append(v);
        });
        if (!resultFilters.isEmpty()) {
            resultDataset = resultDataset.filter(resultFilter.toString().replaceFirst(" and ", ""));
        }
        return resultDataset;
    }

    private DataSet removeVehicleBills(DataSet mainDataSet, List<QFilter> mainFilters) {
        DataSet copy = mainDataSet.copy();
        Iterator iterator = copy.iterator();
        HashSet<String> vehicleOrderNumSet = new HashSet<String>();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            String orderFormId = row.getString("orderformid");
            if (!StringUtils.equals((CharSequence)orderFormId, (CharSequence)"er_vehiclebill")) continue;
            vehicleOrderNumSet.add(row.getString("ordernum"));
        }
        DynamicObjectCollection vehicleBills = QueryServiceHelper.query((String)"er_vehiclebill", (String)"id,vehicletype,ordernum", (QFilter[])new QFilter[]{new QFilter("ordernum", "in", vehicleOrderNumSet)});
        Set removeOrderNumSet = vehicleBills.stream().filter(dynamicObject -> Lists.newArrayList((Object[])new String[]{"2", "3", "4"}).contains(dynamicObject.getString("vehicletype"))).map(dynamicObject -> dynamicObject.getString("ordernum")).collect(Collectors.toSet());
        if (removeOrderNumSet.size() > 0) {
            mainFilters.add(new QFilter("ordernum", "not in", removeOrderNumSet));
            return ErDaoFactory.getInstance((String)RELATE_ENTITY_ALL_ORDER).queryDataSet(((Object)((Object)this)).getClass().getName(), LEFT_SELECT_FIELDS, mainFilters.toArray(new QFilter[mainFilters.size()]));
        }
        return mainDataSet;
    }

    private static class ReportConstant {
        public static final String SOURCE_BOOKED_CODE = "sourcebookedcode";
        public static final String SOURCE_BOOKED_NAME = "sourcebookedname";
        public static final String ORG_COL = "orgcol";
        public static final String COMPANY_COL = "companycol";
        public static final String SERVER_COL = "servercol";
        public static final String OPERATION_TYPE_COL = "operationtypecol";
        public static final String ORDER_NUM = "ordernum";
        public static final String HAPPENDDATE_COL = "happenddatecol";
        public static final String TOTAL_AMOUNT = "totalamount";
        public static final String OA_BILL_NUM = "oabillnum";
        public static final String SUMMARY_TYPE = "summarytype";

        private ReportConstant() {
        }
    }
}

