/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.report.reimctl.mob;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.daily.service.model.ReimburseAmountDetailBean;
import kd.fi.er.business.reimamountctl.mode.QuotaCtrlMode;
import kd.fi.er.business.reimamountctl.mode.QuotaCtrlModeFactory;
import kd.fi.er.business.reimamountctl.model.QuotaAmountBO;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.formplugin.daily.mobile.common.CommonUtilHelper;
import kd.fi.er.report.reimctl.ErAbstractReimCtlUseDetailPlugin;
import org.apache.commons.lang3.StringUtils;

public class ErReimCtlUsedBillDetailMobPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[0]);
        CardEntry cardEntry = (CardEntry)this.getControl("usedetailentity");
        cardEntry.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                ErReimCtlUsedBillDetailMobPlugin.this.openBill(evt.getRow());
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        this.genEntry();
    }

    private void genEntry() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object userQueryParam = formShowParameter.getCustomParam("reimAmountQueryBean");
        QuotaAmountBO quotaAmountBO = (QuotaAmountBO)((JSONObject)userQueryParam).toJavaObject(QuotaAmountBO.class);
        Integer year = quotaAmountBO.getHappenYear();
        if (quotaAmountBO == null) {
            return;
        }
        LocalDate startDate = LocalDate.of((int)year, 1, 1);
        LocalDate endDate = LocalDate.of((int)year, 12, 31);
        Integer month = (Integer)formShowParameter.getCustomParam("reimAmountQueryMonth");
        if (month != null && month >= 1 && month <= 12) {
            startDate = LocalDate.of((int)year, month, 1);
            endDate = startDate.with(TemporalAdjusters.lastDayOfMonth());
        }
        quotaAmountBO.setHappenDatePeriod(new LocalDate[]{startDate, endDate});
        Long currencyId = quotaAmountBO.getCurrencyId();
        QuotaCtrlMode quotaCtrlMode = QuotaCtrlModeFactory.getQuotaCtrlMode((QuotaAmountBO)quotaAmountBO);
        List reimedDetails = quotaCtrlMode.getReimbursedBills(quotaAmountBO);
        Boolean isDeptAmount = (Boolean)formShowParameter.getCustomParam("isDeptAmount");
        if (isDeptAmount.booleanValue()) {
            boolean isNeedFilter = CommonServiceHelper.isFullApp((String)this.getView().getFormShowParameter().getAppId()) && !CommonUtilHelper.isDeptAdmin((Long)quotaAmountBO.getUserOrDeptId(), (Long)Long.valueOf(RequestContext.getOrCreate().getUserId()));
            HashMap specialDataPermissionFilters = Maps.newHashMapWithExpectedSize((int)reimedDetails.size());
            if (isNeedFilter) {
                Set entityKeys = reimedDetails.stream().map(ReimburseAmountDetailBean::getMetaKey).collect(Collectors.toSet());
                for (String entityKey : entityKeys) {
                    QFilter specialDataPermissionFilter = null;
                    specialDataPermissionFilter = entityKey.equals("er_tripreimbursebill") ? PermissionFilterUtil.getSpecialDataPermissionFilter((String)"tra", (String)entityKey, (String)"view", (ITimeService)((ITimeService)this.getView().getService(ITimeService.class)), (IUserService)((IUserService)this.getView().getService(IUserService.class))) : (entityKey.equals("er_dailyreimbursebill") ? PermissionFilterUtil.getSpecialDataPermissionFilter((String)"exp", (String)entityKey, (String)"view", (ITimeService)((ITimeService)this.getView().getService(ITimeService.class)), (IUserService)((IUserService)this.getView().getService(IUserService.class))) : CommonUtilHelper.getSpecialDataPermissionFilter((IFormView)this.getView(), (String)entityKey));
                    specialDataPermissionFilters.put(entityKey, specialDataPermissionFilter);
                }
                reimedDetails = reimedDetails.stream().filter(detail -> {
                    QFilter speicalDataPermQFilter = (QFilter)specialDataPermissionFilters.get(detail.getMetaKey());
                    if (speicalDataPermQFilter == null) {
                        return true;
                    }
                    return QueryServiceHelper.exists((String)detail.getMetaKey(), (QFilter[])new QFilter[]{speicalDataPermQFilter, QFilter.of((String)"id=?", (Object[])new Object[]{detail.getBillId()})});
                }).collect(Collectors.toList());
            }
        }
        this.createEntity(reimedDetails, currencyId);
    }

    private void createEntity(List<ReimburseAmountDetailBean> amountDetails, Long currencyId) {
        if (amountDetails.isEmpty()) {
            return;
        }
        Map<ErAbstractReimCtlUseDetailPlugin.GroupListKey, List<ReimburseAmountDetailBean>> groupedLists = amountDetails.stream().collect(Collectors.groupingBy(k -> {
            ErAbstractReimCtlUseDetailPlugin.GroupListKey gKey = new ErAbstractReimCtlUseDetailPlugin.GroupListKey(k.getMetaKey(), k.getBillName(), k.getBillId(), k.getBillno());
            gKey.setMobFormKey(k.getMobFormKey());
            return gKey;
        }));
        IDataModel model = this.getView().getModel();
        int[] indexs = model.batchCreateNewEntryRow("usedetailentity", groupedLists.size());
        int i = 0;
        for (Map.Entry<ErAbstractReimCtlUseDetailPlugin.GroupListKey, List<ReimburseAmountDetailBean>> pair : groupedLists.entrySet()) {
            ErAbstractReimCtlUseDetailPlugin.GroupListKey groupKey = pair.getKey();
            List<ReimburseAmountDetailBean> value = pair.getValue();
            int index = indexs[i++];
            model.setValue("billname", (Object)groupKey.getBillName(), index);
            model.setValue("metakey", (Object)groupKey.getMetaKey(), index);
            model.setValue("billno", (Object)groupKey.getBillno(), index);
            model.setValue("billid", (Object)groupKey.getBillId(), index);
            model.setValue("currencyid", (Object)currencyId, index);
            model.setValue("mobformkey", (Object)groupKey.getMobFormKey(), index);
            BigDecimal usedAmount = value.stream().map(bean -> bean.getReimburseAmount()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            model.setValue("usedamount", (Object)usedAmount, index);
        }
    }

    private void openBill(int rowIndex) {
        IDataModel model = this.getView().getModel();
        String metaKey = (String)model.getValue("mobformkey", rowIndex);
        String entityId = (String)model.getValue("metakey", rowIndex);
        Long billId = (Long)model.getValue("billid", rowIndex);
        if (StringUtils.isNotBlank((CharSequence)metaKey)) {
            DynamicObject bill;
            if (StringUtils.equals((CharSequence)"er_tripreimbursebill", (CharSequence)entityId) && StringUtils.equals((CharSequence)(bill = QueryServiceHelper.queryOne((String)"er_tripreimbursebill", (String)"billkind", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)})).getString("billkind"), (CharSequence)"1")) {
                metaKey = "er_tripreim_grid_mb";
            }
            MobileBillShowParameter showParameter = new MobileBillShowParameter();
            showParameter.setFormId(metaKey);
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setPkId((Object)billId);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }
}

