/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.botp.writeback;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.common.integrationenum.CasWriteBackOperateEnum;
import kd.fi.er.mservice.botp.writeback.AbstractWriteBackServcie;
import kd.fi.er.mservice.param.ErRefundEntryInfo;
import org.apache.commons.lang3.StringUtils;

public class ErCheckingpaybillWriteBackService
extends AbstractWriteBackServcie {
    private static Log logger = LogFactory.getLog(ErCheckingpaybillWriteBackService.class);

    @Override
    protected boolean writeBack(DynamicObject sourceBill, Object tarBillEntryInfo, Object targetPkId) {
        String operate = this.getOperateName();
        if ("payOrSync".equals(operate)) {
            String select = "id, actpayamt, billstatus,entry.e_actamt,entry.e_sourcebillid";
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)targetPkId, (String)"cas_paybill", (String)select);
            DynamicObjectCollection entry2 = dynamicObject.getDynamicObjectCollection("entry");
            Long billid = Long.parseLong(null == sourceBill.getPkValue() ? "0" : sourceBill.getPkValue().toString());
            if (entry2 != null && entry2.size() > 0) {
                BigDecimal amount;
                HashMap<Long, BigDecimal> sourAmoutMap = new HashMap<Long, BigDecimal>(8);
                for (int i = 0; i < entry2.size(); ++i) {
                    String e_actamt;
                    DynamicObject en = (DynamicObject)entry2.get(i);
                    Object e_sourcebillid = en.get("e_sourcebillid");
                    if (e_sourcebillid == null) continue;
                    logger.info("entry sourceBillId:{}", e_sourcebillid);
                    Long sourceBillId = Long.valueOf(e_sourcebillid.toString());
                    logger.info("Line 43 origin sourceBillId:{}", sourceBill.getPkValue());
                    if (!sourceBillId.equals(sourceBill.getPkValue())) continue;
                    logger.info("Line 45 origin sourceBillId:{}", sourceBill.getPkValue());
                    String string = e_actamt = en.get("e_actamt") == null ? "0" : en.get("e_actamt").toString();
                    if (sourAmoutMap.containsKey(sourceBillId)) {
                        sourAmoutMap.put(sourceBillId, ((BigDecimal)sourAmoutMap.get(sourceBillId)).add(new BigDecimal(e_actamt)));
                        continue;
                    }
                    sourAmoutMap.put(sourceBillId, new BigDecimal(e_actamt));
                }
                BigDecimal bigDecimal = amount = sourAmoutMap.get(billid) == null ? BigDecimal.ZERO : (BigDecimal)sourAmoutMap.get(billid);
                if (sourceBill.getBigDecimal("totalamount_head").compareTo(amount) < 0) {
                    logger.info("\u4ed8\u6b3e\u5904\u7406\u5df2\u4ed8\u91d1\u989d\uff1a{}\uff0c\u5e94\u4ed8\u91d1\u989d\uff1a{}", (Object)sourceBill.getBigDecimal("totalamount_head"), (Object)amount);
                    this.getErrorCollection().put(String.valueOf(targetPkId), ResManager.loadKDString((String)"\u8be5\u7b14\u4ed8\u6b3e\u5173\u8054\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u5df2\u4ed8\u91d1\u989d\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"ErCheckingpaybillWriteBackService_01", (String)"fi-er-mservice", (Object[])new Object[0]));
                    return false;
                }
                sourceBill.set("payamount", sourAmoutMap.get(billid));
            }
            sourceBill.set("billstatus", (Object)"G");
        } else if (CasWriteBackOperateEnum.CANCELPAY.getValue().equals(operate)) {
            sourceBill.set("payamount", (Object)BigDecimal.ZERO);
            sourceBill.set("billstatus", (Object)"F");
        } else if (CasWriteBackOperateEnum.REFUND.getValue().equals(operate) || CasWriteBackOperateEnum.RENOTE.getValue().equals(operate)) {
            DynamicObject cas_paybill = BusinessDataServiceHelper.loadSingle((String)"cas_paybill", (String)"actpayamt,entry,entry.e_refundamt", (QFilter[])new QFilter[]{new QFilter("id", "=", targetPkId)});
            BigDecimal refundingAmount = cas_paybill.getDynamicObjectCollection("entry").stream().map(r -> r.getBigDecimal("e_refundamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal actpayAmount = cas_paybill.getBigDecimal("actpayamt");
            BigDecimal paybillWriteBackAmount = actpayAmount.subtract(refundingAmount);
            sourceBill.set("payamount", (Object)paybillWriteBackAmount);
            sourceBill.set("paybillwriteback", (Object)paybillWriteBackAmount);
            if (paybillWriteBackAmount.compareTo(BigDecimal.ZERO) > 0) {
                sourceBill.set("billstatus", (Object)"F");
            } else {
                sourceBill.set("billstatus", (Object)"E");
            }
        }
        if ("payOrSync".equals(operate) || CasWriteBackOperateEnum.CANCELPAY.getValue().equals(operate)) {
            Object tarBillEntry;
            Object srcEntryMapPkId = null;
            if (tarBillEntryInfo instanceof DynamicObject) {
                tarBillEntry = (DynamicObject)tarBillEntryInfo;
                srcEntryMapPkId = tarBillEntry.get("sourceentryid");
            } else if (!(tarBillEntryInfo instanceof ErRefundEntryInfo)) {
                tarBillEntry = (Map)tarBillEntryInfo;
                srcEntryMapPkId = tarBillEntry.get("sourceentrypk");
            }
            String select = "id,entry.e_sourcebillid";
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)targetPkId, (String)"cas_paybill", (String)select);
            DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("entry");
            boolean match = false;
            if (entrys != null && entrys.size() > 0) {
                match = entrys.stream().anyMatch(m -> Objects.equals(m.get("e_sourcebillid"), sourceBill.getPkValue()));
            }
            if (!match) {
                this.addErrorCode(String.valueOf(targetPkId), ResManager.loadKDString((String)"\u672a\u627e\u5230\u6e90\u5355\uff0c\u6216\u4f20\u9012\u53c2\u6570\u5bf9\u5e94\u7684\u4e0b\u6e38\u5206\u5f55\u4e0d\u6b63\u786e\u3002", (String)"AbstractWriteBackServcie_0", (String)"fi-er-mservice", (Object[])new Object[0]));
                return false;
            }
            if (!Objects.equals(sourceBill.getPkValue(), srcEntryMapPkId)) {
                logger.info("\u51fa\u7eb3\u96c6\u6210,\u5546\u65c5\u4ed8\u6b3e\u7533\u8bf7\u5355\uff0c\u6e90\u5355id\u548c\u4f20\u5165\u7684\u53c2\u6570\u6e90\u5355id\u4e0d\u5339\u914d");
                return true;
            }
            boolean check = this.checkCanWriteBack(this.getBillType(tarBillEntryInfo), (Long)targetPkId, this.getEntryId(tarBillEntryInfo), this.getRecId(tarBillEntryInfo));
            if (!check) {
                logger.info("\u51fa\u7eb3\u96c6\u6210,\u5df2\u7ecf\u53cd\u5199\u8fc7\uff0c\u4e0d\u518d\u53cd\u5199\uff0c\u76ee\u6807\u5355\uff1a{}\uff0c \u5206\u5f55\uff1a{} ", targetPkId, (Object)SerializationUtils.toJsonString((Object)tarBillEntryInfo));
                return true;
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sourceBill});
            this.saveWriteBackRecord(this.getBillType(tarBillEntryInfo), (Long)targetPkId, this.getEntryId(tarBillEntryInfo), this.getRecId(tarBillEntryInfo));
            String orderformid = "";
            DynamicObjectCollection entryentity = sourceBill.getDynamicObjectCollection("entryentity");
            if (null == entryentity || entryentity.isEmpty()) {
                return true;
            }
            Map foperationtypeMap = entryentity.parallelStream().collect(Collectors.groupingBy(entry -> entry.getString("entry_operationtype"), Collectors.toList()));
            for (Map.Entry next : foperationtypeMap.entrySet()) {
                String foperationtype;
                switch (foperationtype = next.getKey()) {
                    case "1": {
                        orderformid = "er_hotelcheckingbill";
                        break;
                    }
                    case "2": {
                        orderformid = "er_planecheckingbill";
                        break;
                    }
                    case "3": {
                        orderformid = "er_vehiclecheckingbill";
                        break;
                    }
                    case "4": {
                        orderformid = "er_traincheckingbill";
                        break;
                    }
                    case "5": {
                        orderformid = "er_mealcheckingbill";
                    }
                }
                if (!StringUtils.isNotEmpty((CharSequence)orderformid)) continue;
                IErDao CheckingBillDao = ErDaoFactory.getInstance((String)orderformid);
                QFilter filter = new QFilter("paybillid", "=", sourceBill.getPkValue());
                CheckingBillDao.update("paybillstatus", (Object)("G".equals(sourceBill.getString("billstatus")) ? "1" : "0"), filter);
            }
            return true;
        }
        return true;
    }

    @Override
    public String getSelectFileds() {
        return "id, billstatus, totalamount_head, payamount, modifytime,paybillwriteback, orderformid";
    }
}

