/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.botp.writeback;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.fi.cas.refund.RefundEntryInfo;
import kd.fi.cas.refund.SourceBillInfo;
import kd.fi.er.mservice.botp.writeback.AbstractWriteBackServcie;
import kd.fi.er.mservice.param.ErRefundEntryInfo;

public class TripBusinessBillWriteBackService
extends AbstractWriteBackServcie {
    private static final String ISSUCCESS = "issuccess";
    private static final String PAYBILL_STATUS = "paybillstatus";
    private static final String PAYBILL_NUM = "paybillnum";

    @Override
    protected boolean writeBack(DynamicObject sourceBill, Object tarBillEntryInfo, Object targetPkId) {
        Boolean isSuccess;
        Long sourceBillIdOfTar;
        Object tarBillEntry;
        if (tarBillEntryInfo instanceof DynamicObject) {
            tarBillEntry = (DynamicObject)tarBillEntryInfo;
            sourceBillIdOfTar = tarBillEntry.getLong("sourcebillid");
            isSuccess = Boolean.valueOf(String.valueOf(tarBillEntry.get("e_issuccess")));
        } else if (tarBillEntryInfo instanceof ErRefundEntryInfo) {
            ErRefundEntryInfo refund = (ErRefundEntryInfo)tarBillEntryInfo;
            RefundEntryInfo tarBillEntry2 = refund.getRefundEntryInfo();
            sourceBillIdOfTar = ((SourceBillInfo)tarBillEntry2.getSourceInfos().get(0)).getSourcePk();
            isSuccess = tarBillEntry2.getSuccess();
        } else {
            tarBillEntry = (Map)tarBillEntryInfo;
            sourceBillIdOfTar = (Long)tarBillEntry.get("sourcepk");
            isSuccess = Boolean.valueOf(String.valueOf(tarBillEntry.get(ISSUCCESS)));
        }
        Long srcBillId = (Long)sourceBill.getPkValue();
        if (srcBillId.equals(sourceBillIdOfTar)) {
            try {
                String operateName = this.getOperateName();
                if (operateName.equalsIgnoreCase("renote") || operateName.equalsIgnoreCase("refund")) {
                    sourceBill.set(PAYBILL_STATUS, (Object)"");
                    sourceBill.set(PAYBILL_NUM, (Object)"");
                } else if (operateName.equalsIgnoreCase("cancelPay")) {
                    sourceBill.set(PAYBILL_STATUS, (Object)"0");
                } else if (operateName.equalsIgnoreCase("payOrSync")) {
                    if (isSuccess.booleanValue()) {
                        sourceBill.set(PAYBILL_STATUS, (Object)"1");
                    } else {
                        sourceBill.set(PAYBILL_STATUS, (Object)"0");
                    }
                }
            }
            catch (KDBizException e) {
                this.addErrorCode(String.valueOf(targetPkId), (Object)e);
                return false;
            }
        }
        return true;
    }

    @Override
    public String getSelectFileds() {
        return "id, billstatus,paybillstatus,paybillnum, modifytime";
    }
}

