/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.invoice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.fi.er.business.invoicecloud.InvoiceService;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.APIHelper;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.provider.param.req.ImportInvoiceIframeUrlReqParam;
import kd.fi.er.business.servicehelper.InvoiceServiceHelper;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ExpenseShareInvoiceUtil;
import kd.fi.er.mservice.invoice.IShowInvoiceOrAttachmentService;

public class ShowInvoiceOrAttachmentServiceImpl
implements IShowInvoiceOrAttachmentService {
    private static Log log = LogFactory.getLog(ShowInvoiceOrAttachmentServiceImpl.class);

    public Map showDeleteAttachment(String pageId, DynamicObject bill) {
        HashMap map = new HashMap(2);
        IFormView billView = SessionManager.getCurrent().getView(pageId);
        ImportInvoiceIframeUrlReqParam importRequestParam = new ImportInvoiceIframeUrlReqParam();
        DynamicObject d = billView.getModel().getDataEntity(true);
        importRequestParam.setBillId(APIHelper.getBillNoCachedInCloud((DynamicObject)d));
        Long costCompany = KingdeeInvoiceCloudConfig.getCostCompanyId((DynamicObject)d);
        if (costCompany == null) {
            billView.showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c\u3002", (String)"ShowInvoiceOrAttachmentServiceImpl_0", (String)"fi-er-mservice", (Object[])new Object[0]));
            return map;
        }
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)costCompany);
        if (config == null) {
            log.info("\u6839\u636e\u8d39\u7528\u627f\u62c5\u516c\u53f8\uff1a {}\u672a\u627e\u5230\u53d1\u7968\u4e91\u914d\u7f6e", (Object)costCompany);
            billView.showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u542f\u7528\u53d1\u7968\u4e91\uff0c\u8bf7\u5148\u914d\u7f6e\u53d1\u7968\u4e91\u3002", (String)"APIHelper_22", (String)"fi-er-business", (Object[])new Object[0]));
            return map;
        }
        importRequestParam.setTaxRegNum(config.getTaxRegnum());
        importRequestParam.setInvoiceCompanyId(costCompany);
        String callBackName = "";
        String entityId = d.getDynamicObjectType().getName();
        callBackName = this.getCallbackClassName(billView, d, entityId);
        CloseCallBack callBack = new CloseCallBack(callBackName, "delete_attach_callback_key");
        if (billView instanceof IMobileView) {
            billView.getPageCache().put("deleteerattachmentoperate", "deleteerattachmentoperate");
            InvoiceService.getInstanceService().baseShowDeleteAttachmentInMob(callBack, importRequestParam, billView);
        } else {
            InvoiceService.getInstanceService().baseShowDeleteAttachmentInPc(callBack, importRequestParam, billView);
        }
        return map;
    }

    @Override
    public Map getShowInvoiceParamter(String pageId, DynamicObject bill) {
        HashMap map = new HashMap(2);
        IFormView billView = SessionManager.getCurrent().getView(pageId);
        DynamicObject d = billView.getModel().getDataEntity(true);
        Long costCompany = KingdeeInvoiceCloudConfig.getCostCompanyId((DynamicObject)d);
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)costCompany);
        if (config == null) {
            log.info("\u6839\u636e\u8d39\u7528\u627f\u62c5\u516c\u53f8\uff1a {}\u672a\u627e\u5230\u53d1\u7968\u4e91\u914d\u7f6e", (Object)costCompany);
            billView.showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u542f\u7528\u53d1\u7968\u4e91\uff0c\u8bf7\u5148\u914d\u7f6e\u53d1\u7968\u4e91\u3002", (String)"APIHelper_22", (String)"fi-er-business", (Object[])new Object[0]));
            return map;
        }
        List serialNos = new ArrayList(0);
        DynamicObjectType type = d.getDynamicObjectType();
        if (type.getProperty("invoiceentry") != null) {
            serialNos = InvoiceServiceHelper.getAllSerialNos((IDataModel)billView.getModel());
        }
        if (ErEntityTypeUtils.isShareBill((String)type.getName())) {
            serialNos = new ArrayList(ExpenseShareInvoiceUtil.getAllSerialNos((DynamicObject)d));
            if (serialNos.isEmpty() && type.getProperty("invoiceattachinfo") != null && d.getDynamicObjectCollection("invoiceattachinfo").size() == 0) {
                billView.showErrorNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53d1\u7968\u9644\u4ef6\u6570\u636e\u3002", (String)"ImportAttachmentPlugin_1", (String)"fi-er-business", (Object[])new Object[0]));
                return map;
            }
        } else if (type.getProperty("invoiceentry") == null && type.getProperty("invoiceattachinfo") != null && d.getDynamicObjectCollection("invoiceattachinfo").size() == 0) {
            billView.showErrorNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53d1\u7968\u9644\u4ef6\u6570\u636e\u3002", (String)"ImportAttachmentPlugin_1", (String)"fi-er-business", (Object[])new Object[0]));
            return map;
        }
        if (billView instanceof IMobileView) {
            InvoiceService.getInstanceService().baseShowInvoiceListInMob(billView, billView.getModel(), serialNos, config, null);
        } else {
            InvoiceService.getInstanceService().baseShowInvoiceListInPc(billView, billView.getModel(), serialNos, config, null);
        }
        return map;
    }

    private String getCallbackClassName(IFormView billView, DynamicObject d, String entityId) {
        String callBackName;
        if (billView instanceof IMobileView) {
            if (ErEntityTypeUtils.isDailyReimburseBill((String)entityId)) {
                callBackName = "kd.fi.er.formplugin.invoicecloud.v2.ImportInvoiceForDailyReimMobPlugin";
            } else if (ErEntityTypeUtils.isPublicReimburseBill((String)entityId)) {
                callBackName = "kd.fi.er.formplugin.invoicecloud.v2.pubreim.ImportInvoiceForPubReimMobPlugin";
            } else if (ErEntityTypeUtils.isTripReimburseBill((String)entityId)) {
                callBackName = "1".equals(d.getString("billkind")) ? "kd.fi.er.formplugin.invoicecloud.v2.mob.ImportInvoiceForTripReimGridMobPlugin" : "kd.fi.er.formplugin.invoicecloud.v2.ImportInvoiceForTripReimMobPlugin";
            } else {
                if (ErEntityTypeUtils.isCheckingpayBill((String)entityId)) {
                    log.error("\u6682\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\uff0c {}", (Object)entityId);
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c\u3002", (String)"ShowInvoiceOrAttachmentServiceImpl_0", (String)"fi-er-mservice", (Object[])new Object[0]));
                }
                callBackName = "kd.fi.er.formplugin.invoicecloud.v2.ImportAttachmentMobPlugin";
            }
        } else {
            callBackName = ErEntityTypeUtils.isDailyReimburseBill((String)entityId) ? "kd.fi.er.formplugin.invoicecloud.v2.ImportInvoiceForDailyReimPCPlugin" : (ErEntityTypeUtils.isPublicReimburseBill((String)entityId) ? "kd.fi.er.formplugin.invoicecloud.v2.pubreim.ImportInvoiceForPubReimPCPlugin" : (ErEntityTypeUtils.isTripReimburseBill((String)entityId) ? "kd.fi.er.formplugin.invoicecloud.v2.ImportInvoiceForTripReimPCPlugin" : (ErEntityTypeUtils.isCheckingpayBill((String)entityId) ? "kd.fi.er.formplugin.invoicecloud.v2.tripbusi.ImportInvoiceForCheckingPayBillPlugin" : "kd.fi.er.formplugin.invoicecloud.v2.ImportAttachmentPlugin")));
        }
        log.error("\u5220\u9664\u9644\u4ef6\u5bf9\u5e94\u7684\u56de\u8c03\u7c7b\u540d\uff0c formId\uff1a {}\uff0c entityId\uff1a{}\uff0c callBackName\uff1a{} ", new Object[]{billView.getFormShowParameter() == null ? "" : billView.getFormShowParameter().getFormId(), entityId, callBackName});
        return callBackName;
    }
}

