/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.orgcheck;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.common.utils.ThrowableHelper;
import kd.fi.er.mservice.base.IErOrgBizChecker;
import org.apache.commons.lang.StringUtils;

public class ErOrgBizCheckerImpl
implements IErOrgBizChecker {
    private static Log logger = LogFactory.getLog((String)"kd.fi.er.business.base.ErOrgBizCheckerImpl");

    public String checkBizClear(long bizOrgId) {
        logger.info("ErOrgBizChecker>>\u7ec4\u7ec7\u804c\u80fd\u53d6\u6d88\u6821\u9a8c>>\u7ec4\u7ec7ID: " + bizOrgId);
        boolean chekOrgUsage = false;
        try {
            Map<String, List<String>> checkBills = ErOrgBizCheckerImpl.checkOrgByFunction("10");
            logger.info(JSON.toJSONString(checkBills));
            chekOrgUsage = this.chekOrgUsage(bizOrgId, checkBills);
        }
        catch (Exception e) {
            String errMsg = ResManager.loadKDString((String)"\u8d22\u52a1\u4e91-\u8d39\u7528\u6838\u7b97\u6821\u9a8c\u7ec4\u7ec7\u804c\u80fd\u5931\u8d25, \u5b58\u5728\u5f02\u5e38\u3002", (String)"ErOrgBizCheckerImpl_0", (String)"fi-er-mservice", (Object[])new Object[0]);
            logger.info(errMsg + "\n" + ThrowableHelper.toString((Exception)e));
            return errMsg;
        }
        if (chekOrgUsage) {
            return null;
        }
        return ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u6838\u7b97\u804c\u80fd\u5df2\u88ab\u5f15\u7528\u4e8e\u8d22\u52a1\u4e91-\u8d39\u7528\u6838\u7b97\uff0c\u53d6\u6d88\u6838\u7b97\u804c\u80fd\u5931\u8d25\u3002", (String)"ErOrgBizCheckerImpl_1", (String)"fi-er-mservice", (Object[])new Object[0]);
    }

    public boolean chekOrgUsage(Long orgId, Map<String, List<String>> billTypes) {
        for (Map.Entry<String, List<String>> entry : billTypes.entrySet()) {
            String billType = entry.getKey();
            List<String> keys = billTypes.get(billType);
            if (keys.isEmpty()) continue;
            for (String key : keys) {
                QFilter keyFilter = new QFilter(key, "=", (Object)orgId);
                logger.info("ErOrgBizCheckerImpl>>" + billType + keyFilter);
                if (!QueryServiceHelper.exists((String)billType, (QFilter[])keyFilter.toArray())) continue;
                logger.info(String.format("ErOrgBizChecker>>\u7ec4\u7ec7\u804c\u80fd\u53d6\u6d88\u6821\u9a8c>>[billType=%s, orgId=%s]", billType, orgId));
                return false;
            }
        }
        return true;
    }

    public static Map<String, List<String>> checkOrgByFunction(String funType) {
        QFilter funFilter = new QFilter("funtype", "=", (Object)funType);
        DynamicObject[] checkEntitys = BusinessDataServiceHelper.loadFromCache((String)"er_orgcheckconfig", (String)"entitytype.number, checkcolumn, funtype, entity, key", (QFilter[])funFilter.toArray()).values().toArray(new DynamicObject[0]);
        HashMap<String, List<String>> checkBills = new HashMap<String, List<String>>();
        for (DynamicObject checkEntity : checkEntitys) {
            String bill = checkEntity.getString("entitytype.number");
            DynamicObjectCollection keyEntrys = checkEntity.getDynamicObjectCollection("checkcolumn");
            if (keyEntrys == null || keyEntrys.size() == 0) continue;
            ArrayList<String> keys = new ArrayList<String>();
            for (DynamicObject keyentry : keyEntrys) {
                String entity = keyentry.getString("entity");
                String key = keyentry.getString("key");
                if (StringUtils.isBlank((String)entity) || StringUtils.isBlank((String)key)) continue;
                keys.add(entity + "." + key);
            }
            checkBills.put(bill, keys);
        }
        return checkBills;
    }
}

