/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.upgrade;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.er.business.servicehelper.ErExceptionServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class FeeStandDataUpgrade
implements IUpgradeService {
    private static final long REIMBURSELEVEL_BILL_ID = 1842877931492458496L;
    private static final long REIMBURSELEVEL_ID = 1842877733848465408L;
    private static final String REIMBURSELEVEL_BILL_FIELDNUMBER = "reimburselevel_bill";
    private static final String REIMBURSELEVEL_BILL_FIELDNAME = "\u5355\u636e\u5934.\u62a5\u9500\u7ea7\u522b";
    private static final String REIMBURSELEVEL_FIELDNUMBER = "expenseentryentity.reimburselevel";
    private static final String REIMBURSELEVEL_FIELDNAME = "\u8d39\u7528\u660e\u7ec6.\u62a5\u9500\u7ea7\u522b";
    private StringBuilder logger = new StringBuilder();

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle h = TX.requiresNew();){
            try {
                DBRoute DBKey = DBRoute.of((String)dbKey);
                Map<Long, String> bizItemMap = this.upgradeForBizItem(DBKey);
                this.upgradeForFeeStandard(DBKey, bizItemMap);
                this.upgradeForBillSetting(DBKey, bizItemMap);
            }
            catch (Exception ex) {
                h.markRollback();
                result.setSuccess(false);
                result.setErrorInfo(ErExceptionServiceHelper.getStackTrace((Throwable)ex));
            }
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setErrorInfo(ErExceptionServiceHelper.getStackTrace((Throwable)e));
        }
        result.setLog(this.logger.toString());
        return result;
    }

    private void upgradeForBillSetting(DBRoute DBKey, Map<Long, String> bizItemMap) {
        final HashMap billSettingMap = Maps.newHashMapWithExpectedSize((int)16);
        List bizItemPks = bizItemMap.entrySet().stream().map(v -> (Long)v.getKey()).collect(Collectors.toList());
        SqlBuilder sb = new SqlBuilder();
        sb.append("select head.fid,head.fbizitem,entry.ffieldnumber from t_er_bill_setting head left join t_er_bill_setting_entry entry on head.fid = entry.fid where", new Object[0]);
        sb.appendIn("head.fbizitem", bizItemPks);
        DB.query((DBRoute)DBKey, (SqlBuilder)sb, (ResultSetHandler)new ResultSetHandler<Object>(){

            public Object handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    Long billSettingPk = rs.getLong("fid");
                    BillSettingInfo info = (BillSettingInfo)billSettingMap.get(billSettingPk);
                    if (info == null) {
                        info = new BillSettingInfo();
                        info.setFid(billSettingPk);
                        info.setBizitem(rs.getLong("fbizitem"));
                        billSettingMap.put(billSettingPk, info);
                    }
                    info.getFieldnumberSet().add(rs.getString("ffieldnumber"));
                }
                return null;
            }
        });
        if (!billSettingMap.isEmpty()) {
            ArrayList params = Lists.newArrayListWithExpectedSize((int)billSettingMap.size());
            long[] genEntryIds = DB.genLongIds((String)"t_er_bill_setting_entry", (int)billSettingMap.size());
            int row = 0;
            for (Map.Entry entry : billSettingMap.entrySet()) {
                BillSettingInfo billSettingInfo = (BillSettingInfo)entry.getValue();
                String bizitemNum = bizItemMap.get(billSettingInfo.getBizitem());
                String fieldnumber = null;
                String ffieldname = null;
                if (bizitemNum.endsWith("_bill")) {
                    fieldnumber = REIMBURSELEVEL_BILL_FIELDNUMBER;
                    ffieldname = REIMBURSELEVEL_BILL_FIELDNAME;
                } else {
                    fieldnumber = REIMBURSELEVEL_FIELDNUMBER;
                    ffieldname = REIMBURSELEVEL_FIELDNAME;
                }
                if (billSettingInfo.getFieldnumberSet().contains(fieldnumber)) continue;
                params.add(new Object[]{billSettingInfo.getFid(), genEntryIds[row++], 1, fieldnumber, "field", Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('0'), ffieldname});
            }
            if (!params.isEmpty()) {
                int[] executeBatch = DB.executeBatch((DBRoute)DBKey, (String)"insert into t_er_bill_setting_entry(fid,fentryid,fseq,ffieldnumber,ffieldtype,fmustinput,fhidden,flock,ffieldname) values(?,?,?,?,?,?,?,?,?)", (List)params);
                this.logger.append("billsetting upgrade:").append(executeBatch.length).append(System.lineSeparator());
            } else {
                this.logger.append("billsetting over").append(System.lineSeparator());
            }
        }
    }

    private void upgradeForFeeStandard(DBRoute DBKey, final Map<Long, String> bizItemMap) {
        List bizItemPks = bizItemMap.entrySet().stream().map(v -> (Long)v.getKey()).collect(Collectors.toList());
        SqlBuilder sb = new SqlBuilder();
        sb.append("select fee.fdimension,fee.fid,reimlevel.fname from t_er_fee_standard fee left join t_er_reimburselevel_l reimlevel on fee.freimburselevel = reimlevel.fid  where  reimlevel.flocaleid= 'zh_CN' and", new Object[0]);
        sb.appendIn("fee.fstardardtype", bizItemPks);
        List params = (List)DB.query((DBRoute)DBKey, (SqlBuilder)sb, (ResultSetHandler)new ResultSetHandler<List<Object[]>>(){

            public List<Object[]> handle(ResultSet rs) throws Exception {
                ArrayList params = Lists.newArrayListWithExpectedSize((int)bizItemMap.size());
                while (rs.next()) {
                    String dimensionEx = rs.getString("fdimension");
                    String ReimlevelName = rs.getString("fname");
                    if (dimensionEx == null || dimensionEx.indexOf(ReimlevelName) != -1) continue;
                    String dimension = null;
                    dimension = StringUtils.isNotBlank((CharSequence)dimensionEx) ? StringUtils.joinWith((String)";", (Object[])new Object[]{dimensionEx, ReimlevelName}) : ReimlevelName;
                    params.add(new Object[]{dimension, rs.getLong("fid")});
                }
                return params;
            }
        });
        if (!params.isEmpty()) {
            int[] executeBatch = DB.executeBatch((DBRoute)DBKey, (String)"update t_er_fee_standard set fdimension  = ? where fid = ?", (List)params);
            this.logger.append("standard upgrade:").append(executeBatch.length).append(System.lineSeparator());
        } else {
            this.logger.append("standard over").append(System.lineSeparator());
        }
    }

    private Map<Long, String> upgradeForBizItem(DBRoute DBKey) {
        final HashMultimap hashMultiMap = HashMultimap.create();
        Map bizItemMap = (Map)DB.query((DBRoute)DBKey, (String)"select bizitem.fid,fnumber,fbasedataid from t_er_standard_type bizitem left join t_er_standard_select_dim dim on bizitem.fid = dim.fid where fnumber not in (?,?)", (Object[])new String[]{"expense", "asset"}, (ResultSetHandler)new ResultSetHandler<Map<Long, String>>(){

            public Map<Long, String> handle(ResultSet rs) throws Exception {
                HashMap map = Maps.newHashMapWithExpectedSize((int)16);
                while (rs.next()) {
                    map.put(rs.getLong("fid"), rs.getString("fnumber"));
                    hashMultiMap.put((Object)rs.getLong("fid"), (Object)rs.getLong("fbasedataid"));
                }
                return map;
            }
        });
        if (!bizItemMap.isEmpty()) {
            ArrayList params = Lists.newArrayListWithExpectedSize((int)bizItemMap.size());
            long[] genLongIds = DB.genLongIds((String)"t_er_standard_select_dim", (int)bizItemMap.size());
            int i = 0;
            Set entrySet = bizItemMap.entrySet();
            Long reimburselevelPk = null;
            for (Map.Entry entry : entrySet) {
                String bizItemNum = (String)entry.getValue();
                Long fid = (Long)entry.getKey();
                reimburselevelPk = bizItemNum.endsWith("_bill") ? Long.valueOf(1842877931492458496L) : Long.valueOf(1842877733848465408L);
                if (hashMultiMap.get((Object)fid).contains(reimburselevelPk)) continue;
                params.add(new Object[]{genLongIds[i], fid, reimburselevelPk});
                ++i;
            }
            if (!params.isEmpty()) {
                int[] executeBatch = DB.executeBatch((DBRoute)DBKey, (String)"insert into t_er_standard_select_dim(fpkid,fid,fbasedataid) values(?,?,?)", (List)params);
                this.logger.append("dim upgrade:").append(executeBatch.length).append(System.lineSeparator());
            } else {
                this.logger.append("dim over").append(System.lineSeparator());
            }
        }
        return bizItemMap;
    }

    static class BillSettingInfo {
        private Long fid;
        private Long bizitem;
        private Set<String> fieldnumberSet = Sets.newHashSetWithExpectedSize((int)16);

        BillSettingInfo() {
        }

        public Long getFid() {
            return this.fid;
        }

        public void setFid(Long fid) {
            this.fid = fid;
        }

        public Long getBizitem() {
            return this.bizitem;
        }

        public void setBizitem(Long bizitem) {
            this.bizitem = bizitem;
        }

        public Set<String> getFieldnumberSet() {
            return this.fieldnumberSet;
        }
    }
}

