/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.upgrade;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.orm.ORM;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.er.business.invoicecloud.kingdee.InvoiceTypeEnum;

public class RelationNameNumberUpgrade
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setLog(ResManager.loadKDString((String)"\u5347\u7ea7\u5f00\u59cb\uff1a\u66f4\u65b0name\u548cnumber\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb\u3002", (String)"RelationNameNumberUpgrade_0", (String)"fi-er-mservice", (Object[])new Object[0]));
        final ArrayList relationList = Lists.newArrayList();
        String selectStr = "select a.fid, a.fbilltype, a.ftripitemid, a.fexpenseitemid, b.fgoodnames, b.fmappingtype, a.finvoicetype, a.fratetypeid from t_er_rel_exp_ratetype a left join t_er_namerflitem b on a.fid = b.fid";
        DB.query((DBRoute)DBRoute.of((String)"er"), (String)selectStr, (ResultSetHandler)new ResultSetHandler(){

            public Object handle(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    String fgoodnames = resultSet.getString("fgoodnames");
                    if (StringUtils.isBlank((CharSequence)fgoodnames)) {
                        fgoodnames = "";
                    }
                    Relation relation = new Relation(resultSet.getLong("fid"), resultSet.getString("fbilltype"), resultSet.getLong("ftripitemid"), resultSet.getLong("fexpenseitemid"), fgoodnames, resultSet.getString("fmappingtype"), resultSet.getString("finvoicetype"), resultSet.getLong("fratetypeid"));
                    relationList.add(relation);
                }
                return null;
            }
        });
        Set rateTypeSet = relationList.stream().map(bo -> ((Relation)bo).fratetypeid).collect(Collectors.toSet());
        final HashMap rateTypeMap = Maps.newHashMapWithExpectedSize((int)rateTypeSet.size());
        String selectRateType = "select fid,fname from  t_er_taxclasscode_l where flocaleid = 'zh_CN' and fid in (%s)";
        String typeids = rateTypeSet.stream().map(id -> String.valueOf(id)).collect(Collectors.joining(","));
        if (StringUtils.isNotBlank((CharSequence)typeids)) {
            selectRateType = String.format(selectRateType, typeids);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)selectRateType, (ResultSetHandler)new ResultSetHandler(){

                public Object handle(ResultSet resultSet) throws Exception {
                    while (resultSet.next()) {
                        rateTypeMap.put(resultSet.getLong("fid"), resultSet.getString("fname"));
                    }
                    return null;
                }
            });
        }
        Set expenseItemSet = relationList.stream().map(bo -> ((Relation)bo).fexpenseitemid).collect(Collectors.toSet());
        final HashMap expenseItemMap = Maps.newHashMapWithExpectedSize((int)expenseItemSet.size());
        String selectExpenseItem = "select fid,fname from  t_er_expenseitem_l where flocaleid = 'zh_CN' and fid in (%s)";
        String expenseids = expenseItemSet.stream().map(id -> String.valueOf(id)).collect(Collectors.joining(","));
        if (StringUtils.isNotBlank((CharSequence)expenseids)) {
            selectExpenseItem = String.format(selectExpenseItem, expenseids);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)selectExpenseItem, (ResultSetHandler)new ResultSetHandler(){

                public Object handle(ResultSet resultSet) throws Exception {
                    while (resultSet.next()) {
                        expenseItemMap.put(resultSet.getLong("fid"), resultSet.getString("fname"));
                    }
                    return null;
                }
            });
        }
        Set tripItemSet = relationList.stream().map(bo -> ((Relation)bo).ftripitemid).collect(Collectors.toSet());
        final HashMap tripItemMap = Maps.newHashMapWithExpectedSize((int)tripItemSet.size());
        String selectTripItem = "select fid,fname from  t_er_tripexpenseitem_l where flocaleid = 'zh_CN' and fid in (%s)";
        String tripids = tripItemSet.stream().map(id -> String.valueOf(id)).collect(Collectors.joining(","));
        if (StringUtils.isNotBlank((CharSequence)tripids)) {
            selectTripItem = String.format(selectTripItem, tripids);
            DB.query((DBRoute)DBRoute.of((String)"er"), (String)selectTripItem, (ResultSetHandler)new ResultSetHandler(){

                public Object handle(ResultSet resultSet) throws Exception {
                    while (resultSet.next()) {
                        tripItemMap.put(resultSet.getLong("fid"), resultSet.getString("fname"));
                    }
                    return null;
                }
            });
        }
        HashMap resultMap = Maps.newHashMap();
        for (Relation relation : relationList) {
            RelationName value = (RelationName)resultMap.get(relation.fid);
            if (value == null) {
                String invoicetype;
                String rateTypeName;
                String expenseItemName;
                String tripitemName = (String)tripItemMap.get(relation.ftripitemid);
                if (StringUtils.isBlank((CharSequence)tripitemName)) {
                    tripitemName = " ";
                }
                if (StringUtils.isBlank((CharSequence)(expenseItemName = (String)expenseItemMap.get(relation.fexpenseitemid)))) {
                    expenseItemName = " ";
                }
                if (StringUtils.isBlank((CharSequence)(rateTypeName = (String)rateTypeMap.get(relation.fratetypeid)))) {
                    rateTypeName = " ";
                }
                if (StringUtils.isBlank((CharSequence)(invoicetype = relation.finvoicetype))) {
                    invoicetype = "0";
                }
                value = new RelationName(relation.fbilltype, relation.fid, tripitemName, expenseItemName, invoicetype, rateTypeName);
                resultMap.put(relation.fid, value);
            }
            value.goodsMap.add(relation.goodsName());
        }
        String deleteSql = "delete from t_er_rel_exp_ratetype_l where fid in (%s)";
        String deleteids = resultMap.keySet().stream().map(id -> String.valueOf(id)).collect(Collectors.joining(","));
        deleteSql = String.format(deleteSql, deleteids);
        if (!StringUtils.isBlank((CharSequence)deleteids)) {
            DB.execute((DBRoute)DBRoute.of((String)"er"), (String)deleteSql);
        }
        String insetSql = "insert into t_er_rel_exp_ratetype_l(fpkid,fid,flocaleid,fname) values(?,?,?,?)";
        String updateSql = "update t_er_rel_exp_ratetype set fnumber = ? where fid = ?";
        LinkedList<Object[]> insList = new LinkedList<Object[]>();
        LinkedList<Object[]> updList = new LinkedList<Object[]>();
        ORM orm = ORM.create();
        String[] ids = orm.genStringIds("er_rel_expense_ratetype", resultMap.size());
        int i = 0;
        for (Map.Entry entry : resultMap.entrySet()) {
            Long key = (Long)entry.getKey();
            RelationName value = (RelationName)entry.getValue();
            insList.add(new Object[]{ids[i++], key, "zh_CN", value.toString()});
            updList.add(new Object[]{value.getNumber(), key});
            result.setLog("RelationName : " + value.getNumber() + " , " + value);
        }
        if (!insList.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)insetSql, insList);
        }
        if (!updList.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)updateSql, updList);
        }
        return result;
    }

    private static class RelationName {
        private String type;
        private String number;
        private String tripitemname;
        private String expenseitemname;
        private String invoicetypename;
        private String ratetypename;
        private Set<String> goodsMap;

        public RelationName(String type, long fid, String tripitemname, String expenseitemname, String finvoicetype, String ratetypename) {
            this.type = type;
            this.number = Long.toHexString(fid);
            this.tripitemname = tripitemname;
            this.expenseitemname = expenseitemname;
            this.invoicetypename = InvoiceTypeEnum.getByValue((String)finvoicetype) == null ? " " : InvoiceTypeEnum.getByValue((String)finvoicetype).getKey();
            this.ratetypename = ratetypename;
            this.goodsMap = Sets.newHashSet();
        }

        private String getGoodsName() {
            return this.goodsMap.stream().collect(Collectors.joining(","));
        }

        public String getNumber() {
            if (this.number == null) {
                return "";
            }
            StringBuilder sbNumber = new StringBuilder();
            if (StringUtils.equals((CharSequence)"1", (CharSequence)this.type)) {
                sbNumber.append("FYXM");
            } else if (StringUtils.equals((CharSequence)"2", (CharSequence)this.type)) {
                sbNumber.append("CLXM");
            }
            sbNumber.append("-");
            while (this.number.length() < 16) {
                this.number = "0" + this.number;
            }
            sbNumber.append(this.number.toUpperCase());
            return sbNumber.toString();
        }

        public String toString() {
            int index;
            StringBuilder result = new StringBuilder();
            if (StringUtils.isNotBlank((CharSequence)this.expenseitemname)) {
                result.append(this.expenseitemname);
            } else if (StringUtils.isNotBlank((CharSequence)this.tripitemname)) {
                result.append(this.tripitemname);
            } else {
                return "-";
            }
            String goodsName = this.getGoodsName();
            if (StringUtils.isNotBlank((CharSequence)goodsName)) {
                result.append("-");
                result.append(goodsName);
            }
            if (StringUtils.isNotBlank((CharSequence)this.invoicetypename) && !StringUtils.equals((CharSequence)this.invoicetypename, (CharSequence)ResManager.loadKDString((String)"\u7a7a", (String)"RelationNameNumberUpgrade_3", (String)"fi-er-mservice", (Object[])new Object[0]))) {
                result.append(String.format(ResManager.loadKDString((String)"-\u53d1\u7968\u7c7b\u578b\uff1a%s", (String)"RelationNameNumberUpgrade_4", (String)"fi-er-mservice", (Object[])new Object[0]), this.invoicetypename));
            }
            if (StringUtils.isNotBlank((CharSequence)this.ratetypename)) {
                result.append(String.format(ResManager.loadKDString((String)"-\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\uff1a%s", (String)"RelationNameNumberUpgrade_5", (String)"fi-er-mservice", (Object[])new Object[0]), this.ratetypename));
            }
            if ((index = result.length()) > 80) {
                index = 80;
            }
            return result.substring(0, index);
        }
    }

    private static class Relation {
        private Long fid;
        private String fbilltype;
        private Long ftripitemid;
        private Long fexpenseitemid;
        private String fgoodnames;
        private String fmappingtype;
        private String finvoicetype;
        private Long fratetypeid;

        public String toString() {
            return "Relation [fid=" + this.fid + ", fbilltype=" + this.fbilltype + ", ftripitemid=" + this.ftripitemid + ", fexpenseitemid=" + this.fexpenseitemid + ", fgoodnames=" + this.fgoodnames + ", fmappingtype=" + this.fmappingtype + ", finvoicetype=" + this.finvoicetype + ", fratetypeid=" + this.fratetypeid + "]";
        }

        public Relation(Long fid, String fbilltype, Long ftripitemid, Long fexpenseitemid, String fgoodnames, String fmappingtype, String finvoicetype, Long fratetypeid) {
            this.fid = fid;
            this.fbilltype = fbilltype;
            this.ftripitemid = ftripitemid;
            this.fexpenseitemid = fexpenseitemid;
            this.fgoodnames = fgoodnames;
            this.fmappingtype = fmappingtype;
            this.finvoicetype = finvoicetype;
            this.fratetypeid = fratetypeid;
        }

        String goodsName() {
            if (StringUtils.isBlank((CharSequence)this.fgoodnames) || StringUtils.equals((CharSequence)"null", (CharSequence)this.fgoodnames)) {
                return " ";
            }
            String type = StringUtils.equals((CharSequence)"0", (CharSequence)this.fmappingtype) ? ResManager.loadKDString((String)"\u5b8c\u5168\u5339\u914d\uff1a", (String)"RelationNameNumberUpgrade_1", (String)"fi-er-mservice", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6a21\u7cca\u5339\u914d\uff1a", (String)"RelationNameNumberUpgrade_2", (String)"fi-er-mservice", (Object[])new Object[0]);
            return type + this.fgoodnames;
        }
    }
}

