/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.upgrade;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class UpgradeBookeddateImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(UpgradeBookeddateImpl.class);
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final List<String> FORM_IDS = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"er_tripreqbill", "er_repaymentbill", "er_dailyreimbursebill", "er_dailyloanbill", "er_tripreimbursebill", "er_publicreimbursebill", "er_expensesharebill", "er_prepaybill", "er_withholdingbill", "er_applypaybill", "er_costestimatebill", "er_tripreimbill_grid"}));
    private static final int BATCH_UPDATE_COUNT = 1000;

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        QFilter qFilter = new QFilter("billtype", "in", FORM_IDS);
        try {
            qFilter.and("createdate", ">=", (Object)this.simpleDateFormat.parse("2022-01-01"));
        }
        catch (ParseException e) {
            logger.info("UpgradeBookeddateImpl \u65f6\u95f4\u683c\u5f0f\u7c7b\u578b\u88c5\u6362\u9519\u8bef\u3002");
        }
        DynamicObjectCollection daptrackers = QueryServiceHelper.query((String)"ai_daptracker", (String)"billtype,sourcebillid,voucherid", (QFilter[])new QFilter[]{qFilter});
        if (daptrackers == null || daptrackers.size() < 1) {
            result.setLog(ResManager.loadKDString((String)"\u65e0DAP\u5173\u7cfb\u3002", (String)"UpgradeBookeddateImpl_0", (String)"fi-er-mservice", (Object[])new Object[0]));
            return result;
        }
        List ids = daptrackers.stream().map(value -> value.getLong("voucherid")).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> voucheridMap = daptrackers.stream().collect(Collectors.groupingBy(v -> v.getLong("voucherid")));
        qFilter = new QFilter("id", "in", ids);
        DynamicObjectCollection vouchers = QueryServiceHelper.query((String)"gl_voucher", (String)"id,bookeddate", (QFilter[])new QFilter[]{qFilter});
        if (vouchers == null || vouchers.size() < 1) {
            result.setLog(ResManager.loadKDString((String)"\u65e0\u51ed\u8bc1\u3002", (String)"UpgradeBookeddateImpl_1", (String)"fi-er-mservice", (Object[])new Object[0]));
            return result;
        }
        AtomicLong count = new AtomicLong(0L);
        CountDownLatch countDownLatch = null;
        ThreadPool threadPool = null;
        try {
            threadPool = ThreadPools.newFixedThreadPool((String)("UpgradeBookeddateImpl" + System.currentTimeMillis()), (int)10);
            logger.info("UpgradeBookeddateImpl vouchers.size():{}", (Object)vouchers.size());
            int times = vouchers.size() / 1000 + (vouchers.size() % 1000 == 0 ? 0 : 1);
            CountDownLatch finalCountDownLatch = countDownLatch = new CountDownLatch(times);
            int i = 0;
            int j = 0;
            while (j < times) {
                int m = i;
                ++j;
                threadPool.execute(() -> {
                    try {
                        List voucherList = vouchers.stream().skip(m).limit(1000L).collect(Collectors.toList());
                        for (DynamicObject dynamicObject : voucherList) {
                            Long id = dynamicObject.getLong("id");
                            Date bookeddate = this.simpleDateFormat.parse(this.simpleDateFormat.format(dynamicObject.getDate("bookeddate")));
                            List dynamicObjects = (List)voucheridMap.get(id);
                            if (null == dynamicObjects || dynamicObjects.isEmpty()) continue;
                            for (DynamicObject d : dynamicObjects) {
                                String billtype = d.getString("billtype");
                                MainEntityType mt = EntityMetadataCache.getDataEntityType((String)billtype);
                                Long sourcebillid = d.getLong("sourcebillid");
                                ArrayList<Object[]> orderparams = new ArrayList<Object[]>(1);
                                Object[] param = new Object[]{bookeddate, sourcebillid};
                                orderparams.add(param);
                                DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)("update " + mt.getAlias() + " set Fbookeddate = ?  where fid =? and Fbookeddate is null;"), orderparams);
                                if (!"er_tripreimbursebill".equals(billtype) && !"er_tripreimbill_grid".equals(billtype) || sourcebillid <= 0L) continue;
                                ArrayList<Long> sourcebillids = new ArrayList<Long>(1);
                                sourcebillids.add(sourcebillid);
                                QFilter sourceqFilter = new QFilter("id", "in", sourcebillids);
                                sourceqFilter.and("tripentry.entryentity.ordernum", "is not null", null);
                                sourceqFilter.and("tripentry.entryentity.ordernum", "!=", (Object)"");
                                DynamicObjectCollection sourcedynamicObjects = QueryServiceHelper.query((String)"er_tripreimbursebill", (String)"id,tripentry.entryentity.ordernum,tripentry.entryentity.orderformid", (QFilter[])new QFilter[]{sourceqFilter});
                                if (null == sourcedynamicObjects || sourcedynamicObjects.size() == 0) continue;
                                for (DynamicObject sourcedynamicObject : sourcedynamicObjects) {
                                    DynamicObject saveallorder;
                                    String ordernum = sourcedynamicObject.getString("tripentry.entryentity.ordernum");
                                    String formid = sourcedynamicObject.getString("tripentry.entryentity.orderformid");
                                    if (ordernum == null || ordernum.length() == 0 || formid.indexOf(",") != -1) continue;
                                    MainEntityType ordermt = EntityMetadataCache.getDataEntityType((String)formid);
                                    Object[] orderparam = new Object[]{bookeddate, ordernum};
                                    orderparams = new ArrayList(1);
                                    orderparams.add(orderparam);
                                    DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)("update " + ordermt.getAlias() + " set Fbookeddate = ?  where fordernum = ?"), orderparams);
                                    DynamicObject allorder = BusinessDataServiceHelper.loadSingle((String)"er_allorderbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("ordernum", "=", (Object)ordernum)});
                                    if (null == allorder || null == (saveallorder = BusinessDataServiceHelper.loadSingle((Object)allorder.getPkValue(), (String)"er_allorderbill"))) continue;
                                    saveallorder.set("bookeddate", (Object)bookeddate);
                                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saveallorder});
                                }
                            }
                            count.addAndGet(1L);
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    finalCountDownLatch.countDown();
                });
                i += 1000;
            }
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), (Throwable)exception);
            result.setLog("error " + exception.getMessage());
        }
        boolean res = false;
        try {
            if (countDownLatch != null) {
                res = countDownLatch.await(3600L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
            result.setLog(result.getLog() + e.getMessage());
        }
        if (threadPool != null) {
            threadPool.close();
        }
        result.setLog(result.getLog() + "UpgradeBookeddateImpl success : " + count.get());
        result.setSuccess(true);
        return result;
    }
}

