/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.upgrade;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class UpgradeContractPayAmountServiceImpl
implements IUpgradeService {
    private static final int MAX_SIZE = 5000;

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        result.setLog("UpgradeContractPayAmountServiceImpl begin");
        Long start = System.currentTimeMillis();
        final HashSet fidSet = new HashSet();
        final HashMap updateExpenseMap = new HashMap();
        LinkedList<Object[]> updateList = new LinkedList<Object[]>();
        DB.query((DBRoute)DBRoute.of((String)"er"), (String)"select fid,fnotpayamount,fnonpayamount,favailableamount,forinonpayamount,foriavailableamount,forinotpayamount from t_er_contractbill_s where fid in (select fid from t_er_contractbill where fbillstatus in ('A','B','C','D','E','F','J') and frameworkcontract = '0');", (ResultSetHandler)new ResultSetHandler(){

            public Object handle(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    LinkedList<Object[]> updateAmountList = new LinkedList<Object[]>();
                    Long billid = resultSet.getLong("fid");
                    fidSet.add(billid);
                    BigDecimal fnotpayamount = resultSet.getBigDecimal("fnotpayamount");
                    BigDecimal forinotpayamount = resultSet.getBigDecimal("forinotpayamount");
                    BigDecimal fnonpayamount = BigDecimal.ZERO;
                    BigDecimal availableamount = fnotpayamount;
                    BigDecimal forinonpayamount = BigDecimal.ZERO;
                    BigDecimal oriavailableamount = forinotpayamount;
                    updateAmountList.add(new Object[]{fnonpayamount, availableamount, forinonpayamount, oriavailableamount, billid});
                    updateExpenseMap.put(billid, updateAmountList);
                }
                return null;
            }
        });
        if (!fidSet.isEmpty()) {
            String params = Stream.generate(() -> "?").limit(fidSet.size()).collect(Collectors.joining(","));
            String sql = String.format("select a.fsourcebillid,sum(a.fexpeapprovecurramount) fexpeapprovecurramount,sum(a.fexpeapproveamount) fexpeapproveamount from t_er_prepaybillentry a inner join t_er_prepaybill b on a.fid = b.fid where b.fbillstatus in ('B','C','E','F') and a.fsourcebillid in (%s) group by a.fsourcebillid;", params);
            DB.query((DBRoute)DBRoute.of((String)"er"), (String)sql, (Object[])fidSet.toArray(), (ResultSetHandler)new ResultSetHandler(){

                public Object handle(ResultSet resultSet) throws Exception {
                    while (resultSet.next()) {
                        Long fsourcebillid = resultSet.getLong("fsourcebillid");
                        BigDecimal fexpeapprovecurramount = resultSet.getBigDecimal("fexpeapprovecurramount");
                        BigDecimal fexpeapproveamount = resultSet.getBigDecimal("fexpeapproveamount");
                        List amountList = (List)updateExpenseMap.get(fsourcebillid);
                        if (amountList == null || amountList.size() <= 0) continue;
                        Object[] amountObject = (Object[])amountList.get(0);
                        BigDecimal nonpayamount = (BigDecimal)amountObject[0];
                        BigDecimal availableamount = (BigDecimal)amountObject[1];
                        BigDecimal orinonpayamount = (BigDecimal)amountObject[2];
                        BigDecimal oriavailableamount = (BigDecimal)amountObject[3];
                        amountObject[0] = nonpayamount.add(fexpeapprovecurramount);
                        amountObject[1] = availableamount.subtract(fexpeapprovecurramount);
                        amountObject[2] = orinonpayamount.add(fexpeapproveamount);
                        amountObject[3] = oriavailableamount.subtract(fexpeapproveamount);
                    }
                    return null;
                }
            });
            sql = String.format("select a.fcontractsid,sum(a.fcontractcurrwriteoff) fcontractcurrwriteoff,sum(a.fcontractwriteoff) fcontractwriteoff from t_er_prepaycontract a inner join t_er_prepaybill b on a.fid = b.fid where b.fbillstatus in ('B','C','E','F') and a.fcontractsid in (%s) group by a.fcontractsid;", params);
            DB.query((DBRoute)DBRoute.of((String)"er"), (String)sql, (Object[])fidSet.toArray(), (ResultSetHandler)new ResultSetHandler(){

                public Object handle(ResultSet resultSet) throws Exception {
                    while (resultSet.next()) {
                        Long fcontractsid = resultSet.getLong("fcontractsid");
                        BigDecimal fcontractcurrwriteoff = resultSet.getBigDecimal("fcontractcurrwriteoff");
                        BigDecimal fcontractwriteoff = resultSet.getBigDecimal("fcontractwriteoff");
                        List amountList = (List)updateExpenseMap.get(fcontractsid);
                        if (amountList == null || amountList.size() <= 0) continue;
                        Object[] amountObject = (Object[])amountList.get(0);
                        BigDecimal nonpayamount = (BigDecimal)amountObject[0];
                        BigDecimal availableamount = (BigDecimal)amountObject[1];
                        BigDecimal orinonpayamount = (BigDecimal)amountObject[2];
                        BigDecimal oriavailableamount = (BigDecimal)amountObject[3];
                        amountObject[0] = nonpayamount.add(fcontractcurrwriteoff);
                        amountObject[1] = availableamount.subtract(fcontractcurrwriteoff);
                        amountObject[2] = orinonpayamount.add(fcontractwriteoff);
                        amountObject[3] = oriavailableamount.subtract(fcontractwriteoff);
                    }
                    return null;
                }
            });
            sql = String.format("select a.fcontractsid,sum(a.fcontractnonpayamount) fcontractnonpayamount,sum(a.foricontractnonpayamount) foricontractnonpayamount from t_er_pubreimcontract a inner join t_er_pubreimbill b on a.fid = b.fid where b.fbillstatus in ('B','C','E','F') and a.fcontractsid in (%s) group by a.fcontractsid;", params);
            DB.query((DBRoute)DBRoute.of((String)"er"), (String)sql, (Object[])fidSet.toArray(), (ResultSetHandler)new ResultSetHandler(){

                public Object handle(ResultSet resultSet) throws Exception {
                    while (resultSet.next()) {
                        Long fcontractsid = resultSet.getLong("fcontractsid");
                        BigDecimal fcontractnonpayamount = resultSet.getBigDecimal("fcontractnonpayamount");
                        BigDecimal foricontractnonpayamount = resultSet.getBigDecimal("foricontractnonpayamount");
                        List amountList = (List)updateExpenseMap.get(fcontractsid);
                        if (amountList == null || amountList.size() <= 0) continue;
                        Object[] amountObject = (Object[])amountList.get(0);
                        BigDecimal nonpayamount = (BigDecimal)amountObject[0];
                        BigDecimal availableamount = (BigDecimal)amountObject[1];
                        BigDecimal orinonpayamount = (BigDecimal)amountObject[2];
                        BigDecimal oriavailableamount = (BigDecimal)amountObject[3];
                        amountObject[0] = nonpayamount.add(fcontractnonpayamount);
                        amountObject[1] = availableamount.subtract(fcontractnonpayamount);
                        amountObject[2] = orinonpayamount.add(foricontractnonpayamount);
                        amountObject[3] = oriavailableamount.subtract(foricontractnonpayamount);
                    }
                    return null;
                }
            });
        }
        if (updateExpenseMap != null && updateExpenseMap.size() > 0) {
            for (Map.Entry entry : updateExpenseMap.entrySet()) {
                List objectList = (List)entry.getValue();
                if (objectList == null || objectList.size() <= 0) continue;
                Object[] theObjects = (Object[])objectList.get(0);
                Object[] objects = new Object[]{theObjects[0], theObjects[1], theObjects[2], theObjects[3], theObjects[4]};
                updateList.add(objects);
            }
        }
        if (updateList.isEmpty()) {
            result.setLog("don't have updata contract bills");
            return result;
        }
        ArrayList<Object[]> updateObjs = new ArrayList<Object[]>(1);
        for (Object[] objects : updateList) {
            updateObjs.add(objects);
            if (updateObjs.size() < 5000) continue;
            DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"update t_er_contractbill_s set fnonpayamount = ?, favailableamount = ?, forinonpayamount = ?, foriavailableamount = ? where fid = ?", updateObjs);
            updateObjs.clear();
        }
        if (!updateObjs.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"update t_er_contractbill_s set fnonpayamount = ?, favailableamount = ?, forinonpayamount = ?, foriavailableamount = ? where fid = ?", updateObjs);
        }
        result.setLog("update t_er_contractbill_s " + updateList.size() + " record...");
        Long contractEnd = System.currentTimeMillis();
        result.setLog("UpgradeContractPayAmountServiceImpl end,cost time:" + (contractEnd - start));
        return result;
    }
}

